/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.Column;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.core4j.CoreUtils;
import org.odata4j.core.Throwables;

public abstract class JPAMember {
    private JPAMember() {
    }

    public abstract Class<?> getJavaType();

    public abstract boolean isReadable();

    public abstract boolean isWriteable();

    public abstract <T> T get();

    public abstract <T> void set(T var1);

    public abstract <T extends Annotation> T getAnnotation(Class<T> var1);

    public static JPAMember create(Attribute<?, ?> jpaAttribute, Object target) {
        Member javaMember = jpaAttribute.getJavaMember();
        if (javaMember instanceof Field) {
            return new FieldMember((Field)javaMember, target);
        }
        if (javaMember instanceof Method) {
            return new GetterSetterMember((Method)javaMember, null, target);
        }
        JPAMember rt = JPAMember.reverseEngineerJPAMember(jpaAttribute.getDeclaringType().getJavaType(), jpaAttribute.getName(), target);
        if (rt == null) {
            throw new IllegalArgumentException("Could not find java member for: " + jpaAttribute);
        }
        return rt;
    }

    public static JPAMember findByColumn(EntityType<?> jpaEntityType, String columnName, Object jpaEntity) {
        for (Attribute att : jpaEntityType.getAttributes()) {
            JPAMember rt;
            if (att.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                SingularAttribute eatt = (SingularAttribute)att;
                EmbeddableType et = (EmbeddableType)eatt.getType();
                Object eo = JPAMember.create(att, jpaEntity).get();
                for (Attribute embeddedAtt : et.getAttributes()) {
                    JPAMember rt2 = JPAMember.findByColumn(embeddedAtt, columnName, eo);
                    if (rt2 == null) continue;
                    return rt2;
                }
            }
            if ((rt = JPAMember.findByColumn(att, columnName, jpaEntity)) == null) continue;
            return rt;
        }
        return null;
    }

    private static JPAMember findByColumn(Attribute<?, ?> att, String columnName, Object target) {
        JPAMember rt = JPAMember.create(att, target);
        Column c = rt.getAnnotation(Column.class);
        if (c == null) {
            return null;
        }
        if (columnName.equals(c.name())) {
            return rt;
        }
        return null;
    }

    private static JPAMember reverseEngineerJPAMember(Class<?> type, String name, Object target) {
        try {
            Field field = CoreUtils.getField(type, (String)name);
            return new FieldMember(field, target);
        }
        catch (Exception ignore) {
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            while (!type.equals(Object.class)) {
                try {
                    Method method = type.getDeclaredMethod(methodName, new Class[0]);
                    return new GetterSetterMember(method, null, target);
                }
                catch (Exception ignore2) {
                    type = type.getSuperclass();
                }
            }
            return null;
        }
    }

    private static class GetterSetterMember
    extends JPAMember {
        private final Method getter;
        private final Method setter;
        private final Object target;

        public GetterSetterMember(Method getter, Method setter, Object target) {
            this.getter = getter;
            this.setter = setter;
            this.target = target;
            if (getter != null) {
                getter.setAccessible(true);
            }
            if (setter != null) {
                setter.setAccessible(true);
            }
        }

        @Override
        public Class<?> getJavaType() {
            return this.getter.getReturnType();
        }

        @Override
        public boolean isReadable() {
            return this.getter != null;
        }

        @Override
        public boolean isWriteable() {
            return this.setter != null;
        }

        @Override
        public <T> T get() {
            if (this.getter == null) {
                throw new RuntimeException("Member is not readable");
            }
            try {
                return (T)this.getter.invoke(this.target, new Object[0]);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public <T> void set(T value) {
            if (this.setter == null) {
                throw new RuntimeException("Member is not writeable");
            }
            try {
                this.setter.invoke(this.target, value);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.getter.getAnnotation(annotationClass);
        }
    }

    private static class FieldMember
    extends JPAMember {
        private final Field field;
        private final Object target;

        public FieldMember(Field field, Object target) {
            this.field = field;
            this.target = target;
            field.setAccessible(true);
        }

        @Override
        public Class<?> getJavaType() {
            return this.field.getType();
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWriteable() {
            return true;
        }

        @Override
        public <T> T get() {
            try {
                return (T)this.field.get(this.target);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public <T> void set(T value) {
            try {
                this.field.set(this.target, value);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }
    }
}

