/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odata4j.command.Command;
import org.odata4j.command.CommandContext;
import org.odata4j.command.CommandExecution;
import org.odata4j.core.Throwables;
import org.odata4j.producer.command.CommandProducer;
import org.odata4j.producer.command.ProducerCommandContext;
import org.odata4j.producer.jdbc.Jdbc;
import org.odata4j.producer.jdbc.JdbcProducerBackend;

public class JdbcProducer
extends CommandProducer {
    private final JdbcProducerBackend jdbcBackend;

    protected JdbcProducer(JdbcProducerBackend jdbcBackend) {
        super(jdbcBackend);
        this.jdbcBackend = jdbcBackend;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Jdbc getJdbc() {
        return this.jdbcBackend.getJdbc();
    }

    public static class Builder {
        private final Map<Class<?>, Object> instances = new HashMap();
        private final Map<Class<?>, List<Command<?>>> preCommands = new HashMap();
        private final Map<Class<?>, List<Command<?>>> postCommands = new HashMap();
        private Jdbc jdbc;

        public Builder jdbc(Jdbc jdbc) {
            this.jdbc = jdbc;
            return this;
        }

        public <TContext extends ProducerCommandContext<?>> Builder insert(Class<TContext> contextType, Command<?> command) {
            return this.preOrPost(contextType, command, this.preCommands);
        }

        public <TContext extends ProducerCommandContext<?>> Builder append(Class<TContext> contextType, Command<?> command) {
            return this.preOrPost(contextType, command, this.postCommands);
        }

        private <TContext extends ProducerCommandContext<?>> Builder preOrPost(Class<TContext> contextType, Command<?> command, Map<Class<?>, List<Command<?>>> map) {
            if (!map.containsKey(contextType)) {
                map.put(contextType, new ArrayList());
            }
            map.get(contextType).add(command);
            return this;
        }

        public JdbcProducer build() {
            if (this.jdbc == null) {
                throw new IllegalArgumentException("Jdbc is mandatory");
            }
            JdbcProducerBackend jdbcBackend = new JdbcProducerBackend(){

                @Override
                public CommandExecution getCommandExecution() {
                    return CommandExecution.DEFAULT;
                }

                @Override
                public Jdbc getJdbc() {
                    return Builder.this.jdbc;
                }

                @Override
                protected <TContext extends CommandContext> List<Command<?>> getPreCommands(Class<TContext> contextType) {
                    return (List)Builder.this.preCommands.get(contextType);
                }

                @Override
                protected <TContext extends CommandContext> List<Command<?>> getPostCommands(Class<TContext> contextType) {
                    return (List)Builder.this.postCommands.get(contextType);
                }

                @Override
                protected <T> T get(Class<T> instanceType) {
                    Object rt = Builder.this.instances.get(instanceType);
                    if (rt == null) {
                        try {
                            rt = instanceType.newInstance();
                        }
                        catch (Exception e) {
                            throw Throwables.propagate(e);
                        }
                    }
                    return (T)rt;
                }
            };
            return new JdbcProducer(jdbcBackend);
        }

        public <T> Builder register(Class<T> instanceType, T instance) {
            this.instances.put(instanceType, instance);
            return this;
        }
    }
}

