/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OPredicates;
import org.odata4j.core.PrefixedNamespace;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmAnnotationElement;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmOnDeleteAction;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmReferentialConstraint;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.XmlFormatParser;
import org.odata4j.internal.AndroidCompat;
import org.odata4j.stax2.Attribute2;
import org.odata4j.stax2.Namespace2;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;

public class EdmxFormatParser
extends XmlFormatParser {
    private static final Set<String> NON_USER_NAMESPACES = Enumerable.create((Object[])new String[]{"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "http://schemas.microsoft.com/ado/2007/08/dataservices", "http://schemas.microsoft.com/ado/2006/04/edm", "http://schemas.microsoft.com/ado/2007/05/edm", "http://schemas.microsoft.com/ado/2008/01/edm", "http://schemas.microsoft.com/ado/2008/09/edm", "http://schemas.microsoft.com/ado/2008/09/edm", "http://schemas.microsoft.com/ado/2009/08/edm", "http://schemas.microsoft.com/ado/2009/11/edm", "http://schemas.microsoft.com/ado/2007/06/edmx", "http://schemas.microsoft.com/ado/2009/02/edm/annotation"}).toSet();
    private final EdmDataServices.Builder dataServices = EdmDataServices.newBuilder();

    public EdmDataServices parseMetadata(XMLEventReader2 reader) {
        ArrayList<EdmSchema.Builder> schemas = new ArrayList<EdmSchema.Builder>();
        List<PrefixedNamespace> namespaces = null;
        ODataVersion version = null;
        boolean foundDataServices = false;
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            boolean shouldReturn = false;
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, XmlFormatParser.EDMX_EDMX)) {
                    namespaces = this.getExtensionNamespaces(event.asStartElement());
                } else if (EdmxFormatParser.isElement(event, EDMX_DATASERVICES)) {
                    foundDataServices = true;
                    String str = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "DataServiceVersion"));
                    version = str != null ? ODataVersion.parse(str) : null;
                } else if (EdmxFormatParser.isElement(event, EDM2006_SCHEMA, EDM2007_SCHEMA, EDM2008_1_SCHEMA, EDM2008_9_SCHEMA, EDM2009_8_SCHEMA, EDM2009_11_SCHEMA)) {
                    schemas.add(this.parseEdmSchema(reader, event.asStartElement()));
                    if (!foundDataServices) {
                        shouldReturn = true;
                    }
                }
            }
            if (EdmxFormatParser.isEndElement(event, EDMX_DATASERVICES)) {
                shouldReturn = true;
            }
            if (!shouldReturn) continue;
            this.dataServices.setVersion(version).addSchemas(schemas).addNamespaces(namespaces);
            this.resolve();
            return this.dataServices.build();
        }
        throw new UnsupportedOperationException();
    }

    private void resolve() {
        Map allEetsByFQName = Enumerable.create(this.dataServices.getEntityTypes()).toMap(EdmEntityType.Builder.func1_getFullyQualifiedTypeName());
        Map allEetsByFQAliasName = Enumerable.create(this.dataServices.getEntityTypes()).where(EdmEntityType.Builder.pred1_hasAlias()).toMap(EdmEntityType.Builder.func1_getFQAliasName());
        Map allEasByFQName = Enumerable.create(this.dataServices.getAssociations()).toMap(EdmAssociation.Builder.func1_getFQNamespaceName());
        for (EdmSchema.Builder edmSchema : this.dataServices.getSchemas()) {
            for (int i = 0; i < edmSchema.getAssociations().size(); ++i) {
                EdmAssociation.Builder builder = edmSchema.getAssociations().get(i);
                builder.getEnd1().setType((EdmEntityType.Builder)allEetsByFQName.get(builder.getEnd1().getTypeName()));
                builder.getEnd2().setType((EdmEntityType.Builder)allEetsByFQName.get(builder.getEnd2().getTypeName()));
            }
            for (EdmEntityType.Builder builder : edmSchema.getEntityTypes()) {
                List<EdmNavigationProperty.Builder> navProps = builder.getNavigationProperties();
                for (int i = 0; i < navProps.size(); ++i) {
                    EdmNavigationProperty.Builder tmp = navProps.get(i);
                    final EdmAssociation.Builder ea = (EdmAssociation.Builder)allEasByFQName.get(tmp.getRelationshipName());
                    if (ea == null) {
                        throw new IllegalArgumentException("Invalid relationship name " + tmp.getRelationshipName());
                    }
                    List finalEnds = Enumerable.create((Object[])new String[]{tmp.getFromRoleName(), tmp.getToRoleName()}).select((Func1)new Func1<String, EdmAssociationEnd.Builder>(){

                        public EdmAssociationEnd.Builder apply(String input) {
                            if (ea.getEnd1().getRole().equals(input)) {
                                return ea.getEnd1();
                            }
                            if (ea.getEnd2().getRole().equals(input)) {
                                return ea.getEnd2();
                            }
                            throw new IllegalArgumentException("Invalid role name " + input);
                        }
                    }).toList();
                    tmp.setRelationship(ea).setFromTo((EdmAssociationEnd.Builder)finalEnds.get(0), (EdmAssociationEnd.Builder)finalEnds.get(1));
                }
            }
            for (EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getEntitySets().size(); ++i) {
                    EdmEntitySet.Builder tmpEes = builder.getEntitySets().get(i);
                    EdmEntityType.Builder eet = (EdmEntityType.Builder)allEetsByFQName.get(tmpEes.getEntityTypeName());
                    if (eet == null) {
                        eet = (EdmEntityType.Builder)allEetsByFQAliasName.get(tmpEes.getEntityTypeName());
                    }
                    if (eet == null) {
                        throw new IllegalArgumentException("Invalid entity type " + tmpEes.getEntityTypeName());
                    }
                    builder.getEntitySets().set(i, (EdmEntitySet.Builder)((EdmEntitySet.Builder)EdmEntitySet.newBuilder().setName(tmpEes.getName()).setEntityType(eet).setAnnotationElements(tmpEes.getAnnotationElements())).setAnnotations(tmpEes.getAnnotations()));
                }
            }
            for (final EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getAssociationSets().size(); ++i) {
                    EdmAssociationSet.Builder tmpEas = builder.getAssociationSets().get(i);
                    final EdmAssociation.Builder ea = (EdmAssociation.Builder)allEasByFQName.get(tmpEas.getAssociationName());
                    List finalEnds = Enumerable.create((Object[])new EdmAssociationSetEnd.Builder[]{tmpEas.getEnd1(), tmpEas.getEnd2()}).select((Func1)new Func1<EdmAssociationSetEnd.Builder, EdmAssociationSetEnd.Builder>(){

                        public EdmAssociationSetEnd.Builder apply(EdmAssociationSetEnd.Builder input) {
                            EdmAssociationEnd.Builder eae;
                            EdmAssociationEnd.Builder builder2 = ea.getEnd1().getRole().equals(input.getRoleName()) ? ea.getEnd1() : (eae = ea.getEnd2().getRole().equals(input.getRoleName()) ? ea.getEnd2() : null);
                            if (eae == null) {
                                throw new IllegalArgumentException("Invalid role name " + input.getRoleName());
                            }
                            EdmEntitySet.Builder ees = (EdmEntitySet.Builder)Enumerable.create(builder.getEntitySets()).first(OPredicates.nameEquals(EdmEntitySet.Builder.class, input.getEntitySetName()));
                            return (EdmAssociationSetEnd.Builder)((EdmAssociationSetEnd.Builder)EdmAssociationSetEnd.newBuilder().setRole(eae).setEntitySet(ees).setAnnotationElements(input.getAnnotationElements())).setAnnotations(input.getAnnotations());
                        }
                    }).toList();
                    tmpEas.setAssociation(ea).setEnds((EdmAssociationSetEnd.Builder)finalEnds.get(0), (EdmAssociationSetEnd.Builder)finalEnds.get(1));
                }
            }
            for (EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getFunctionImports().size(); ++i) {
                    final EdmFunctionImport.Builder tmpEfi = builder.getFunctionImports().get(i);
                    EdmEntitySet.Builder ees = (EdmEntitySet.Builder)Enumerable.create(builder.getEntitySets()).firstOrNull((Predicate1)new Predicate1<EdmEntitySet.Builder>(){

                        public boolean apply(EdmEntitySet.Builder input) {
                            return input.getName().equals(tmpEfi.getEntitySetName());
                        }
                    });
                    EdmCollectionType.Builder typeBuilder = null;
                    if (tmpEfi.getReturnTypeName() != null) {
                        typeBuilder = this.dataServices.resolveType(tmpEfi.getReturnTypeName());
                        if (typeBuilder == null) {
                            throw new RuntimeException("Edm-type not found: " + tmpEfi.getReturnTypeName());
                        }
                        if (tmpEfi.isCollection()) {
                            typeBuilder = EdmCollectionType.newBuilder().setKind(EdmProperty.CollectionKind.Collection).setCollectionType(typeBuilder);
                        }
                    }
                    builder.getFunctionImports().set(i, (EdmFunctionImport.Builder)((EdmFunctionImport.Builder)EdmFunctionImport.newBuilder().setName(tmpEfi.getName()).setEntitySet(ees).setReturnType(typeBuilder).setHttpMethod(tmpEfi.getHttpMethod()).addParameters(tmpEfi.getParameters()).setAnnotationElements(tmpEfi.getAnnotationElements())).setAnnotations(tmpEfi.getAnnotations()));
                }
            }
            for (Map.Entry entry : allEetsByFQName.entrySet()) {
                String baseTypeName = ((EdmEntityType.Builder)entry.getValue()).getFQBaseTypeName();
                if (baseTypeName == null) continue;
                EdmEntityType.Builder baseType = (EdmEntityType.Builder)allEetsByFQName.get(baseTypeName);
                if (baseType == null) {
                    throw new IllegalArgumentException("Invalid baseType: " + baseTypeName);
                }
                ((EdmEntityType.Builder)entry.getValue()).setBaseType(baseType);
            }
        }
    }

    private EdmSchema.Builder parseEdmSchema(XMLEventReader2 reader, StartElement2 schemaElement) {
        String schemaNamespace = schemaElement.getAttributeByName(new QName2("Namespace")).getValue();
        String schemaAlias = EdmxFormatParser.getAttributeValueIfExists(schemaElement, new QName2("Alias"));
        ArrayList<EdmEntityType.Builder> edmEntityTypes = new ArrayList<EdmEntityType.Builder>();
        ArrayList<EdmComplexType.Builder> edmComplexTypes = new ArrayList<EdmComplexType.Builder>();
        ArrayList<EdmAssociation.Builder> edmAssociations = new ArrayList<EdmAssociation.Builder>();
        ArrayList<EdmEntityContainer.Builder> edmEntityContainers = new ArrayList<EdmEntityContainer.Builder>();
        ArrayList annotElements = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_ENTITYTYPE, EDM2007_ENTITYTYPE, EDM2008_1_ENTITYTYPE, EDM2008_9_ENTITYTYPE, EDM2009_8_ENTITYTYPE, EDM2009_11_ENTITYTYPE)) {
                    EdmEntityType.Builder edmEntityType = this.parseEdmEntityType(reader, schemaNamespace, schemaAlias, event.asStartElement());
                    edmEntityTypes.add(edmEntityType);
                } else if (EdmxFormatParser.isElement(event, EDM2006_ASSOCIATION, EDM2007_ASSOCIATION, EDM2008_1_ASSOCIATION, EDM2008_9_ASSOCIATION, EDM2009_8_ASSOCIATION, EDM2009_11_ASSOCIATION)) {
                    EdmAssociation.Builder edmAssociation = this.parseEdmAssociation(reader, schemaNamespace, schemaAlias, event.asStartElement());
                    edmAssociations.add(edmAssociation);
                } else if (EdmxFormatParser.isElement(event, EDM2006_COMPLEXTYPE, EDM2007_COMPLEXTYPE, EDM2008_1_COMPLEXTYPE, EDM2008_9_COMPLEXTYPE, EDM2009_8_COMPLEXTYPE, EDM2009_11_COMPLEXTYPE)) {
                    EdmComplexType.Builder edmComplexType = this.parseEdmComplexType(reader, schemaNamespace, event.asStartElement());
                    edmComplexTypes.add(edmComplexType);
                } else if (EdmxFormatParser.isElement(event, EDM2006_ENTITYCONTAINER, EDM2007_ENTITYCONTAINER, EDM2008_1_ENTITYCONTAINER, EDM2008_9_ENTITYCONTAINER, EDM2009_8_ENTITYCONTAINER, EDM2009_11_ENTITYCONTAINER)) {
                    EdmEntityContainer.Builder edmEntityContainer = this.parseEdmEntityContainer(reader, schemaNamespace, event.asStartElement());
                    edmEntityContainers.add(edmEntityContainer);
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, reader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, schemaElement.getName())) continue;
            return (EdmSchema.Builder)((EdmSchema.Builder)EdmSchema.newBuilder().setNamespace(schemaNamespace).setAlias(schemaAlias).addEntityTypes(edmEntityTypes).addComplexTypes(edmComplexTypes).addAssociations(edmAssociations).addEntityContainers(edmEntityContainers).setAnnotations(this.getAnnotations(schemaElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmEntityContainer.Builder parseEdmEntityContainer(XMLEventReader2 reader, String schemaNamespace, StartElement2 entityContainerElement) {
        String name = entityContainerElement.getAttributeByName("Name").getValue();
        boolean isDefault = "true".equals(EdmxFormatParser.getAttributeValueIfExists(entityContainerElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer")));
        String lazyLoadingEnabledValue = EdmxFormatParser.getAttributeValueIfExists(entityContainerElement, new QName2("http://schemas.microsoft.com/ado/2009/02/edm/annotation", "LazyLoadingEnabled"));
        Boolean lazyLoadingEnabled = lazyLoadingEnabledValue == null ? null : Boolean.valueOf(lazyLoadingEnabledValue.equals("true"));
        String extendz = EdmxFormatParser.getAttributeValueIfExists(entityContainerElement, new QName2("Extends"));
        ArrayList<EdmEntitySet.Builder> edmEntitySets = new ArrayList<EdmEntitySet.Builder>();
        ArrayList<EdmAssociationSet.Builder> edmAssociationSets = new ArrayList<EdmAssociationSet.Builder>();
        ArrayList<EdmFunctionImport.Builder> edmFunctionImports = new ArrayList<EdmFunctionImport.Builder>();
        ArrayList annotElements = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_ENTITYSET, EDM2007_ENTITYSET, EDM2008_1_ENTITYSET, EDM2008_9_ENTITYSET, EDM2009_8_ENTITYSET, EDM2009_11_ENTITYSET)) {
                    EdmEntitySet.Builder entitySet = this.parseEdmEntitySet(reader, schemaNamespace, event.asStartElement());
                    edmEntitySets.add(entitySet);
                } else if (EdmxFormatParser.isElement(event, EDM2006_ASSOCIATIONSET, EDM2007_ASSOCIATIONSET, EDM2008_1_ASSOCIATIONSET, EDM2008_9_ASSOCIATIONSET, EDM2009_8_ASSOCIATIONSET, EDM2009_11_ASSOCIATIONSET)) {
                    edmAssociationSets.add(this.parseEdmAssociationSet(reader, schemaNamespace, event.asStartElement()));
                } else if (EdmxFormatParser.isElement(event, EDM2006_FUNCTIONIMPORT, EDM2007_FUNCTIONIMPORT, EDM2008_1_FUNCTIONIMPORT, EDM2008_9_FUNCTIONIMPORT, EDM2009_8_FUNCTIONIMPORT, EDM2009_11_FUNCTIONIMPORT)) {
                    edmFunctionImports.add(this.parseEdmFunctionImport(reader, schemaNamespace, event.asStartElement()));
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, reader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, entityContainerElement.getName())) continue;
            return (EdmEntityContainer.Builder)((EdmEntityContainer.Builder)EdmEntityContainer.newBuilder().setName(name).setIsDefault(isDefault).setLazyLoadingEnabled(lazyLoadingEnabled).setExtendz(extendz).addEntitySets(edmEntitySets).addAssociationSets(edmAssociationSets).addFunctionImports(edmFunctionImports).setAnnotations(this.getAnnotations(entityContainerElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmEntitySet.Builder parseEdmEntitySet(XMLEventReader2 reader, String schemaNamespace, StartElement2 entitySetStartElement) {
        ArrayList annotElements = new ArrayList();
        String name = entitySetStartElement.getAttributeByName("Name").getValue();
        String entityTypeName = EdmxFormatParser.getAttributeValueIfExists(entitySetStartElement, "EntityType");
        while (reader.hasNext()) {
            EdmAnnotation<?> anElement;
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement() && (anElement = this.getAnnotationElements(event, reader)) != null) {
                annotElements.add(anElement);
            }
            if (!EdmxFormatParser.isEndElement(event, entitySetStartElement.getName())) continue;
            return (EdmEntitySet.Builder)((EdmEntitySet.Builder)EdmEntitySet.newBuilder().setName(name).setEntityTypeName(entityTypeName).setAnnotations(this.getAnnotations(entitySetStartElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmFunctionImport.Builder parseEdmFunctionImport(XMLEventReader2 reader, String schemaNamespace, StartElement2 functionImportElement) {
        boolean isCollection;
        String name = functionImportElement.getAttributeByName("Name").getValue();
        String entitySet = EdmxFormatParser.getAttributeValueIfExists(functionImportElement, "EntitySet");
        Attribute2 returnTypeAttr = functionImportElement.getAttributeByName("ReturnType");
        String returnType = returnTypeAttr != null ? returnTypeAttr.getValue() : null;
        ArrayList annotElements = new ArrayList();
        boolean bl = isCollection = returnType != null && returnType.matches("^Collection\\(.*\\)$");
        if (isCollection) {
            returnType = returnType.substring(11, returnType.length() - 1);
        }
        String httpMethod = EdmxFormatParser.getAttributeValueIfExists(functionImportElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HttpMethod"));
        ArrayList<EdmFunctionParameter.Builder> parameters = new ArrayList<EdmFunctionParameter.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_PARAMETER, EDM2007_PARAMETER, EDM2008_1_PARAMETER, EDM2008_9_PARAMETER, EDM2009_8_PARAMETER, EDM2009_11_PARAMETER)) {
                    StartElement2 paramStartElement = event.asStartElement();
                    EdmFunctionParameter.Builder functionParameter = this.parseEdmFunctionParameter(reader, paramStartElement);
                    parameters.add(functionParameter);
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, reader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, functionImportElement.getName())) continue;
            return (EdmFunctionImport.Builder)((EdmFunctionImport.Builder)EdmFunctionImport.newBuilder().setName(name).setEntitySetName(entitySet).setReturnTypeName(returnType).setIsCollection(isCollection).setHttpMethod(httpMethod).addParameters(parameters).setAnnotations(this.getAnnotations(functionImportElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmFunctionParameter.Builder parseEdmFunctionParameter(XMLEventReader2 reader, StartElement2 paramStartElement) {
        ArrayList annotElements = new ArrayList();
        Attribute2 modeAttribute = paramStartElement.getAttributeByName("Mode");
        String nullableS = EdmxFormatParser.getAttributeValueIfExists(paramStartElement, "Nullable");
        String maxLength = EdmxFormatParser.getAttributeValueIfExists(paramStartElement, "MaxLength");
        String precision = EdmxFormatParser.getAttributeValueIfExists(paramStartElement, "Precision");
        String scale = EdmxFormatParser.getAttributeValueIfExists(paramStartElement, "Scale");
        while (reader.hasNext()) {
            EdmAnnotation<?> anElement;
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement() && (anElement = this.getAnnotationElements(event, reader)) != null) {
                annotElements.add(anElement);
            }
            if (!EdmxFormatParser.isEndElement(event, paramStartElement.getName())) continue;
            return (EdmFunctionParameter.Builder)((EdmFunctionParameter.Builder)EdmFunctionParameter.newBuilder().setName(paramStartElement.getAttributeByName("Name").getValue()).setType(EdmType.newDeferredBuilder(paramStartElement.getAttributeByName("Type").getValue(), this.dataServices)).setMode(modeAttribute != null ? EdmFunctionParameter.Mode.valueOf(modeAttribute.getValue()) : null).setNullable(nullableS == null ? null : Boolean.valueOf("true".equalsIgnoreCase(nullableS))).setMaxLength(maxLength == null ? null : Integer.valueOf(maxLength.equals("Max") ? Integer.MAX_VALUE : Integer.parseInt(maxLength))).setPrecision(precision == null ? null : Integer.valueOf(Integer.parseInt(precision))).setScale(scale == null ? null : Integer.valueOf(Integer.parseInt(scale))).setAnnotations(this.getAnnotations(paramStartElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociationSet.Builder parseEdmAssociationSet(XMLEventReader2 reader, String schemaNamespace, StartElement2 associationSetElement) {
        String name = associationSetElement.getAttributeByName("Name").getValue();
        String associationName = associationSetElement.getAttributeByName("Association").getValue();
        ArrayList<EdmAssociationSetEnd.Builder> ends = new ArrayList<EdmAssociationSetEnd.Builder>();
        ArrayList annotElements = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_END, EDM2007_END, EDM2008_1_END, EDM2008_9_END, EDM2009_8_END, EDM2009_11_END)) {
                    StartElement2 endStartElement = event.asStartElement();
                    EdmAssociationSetEnd.Builder assocSetEnd = this.parseEdmAssociationSetEnd(reader, endStartElement);
                    ends.add(assocSetEnd);
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, reader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, associationSetElement.getName())) continue;
            return (EdmAssociationSet.Builder)((EdmAssociationSet.Builder)EdmAssociationSet.newBuilder().setName(name).setAssociationName(associationName).setEnds((EdmAssociationSetEnd.Builder)ends.get(0), (EdmAssociationSetEnd.Builder)ends.get(1)).setAnnotations(this.getAnnotations(associationSetElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociationSetEnd.Builder parseEdmAssociationSetEnd(XMLEventReader2 reader, StartElement2 endStartElement) {
        ArrayList annotElements = new ArrayList();
        String role = endStartElement.getAttributeByName("Role").getValue();
        String entitySetName = endStartElement.getAttributeByName("EntitySet").getValue();
        while (reader.hasNext()) {
            EdmAnnotation<?> anElement;
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement() && (anElement = this.getAnnotationElements(event, reader)) != null) {
                annotElements.add(anElement);
            }
            if (!EdmxFormatParser.isEndElement(event, endStartElement.getName())) continue;
            return (EdmAssociationSetEnd.Builder)((EdmAssociationSetEnd.Builder)EdmAssociationSetEnd.newBuilder().setRoleName(role).setEntitySetName(entitySetName).setAnnotations(this.getAnnotations(endStartElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociation.Builder parseEdmAssociation(XMLEventReader2 reader, String schemaNamespace, String schemaAlias, StartElement2 associationElement) {
        String name = associationElement.getAttributeByName("Name").getValue();
        ArrayList<EdmAssociationEnd.Builder> ends = new ArrayList<EdmAssociationEnd.Builder>();
        ArrayList annotElements = new ArrayList();
        EdmReferentialConstraint.Builder referentialConstraint = null;
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_END, EDM2007_END, EDM2008_1_END, EDM2008_9_END, EDM2009_8_END, EDM2009_11_END)) {
                    EdmAssociationEnd.Builder edmAssociationEnd = this.parseEdmAssociationEnd(reader, event);
                    ends.add(edmAssociationEnd);
                } else if (EdmxFormatParser.isElement(event, EDM2006_REFCONSTRAINT, EDM2007_REFCONSTRAINT, EDM2008_1_REFCONSTRAINT, EDM2008_9_REFCONSTRAINT, EDM2009_8_REFCONSTRAINT, EDM2009_11_REFCONSTRAINT)) {
                    StartElement2 constraintElement = event.asStartElement();
                    referentialConstraint = this.parseEdmConstraintElement(reader, constraintElement);
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, reader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, associationElement.getName())) continue;
            return (EdmAssociation.Builder)((EdmAssociation.Builder)EdmAssociation.newBuilder().setNamespace(schemaNamespace).setAlias(schemaAlias).setName(name).setEnds((EdmAssociationEnd.Builder)ends.get(0), (EdmAssociationEnd.Builder)ends.get(1)).setRefConstraint(referentialConstraint == null ? null : referentialConstraint).setAnnotations(this.getAnnotations(associationElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmReferentialConstraint.Builder parseEdmConstraintElement(XMLEventReader2 tmpReader, StartElement2 constraintElement) {
        ArrayList annotElements = new ArrayList();
        List<String> principalPropertyRef = new ArrayList<String>();
        List<String> dependentPropertyRef = new ArrayList<String>();
        String principalRole = null;
        String dependentRole = null;
        while (tmpReader.hasNext()) {
            XMLEvent2 event = tmpReader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_PRINCIPAL, EDM2007_PRINCIPAL, EDM2008_1_PRINCIPAL, EDM2008_9_PRINCIPAL, EDM2009_8_PRINCIPAL, EDM2009_11_PRINCIPAL)) {
                    StartElement2 principalElement = event.asStartElement();
                    principalPropertyRef = this.parsePropertyRef(tmpReader, principalElement);
                    principalRole = principalElement.getAttributeByName("Role").getValue();
                } else if (EdmxFormatParser.isElement(event, EDM2006_DEPENDENT, EDM2007_DEPENDENT, EDM2008_1_DEPENDENT, EDM2008_9_DEPENDENT, EDM2009_8_DEPENDENT, EDM2009_11_DEPENDENT)) {
                    StartElement2 dependentElement = event.asStartElement();
                    dependentPropertyRef = this.parsePropertyRef(tmpReader, dependentElement);
                    dependentRole = dependentElement.getAttributeByName("Role").getValue();
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, tmpReader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, constraintElement.getName())) continue;
            return (EdmReferentialConstraint.Builder)((EdmReferentialConstraint.Builder)EdmReferentialConstraint.newBuilder().setPrincipalRole(principalRole).setDependentRole(dependentRole).addDependentReferences(dependentPropertyRef).addPrincipalReferences(principalPropertyRef).setAnnotationElements(annotElements)).setAnnotations(this.getAnnotations(constraintElement));
        }
        throw new UnsupportedOperationException();
    }

    private List<String> parsePropertyRef(XMLEventReader2 tmpReader, StartElement2 startElement) {
        ArrayList<String> references = new ArrayList<String>();
        while (tmpReader.hasNext()) {
            XMLEvent2 event = tmpReader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_PROPERTYREF, EDM2007_PROPERTYREF, EDM2008_1_PROPERTYREF, EDM2008_9_PROPERTYREF, EDM2009_8_PROPERTYREF, EDM2009_11_PROPERTYREF)) {
                references.add(event.asStartElement().getAttributeByName("Name").getValue());
            }
            if (!EdmxFormatParser.isEndElement(event, startElement.getName())) continue;
            return references;
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociationEnd.Builder parseEdmAssociationEnd(XMLEventReader2 tmpReader, XMLEvent2 event) {
        ArrayList annotElements = new ArrayList();
        StartElement2 endStartElement = event.asStartElement();
        String onDeleteAction = null;
        while (tmpReader.hasNext()) {
            XMLEvent2 event2 = tmpReader.nextEvent();
            if (event2.isStartElement()) {
                if (EdmxFormatParser.isElement(event2, EDM2006_ONDELETE, EDM2007_ONDELETE, EDM2008_1_ONDELETE, EDM2008_9_ONDELETE, EDM2009_8_ONDELETE, EDM2009_11_ONDELETE)) {
                    StartElement2 onDeleteStartElement = event2.asStartElement();
                    onDeleteAction = onDeleteStartElement.getAttributeByName("Action").getValue();
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event2, tmpReader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event2, endStartElement.getName())) continue;
            return (EdmAssociationEnd.Builder)((EdmAssociationEnd.Builder)EdmAssociationEnd.newBuilder().setRole(endStartElement.getAttributeByName("Role").getValue()).setTypeName(endStartElement.getAttributeByName("Type").getValue()).setMultiplicity(EdmMultiplicity.fromSymbolString(endStartElement.getAttributeByName("Multiplicity").getValue())).setOnDeleteAction(onDeleteAction == null ? null : EdmOnDeleteAction.fromSymbolString(onDeleteAction)).setAnnotations(this.getAnnotations(endStartElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmProperty.Builder parseEdmProperty(XMLEventReader2 reader, XMLEvent2 event) {
        ArrayList annotElements = new ArrayList();
        StartElement2 startElement = event.asStartElement();
        String propertyName = EdmxFormatParser.getAttributeValueIfExists(startElement, "Name");
        String propertyType = EdmxFormatParser.getAttributeValueIfExists(startElement, "Type");
        String propertyNullable = EdmxFormatParser.getAttributeValueIfExists(startElement, "Nullable");
        String maxLength = EdmxFormatParser.getAttributeValueIfExists(startElement, "MaxLength");
        String unicode = EdmxFormatParser.getAttributeValueIfExists(startElement, "Unicode");
        String fixedLength = EdmxFormatParser.getAttributeValueIfExists(startElement, "FixedLength");
        String collation = EdmxFormatParser.getAttributeValueIfExists(startElement, "Collation");
        String collectionKindS = EdmxFormatParser.getAttributeValueIfExists(startElement, "CollectionKind");
        EdmProperty.CollectionKind ckind = EdmProperty.CollectionKind.NONE;
        if (collectionKindS != null) {
            ckind = Enum.valueOf(EdmProperty.CollectionKind.class, collectionKindS);
        }
        String defaultValue = EdmxFormatParser.getAttributeValueIfExists(startElement, "DefaultValue");
        String precision = EdmxFormatParser.getAttributeValueIfExists(startElement, "Precision");
        String scale = EdmxFormatParser.getAttributeValueIfExists(startElement, "Scale");
        String storeGeneratedPattern = EdmxFormatParser.getAttributeValueIfExists(startElement, new QName2("http://schemas.microsoft.com/ado/2009/02/edm/annotation", "StoreGeneratedPattern"));
        String concurrencyMode = EdmxFormatParser.getAttributeValueIfExists(startElement, "ConcurrencyMode");
        String mimeType = EdmxFormatParser.getAttributeValueIfExists(startElement, M_MIMETYPE);
        String fcTargetPath = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_TARGETPATH);
        String fcContentKind = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_CONTENTKIND);
        String fcKeepInContent = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_KEEPINCONTENT);
        String fcEpmContentKind = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_EPMCONTENTKIND);
        String fcEpmKeepInContent = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_EPMKEEPINCONTENT);
        String fcNsPrefix = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_NSPREFIX);
        String fcNsUri = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_NSURI);
        while (reader.hasNext()) {
            EdmAnnotation<?> anElement;
            XMLEvent2 event2 = reader.nextEvent();
            if (event2.isStartElement() && (anElement = this.getAnnotationElements(event2, reader)) != null) {
                annotElements.add(anElement);
            }
            if (!EdmxFormatParser.isEndElement(event2, startElement.getName())) continue;
            return (EdmProperty.Builder)((EdmProperty.Builder)EdmProperty.newBuilder(propertyName).setType(EdmType.newDeferredBuilder(propertyType, this.dataServices)).setNullable("true".equalsIgnoreCase(propertyNullable)).setMaxLength(maxLength == null ? null : Integer.valueOf(maxLength.equals("Max") ? Integer.MAX_VALUE : Integer.parseInt(maxLength))).setUnicode(unicode == null ? null : Boolean.valueOf("true".equalsIgnoreCase(unicode))).setFixedLength(fixedLength == null ? null : Boolean.valueOf("true".equalsIgnoreCase(fixedLength))).setCollation(collation).setConcurrencyMode(concurrencyMode).setStoreGeneratedPattern(storeGeneratedPattern).setMimeType(mimeType).setFcTargetPath(fcTargetPath).setFcContentKind(fcContentKind).setFcKeepInContent(fcKeepInContent).setFcEpmContentKind(fcEpmContentKind).setFcEpmKeepInContent(fcEpmKeepInContent).setFcNsPrefix(fcNsPrefix).setFcNsUri(fcNsUri).setCollectionKind(ckind).setDefaultValue(defaultValue).setPrecision(precision == null ? null : Integer.valueOf(Integer.parseInt(precision))).setScale(scale == null ? null : Integer.valueOf(Integer.parseInt(scale))).setAnnotations(this.getAnnotations(startElement))).setAnnotationElements(annotElements.isEmpty() ? null : annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmComplexType.Builder parseEdmComplexType(XMLEventReader2 reader, String schemaNamespace, StartElement2 complexTypeElement) {
        String name = complexTypeElement.getAttributeByName("Name").getValue();
        String isAbstractS = EdmxFormatParser.getAttributeValueIfExists(complexTypeElement, "Abstract");
        String baseType = EdmxFormatParser.getAttributeValueIfExists(complexTypeElement, "BaseType");
        ArrayList<EdmProperty.Builder> edmProperties = new ArrayList<EdmProperty.Builder>();
        ArrayList annotElements = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_PROPERTY, EDM2007_PROPERTY, EDM2008_1_PROPERTY, EDM2008_9_PROPERTY, EDM2009_8_PROPERTY, EDM2009_11_PROPERTY)) {
                    edmProperties.add(this.parseEdmProperty(reader, event));
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, reader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, complexTypeElement.getName())) continue;
            EdmComplexType.Builder complexType = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace(schemaNamespace)).setName(name)).setBaseType(baseType).addProperties(edmProperties)).setAnnotations(this.getAnnotations(complexTypeElement))).setAnnotationElements(annotElements);
            if (isAbstractS != null) {
                complexType.setIsAbstract("true".equals(isAbstractS));
            }
            return complexType;
        }
        throw new UnsupportedOperationException();
    }

    private EdmEntityType.Builder parseEdmEntityType(XMLEventReader2 reader, String schemaNamespace, String schemaAlias, StartElement2 entityTypeElement) {
        String name = entityTypeElement.getAttributeByName("Name").getValue();
        String hasStreamValue = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HasStream"));
        Boolean hasStream = hasStreamValue == null ? null : Boolean.valueOf(hasStreamValue.equals("true"));
        String baseType = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, "BaseType");
        String isAbstractS = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, "Abstract");
        String openTypeValue = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, "OpenType");
        Boolean openType = openTypeValue == null ? null : Boolean.valueOf(openTypeValue.equals("true"));
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<EdmProperty.Builder> edmProperties = new ArrayList<EdmProperty.Builder>();
        ArrayList<EdmNavigationProperty.Builder> edmNavigationProperties = new ArrayList<EdmNavigationProperty.Builder>();
        ArrayList annotElements = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isStartElement()) {
                if (EdmxFormatParser.isElement(event, EDM2006_PROPERTYREF, EDM2007_PROPERTYREF, EDM2008_1_PROPERTYREF, EDM2008_9_PROPERTYREF, EDM2009_8_PROPERTYREF, EDM2009_11_PROPERTYREF)) {
                    keys.add(event.asStartElement().getAttributeByName("Name").getValue());
                } else if (EdmxFormatParser.isElement(event, EDM2006_PROPERTY, EDM2007_PROPERTY, EDM2008_1_PROPERTY, EDM2008_9_PROPERTY, EDM2009_8_PROPERTY, EDM2009_11_PROPERTY)) {
                    edmProperties.add(this.parseEdmProperty(reader, event));
                } else if (EdmxFormatParser.isElement(event, EDM2006_NAVIGATIONPROPERTY, EDM2007_NAVIGATIONPROPERTY, EDM2008_1_NAVIGATIONPROPERTY, EDM2008_9_NAVIGATIONPROPERTY, EDM2009_8_NAVIGATIONPROPERTY, EDM2009_11_NAVIGATIONPROPERTY)) {
                    edmNavigationProperties.add(this.parseEdmNavigationProperty(reader, event));
                } else {
                    EdmAnnotation<?> anElement = this.getAnnotationElements(event, reader);
                    if (anElement != null) {
                        annotElements.add(anElement);
                    }
                }
            }
            if (!EdmxFormatParser.isEndElement(event, entityTypeElement.getName())) continue;
            return (EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace(schemaNamespace)).setAlias(schemaAlias).setName(name)).setHasStream(hasStream).setOpenType(openType).addKeys(keys).addProperties(edmProperties)).addNavigationProperties(edmNavigationProperties).setBaseType(baseType).setIsAbstract(isAbstractS == null ? null : Boolean.valueOf("true".equals(isAbstractS)))).setAnnotations(this.getAnnotations(entityTypeElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    private EdmNavigationProperty.Builder parseEdmNavigationProperty(XMLEventReader2 reader, XMLEvent2 event) {
        ArrayList annotElements = new ArrayList();
        StartElement2 navPropStartElement = event.asStartElement();
        String associationName = navPropStartElement.getAttributeByName("Name").getValue();
        String relationshipName = navPropStartElement.getAttributeByName("Relationship").getValue();
        String fromRoleName = navPropStartElement.getAttributeByName("FromRole").getValue();
        String toRoleName = navPropStartElement.getAttributeByName("ToRole").getValue();
        while (reader.hasNext()) {
            EdmAnnotation<?> anElement;
            event = reader.nextEvent();
            if (event.isStartElement() && (anElement = this.getAnnotationElements(event, reader)) != null) {
                annotElements.add(anElement);
            }
            if (!EdmxFormatParser.isEndElement(event, navPropStartElement.getName())) continue;
            return (EdmNavigationProperty.Builder)((EdmNavigationProperty.Builder)EdmNavigationProperty.newBuilder(associationName).setRelationshipName(relationshipName).setFromToName(fromRoleName, toRoleName).setAnnotations(this.getAnnotations(navPropStartElement))).setAnnotationElements(annotElements);
        }
        throw new UnsupportedOperationException();
    }

    protected boolean isExtensionNamespace(String namespaceUri) {
        return namespaceUri != null && !AndroidCompat.String_isEmpty(namespaceUri.trim()) && !namespaceUri.contains("schemas.microsoft.com");
    }

    protected List<EdmAnnotation<?>> getAnnotations(StartElement2 element) {
        try {
            Enumerable<Attribute2> atts = element.getAttributes();
            ArrayList annots = new ArrayList();
            for (Attribute2 att : atts) {
                QName2 q = att.getName();
                if (!this.isExtensionNamespace(q.getNamespaceUri())) continue;
                annots.add(EdmAnnotation.attribute(q.getNamespaceUri(), q.getPrefix(), q.getLocalPart(), att.getValue()));
            }
            return annots;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected List<PrefixedNamespace> getExtensionNamespaces(StartElement2 startElement) {
        try {
            Enumerable<Namespace2> nse = startElement.getNamespaces();
            ArrayList<PrefixedNamespace> nsl = new ArrayList<PrefixedNamespace>();
            for (Namespace2 ns : nse) {
                if (!this.isExtensionNamespace(ns.getNamespaceURI())) continue;
                nsl.add(new PrefixedNamespace(ns.getNamespaceURI(), ns.getPrefix()));
            }
            return nsl;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected EdmAnnotation<?> getAnnotationElements(XMLEvent2 event, XMLEventReader2 reader) {
        StartElement2 annotationStartElement = event.asStartElement();
        QName2 q = annotationStartElement.getName();
        String value = null;
        EdmAnnotationElement<String> element = null;
        ArrayList list = new ArrayList();
        if (!NON_USER_NAMESPACES.contains(q.getNamespaceUri())) {
            while (reader.hasNext()) {
                event = reader.nextEvent();
                if (event.isStartElement()) {
                    EdmAnnotation<?> childElement = this.getAnnotationElements(event, reader);
                    if (childElement == null) continue;
                    list.add(childElement);
                    continue;
                }
                if (event.isCharacters()) {
                    value = event.asCharacters().getData().trim();
                    continue;
                }
                if (!event.isEndElement()) continue;
                element = value != null ? EdmAnnotation.element(q.getNamespaceUri(), q.getPrefix(), q.getLocalPart(), String.class, value) : EdmAnnotation.element(q.getNamespaceUri(), q.getPrefix(), q.getLocalPart(), String.class, "");
                element.setAnnotationElements(list);
                element.setAnnotations(this.getAnnotations(annotationStartElement));
                return element;
            }
        }
        return null;
    }
}

