/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.Named;
import org.odata4j.core.OPredicates;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmStructuralType;

public class EdmEntityType
extends EdmStructuralType {
    private final String alias;
    private final Boolean hasStream;
    private final Boolean openType;
    private final List<String> keys;
    private final List<EdmNavigationProperty> navigationProperties;

    private EdmEntityType(String namespace, String alias, String name, Boolean hasStream, Boolean openType, ImmutableList<String> keys, EdmEntityType baseType, List<EdmProperty.Builder> properties, ImmutableList<EdmNavigationProperty> navigationProperties, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annotations, ImmutableList<EdmAnnotation<?>> annotElements, Boolean isAbstract) {
        super(baseType, namespace, name, properties, doc, annotations, annotElements, isAbstract);
        this.alias = alias;
        this.hasStream = hasStream;
        this.openType = openType;
        List<String> list = keys == null || keys.isEmpty() ? (baseType == null ? this.findConventionalKeys() : null) : (this.keys = keys);
        if (baseType == null && this.keys == null) {
            throw new IllegalArgumentException("Root types must have keys");
        }
        if (baseType != null && this.keys != null) {
            throw new IllegalArgumentException("Keys on root types only");
        }
        this.navigationProperties = navigationProperties;
    }

    private List<String> findConventionalKeys() {
        for (EdmProperty prop : this.getProperties()) {
            if (!prop.getName().equalsIgnoreCase("Id") || !prop.getType().isSimple() || prop.isNullable()) continue;
            return Enumerable.create((Object[])new String[]{prop.getName()}).toList();
        }
        return null;
    }

    public String getAlias() {
        return this.alias;
    }

    public Boolean getHasStream() {
        return this.hasStream;
    }

    public Boolean getOpenType() {
        return this.openType;
    }

    public String getFQAliasName() {
        return this.alias == null ? null : this.alias + "." + this.getName();
    }

    @Override
    public String toString() {
        return String.format("EdmEntityType[%s.%s,alias=%s]", this.getNamespace(), this.getName(), this.alias);
    }

    public EdmNavigationProperty findNavigationProperty(String name) {
        return (EdmNavigationProperty)this.getNavigationProperties().firstOrNull(OPredicates.nameEquals(EdmNavigationProperty.class, name));
    }

    public Enumerable<EdmNavigationProperty> getDeclaredNavigationProperties() {
        return Enumerable.create(this.navigationProperties);
    }

    public EdmNavigationProperty findDeclaredNavigationProperty(String name) {
        return (EdmNavigationProperty)this.getDeclaredNavigationProperties().firstOrNull(OPredicates.nameEquals(EdmNavigationProperty.class, name));
    }

    public Enumerable<EdmNavigationProperty> getNavigationProperties() {
        return this.isRootType() ? this.getDeclaredNavigationProperties() : this.getBaseType().getNavigationProperties().union(this.getDeclaredNavigationProperties());
    }

    public List<String> getKeys() {
        return this.isRootType() ? this.keys : this.getBaseType().getKeys();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(EdmEntityType entityType, EdmItem.BuilderContext context) {
        return context.newBuilder(entityType, new Builder());
    }

    public static class Builder
    extends EdmStructuralType.Builder<EdmEntityType, Builder>
    implements Named {
        private String alias;
        private Boolean hasStream;
        private Boolean openType;
        private final List<String> keys = new ArrayList<String>();
        private final List<EdmNavigationProperty.Builder> navigationProperties = new ArrayList<EdmNavigationProperty.Builder>();
        private Builder baseTypeBuilder;
        private String baseTypeNameFQ;

        @Override
        Builder newBuilder(EdmEntityType entityType, EdmItem.BuilderContext context) {
            this.fillBuilder(entityType, context);
            context.register(entityType, this);
            this.alias = entityType.alias;
            this.hasStream = entityType.hasStream;
            this.openType = entityType.openType;
            if (entityType.keys != null) {
                this.keys.addAll(entityType.keys);
            }
            if (entityType.getBaseType() != null) {
                this.baseTypeBuilder = EdmEntityType.newBuilder(entityType.getBaseType(), context);
            }
            for (EdmNavigationProperty navigationProperty : entityType.navigationProperties) {
                this.navigationProperties.add(EdmNavigationProperty.newBuilder(navigationProperty, context));
            }
            return this;
        }

        @Override
        public EdmEntityType build() {
            return (EdmEntityType)this._build();
        }

        @Override
        protected EdmEntityType buildImpl() {
            ArrayList<EdmNavigationProperty> builtNavProps = new ArrayList<EdmNavigationProperty>();
            for (EdmNavigationProperty.Builder navigationProperty : this.navigationProperties) {
                builtNavProps.add(navigationProperty.build());
            }
            return new EdmEntityType(this.namespace, this.alias, this.name, this.hasStream, this.openType, ImmutableList.copyOf(this.keys), this.baseTypeBuilder != null ? this.baseTypeBuilder.build() : null, this.properties, ImmutableList.copyOf(builtNavProps), this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()), ImmutableList.copyOf(this.getAnnotationElements()), this.isAbstract);
        }

        public Builder addNavigationProperties(EdmNavigationProperty.Builder ... navigationProperties) {
            return this.addNavigationProperties(Arrays.asList(navigationProperties));
        }

        public Builder addNavigationProperties(List<EdmNavigationProperty.Builder> navProperties) {
            this.navigationProperties.addAll(navProperties);
            return this;
        }

        public Builder addKeys(List<String> keys) {
            this.keys.addAll(keys);
            return this;
        }

        public Builder addKeys(String ... keys) {
            return this.addKeys(Arrays.asList(keys));
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Builder setBaseType(Builder baseType) {
            this.baseTypeBuilder = baseType;
            return this;
        }

        public Builder setBaseType(String baseTypeName) {
            this.baseTypeNameFQ = baseTypeName;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setHasStream(Boolean hasStream) {
            this.hasStream = hasStream;
            return this;
        }

        public Builder setOpenType(Boolean openType) {
            this.openType = openType;
            return this;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getFQAliasName() {
            return this.alias == null ? null : this.alias + "." + this.getName();
        }

        public String getFQBaseTypeName() {
            return this.baseTypeNameFQ != null ? this.baseTypeNameFQ : (this.baseType != null ? this.baseType.getFullyQualifiedTypeName() : null);
        }

        public List<EdmNavigationProperty.Builder> getNavigationProperties() {
            return this.navigationProperties;
        }

        public Func<EdmEntityType> builtFunc() {
            return new Func<EdmEntityType>(){

                public EdmEntityType apply() {
                    return Builder.this.build();
                }
            };
        }

        public static Func1<Builder, String> func1_getFullyQualifiedTypeName() {
            return new Func1<Builder, String>(){

                public String apply(Builder input) {
                    return input.getFullyQualifiedTypeName();
                }
            };
        }

        public static Func1<Builder, String> func1_getFQAliasName() {
            return new Func1<Builder, String>(){

                public String apply(Builder input) {
                    return input.getFQAliasName();
                }
            };
        }

        public static Predicate1<Builder> pred1_hasAlias() {
            return new Predicate1<Builder>(){

                public boolean apply(Builder input) {
                    return input.getAlias() != null;
                }
            };
        }
    }
}

