/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.core4j.Enumerable;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OPredicates;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmComplexType;

public class OComplexObjects {
    private OComplexObjects() {
    }

    public static OComplexObject.Builder newBuilder(EdmComplexType type) {
        return new BuilderImpl(type);
    }

    public static OComplexObject create(EdmComplexType type, List<OProperty<?>> properties) {
        return new OComplexObjectImpl(type, properties);
    }

    private static class OComplexObjectImpl
    implements OComplexObject {
        private final EdmComplexType complexType;
        private final List<OProperty<?>> properties;

        public OComplexObjectImpl(EdmComplexType complexType, List<OProperty<?>> properties) {
            if (complexType == null) {
                throw new IllegalArgumentException("complexType cannot be null");
            }
            this.complexType = complexType;
            this.properties = Collections.unmodifiableList(properties);
        }

        public String toString() {
            return "OComplexObject[" + Enumerable.create(this.getProperties()).join(",") + "]";
        }

        @Override
        public List<OProperty<?>> getProperties() {
            return this.properties;
        }

        @Override
        public OProperty<?> getProperty(String propName) {
            return (OProperty)Enumerable.create(this.properties).first(OPredicates.propertyNameEquals(propName));
        }

        @Override
        public <T> OProperty<T> getProperty(String propName, Class<T> propClass) {
            return this.getProperty(propName);
        }

        @Override
        public EdmComplexType getType() {
            return this.complexType;
        }
    }

    private static class BuilderImpl
    implements OComplexObject.Builder {
        private final EdmComplexType type;
        private final List<OProperty<?>> values = new LinkedList();

        BuilderImpl(EdmComplexType type) {
            this.type = type;
        }

        @Override
        public OComplexObject.Builder add(OProperty<?> value) {
            this.values.add(value);
            return this;
        }

        @Override
        public OComplexObject build() {
            return new OComplexObjectImpl(this.type, this.values);
        }

        @Override
        public EdmComplexType getType() {
            return this.type;
        }
    }
}

