/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.command;

import org.odata4j.command.Command;
import org.odata4j.command.CommandContext;
import org.odata4j.command.FilterCommand;
import org.odata4j.command.FilterResult;

public interface CommandExecution {
    public static final CommandExecution DEFAULT = new CommandExecution(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <TContext extends CommandContext, TCommand extends Command<TContext>> void execute(TCommand command, TContext context) throws Exception {
            if (command instanceof FilterCommand) {
                try {
                    command.execute(context);
                    return;
                }
                catch (Exception e) {
                    FilterCommand filterCommand = (FilterCommand)command;
                    FilterResult postProcessResult = filterCommand.postProcess(context, e);
                    if (postProcessResult == FilterResult.HANDLED) return;
                    throw e;
                }
            } else {
                command.execute(context);
            }
        }
    };

    public <TContext extends CommandContext, TCommand extends Command<TContext>> void execute(TCommand var1, TContext var2) throws Exception;
}

