/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;
import org.teiid.translator.mongodb.MutableDBRef;

class MongoDocument {
    private RuntimeMetadata metadata;
    private Table table;
    private MutableDBRef mergeKey;
    private List<MutableDBRef> pullKeys = new ArrayList<MutableDBRef>();
    private LinkedHashMap<List<String>, MutableDBRef> foreignKeys = new LinkedHashMap();
    private ArrayList<MutableDBRef> copyto = new ArrayList();
    private MongoDocument mergeDocument;
    private HashMap<String, MongoDocument> relatedDocs = new HashMap();

    public MongoDocument(Table table, RuntimeMetadata metadata) throws TranslatorException {
        this.table = table;
        this.metadata = metadata;
        if (this.isEmbeddable() && this.isMerged()) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18013, new Object[]{table.getName()}));
        }
        this.build();
    }

    public Table getTable() {
        return this.table;
    }

    public Table getTargetTable() throws TranslatorException {
        if (this.isMerged()) {
            Table merge = this.getMergeTable();
            MongoDocument mergeDoc = this.getDocument(merge.getName());
            if (mergeDoc.isMerged()) {
                return mergeDoc.getTargetTable();
            }
            return merge;
        }
        return this.getTable();
    }

    public MongoDocument getTargetDocument() throws TranslatorException {
        if (this.isMerged()) {
            return this.getMergeDocument().getTargetDocument();
        }
        return this;
    }

    public boolean isEmbeddable() {
        return MongoDocument.isEmbeddable(this.table);
    }

    public static boolean isEmbeddable(Table tbl) {
        return Boolean.parseBoolean(tbl.getProperty("{http://www.teiid.org/translator/mongodb/2013}EMBEDDABLE", false));
    }

    public boolean isMerged() {
        return this.table.getProperty("{http://www.teiid.org/translator/mongodb/2013}MERGE", false) != null;
    }

    public Table getMergeTable() throws TranslatorException {
        String tblName = this.table.getProperty("{http://www.teiid.org/translator/mongodb/2013}MERGE", false);
        if (tblName == null) {
            return null;
        }
        Table mergeTable = this.metadata.getTable(((Schema)this.table.getParent()).getName(), tblName);
        return mergeTable;
    }

    public MongoDocument getMergeDocument() throws TranslatorException {
        if (this.mergeDocument != null) {
            return this.mergeDocument;
        }
        Table mergeTable = this.getMergeTable();
        if (mergeTable != null) {
            this.mergeDocument = new MongoDocument(mergeTable, this.metadata);
        }
        return this.mergeDocument;
    }

    public MutableDBRef.Assosiation getMergeAssosiation() {
        return this.mergeKey.getAssosiation();
    }

    public boolean hasEmbeddedDocuments() {
        return !this.pullKeys.isEmpty();
    }

    public List<String> getEmbeddedDocumentNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (MutableDBRef ref : this.pullKeys) {
            names.add(ref.getName());
        }
        return names;
    }

    private void build() throws TranslatorException {
        this.buildForeignKeyReferences();
        this.buildEmbeddableIntoReferences();
        this.buildEmbeddedReferences();
        this.buildMergeKey();
    }

    private void buildEmbeddableIntoReferences() {
        if (this.isEmbeddable()) {
            for (Table t : ((Schema)this.table.getParent()).getTables().values()) {
                for (ForeignKey fk : t.getForeignKeys()) {
                    if (!((Table)fk.getPrimaryKey().getParent()).equals((Object)this.table)) continue;
                    MutableDBRef key = new MutableDBRef();
                    key.setName(this.table.getName());
                    key.setParentTable(t.getName());
                    key.setEmbeddedTable(this.table.getName());
                    key.setColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
                    key.setReferenceColumns(fk.getReferenceColumns());
                    key.setAssosiation(MutableDBRef.Assosiation.ONE);
                    this.setReferenceName(key, t, MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
                    this.copyto.add(key);
                }
            }
        }
    }

    private void setReferenceName(MutableDBRef key, Table table, List<String> columnNames) {
        boolean ispartofPK = false;
        for (String column : columnNames) {
            if (!MongoDBSelectVisitor.isPartOfPrimaryKey(table, column)) continue;
            ispartofPK = true;
        }
        if (ispartofPK) {
            key.setReferenceName("_id");
        } else {
            key.setReferenceName(columnNames.get(0));
        }
    }

    private void buildEmbeddedReferences() throws TranslatorException {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            Table referenceTable = (Table)fk.getPrimaryKey().getParent();
            MongoDocument refereceDoc = new MongoDocument(referenceTable, this.metadata);
            if (!refereceDoc.isEmbeddable() || this.isMerged() && this.getMergeTable().getName().equals(referenceTable.getName())) continue;
            MutableDBRef key = new MutableDBRef();
            key.setName(fk.getReferenceTableName());
            key.setParentTable(this.table.getName());
            key.setColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            key.setReferenceColumns(fk.getReferenceColumns());
            key.setEmbeddedTable(fk.getReferenceTableName());
            if (MongoDBSelectVisitor.isPartOfForeignKey(referenceTable, (String)fk.getReferenceColumns().get(0))) {
                key.setIdReference(MongoDBSelectVisitor.getForeignKeyRefTable(referenceTable, (String)fk.getReferenceColumns().get(0)));
            }
            this.setReferenceName(key, this.table, MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            this.pullKeys.add(key);
        }
    }

    private void buildForeignKeyReferences() throws TranslatorException {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            MutableDBRef key = new MutableDBRef();
            key.setParentTable(fk.getReferenceTableName());
            key.setEmbeddedTable(this.table.getName());
            key.setName(fk.getName());
            key.setColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            key.setReferenceColumns(fk.getReferenceColumns());
            Table refTable = this.metadata.getTable(((Schema)this.table.getParent()).getName(), fk.getReferenceTableName());
            this.setReferenceName(key, refTable, MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            this.foreignKeys.put(MongoDBSelectVisitor.getColumnNames(fk.getColumns()), key);
        }
    }

    private void buildMergeKey() throws TranslatorException {
        if (!this.isMerged()) {
            return;
        }
        Table mergeTable = this.getMergeTable();
        for (ForeignKey fk : this.table.getForeignKeys()) {
            if (!((Table)fk.getPrimaryKey().getParent()).equals((Object)mergeTable)) continue;
            MutableDBRef key = new MutableDBRef();
            key.setName(this.table.getName());
            key.setParentTable(mergeTable.getName());
            key.setColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            key.setReferenceColumns(fk.getReferenceColumns());
            key.setEmbeddedTable(this.table.getName());
            key.setAssosiation(MutableDBRef.Assosiation.MANY);
            this.setReferenceName(key, mergeTable, MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            for (ForeignKey fk1 : mergeTable.getForeignKeys()) {
                if (!((Table)fk1.getPrimaryKey().getParent()).equals((Object)this.table)) continue;
                key.setAssosiation(MutableDBRef.Assosiation.ONE);
                break;
            }
            if (this.sameKeys(MongoDBSelectVisitor.getColumnNames(fk.getColumns()), MongoDBSelectVisitor.getColumnNames(this.table.getPrimaryKey().getColumns()))) {
                key.setAssosiation(MutableDBRef.Assosiation.ONE);
            }
            this.mergeKey = key;
            break;
        }
    }

    private boolean sameKeys(List<String> columns1, List<String> columns2) {
        if (columns1.size() != columns2.size()) {
            return false;
        }
        for (String name : columns1) {
            if (columns2.contains(name)) continue;
            return false;
        }
        return true;
    }

    public void updateReferenceColumnValue(String tableName, String columnName, Object value) {
        for (Map.Entry<List<String>, MutableDBRef> pairs : this.foreignKeys.entrySet()) {
            List<String> keys = pairs.getKey();
            MutableDBRef ref = pairs.getValue();
            if (!keys.contains(columnName) || !ref.getEmbeddedTable().equals(tableName)) continue;
            ref.setId(columnName, value);
        }
        if (this.mergeKey != null && this.mergeKey.getColumns().contains(columnName) && this.mergeKey.getEmbeddedTable().equals(tableName)) {
            for (int i = 0; i < this.mergeKey.getColumns().size(); ++i) {
                String column = this.mergeKey.getColumns().get(i);
                if (!column.equals(columnName)) continue;
                String referenceColumn = this.mergeKey.getReferenceColumns().get(i);
                this.mergeKey.setId(referenceColumn, value);
            }
        }
        if (!this.pullKeys.isEmpty()) {
            for (MutableDBRef ref : this.pullKeys) {
                if (!ref.getColumns().contains(columnName) || !ref.getParentTable().equals(tableName)) continue;
                for (int i = 0; i < ref.getColumns().size(); ++i) {
                    String column = ref.getColumns().get(i);
                    if (!column.equals(columnName)) continue;
                    String referenceColumn = ref.getReferenceColumns().get(i);
                    ref.setId(referenceColumn, value);
                }
            }
        }
    }

    public MutableDBRef getFKReference(String columnName) {
        for (Map.Entry<List<String>, MutableDBRef> pairs : this.foreignKeys.entrySet()) {
            List<String> keys = pairs.getKey();
            MutableDBRef ref = pairs.getValue();
            if (!keys.contains(columnName)) continue;
            return ref;
        }
        return null;
    }

    public DBObject getEmbeddedDocument(DB mongoDB, String docName) {
        for (MutableDBRef ref : this.pullKeys) {
            DBRef dbRef;
            if (!ref.getName().equals(docName) || (dbRef = ref.getDBRef(mongoDB, false)) == null) continue;
            return mongoDB.getCollection(dbRef.getRef()).findOne((DBObject)new BasicDBObject("_id", dbRef.getId()));
        }
        return null;
    }

    public Object[] getMergeParentCriteria(DB mongo, DBObject match, String embedTable, BasicDBObject insert, boolean nested) throws TranslatorException {
        DBCollection collection;
        DBObject result;
        MongoDocument mergeDocument = this.getDocument(this.mergeKey.getParentTable());
        if (mergeDocument.isMerged()) {
            if (match == null) {
                match = new BasicDBObject(this.mergeKey.getParentTable() + "._id", this.mergeKey.getDBRef(mongo, true).getId());
                embedTable = "$";
            } else {
                DBCollection collection2 = mongo.getCollection(this.mergeKey.getParentTable());
                DBObject result2 = collection2.findOne(match);
                match = new BasicDBObject(this.mergeKey.getParentTable() + "._id", result2.get("_id"));
            }
            return mergeDocument.getMergeParentCriteria(mongo, match, embedTable + "." + this.getTable().getName(), insert, true);
        }
        if (match == null) {
            DBRef dbRef = this.mergeKey.getDBRef(mongo, true);
            if (dbRef == null) {
                throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18015, new Object[]{this.mergeKey.getParentTable(), this.mergeKey.getId(), this.mergeKey.getEmbeddedTable()}));
            }
            match = new BasicDBObject("_id", dbRef.getId());
        }
        if ((result = (collection = mongo.getCollection(this.mergeKey.getParentTable())).findOne(match)) == null) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18006, new Object[]{this.mergeKey.getParentTable(), this.mergeKey.getId(), this.mergeKey.getEmbeddedTable()}));
        }
        ((BasicDBObject)match).append("_id", result.get("_id"));
        String nestedKey = this.getTable().getName();
        if (embedTable != null) {
            nestedKey = this.getTable().getName() + "." + embedTable;
        }
        return new Object[]{match, new BasicDBObject(nestedKey, (Object)insert), this.getMergeAssosiation(), nested};
    }

    public List<MutableDBRef> getEmbeddedInReferences() {
        return this.copyto;
    }

    MutableDBRef getMergeKey() {
        return this.mergeKey;
    }

    List<MutableDBRef> getEmbeddableReferences() {
        return this.pullKeys;
    }

    public boolean embeds(MongoDocument right) throws TranslatorException {
        if (this.equals(right)) {
            return false;
        }
        for (MutableDBRef ref : this.pullKeys) {
            if (!ref.getEmbeddedTable().equals(right.getTable().getName())) continue;
            return true;
        }
        for (MutableDBRef ref : right.getEmbeddedInReferences()) {
            if (!ref.getParentTable().equals(this.getTable().getName())) continue;
            return true;
        }
        if (right.isMerged() && right.mergeKey.getParentTable().equals(this.getTable().getName())) {
            return true;
        }
        return this.nested(right);
    }

    private boolean nested(MongoDocument right) throws TranslatorException {
        MongoDocument parent;
        MongoDocument parent2;
        for (MutableDBRef ref : this.pullKeys) {
            parent2 = this.getDocument(ref.getEmbeddedTable());
            if (!parent2.embeds(right)) continue;
            return true;
        }
        for (MutableDBRef ref : right.getEmbeddedInReferences()) {
            parent2 = this.getDocument(ref.getParentTable());
            if (!parent2.embeds(right)) continue;
            return true;
        }
        return right.isMerged() && (parent = this.getDocument(right.mergeKey.getParentTable())).embeds(right);
    }

    private MongoDocument getDocument(String tblName) throws TranslatorException {
        if (this.relatedDocs.get(tblName) != null) {
            return this.relatedDocs.get(tblName);
        }
        Table tbl = this.metadata.getTable(((Schema)this.table.getParent()).getName(), tblName);
        MongoDocument doc = new MongoDocument(tbl, this.metadata);
        this.relatedDocs.put(tblName, doc);
        return doc;
    }

    public MutableDBRef getEmbeddedDocumentReferenceKey(MongoDocument right) throws TranslatorException {
        if (this.equals(right)) {
            return null;
        }
        for (MutableDBRef ref : this.pullKeys) {
            if (!ref.getEmbeddedTable().equals(right.getTable().getName())) continue;
            return ref.clone();
        }
        for (MutableDBRef ref : right.getEmbeddedInReferences()) {
            if (!ref.getParentTable().equals(this.getTable().getName())) continue;
            return ref.clone();
        }
        if (right.isMerged() && right.mergeKey.getParentTable().equals(this.getTable().getName())) {
            return right.mergeKey.clone();
        }
        return this.getNestedEmbeddedDocumentReferenceKey(right);
    }

    private MutableDBRef getNestedEmbeddedDocumentReferenceKey(MongoDocument right) throws TranslatorException {
        MongoDocument parent;
        MongoDocument parent2;
        for (MutableDBRef ref : this.pullKeys) {
            parent2 = this.getDocument(ref.getEmbeddedTable());
            if (!parent2.embeds(right)) continue;
            MutableDBRef key = parent2.getEmbeddedDocumentReferenceKey(right);
            key.setName(parent2.getTable().getName() + "." + key.getName());
            return key;
        }
        for (MutableDBRef ref : right.getEmbeddedInReferences()) {
            parent2 = this.getDocument(ref.getParentTable());
            if (!parent2.embeds(right)) continue;
            MutableDBRef key = parent2.getEmbeddedDocumentReferenceKey(right);
            key.setName(parent2.getTable().getName() + "." + key.getName());
            return key;
        }
        if (right.isMerged() && (parent = this.getDocument(right.mergeKey.getParentTable())).embeds(right)) {
            MutableDBRef key = parent.getEmbeddedDocumentReferenceKey(right);
            key.setName(parent.getTable().getName() + "." + key.getName());
            return key;
        }
        return null;
    }

    public boolean isPartOfPrimaryKey(String columnName) {
        KeyRecord pk = this.table.getPrimaryKey();
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCompositePrimaryKey() {
        KeyRecord pk = this.table.getPrimaryKey();
        return pk.getColumns().size() > 1;
    }

    boolean isPartOfForeignKey(String columnName) {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isMultiKeyForeignKey(String columnName) {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return fk.getColumns().size() > 1;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MongoDocument)) {
            return false;
        }
        MongoDocument other = (MongoDocument)obj;
        return this.getTable().getName().equals(other.getTable().getName());
    }

    public String toString() {
        return this.getTable().getName();
    }
}

