/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution.visitors;

import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Join;
import org.teiid.language.NamedTable;
import org.teiid.language.TableReference;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.execution.visitors.SelectVisitor;

public class JoinQueryVisitor
extends SelectVisitor {
    private Table leftTableInJoin;
    private Table rightTableInJoin;
    private Table childTable;

    public JoinQueryVisitor(RuntimeMetadata metadata) {
        super(metadata);
    }

    public void visit(Join join) {
        try {
            TableReference left = join.getLeftItem();
            NamedTable leftGroup = (NamedTable)left;
            this.leftTableInJoin = leftGroup.getMetadataObject();
            this.loadColumnMetadata(leftGroup);
            TableReference right = join.getRightItem();
            NamedTable rightGroup = (NamedTable)right;
            this.rightTableInJoin = rightGroup.getMetadataObject();
            this.loadColumnMetadata((NamedTable)right);
            Comparison criteria = (Comparison)join.getCondition();
            Expression lExp = criteria.getLeftExpression();
            Expression rExp = criteria.getRightExpression();
            if (this.isIdColumn(rExp) || this.isIdColumn(lExp)) {
                Column rColumn = ((ColumnReference)rExp).getMetadataObject();
                String rTableName = rColumn.getParent().getNameInSource();
                Column lColumn = ((ColumnReference)lExp).getMetadataObject();
                String lTableName = lColumn.getParent().getNameInSource();
                if (this.leftTableInJoin.getNameInSource().equals(rTableName) || this.leftTableInJoin.getNameInSource().equals(lTableName) && this.rightTableInJoin.getNameInSource().equals(rTableName) || this.rightTableInJoin.getNameInSource().equals(lTableName) && !rTableName.equals(lTableName)) {
                    Expression fKey = !this.isIdColumn(lExp) ? lExp : rExp;
                    this.table = this.childTable = (Table)((ColumnReference)fKey).getMetadataObject().getParent();
                } else {
                    super.visit(criteria);
                }
            } else {
                super.visit(criteria);
            }
        }
        catch (TranslatorException ce) {
            this.exceptions.add(ce);
        }
    }

    @Override
    public String getQuery() throws TranslatorException {
        if (this.isParentToChildJoin()) {
            return super.getQuery();
        }
        if (!this.exceptions.isEmpty()) {
            throw (TranslatorException)((Object)this.exceptions.get(0));
        }
        StringBuilder select = new StringBuilder();
        select.append("SELECT").append(" ");
        this.addSelect(this.leftTableInJoin.getNameInSource(), select, true);
        select.append("(");
        StringBuilder subselect = new StringBuilder();
        subselect.append("SELECT").append(" ");
        this.addSelect(this.rightTableInJoin.getNameInSource(), subselect, false);
        subselect.append(" ");
        subselect.append("FROM").append(" ");
        subselect.append(this.rightTableInJoin.getNameInSource()).append('s');
        subselect.append(")").append(" ");
        select.append((CharSequence)subselect);
        select.append("FROM").append(" ");
        select.append(this.leftTableInJoin.getNameInSource()).append(" ");
        this.addCriteriaString(select);
        this.appendGroupByHaving(select);
        select.append((CharSequence)this.limitClause);
        return select.toString();
    }

    public boolean isParentToChildJoin() {
        return this.childTable.equals((Object)this.leftTableInJoin);
    }

    void addSelect(String tableNameInSource, StringBuilder result, boolean addComma) {
        boolean firstTime = true;
        for (DerivedColumn symbol : this.selectSymbols) {
            Expression expression = symbol.getExpression();
            if (expression instanceof ColumnReference) {
                Column element = ((ColumnReference)expression).getMetadataObject();
                String tableName = element.getParent().getNameInSource();
                if (!this.isParentToChildJoin() && !tableNameInSource.equals(tableName)) continue;
                if (!firstTime) {
                    result.append(", ");
                } else {
                    firstTime = false;
                }
                this.appendColumnReference(result, (ColumnReference)expression);
                continue;
            }
            if (expression instanceof AggregateFunction) {
                if (!firstTime) {
                    result.append(", ");
                } else {
                    firstTime = false;
                }
                this.appendAggregateFunction(result, (AggregateFunction)expression);
                continue;
            }
            throw new AssertionError((Object)("Unknown select symbol type" + symbol));
        }
        if (!firstTime && addComma) {
            result.append(", ");
        }
    }
}

