/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import java.util.ArrayList;
import javax.resource.ResourceException;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.AbstractUpdateExecution;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.visitors.UpdateVisitor;

public class UpdateExecutionImpl
extends AbstractUpdateExecution {
    public UpdateExecutionImpl(SalesForceExecutionFactory ef, Command command, SalesforceConnection salesforceConnection, RuntimeMetadata metadata, ExecutionContext context) {
        super(ef, command, salesforceConnection, metadata, context);
    }

    public void execute() throws TranslatorException {
        UpdateVisitor visitor = new UpdateVisitor(this.getMetadata());
        visitor.visit((Update)this.command);
        String[] ids = this.getIDs(((Update)this.command).getWhere(), visitor);
        if (ids != null && ids.length > 0) {
            ArrayList<JAXBElement> elements = new ArrayList<JAXBElement>();
            for (SetClause clause : ((Update)this.command).getChanges()) {
                ColumnReference element = clause.getSymbol();
                Column column = element.getMetadataObject();
                String val = ((Literal)clause.getValue()).toString();
                JAXBElement messageElem = new JAXBElement(new QName(column.getNameInSource()), String.class, (Object)Util.stripQutes(val));
                elements.add(messageElem);
            }
            ArrayList<DataPayload> updateDataList = new ArrayList<DataPayload>();
            for (int i = 0; i < ids.length; ++i) {
                DataPayload data = new DataPayload();
                data.setType(visitor.getTableName());
                data.setID(ids[i]);
                data.setMessageElements(elements);
                updateDataList.add(data);
            }
            try {
                this.result = this.getConnection().update(updateDataList);
            }
            catch (ResourceException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
    }
}

