/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import java.util.List;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.language.Call;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.execution.GetDeletedExecutionImpl;
import org.teiid.translator.salesforce.execution.GetUpdatedExecutionImpl;
import org.teiid.translator.salesforce.execution.ProcedureExecutionParent;
import org.teiid.translator.salesforce.execution.SalesforceProcedureExecution;

public class ProcedureExecutionParentImpl
implements ProcedureExecution,
ProcedureExecutionParent {
    public static final String GET_DELETED = "GetDeleted";
    public static final String GET_UPDATED = "GetUpdated";
    private Call command;
    private ExecutionContext executionContext;
    private RuntimeMetadata metadata;
    private SalesforceProcedureExecution execution;
    private SalesforceConnection connection;

    public ProcedureExecutionParentImpl(Call command, SalesforceConnection connection, RuntimeMetadata metadata, ExecutionContext executionContext) {
        this.setCommand(command);
        this.setConnection(connection);
        this.setMetadata(metadata);
        this.setExecutionContext(executionContext);
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return this.execution.getOutputParameterValues();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        return this.execution.next();
    }

    public void cancel() throws TranslatorException {
        this.execution.cancel();
    }

    public void close() {
        this.execution.close();
    }

    public void execute() throws TranslatorException {
        String name = this.getCommand().getMetadataObject().getNameInSource();
        if (name == null) {
            name = this.getCommand().getProcedureName();
        }
        if (GET_UPDATED.equalsIgnoreCase(name)) {
            this.execution = new GetUpdatedExecutionImpl(this);
        } else if (GET_DELETED.equalsIgnoreCase(name)) {
            this.execution = new GetDeletedExecutionImpl(this);
        } else {
            throw new TeiidRuntimeException("Unknown procedure " + this.getCommand().getProcedureName() + " with name in source " + name);
        }
        this.execution.execute(this);
    }

    public void setCommand(Call command) {
        this.command = command;
    }

    @Override
    public Call getCommand() {
        return this.command;
    }

    private void setConnection(SalesforceConnection connection) {
        this.connection = connection;
    }

    @Override
    public SalesforceConnection getConnection() {
        return this.connection;
    }

    private void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    private void setMetadata(RuntimeMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public RuntimeMetadata getMetadata() {
        return this.metadata;
    }
}

