/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import com.sforce.async.BatchResult;
import com.sforce.async.JobInfo;
import com.sforce.async.Result;
import com.sforce.async.SObject;
import java.sql.SQLWarning;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.resource.ResourceException;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Literal;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.AbstractUpdateExecution;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.visitors.InsertVisitor;

public class InsertExecutionImpl
extends AbstractUpdateExecution {
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private JobInfo activeJob;
    private Iterator<? extends List<?>> rowIter;
    private String objectName;

    public InsertExecutionImpl(SalesForceExecutionFactory ef, Command command, SalesforceConnection salesforceConnection, RuntimeMetadata metadata, ExecutionContext context) throws TranslatorException {
        super(ef, command, salesforceConnection, metadata, context);
        Insert insert = (Insert)command;
        if (insert.getParameterValues() != null) {
            this.rowIter = insert.getParameterValues();
        }
        InsertVisitor visitor = new InsertVisitor(this.getMetadata());
        visitor.visit(insert);
        this.objectName = visitor.getTableName();
    }

    public void execute() throws TranslatorException {
        try {
            Insert insert = (Insert)this.command;
            if (insert.getParameterValues() == null) {
                DataPayload data = new DataPayload();
                data.setType(this.objectName);
                data.setMessageElements(this.buildSingleRowInsertPayload(insert));
                this.result = this.getConnection().create(data);
            } else {
                if (this.activeJob == null) {
                    this.activeJob = this.runBulkInsert(insert);
                }
                if (this.activeJob != null) {
                    BatchResult batchResult = this.getConnection().getBulkResults(this.activeJob);
                    for (Result result : batchResult.getResult()) {
                        if (result.isSuccess() && result.isCreated()) {
                            ++this.result;
                            continue;
                        }
                        if (result.getErrors().length <= 0) continue;
                        this.context.addWarning((Exception)new SQLWarning(result.getErrors()[0].getMessage(), result.getErrors()[0].getStatusCode().name()));
                    }
                    this.activeJob = null;
                    throw new DataNotAvailableException();
                }
            }
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private JobInfo runBulkInsert(Insert insert) throws ResourceException {
        if (this.rowIter.hasNext()) {
            List<SObject> rows = this.buildBulkRowPayload(insert, this.rowIter, this.executionFactory.getMaxBulkInsertBatchSize());
            return this.getConnection().executeBulkJob(this.objectName, rows);
        }
        return null;
    }

    private List<JAXBElement> buildSingleRowInsertPayload(Insert insert) throws TranslatorException {
        List columns = insert.getColumns();
        List values = ((ExpressionValueSource)insert.getValueSource()).getValues();
        if (columns.size() != values.size()) {
            throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13006, new Object[0]));
        }
        ArrayList<JAXBElement> elements = new ArrayList<JAXBElement>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = ((ColumnReference)columns.get(i)).getMetadataObject();
            QName qname = new QName(column.getNameInSource());
            Object value = values.get(i);
            if (value == null) {
                JAXBElement jbe = new JAXBElement(qname, String.class, null);
                elements.add(jbe);
                continue;
            }
            if (!(value instanceof Literal)) {
                throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13007, new Object[0]));
            }
            Literal literalValue = (Literal)values.get(i);
            String val = literalValue.getType().equals(DataTypeManager.DefaultDataClasses.STRING) ? Util.stripQutes((String)literalValue.getValue()) : literalValue.getValue().toString();
            JAXBElement jbe = new JAXBElement(qname, String.class, (Object)val);
            elements.add(jbe);
        }
        return elements;
    }

    protected List<SObject> buildBulkRowPayload(Insert insert, Iterator<? extends List<?>> it, int rowCount) {
        ArrayList<SObject> rows = new ArrayList<SObject>();
        List columns = insert.getColumns();
        int boundCount = 0;
        while (it.hasNext() && boundCount < rowCount) {
            ++boundCount;
            List<?> values = it.next();
            SObject sobj = new SObject();
            for (int i = 0; i < columns.size(); ++i) {
                ColumnReference element = (ColumnReference)columns.get(i);
                Column column = element.getMetadataObject();
                Object value = values.get(i);
                if (value == null) {
                    sobj.setField(column.getNameInSource(), null);
                    continue;
                }
                if (DataTypeManager.getRuntimeType(value.getClass()).equals(DataTypeManager.DefaultDataClasses.STRING)) {
                    sobj.setField(column.getNameInSource(), Util.stripQutes((String)value));
                    continue;
                }
                if (DataTypeManager.getRuntimeType(value.getClass()).equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                    sobj.setField(column.getNameInSource(), SDF.format(value));
                    continue;
                }
                sobj.setField(column.getNameInSource(), value.toString());
            }
            rows.add(sobj);
        }
        return rows;
    }

    @Override
    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.result};
    }

    @Override
    public void cancel() throws TranslatorException {
        if (this.activeJob != null) {
            try {
                this.getConnection().cancelBulkJob(this.activeJob);
            }
            catch (ResourceException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
    }
}

