/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.execution;

import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.StringUtil;
import org.teiid.language.Argument;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.GoogleSpreadsheetConnection;
import org.teiid.resource.adapter.google.common.SheetRow;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.google.SpreadsheetExecutionFactory;

public class DirectSpreadsheetQueryExecution
implements ProcedureExecution {
    private static final String WORKSHEET = "worksheet";
    private static final String QUERY = "query";
    private static final String OFFEST = "offset";
    private static final String LIMIT = "limit";
    private GoogleSpreadsheetConnection connection;
    private Iterator<SheetRow> rowIterator;
    private ExecutionContext executionContext;
    private List<Argument> arguments;

    public DirectSpreadsheetQueryExecution(List<Argument> arguments, ExecutionContext executionContext, GoogleSpreadsheetConnection connection) {
        this.executionContext = executionContext;
        this.connection = connection;
        this.arguments = arguments;
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{SpreadsheetExecutionFactory.UTIL.getString("close_query")});
    }

    public void cancel() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{SpreadsheetExecutionFactory.UTIL.getString("cancel_query")});
        this.rowIterator = null;
    }

    public void execute() throws TranslatorException {
        String worksheet = null;
        String query = null;
        Integer limit = null;
        Integer offset = null;
        String str = (String)this.arguments.get(0).getArgumentValue().getValue();
        List parts = StringUtil.tokenize((String)str, (char)';');
        for (String var : parts) {
            int index = var.indexOf(61);
            if (index == -1) continue;
            String key = var.substring(0, index).trim();
            String value = var.substring(index + 1).trim();
            if (key.equalsIgnoreCase(WORKSHEET)) {
                worksheet = value;
                continue;
            }
            if (key.equalsIgnoreCase(QUERY)) {
                query = value;
                continue;
            }
            if (key.equalsIgnoreCase(LIMIT)) {
                limit = Integer.parseInt(value);
                continue;
            }
            if (!key.equalsIgnoreCase(OFFEST)) continue;
            offset = Integer.parseInt(value);
        }
        this.rowIterator = this.connection.executeQuery(worksheet, query, offset, limit, this.executionContext.getBatchSize()).iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.rowIterator != null && this.rowIterator.hasNext()) {
            return this.rowIterator.next().getRow();
        }
        this.rowIterator = null;
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

