/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.SymmetricCryptor;

public class DhKeyGenerator {
    private static String ALGORITHM = "DiffieHellman";
    private static String DIGEST = "SHA-256";
    private static DHParameterSpec DH_SPEC;
    private PrivateKey privateKey;
    private int keySize = 128;

    public byte[] createPublicKey() throws CryptoException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
            keyGen.initialize(DH_SPEC);
            KeyPair keypair = keyGen.generateKeyPair();
            this.privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            return publicKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10001, (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10002, (Throwable)e);
        }
    }

    public SymmetricCryptor getSymmetricCryptor(byte[] peerPublicKeyBytes, boolean useSealedObject, ClassLoader classLoader) throws CryptoException {
        if (this.privateKey == null) {
            throw new IllegalStateException("KeyGenerator did not successfully generate public key");
        }
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(peerPublicKeyBytes);
            KeyFactory keyFact = KeyFactory.getInstance(ALGORITHM);
            PublicKey publicKey = keyFact.generatePublic(x509KeySpec);
            KeyAgreement ka = KeyAgreement.getInstance(ALGORITHM);
            ka.init(this.privateKey);
            ka.doPhase(publicKey, true);
            byte[] secret = ka.generateSecret();
            MessageDigest sha = MessageDigest.getInstance(DIGEST);
            byte[] hash = sha.digest(secret);
            byte[] symKey = new byte[this.keySize / 8];
            System.arraycopy(hash, 0, symKey, 0, symKey.length);
            SymmetricCryptor sc = SymmetricCryptor.getSymmectricCryptor(symKey);
            sc.setUseSealedObject(useSealedObject);
            sc.setClassLoader(classLoader);
            return sc;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10003, (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10004, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10005, (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance(ALGORITHM);
        paramGen.init(1024);
        AlgorithmParameters params = paramGen.generateParameters();
        DHParameterSpec dhSpec = params.getParameterSpec(DHParameterSpec.class);
        System.out.println("l=" + dhSpec.getL());
        System.out.println("g=" + dhSpec.getG());
        System.out.println("p=" + dhSpec.getP());
    }

    static {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = DhKeyGenerator.class.getResourceAsStream("dh.properties");
            props.load(is);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10000, (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        BigInteger p = new BigInteger(props.getProperty("p"));
        BigInteger g = new BigInteger(props.getProperty("g"));
        DH_SPEC = new DHParameterSpec(p, g, Integer.parseInt(props.getProperty("l")));
    }
}

