/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.hive;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.jdbc.JDBCMetdataProcessor;

public class HiveMetadataProcessor
extends JDBCMetdataProcessor {
    private boolean trimColumnNames;

    public void getConnectorMetadata(Connection conn, MetadataFactory metadataFactory) throws SQLException {
        List<String> tables = this.getTables(conn);
        for (String table : tables) {
            this.addTable(table, conn, metadataFactory);
        }
    }

    private List<String> getTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW TABLES");
        while (rs.next()) {
            tables.add(rs.getString(1));
        }
        rs.close();
        return tables;
    }

    private String getRuntimeType(String type) {
        if (type.equalsIgnoreCase("int")) {
            return "integer";
        }
        if (type.equalsIgnoreCase("tinyint")) {
            return "byte";
        }
        if (type.equalsIgnoreCase("smallint")) {
            return "short";
        }
        if (type.equalsIgnoreCase("bigint")) {
            return "long";
        }
        if (type.equalsIgnoreCase("string")) {
            return "string";
        }
        if (type.equalsIgnoreCase("float")) {
            return "float";
        }
        if (type.equalsIgnoreCase("double")) {
            return "double";
        }
        if (type.equalsIgnoreCase("boolean")) {
            return "boolean";
        }
        if (type.equalsIgnoreCase("decimal")) {
            return "bigdecimal";
        }
        if (type.equalsIgnoreCase("timestamp")) {
            return "timestamp";
        }
        if (type.equalsIgnoreCase("date")) {
            return "date";
        }
        if (type.equalsIgnoreCase("BINARY")) {
            return "varbinary";
        }
        if (type.equalsIgnoreCase("varchar")) {
            return "string";
        }
        return "string";
    }

    private void addTable(String tableName, Connection conn, MetadataFactory metadataFactory) throws SQLException {
        Table table = this.addTable(metadataFactory, null, null, tableName, null, tableName);
        if (table == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("DESCRIBE " + tableName);
        while (rs.next()) {
            String type;
            String name = rs.getString(1);
            if (this.trimColumnNames) {
                name = name.trim();
            }
            if ((type = rs.getString(2)) != null) {
                type = type.trim();
            }
            String runtimeType = this.getRuntimeType(type);
            Column column = metadataFactory.addColumn(name, runtimeType, (ColumnSet)table);
            column.setNameInSource(name);
            column.setUpdatable(true);
        }
        rs.close();
    }

    public void setTrimColumnNames(boolean trimColumnNames) {
        this.trimColumnNames = trimColumnNames;
    }
}

