/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CreateUpdateProcedureCommand
extends Command {
    private Block block;
    private List symbolMaps;
    private Command userCommand;
    private boolean isUpdateProcedure = true;
    private List projectedSymbols;
    private List parentProjectSymbols;
    private Command resultsCommand;

    public CreateUpdateProcedureCommand() {
    }

    public CreateUpdateProcedureCommand(Block block) {
        this.block = block;
    }

    public int getType() {
        return 7;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void setUserCommand(Command command) {
        this.userCommand = command;
    }

    public Command getUserCommand() {
        return this.userCommand;
    }

    public void setSymbolMaps(List symbolMap) {
        this.symbolMaps = symbolMap;
    }

    public List getSymbolMaps() {
        return this.symbolMaps;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        CreateUpdateProcedureCommand copy = new CreateUpdateProcedureCommand();
        if (this.getOption() != null) {
            copy.setOption((Option)this.getOption().clone());
        }
        if (this.block != null) {
            copy.setBlock((Block)this.block.clone());
        }
        if (this.getSymbolMaps() != null) {
            copy.setSymbolMaps(new ArrayList(this.getSymbolMaps()));
        }
        if (this.getVirtualGroup() != null) {
            copy.setVirtualGroup((GroupSymbol)this.getVirtualGroup().clone());
        }
        copy.setUpdateProcedure(this.isUpdateProcedure());
        if (this.projectedSymbols != null) {
            copy.setProjectedSymbols(new ArrayList(this.projectedSymbols));
        }
        if (this.getResultsCommand() != null) {
            copy.setResultsCommand((Command)this.getResultsCommand().clone());
        }
        if (this.parentProjectSymbols != null) {
            copy.parentProjectSymbols = new ArrayList(this.parentProjectSymbols);
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.getBlock(), (Object)((CreateUpdateProcedureCommand)((Object)obj)).getBlock());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object)this.getBlock());
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString((LanguageObject)this);
    }

    public List getProjectedSymbols() {
        if (this.projectedSymbols != null) {
            return this.projectedSymbols;
        }
        if (!this.isUpdateProcedure) {
            if (this.resultsCommand == null) {
                return Collections.EMPTY_LIST;
            }
            return this.resultsCommand.getProjectedSymbols();
        }
        this.projectedSymbols = Command.getUpdateCommandSymbol();
        return this.projectedSymbols;
    }

    public boolean isUpdateProcedure() {
        return this.isUpdateProcedure;
    }

    public void setUpdateProcedure(boolean isUpdateProcedure) {
        this.isUpdateProcedure = isUpdateProcedure;
    }

    public void setProjectedSymbols(List projSymbols) {
        this.projectedSymbols = projSymbols;
    }

    public Command getResultsCommand() {
        return this.resultsCommand;
    }

    public void setResultsCommand(Command command) {
        this.resultsCommand = command;
    }

    public boolean areResultsCachable() {
        return !this.isUpdateProcedure();
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        return this.getSubCommandsUpdatingModelCount(metadata);
    }

    public List getParentProjectSymbols() {
        return this.parentProjectSymbols;
    }

    public void setParentProjectSymbols(List parentProjectSymbols) {
        this.parentProjectSymbols = parentProjectSymbols;
    }
}

