/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.ProductReleaseInfoUtil;
import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ResourceModel;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.bootstrap.PropertyFileCurrentConfigBootstrap;
import com.metamatrix.common.config.bootstrap.SystemCurrentConfigBootstrap;
import com.metamatrix.common.config.reader.CurrentConfigurationReader;
import com.metamatrix.common.config.reader.SystemCurrentConfigurationReader;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.common.util.NetUtils;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.VMNaming;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class CurrentConfiguration {
    private static CurrentConfigurationReader READER = null;
    private static boolean REQUIRES_CLOSE = false;
    private static Properties BOOTSTRAP_PROPERTIES = null;
    private static Object systemPropLock = new Object();
    private static Properties SYSTEM_BOOTSTRAP_PROPERTIES = null;
    private static Properties STARTUP_PROPERTIES = null;
    private static boolean SHUTDOWN_REQUESTED = false;
    private static boolean performedBootStrap = false;
    private static boolean isInitializing = false;

    private CurrentConfiguration() {
    }

    public static String getSystemName() throws ConfigurationException {
        return CurrentConfiguration.getConfigurationModel().getSystemName();
    }

    public static String getProperty(String name, boolean forceRefresh) throws ConfigurationException {
        if (name == null) {
            return null;
        }
        if (!forceRefresh) {
            return CurrentConfiguration.getProperty(name);
        }
        CurrentConfiguration.check();
        return READER.getComponentPropertyValue(Configuration.NEXT_STARTUP_ID, name);
    }

    public static synchronized Properties getStartupProperties() throws ConfigurationException {
        CurrentConfiguration.check();
        Properties result = READER.getStartupConfigurationProperties();
        Properties copyResult = PropertiesUtils.clone((Properties)result, (Properties)BOOTSTRAP_PROPERTIES, (boolean)false, (boolean)true);
        if (!(copyResult instanceof UnmodifiableProperties)) {
            copyResult = new UnmodifiableProperties(copyResult);
        }
        return copyResult;
    }

    public static String getStartupProperty(String name) {
        if (name == null) {
            return null;
        }
        try {
            CurrentConfiguration.check();
            if (STARTUP_PROPERTIES == null) {
                STARTUP_PROPERTIES = READER.getStartupConfigurationProperties();
            }
        }
        catch (ConfigurationException e) {
            System.err.println("**********************************************************************************************");
            System.err.println("** ERROR: Unable to read/obtain the configuration property from Startup Configuration. **");
            System.err.println("**********************************************************************************************");
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("**********************************************************************************************");
            System.err.println("** ERROR: Unknown error during reading of the configuration properties from Startup Configuration. **");
            System.err.println("**********************************************************************************************");
            return null;
        }
        String result = null;
        if (STARTUP_PROPERTIES == null) {
            System.err.println("**********************************************************************************************");
            System.err.println("** ERROR: Startup Configuration properties are null - call MetaMatrix Support. **");
            System.err.println("**********************************************************************************************");
            return null;
        }
        result = STARTUP_PROPERTIES.getProperty(name);
        if (result == null || result.trim().length() == 0) {
            result = CurrentConfiguration.getBootStrapProperty(name);
        }
        return result;
    }

    public static String getProperty(String name, String defaultValue) {
        String value = CurrentConfiguration.getProperty(name);
        return value == null ? defaultValue : value;
    }

    public static String getProperty(String name) {
        Properties configProps;
        if (name == null) {
            return null;
        }
        try {
            CurrentConfiguration.check();
            configProps = READER.getConfigurationProperties();
        }
        catch (ConfigurationException e) {
            System.err.println("**********************************************************************************************");
            System.err.println("** ERROR: Unable to read/obtain the configuration property for the current configuration. **");
            System.err.println("**********************************************************************************************");
            return null;
        }
        catch (Throwable e) {
            System.err.println("**********************************************************************************************");
            System.err.println("** ERROR: Unknown error during reading of the configuration properties for the current configuration. **");
            System.err.println("**********************************************************************************************");
            return null;
        }
        String result = null;
        if (configProps == null) {
            System.err.println("**********************************************************************************************");
            System.err.println("** ERROR: Configuration properties are null - call MetaMatrix Support. **");
            System.err.println("**********************************************************************************************");
            return null;
        }
        result = configProps.getProperty(name);
        if (result == null || result.trim().length() == 0) {
            result = CurrentConfiguration.getBootStrapProperty(name);
        }
        return result;
    }

    public static synchronized String getBootStrapProperty(String key) {
        String result = null;
        try {
            CurrentConfiguration.initBootStrapProperties();
        }
        catch (ConfigurationException e) {
            System.err.println("*************************************************************************************");
            System.err.println("** ERROR: Unable to obtain the bootstrap properties for the current configuration. **");
            System.err.println("*************************************************************************************");
            e.printStackTrace(System.err);
        }
        try {
            if (BOOTSTRAP_PROPERTIES != null && ((result = BOOTSTRAP_PROPERTIES.getProperty(key)) == null || result.trim().length() == 0)) {
                result = CurrentConfiguration.getSystemBootStrapProperties().getProperty(key);
            }
        }
        catch (ConfigurationException e) {
            System.err.println("*************************************************************************************");
            System.err.println("** ERROR: Unable to obtain the bootstrap properties for the current configuration. **");
            System.err.println("*************************************************************************************");
            e.printStackTrace(System.err);
        }
        return result;
    }

    public static Properties getProperties() throws ConfigurationException {
        return CurrentConfiguration.getProperties(false);
    }

    public static synchronized Properties getProperties(boolean forceRefresh) throws ConfigurationException {
        CurrentConfiguration.check();
        Properties result = READER.getConfigurationProperties();
        Properties copyResult = PropertiesUtils.clone((Properties)result, (Properties)BOOTSTRAP_PROPERTIES, (boolean)false, (boolean)true);
        if (!(copyResult instanceof UnmodifiableProperties)) {
            copyResult = new UnmodifiableProperties(copyResult);
        }
        return copyResult;
    }

    public static synchronized Properties getResourceProperties(String resourceName) throws ConfigurationException {
        Properties props;
        CurrentConfiguration.check();
        SharedResource sr = READER.getResource(resourceName);
        if (sr != null) {
            props = ResourceModel.getDefaultProperties((String)resourceName);
            props.putAll((Map<?, ?>)sr.getProperties());
        } else {
            props = new Properties();
        }
        PropertiesUtils.setOverrideProperies((Properties)props, (Properties)CurrentConfiguration.getSystemBootStrapProperties());
        UnmodifiableProperties result = new UnmodifiableProperties(props);
        return result;
    }

    public static ResourceDescriptor getResourceDescriptor(String descriptorName) throws ConfigurationException {
        Configuration config = CurrentConfiguration.getConfiguration();
        if (config == null) {
            return null;
        }
        return config.getResourcePool(descriptorName);
    }

    public static Collection getResourceDescriptors() throws ConfigurationException {
        Configuration config = CurrentConfiguration.getConfiguration();
        ArrayList<ComponentDefn> rd = new ArrayList<ComponentDefn>(10);
        Iterator compDefns = config.getResourcePools().iterator();
        ComponentDefn aDefn = null;
        while (compDefns.hasNext()) {
            aDefn = (ComponentDefn)compDefns.next();
            rd.add(aDefn);
        }
        return rd;
    }

    public static synchronized Configuration getStartupConfiguration() throws ConfigurationException {
        CurrentConfiguration.check();
        Configuration config = READER.getStartupConfiguration();
        if (config == null) {
            throw new ConfigurationException("ERR.003.001.0021", CommonPlugin.Util.getString("ERR.003.001.0021"));
        }
        return config;
    }

    public static Configuration getConfiguration() throws ConfigurationException {
        return CurrentConfiguration.getConfiguration(false);
    }

    public static synchronized Configuration getConfiguration(boolean forceRefresh) throws ConfigurationException {
        CurrentConfiguration.check();
        Configuration config = READER.getNextStartupConfiguration();
        if (config == null) {
            throw new ConfigurationException("ERR.003.001.0021", CommonPlugin.Util.getString("ERR.003.001.0021"));
        }
        return config;
    }

    public static synchronized ConfigurationModelContainer getConfigurationModel() throws ConfigurationException {
        CurrentConfiguration.check();
        ConfigurationModelContainer config = null;
        try {
            config = READER.getConfigurationModel();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (config == null) {
            throw new ConfigurationException("ERR.003.001.0022", CommonPlugin.Util.getString("ERR.003.001.0022"));
        }
        return config;
    }

    public static synchronized ConfigurationModelContainer getStartupConfigurationModel() throws ConfigurationException {
        CurrentConfiguration.check();
        ConfigurationModelContainer config = null;
        try {
            config = READER.getStartupConfigurationModel();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (config == null) {
            throw new ConfigurationException("ERR.003.001.0022", CommonPlugin.Util.getString("ERR.003.001.0022"));
        }
        return config;
    }

    public static Collection getProductReleaseInfos() throws ConfigurationException {
        CurrentConfiguration.check();
        return ProductReleaseInfoUtil.getProductReleaseInfos();
    }

    public static Collection getMonitoredComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        throw new UnsupportedOperationException("Method getMonitoredComponent is not implemented on CurrentConfiguration.");
    }

    public static Collection getComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        CurrentConfiguration.check();
        return READER.getComponentTypes(includeDeprecated);
    }

    public static Collection getProductTypes() throws ConfigurationException {
        CurrentConfiguration.check();
        return READER.getProductTypes();
    }

    public static Host getHost(HostID hostID) throws ConfigurationException {
        CurrentConfiguration.check();
        return READER.getHost(hostID);
    }

    public static Host getHost(String name) throws ConfigurationException {
        CurrentConfiguration.check();
        return READER.getConfigurationModel().getHost(name);
    }

    public static Host findHost(String hostName) throws ConfigurationException {
        CurrentConfiguration.check();
        Host h2 = null;
        try {
            h2 = CurrentConfiguration.getHost(hostName);
            if (h2 != null) {
                return h2;
            }
            if (hostName.equalsIgnoreCase("localhost") && (h2 = CurrentConfiguration.getHost(hostName = InetAddress.getLocalHost().getHostName())) != null) {
                return h2;
            }
            InetAddress inetAddress = InetAddress.getByName(hostName);
            h2 = CurrentConfiguration.getHost(inetAddress.getCanonicalHostName());
            if (h2 != null) {
                return h2;
            }
            h2 = CurrentConfiguration.getHost(inetAddress.getHostName());
            if (h2 != null) {
                return h2;
            }
            String shortName = NetUtils.getHostShortName((String)inetAddress.getCanonicalHostName());
            h2 = CurrentConfiguration.getHost(shortName);
            if (h2 != null) {
                return h2;
            }
            h2 = CurrentConfiguration.getHost(inetAddress.getHostAddress());
            if (h2 != null) {
                return h2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Collection hosts = CurrentConfiguration.getConfigurationModel().getHosts();
        try {
            for (Host h2 : hosts) {
                String shortname = NetUtils.getHostShortName((String)h2.getFullName());
                if (!shortname.equalsIgnoreCase(hostName)) continue;
                return h2;
            }
            String shortName = NetUtils.getHostShortName();
            h2 = CurrentConfiguration.getHost(shortName);
            if (h2 != null) {
                return h2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Host h2 : hosts) {
            if (h2.getHostAddress().equalsIgnoreCase(hostName)) {
                return h2;
            }
            if (!h2.getBindAddress().equalsIgnoreCase(hostName)) continue;
            return h2;
        }
        return null;
    }

    public static Host getHost() throws ConfigurationException, UnknownHostException {
        CurrentConfiguration.check();
        Host host = CurrentConfiguration.findHost(VMNaming.getLogicalHostName());
        if (host == null) {
            host = CurrentConfiguration.findHost("localhost");
        }
        return host;
    }

    public static VMComponentDefn getVM() throws ConfigurationException, UnknownHostException {
        CurrentConfiguration.check();
        Host host = CurrentConfiguration.getHost();
        if (host == null) {
            return null;
        }
        VMComponentDefn vm = READER.getConfigurationModel().getConfiguration().getVMForHost(host.getFullName(), VMNaming.getVMName());
        if (vm != null) {
            return vm;
        }
        Collection vms = READER.getConfigurationModel().getConfiguration().getVMsForHost(host.getFullName());
        if (vms != null && vms.size() == 1) {
            return (VMComponentDefn)vms.iterator().next();
        }
        return null;
    }

    protected static final synchronized void check() throws ConfigurationException {
        if (!performedBootStrap) {
            CurrentConfiguration.verifyBootstrapProperties();
        }
    }

    public static final synchronized void refresh() throws ConfigurationException {
        if (isInitializing || SHUTDOWN_REQUESTED) {
            return;
        }
        CurrentConfiguration.clear();
    }

    public static final synchronized void reset() throws ConfigurationException {
        if (isInitializing || SHUTDOWN_REQUESTED) {
            return;
        }
        CurrentConfiguration.clear();
    }

    public static final boolean isShutdownRequired() {
        boolean result = false;
        result = REQUIRES_CLOSE;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void clear() {
        READER = null;
        BOOTSTRAP_PROPERTIES = null;
        Object object = systemPropLock;
        synchronized (object) {
            SYSTEM_BOOTSTRAP_PROPERTIES = null;
        }
        performedBootStrap = false;
    }

    public static final synchronized void shutdown() {
        SHUTDOWN_REQUESTED = true;
        if (REQUIRES_CLOSE && READER != null) {
            try {
                READER.close();
                REQUIRES_CLOSE = false;
                CurrentConfiguration.clear();
            }
            catch (Exception e) {
                System.err.println(CommonPlugin.Util.getString("ERR.003.001.0023"));
                e.printStackTrace(System.err);
            }
        }
    }

    public static final synchronized void performSystemInitialization(boolean forceInitialization) throws StartupStateException, ConfigurationException {
        isInitializing = true;
        try {
            CurrentConfiguration.check();
            READER.getInitializer().performSystemInitialization(forceInitialization);
        }
        catch (StartupStateException se) {
            throw se;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        finally {
            isInitializing = false;
        }
        CurrentConfiguration.reset();
    }

    public static final void beginSystemInitialization(boolean forceInitialization) throws StartupStateException, ConfigurationException {
        throw new UnsupportedOperationException("beginSystemInitialization is no longer supported.");
    }

    public static final synchronized void finishSystemInitialization() throws StartupStateException, ConfigurationException {
        throw new UnsupportedOperationException("finishSystemInitialization is no longer supported.");
    }

    public static final void indicateSystemShutdown() throws ConfigurationException {
        CurrentConfiguration.check();
        READER.getInitializer().indicateSystemShutdown();
    }

    private static synchronized void initBootStrapProperties() throws ConfigurationException {
        if (BOOTSTRAP_PROPERTIES != null) {
            return;
        }
        boolean useSystemProperties = false;
        PropertyFileCurrentConfigBootstrap bootstrapStrategy = null;
        Properties systemBootStrapProps = CurrentConfiguration.getSystemBootStrapProperties();
        try {
            if (systemBootStrapProps.getProperty("metamatrix.config.none") != null) {
                useSystemProperties = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (useSystemProperties) {
                BOOTSTRAP_PROPERTIES = systemBootStrapProps;
            } else {
                bootstrapStrategy = new PropertyFileCurrentConfigBootstrap();
                BOOTSTRAP_PROPERTIES = bootstrapStrategy.getBootstrapProperties(systemBootStrapProps);
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Properties getSystemBootStrapProperties() throws ConfigurationException {
        Object object = systemPropLock;
        synchronized (object) {
            if (SYSTEM_BOOTSTRAP_PROPERTIES != null) {
                return PropertiesUtils.clone((Properties)SYSTEM_BOOTSTRAP_PROPERTIES, (boolean)false);
            }
            SystemCurrentConfigBootstrap bootstrapStrategy = null;
            try {
                bootstrapStrategy = new SystemCurrentConfigBootstrap();
                SYSTEM_BOOTSTRAP_PROPERTIES = bootstrapStrategy.getBootstrapProperties();
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage());
            }
            return PropertiesUtils.clone((Properties)SYSTEM_BOOTSTRAP_PROPERTIES, (boolean)false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final synchronized void verifyBootstrapProperties() throws ConfigurationException {
        if (performedBootStrap) {
            return;
        }
        try {
            String readerClassName;
            if (READER != null) return;
            boolean useSystemProperties = false;
            CurrentConfiguration.initBootStrapProperties();
            if (CurrentConfiguration.getSystemBootStrapProperties().getProperty("metamatrix.config.none") != null || BOOTSTRAP_PROPERTIES.getProperty("metamatrix.config.none") != null) {
                useSystemProperties = true;
            }
            if ((readerClassName = BOOTSTRAP_PROPERTIES.getProperty("metamatrix.config.reader")) == null) {
                if (!useSystemProperties) throw new ConfigurationException("ERR.003.001.0024", CommonPlugin.Util.getString("ERR.003.001.0024", (Object)"metamatrix.config.reader"));
                READER = new SystemCurrentConfigurationReader();
            } else {
                Class<?> readerClass = Class.forName(readerClassName);
                CurrentConfigurationReader tempReader = (CurrentConfigurationReader)readerClass.newInstance();
                tempReader.connect(BOOTSTRAP_PROPERTIES);
                READER = tempReader;
                if (!useSystemProperties) {
                    REQUIRES_CLOSE = true;
                }
            }
            performedBootStrap = true;
            return;
        }
        catch (ConfigurationException e) {
            System.err.println("*************************************************************************************");
            System.err.println("** ERROR: Unable to obtain the bootstrap properties for the current configuration. **");
            System.err.println("*************************************************************************************");
            e.printStackTrace(System.err);
            throw new ConfigurationException((Throwable)e, "ERR.003.001.0025", CommonPlugin.Util.getString("ERR.003.001.0025"));
        }
        catch (Throwable e) {
            System.err.println("*************************************************************************************");
            System.err.println("** ERROR: Unable to obtain the bootstrap properties for the current configuration. **");
            System.err.println("*************************************************************************************");
            e.printStackTrace(System.err);
            throw new ConfigurationException("ERR.003.001.0025", CommonPlugin.Util.getString("ERR.003.001.0025"));
        }
    }

    public static boolean hasPerformedBootStrap() {
        return performedBootStrap;
    }
}

