/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.ui.tree;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.modeler.compare.DifferenceDescriptor;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.DifferenceType;
import com.metamatrix.modeler.compare.ui.PluginConstants;
import com.metamatrix.modeler.compare.ui.UiConstants;
import com.metamatrix.modeler.compare.ui.UiPlugin;
import com.metamatrix.modeler.compare.ui.tree.DifferenceAnalysis;
import com.metamatrix.modeler.compare.ui.tree.MappingLabelDecorator;
import com.metamatrix.modeler.compare.ui.tree.MappingTreeContentProvider;
import com.metamatrix.modeler.compare.ui.tree.PrimaryMetamodelObjectViewerFilter;
import com.metamatrix.ui.graphics.GlobalUiFontManager;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.widget.DefaultTreeViewerController;
import com.metamatrix.ui.internal.widget.ITreeViewerController;
import com.metamatrix.ui.internal.widget.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CompareTreePanel
extends ViewForm
implements UiConstants,
PluginConstants {
    private Tree tree;
    private TreeViewer treeViewer;
    private List diffReports;
    private boolean bDisplayOnlyPrimaryMetamodelObjects = false;
    private String title;
    private boolean updateMapping = true;
    private CompareTreeController controller;
    private boolean showCheckBoxes;
    private ITreeContentProvider contentProvider;
    private PrimaryMetamodelObjectViewerFilter pmofViewerFilter;
    private int iAdditions;
    private int iChanges;
    private int iDeletions;
    private ArrayList arylTreeItemDepthFirstList;
    private TreeItem tiCurrentSelection;
    private boolean bUpdatingSelection = false;
    private Button btnSelectAll;
    private Button btnUnselectAll;
    private ToolBar tbToolBar;
    private ToolBarManager tbmToolBarMgr;
    private Action actUp;
    private Action actDown;
    private static final String SELECT_ALL_TEXT = UiPlugin.Util.getString("CompareTreePanel.selectAll.text");
    private static final String SELECT_ALL_TIP = UiPlugin.Util.getString("CompareTreePanel.selectAll.tip");
    private static final String UNSELECT_ALL_TEXT = UiPlugin.Util.getString("CompareTreePanel.unselectAll.text");
    private static final String UNSELECT_ALL_TIP = UiPlugin.Util.getString("CompareTreePanel.unselectAll.tip");
    private static final String NEXT_NAV_TIP = UiPlugin.Util.getString("CompareTreePanel.nextNav.tip");
    private static final String PREV_NAV_TIP = UiPlugin.Util.getString("CompareTreePanel.prevNav.tip");
    private static final String GO_TO_NEXT_TITLE = UiPlugin.Util.getString("CompareTreePanel.goToNext.title");
    private static final String END_OF_DOC_MSG = UiPlugin.Util.getString("CompareTreePanel.endOfDoc.msg");
    private static final String BEGINNING_OF_DOC_MSG = UiPlugin.Util.getString("CompareTreePanel.beginningOfDoc.msg");

    public CompareTreePanel(Composite parent, String title, List diffReports, boolean showCheckBoxes, int terminology) {
        this(parent, title, showCheckBoxes, false, terminology);
        this.setDifferenceReports(diffReports);
    }

    public CompareTreePanel(Composite parent, String title, List diffReports, int terminology) {
        this(parent, title, true, false, terminology);
        this.setDifferenceReports(diffReports);
    }

    public CompareTreePanel(Composite parent, String title, DifferenceReport diffReport, int terminology) {
        this(parent, title, Arrays.asList(diffReport), terminology);
    }

    public CompareTreePanel(Composite theParent, String theTitle, boolean showCheckBoxes, boolean bDisplayOnlyPrimaryMetamodelObjects, int terminology) {
        super(theParent, 0);
        this.title = theTitle;
        this.showCheckBoxes = showCheckBoxes;
        this.bDisplayOnlyPrimaryMetamodelObjects = bDisplayOnlyPrimaryMetamodelObjects;
        this.initialize(terminology);
    }

    public void clearSelection() {
        this.tree.deselectAll();
    }

    public void selectAll() {
        this.tree.selectAll();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void initialize(int terminology) {
        ILabelDecorator decorator;
        Label lblTitle = WidgetFactory.createLabel((Composite)this, (String)this.title);
        Font fOld = lblTitle.getFont();
        FontData data = fOld.getFontData()[0];
        data.setStyle(1);
        Font fNewFont = GlobalUiFontManager.getFont((FontData)data);
        lblTitle.setFont(fNewFont);
        this.setTopLeft((Control)lblTitle);
        this.controller = new CompareTreeController();
        this.treeViewer = this.showCheckBoxes ? WidgetFactory.createTreeViewer((Composite)this, (int)36, (int)1808, (ITreeViewerController)this.controller) : WidgetFactory.createTreeViewer((Composite)this, (int)4, (int)1808, (ITreeViewerController)this.controller);
        this.tree = this.treeViewer.getTree();
        this.setContent((Control)this.tree);
        this.contentProvider = new MappingTreeContentProvider();
        if (this.diffReports != null && this.diffReports.get(0) != null) {
            ((MappingTreeContentProvider)this.contentProvider).setDifferenceReports(this.diffReports);
        }
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        ILabelProvider labelProvider = DifferenceAnalysis.getMappingDecoratingLabelProvider((int)terminology);
        if (labelProvider instanceof DecoratingLabelProvider && (decorator = ((DecoratingLabelProvider)labelProvider).getLabelDecorator()) instanceof MappingLabelDecorator) {
            ((MappingLabelDecorator)decorator).setMappingTreeContentProvider((MappingTreeContentProvider)this.contentProvider);
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (this.bDisplayOnlyPrimaryMetamodelObjects) {
            this.pmofViewerFilter = new PrimaryMetamodelObjectViewerFilter();
            this.treeViewer.addFilter((ViewerFilter)this.pmofViewerFilter);
        }
        if (this.showCheckBoxes) {
            this.createSelectUnSelectButtonPanel((Composite)this);
        }
        this.createToolBar();
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                CompareTreePanel.this.handleTreeNodeSelection();
            }
        });
    }

    private void createSelectUnSelectButtonPanel(Composite parent) {
        Composite pnlButtons = WidgetFactory.createPanel((Composite)parent, (int)64);
        GridLayout gridLayout = new GridLayout();
        pnlButtons.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(2);
        pnlButtons.setLayoutData((Object)gridData);
        this.btnSelectAll = WidgetFactory.createButton((Composite)pnlButtons, (String)SELECT_ALL_TEXT, (int)768);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectAll.setToolTipText(SELECT_ALL_TIP);
        this.btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                CompareTreePanel.this.handleSelectAll();
            }
        });
        this.btnUnselectAll = WidgetFactory.createButton((Composite)pnlButtons, (String)UNSELECT_ALL_TEXT, (int)768);
        this.btnUnselectAll.setEnabled(true);
        this.btnUnselectAll.setToolTipText(UNSELECT_ALL_TIP);
        this.btnUnselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                CompareTreePanel.this.handleUnselectAll();
            }
        });
    }

    public void selectFirstDiff() {
        TreeItem tiFirst = this.getNextDiffItem(null);
        if (tiFirst != null) {
            TreeItem[] tiArray = new TreeItem[]{tiFirst};
            this.getTreeViewer().reveal((Object)tiFirst);
            this.forceTreeSelection(tiArray);
            this.setCurrentTreeItem(tiFirst);
        }
    }

    protected void createToolBar() {
        this.tbToolBar = new ToolBar((Composite)this, 0x800040);
        this.setTopRight((Control)this.tbToolBar);
        this.tbmToolBarMgr = new PaneToolBarManager(this.tbToolBar);
        this.actDown = new Action(){

            public void run() {
                CompareTreePanel.this.handleDownArrow();
            }
        };
        this.actDown.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/next_nav.gif"));
        this.actDown.setToolTipText(NEXT_NAV_TIP);
        this.tbmToolBarMgr.add((IAction)this.actDown);
        this.actUp = new Action(){

            public void run() {
                CompareTreePanel.this.handleUpArrow();
            }
        };
        this.actUp.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/prev_nav.gif"));
        this.actUp.setToolTipText(PREV_NAV_TIP);
        this.tbmToolBarMgr.add((IAction)this.actUp);
        this.tbmToolBarMgr.update(true);
    }

    private void handleSelectAll() {
        this.setAllNodesSelected(true);
    }

    private void handleUnselectAll() {
        this.setAllNodesSelected(false);
    }

    public void setDifferenceReports(List theDifferenceReports) {
        this.diffReports = theDifferenceReports;
        if (this.contentProvider != null) {
            ((MappingTreeContentProvider)this.contentProvider).setDifferenceReports(this.diffReports);
        }
        this.treeViewer.setInput((Object)this.diffReports);
        this.initTreeSelections();
        this.generateStats();
        if (this.getAdditionCount() == 0 && this.getChangeCount() == 0 && this.getDeletionCount() == 0) {
            this.actDown.setEnabled(false);
            this.actUp.setEnabled(false);
        }
    }

    public void initTreeSelections() {
        this.arylTreeItemDepthFirstList = new ArrayList();
        TreeItem[] items = this.tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            this.selectItemAndChildren(items[i]);
        }
    }

    public void generateStats() {
        this.iAdditions = 0;
        this.iChanges = 0;
        this.iDeletions = 0;
        this.getTreeViewer().expandAll();
        TreeItem[] items = this.tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            this.calculateCounts(items[i]);
        }
        this.getTreeViewer().collapseAll();
    }

    private void calculateCounts(TreeItem item) {
        DifferenceDescriptor desc;
        Mapping mapping;
        Object data = item.getData();
        if (data != null && data instanceof DifferenceReport) {
            mapping = ((DifferenceReport)data).getMapping();
            if (mapping == null) {
                return;
            }
            if ((this.pmofViewerFilter == null || this.pmofViewerFilter.passesFilter(mapping)) && (desc = DifferenceAnalysis.getDifferenceDescriptor((Mapping)mapping)) != null) {
                if (desc.isAddition()) {
                    ++this.iAdditions;
                } else if (desc.isChanged()) {
                    ++this.iChanges;
                } else if (desc.isDeletion()) {
                    ++this.iDeletions;
                }
            }
        } else if (data != null && data instanceof Mapping && (desc = DifferenceAnalysis.getDifferenceDescriptor((Mapping)(mapping = (Mapping)data))) != null) {
            if (desc.isAddition()) {
                ++this.iAdditions;
            } else if (desc.isChanged()) {
                ++this.iChanges;
            } else if (desc.isDeletion()) {
                ++this.iDeletions;
            }
        }
        TreeItem[] children = item.getItems();
        for (int i = 0; i < children.length; ++i) {
            this.calculateCounts(children[i]);
        }
    }

    public boolean isUpdatingMappingSkipFlag() {
        return this.updateMapping;
    }

    private void selectItemAndChildren(TreeItem item) {
        boolean skip;
        DifferenceDescriptor desc;
        Mapping mapping;
        this.arylTreeItemDepthFirstList.add(item);
        Object data = item.getData();
        if (data != null && data instanceof DifferenceReport) {
            mapping = ((DifferenceReport)data).getMapping();
            if (mapping == null) {
                return;
            }
            desc = DifferenceAnalysis.getDifferenceDescriptor((Mapping)mapping);
            if (desc != null) {
                skip = desc.isSkip();
                WidgetUtil.setChecked((TreeItem)item, (!skip ? 1 : 0) != 0, (boolean)false, (ITreeViewerController)this.controller);
            }
            if (!this.controller.isItemCheckable(item)) {
                item.setGrayed(true);
                this.controller.update(item, false);
            }
        } else if (data != null && data instanceof Mapping) {
            mapping = (Mapping)data;
            desc = DifferenceAnalysis.getDifferenceDescriptor((Mapping)mapping);
            if (desc != null) {
                skip = desc.isSkip();
                WidgetUtil.setChecked((TreeItem)item, (!skip ? 1 : 0) != 0, (boolean)false, (ITreeViewerController)this.controller);
            }
            if (!this.controller.isItemCheckable(item)) {
                item.setGrayed(true);
                this.controller.update(item, false);
            }
        }
        TreeItem[] children = item.getItems();
        for (int i = 0; i < children.length; ++i) {
            this.selectItemAndChildren(children[i]);
        }
    }

    private void setAllNodesSelected(boolean bSelected) {
        TreeItem[] items = this.tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            this.setAllSelected(items[i], bSelected);
        }
    }

    private void setAllSelected(TreeItem item, boolean checked) {
        Mapping mapping;
        Object data = item.getData();
        if (data instanceof DifferenceReport) {
            mapping = ((DifferenceReport)data).getMapping();
        } else if (data instanceof Mapping) {
            mapping = (Mapping)data;
        } else {
            return;
        }
        DifferenceDescriptor desc = DifferenceAnalysis.getDifferenceDescriptor((Mapping)mapping);
        if (desc != null) {
            WidgetUtil.setChecked((TreeItem)item, (boolean)checked, (boolean)false, (ITreeViewerController)this.controller);
        }
        if (!this.controller.isItemCheckable(item)) {
            item.setGrayed(true);
            this.controller.update(item, false);
        }
        TreeItem[] children = item.getItems();
        for (int ndx = 0; ndx < children.length; ++ndx) {
            this.setAllSelected(children[ndx], checked);
        }
    }

    public void setUpdateMappingSkipFlag(boolean theUpdateMappingFlag) {
        this.updateMapping = theUpdateMappingFlag;
    }

    public int getAdditionCount() {
        return this.iAdditions;
    }

    public int getChangeCount() {
        return this.iChanges;
    }

    public int getDeletionCount() {
        return this.iDeletions;
    }

    public EObject getEObjectForMapping(Mapping mapping) {
        EObject eoResult = null;
        MappingHelper helper = mapping.getHelper();
        if (helper instanceof DifferenceDescriptor) {
            DifferenceDescriptor desc = (DifferenceDescriptor)helper;
            DifferenceType type = desc.getType();
            if (type.getValue() == 2) {
                EObject input;
                EList inputs = mapping.getInputs();
                EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                if (input != null) {
                    eoResult = input;
                }
            } else {
                EObject input;
                EList outputs = mapping.getOutputs();
                EObject output = outputs.isEmpty() ? null : (EObject)outputs.get(0);
                EList inputs = mapping.getInputs();
                EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                if (output != null) {
                    eoResult = output;
                } else if (input != null) {
                    eoResult = input;
                }
            }
        }
        return eoResult;
    }

    private void handleTreeNodeSelection() {
        if (this.bUpdatingSelection) {
            return;
        }
        TreeItem[] tiSelectedTreeItems = this.tree.getSelection();
        if (tiSelectedTreeItems != null && tiSelectedTreeItems.length > 0) {
            TreeItem ti = tiSelectedTreeItems[0];
            this.setCurrentTreeItem(ti);
        }
    }

    private void handleUpArrow() {
        this.bUpdatingSelection = true;
        TreeItem tiPrev = this.getPrevDiffItem(this.getCurrentTreeItem());
        if (tiPrev != null) {
            TreeItem[] tiArray = new TreeItem[]{tiPrev};
            this.getTreeViewer().reveal((Object)tiPrev);
            this.forceTreeSelection(tiArray);
            this.setCurrentTreeItem(tiPrev);
        } else {
            TreeItem tiLast;
            boolean bContinue = MessageDialog.openQuestion(null, (String)GO_TO_NEXT_TITLE, (String)BEGINNING_OF_DOC_MSG);
            if (bContinue && (tiLast = this.getPrevDiffItem(null)) != null) {
                TreeItem[] tiArray = new TreeItem[]{tiLast};
                this.getTreeViewer().reveal((Object)tiLast);
                this.forceTreeSelection(tiArray);
                this.setCurrentTreeItem(tiLast);
            }
        }
        this.bUpdatingSelection = false;
    }

    private void handleDownArrow() {
        this.bUpdatingSelection = true;
        TreeItem tiNext = this.getNextDiffItem(this.getCurrentTreeItem());
        if (tiNext != null) {
            TreeItem[] tiArray = new TreeItem[]{tiNext};
            this.forceTreeSelection(tiArray);
            this.setCurrentTreeItem(tiNext);
        } else {
            TreeItem tiFirst;
            boolean bContinue = MessageDialog.openQuestion(null, (String)GO_TO_NEXT_TITLE, (String)END_OF_DOC_MSG);
            if (bContinue && (tiFirst = this.getNextDiffItem(null)) != null) {
                TreeItem[] tiArray = new TreeItem[]{tiFirst};
                this.getTreeViewer().reveal((Object)tiFirst);
                this.forceTreeSelection(tiArray);
                this.setCurrentTreeItem(tiFirst);
            }
        }
        this.bUpdatingSelection = false;
    }

    private void forceTreeSelection(final TreeItem[] tiArray) {
        if (tiArray == null || tiArray.length == 0 || tiArray[0] == null || tiArray[0].getData() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CompareTreePanel.this.doTreeSelection(tiArray);
                CompareTreePanel.this.forceTreeSelectionAgain(tiArray);
            }
        });
    }

    private void forceTreeSelectionAgain(final TreeItem[] tiArray) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CompareTreePanel.this.doTreeSelection(tiArray);
            }
        });
    }

    private void doTreeSelection(TreeItem[] tiArray) {
        StructuredSelection sel = new StructuredSelection(tiArray[0].getData());
        this.getTreeViewer().setSelection((ISelection)sel, true);
        Event event = new Event();
        event.widget = this.tree;
        this.tree.notifyListeners(13, event);
    }

    private void setCurrentTreeItem(TreeItem ti) {
        this.tiCurrentSelection = ti;
    }

    private TreeItem getCurrentTreeItem() {
        return this.tiCurrentSelection;
    }

    private TreeItem getNextDiffItem(TreeItem tiCurrentNode) {
        int iSize = this.arylTreeItemDepthFirstList.size();
        int iStartIndex = 0;
        TreeItem tiResult = null;
        if (tiCurrentNode != null) {
            iStartIndex = this.arylTreeItemDepthFirstList.indexOf(tiCurrentNode);
            ++iStartIndex;
        } else {
            iStartIndex = 0;
        }
        for (int i = iStartIndex; i < iSize; ++i) {
            TreeItem tiTemp = (TreeItem)this.arylTreeItemDepthFirstList.get(i);
            if (!this.controller.isItemChanged(tiTemp)) continue;
            tiResult = tiTemp;
            break;
        }
        return tiResult;
    }

    private TreeItem getPrevDiffItem(TreeItem tiCurrentNode) {
        int iSize = this.arylTreeItemDepthFirstList.size();
        int iStartIndex = iSize - 1;
        TreeItem tiResult = null;
        if (tiCurrentNode != null) {
            iStartIndex = this.arylTreeItemDepthFirstList.indexOf(tiCurrentNode);
            --iStartIndex;
        } else {
            iStartIndex = iSize - 1;
        }
        for (int i = iStartIndex; i > -1; --i) {
            TreeItem tiTemp = (TreeItem)this.arylTreeItemDepthFirstList.get(i);
            if (!this.controller.isItemChanged(tiTemp)) continue;
            tiResult = tiTemp;
            break;
        }
        return tiResult;
    }

    public void setTerminology(int terminology) {
        DecoratingLabelProvider labelProvider = (DecoratingLabelProvider)this.treeViewer.getLabelProvider();
        ((MappingLabelDecorator)labelProvider.getLabelDecorator()).setTerminology(terminology);
    }

    private class CompareTreeController
    extends DefaultTreeViewerController {
        private CompareTreeController() {
        }

        public boolean isItemCheckable(TreeItem theItem) {
            return this.isItemChanged(theItem);
        }

        public boolean isItemChanged(TreeItem theItem) {
            Object element = theItem.getData();
            MappingHelper helper = null;
            if (element instanceof DifferenceReport) {
                Mapping mapping = ((DifferenceReport)element).getMapping();
                helper = mapping.getHelper();
            } else if (element instanceof Mapping) {
                helper = ((Mapping)element).getHelper();
            }
            if (helper instanceof DifferenceDescriptor) {
                DifferenceDescriptor desc = (DifferenceDescriptor)helper;
                if (desc.isChangedBelow()) {
                    return false;
                }
                if (desc.isAddition() || desc.isDeletion() || desc.isChanged()) {
                    return true;
                }
            }
            return false;
        }

        public void checkedStateToggled(TreeItem theItem) {
            if (CompareTreePanel.this.isUpdatingMappingSkipFlag()) {
                Object element = theItem.getData();
                MappingHelper helper = null;
                if (element instanceof DifferenceReport) {
                    Mapping mapping = ((DifferenceReport)element).getMapping();
                    helper = mapping.getHelper();
                } else if (element instanceof Mapping) {
                    helper = ((Mapping)element).getHelper();
                }
                if (helper instanceof DifferenceDescriptor) {
                    boolean bNewState = !theItem.getChecked();
                    ((DifferenceDescriptor)helper).setSkip(bNewState);
                    if (element instanceof DifferenceReport) {
                        return;
                    }
                    EList inputs = ((Mapping)element).getInputs();
                    if (inputs != null && inputs.size() != 1) {
                        return;
                    }
                    EObject elem = (EObject)inputs.get(0);
                    ObjectID elementId = elem.getObjectId();
                    EObject eo = ((EObject)element).eContainer();
                    while (eo != null && !(eo instanceof DifferenceReport)) {
                        eo = ((Mapping)eo).eContainer();
                    }
                    assert (eo instanceof DifferenceReport);
                    DifferenceReport report = (DifferenceReport)eo;
                    block1: for (Object reportContent : report.getMapping().getNested()) {
                        Mapping mapping;
                        EList list;
                        if (!(reportContent instanceof Mapping) || (list = (mapping = (Mapping)reportContent).getInputs()) == null || list.size() != 1 || !(list.get(0) instanceof AnnotationContainer)) continue;
                        for (Object annCtnrContent : mapping.getNested()) {
                            Annotation ann;
                            Object obj;
                            if (!(annCtnrContent instanceof Mapping) || (list = (mapping = (Mapping)annCtnrContent).getInputs()) == null || list.size() != 1 || !((obj = list.get(0)) instanceof Annotation) || !(ann = (Annotation)obj).getAnnotatedObject().getObjectId().equals(elementId)) continue;
                            helper = mapping.getHelper();
                            assert (helper instanceof DifferenceDescriptor);
                            ((DifferenceDescriptor)helper).setSkip(bNewState);
                            break block1;
                        }
                    }
                }
            }
        }

        public void update(TreeItem item, boolean selected) {
            super.update(item, selected);
            this.checkedStateToggled(item);
        }
    }

    class PaneToolBarManager
    extends ToolBarManager {
        public PaneToolBarManager(ToolBar paneToolBar) {
            super(paneToolBar);
        }

        protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
            toolBar.layout();
            Composite parent = toolBar.getParent();
            parent.layout();
            if (parent.getParent() != null) {
                parent.getParent().layout();
            }
        }
    }
}

