/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xml.ui.wizards;

import com.metamatrix.metamodels.xsd.validator.XsdResourceValidator;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.builder.ResourceValidator;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.builder.ModelBuildUtil;
import com.metamatrix.modeler.internal.mapping.factory.CompositorBasedBuilderStrategy;
import com.metamatrix.modeler.internal.mapping.factory.IterationBasedBuilderStrategy;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassFactory;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.xml.factory.IDocumentsAndFragmentsPopulator;
import com.metamatrix.modeler.internal.xml.factory.VirtualDocumentModelPopulator;
import com.metamatrix.modeler.internal.xml.ui.wizards.NewDocumentWizardModel;
import com.metamatrix.modeler.internal.xml.ui.wizards.NewVirtualDocumentAccumulatorSource;
import com.metamatrix.modeler.internal.xml.ui.wizards.NewVirtualDocumentWizardPage;
import com.metamatrix.modeler.internal.xml.ui.wizards.SchemaFileViewerFilter;
import com.metamatrix.modeler.mapping.factory.MappingClassBuilderStrategy;
import com.metamatrix.modeler.ui.viewsupport.ModelWorkspaceTreeProvider;
import com.metamatrix.modeler.ui.viewsupport.ModelingResourceFilter;
import com.metamatrix.modeler.xml.ui.ModelerXmlUiConstants;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.viewsupport.StatusInfo;
import com.metamatrix.ui.internal.viewsupport.UiBusyIndicator;
import com.metamatrix.ui.internal.widget.accumulator.AccumulatorPanel;
import com.metamatrix.ui.internal.widget.accumulator.IAccumulatedValuesChangeListener;
import com.metamatrix.ui.internal.widget.accumulator.IAccumulatorSource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

class NewVirtualDocumentWizardPanel
extends Composite
implements ModelerXmlUiConstants,
IAccumulatedValuesChangeListener {
    private static final String NO_SCHEMA_SELECTED = Util.getString("NewVirtualDocumentWizardPage.noSchemaSelected");
    private static final String MUST_SELECT_SCHEMA = Util.getString("NewVirtualDocumentWizardPage.mustSelectSchema");
    private static final String SELECT_SCHEMA_TITLE = Util.getString("NewVirtualDocumentWizardPage.selectSchemaTitle");
    private static final String SELECT_SCHEMA_MSG = Util.getString("NewVirtualDocumentWizardPage.selectSchemaMsg");
    private static final String BUILD_MAPPING_CLASSES = Util.getString("NewVirtualDocumentWizardPage.buildMappingClasses");
    private static final String BUILD_ENTIRE_DOCUMENTS = Util.getString("NewVirtualDocumentWizardPage.buildEntireDocuments");
    private static final String BUILD_GLOBAL_ONLY = Util.getString("NewVirtualDocumentWizardPage.buildGlobalOnly");
    private static final String MAPPING_OPTIONS = Util.getString("NewVirtualDocumentWizardPage.mappingOptions");
    private static final String DOCUMENT_OPTIONS = Util.getString("NewVirtualDocumentWizardPage.documentOptions");
    private static final String USE_STRING = Util.getString("NewVirtualDocumentWizardPage.useString");
    private static final String USE_SCHEMA_TYPE = Util.getString("NewVirtualDocumentWizardPage.useSchemaType");
    private static final String DATATYPE_OPTIONS = Util.getString("NewVirtualDocumentWizardPage.datatypeOptions");
    private static final String STRATEGY_OPTIONS = Util.getString("NewVirtualDocumentWizardPage.strategyOptions");
    private static final String BROWSE_SHORTHAND = "...";
    private static final int FILE_NAME_TEXT_WIDTH = (int)((double)Display.getCurrent().getBounds().width * 0.25);
    private static final int FILE_NAME_TEXT_HEIGHT = 16;
    private static final int ACCUMULATOR_RESET_BUTTON_VERTICAL_MARGIN = 4;
    public static final int DOCUMENTS = 1;
    public static final int FRAGMENTS = 2;
    private Text fileNameText;
    private Button browseButton;
    private TableViewer documentsListViewer;
    private TableViewer fragmentsListViewer = null;
    private AccumulatorPanel documentsAccumulatorPanel = null;
    private AccumulatorPanel fragmentsAccumulatorPanel = null;
    private ILabelProvider accumulatorsLabelProvider;
    private IDocumentsAndFragmentsPopulator populator = null;
    private Button buildEntireDocumentsButton;
    private Button buildGlobalOnlyButton;
    private Button useSchemaTypeButton;
    private Button useStringTypeButton;
    private Button buildMappingClassesButton;
    private Button iterationStrategyButton;
    private Button compositorStrategyButton;
    private NewDocumentWizardModel model;
    private WizardPage page;

    public NewVirtualDocumentWizardPanel(Composite parent, NewDocumentWizardModel model, WizardPage page) {
        super(parent, 0);
        this.model = model;
        this.page = page;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Composite fileComposite = new Composite((Composite)this, 0);
        GridLayout fileCompositeLayout = new GridLayout();
        fileComposite.setLayout((Layout)fileCompositeLayout);
        fileCompositeLayout.numColumns = 3;
        fileCompositeLayout.marginWidth = 0;
        GridData fileCompositeGridData = new GridData(768);
        fileComposite.setLayoutData((Object)fileCompositeGridData);
        Label schemaNameLabel = new Label(fileComposite, 0);
        schemaNameLabel.setText(Util.getString("NewVirtualDocumentWizardPage.xmlSchemaFileLabel"));
        this.fileNameText = WidgetFactory.createTextField((Composite)fileComposite, (int)0, null);
        this.fileNameText.setEditable(false);
        GridData fileNameTextGridData = new GridData();
        fileNameTextGridData.widthHint = FILE_NAME_TEXT_WIDTH;
        fileNameTextGridData.heightHint = 16;
        this.fileNameText.setLayoutData((Object)fileNameTextGridData);
        this.browseButton = new Button(fileComposite, 8);
        this.browseButton.setText(BROWSE_SHORTHAND);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                NewVirtualDocumentWizardPanel.this.browseButtonClicked();
            }
        });
        this.accumulatorsLabelProvider = ModelUtilities.getEMFLabelProvider();
        if (NewVirtualDocumentWizardPage.getIncludeXMLDocuments()) {
            Group documentsAccumulatorComposite = new Group((Composite)this, 0);
            String documentsGroupName = Util.getString("NewVirtualDocumentWizardPage.virtualXMLDocumentsLabel");
            documentsAccumulatorComposite.setText(documentsGroupName);
            GridLayout documentsAccumulatorCompositeLayout = new GridLayout();
            documentsAccumulatorComposite.setLayout((Layout)documentsAccumulatorCompositeLayout);
            documentsAccumulatorCompositeLayout.marginWidth = 0;
            documentsAccumulatorCompositeLayout.marginHeight = 2;
            NewVirtualDocumentAccumulatorSource documentsAccumulatorSource = new NewVirtualDocumentAccumulatorSource(this, 1);
            String documentsAvailableHdr = Util.getString("NewVirtualDocumentWizardPage.documentsAccumulatorLeftLabel");
            String documentsSelectedHdr = Util.getString("NewVirtualDocumentWizardPage.documentsAccumulatorRightLabel");
            this.documentsAccumulatorPanel = new AccumulatorPanel((Composite)documentsAccumulatorComposite, (IAccumulatorSource)documentsAccumulatorSource, new ArrayList(), this.accumulatorsLabelProvider, documentsAvailableHdr, documentsSelectedHdr, 4, -1, -1, -1);
            this.documentsAccumulatorPanel.addAccumulatedValuesChangeListener((IAccumulatedValuesChangeListener)this);
        }
        if (NewVirtualDocumentWizardPage.getIncludeXMLFragments()) {
            Group fragmentsAccumulatorComposite = new Group((Composite)this, 0);
            fragmentsAccumulatorComposite.setText(Util.getString("NewVirtualDocumentWizardPage.virtualXMLFragmentsLabel"));
            GridLayout fragmentsAccumulatorCompositeLayout = new GridLayout();
            fragmentsAccumulatorComposite.setLayout((Layout)fragmentsAccumulatorCompositeLayout);
            fragmentsAccumulatorCompositeLayout.marginWidth = 0;
            fragmentsAccumulatorCompositeLayout.marginHeight = 2;
            NewVirtualDocumentAccumulatorSource fragmentsAccumulatorSource = new NewVirtualDocumentAccumulatorSource(this, 2);
            String fragmentsAvailableHdr = Util.getString("NewVirtualDocumentWizardPage.fragmentsAccumulatorLeftLabel");
            String fragmentsSelectedHdr = Util.getString("NewVirtualDocumentWizardPage.fragmentsAccumulatorRightLabel");
            this.fragmentsAccumulatorPanel = new AccumulatorPanel((Composite)fragmentsAccumulatorComposite, (IAccumulatorSource)fragmentsAccumulatorSource, new ArrayList(), this.accumulatorsLabelProvider, fragmentsAvailableHdr, fragmentsSelectedHdr, 4, -1, -1, -1);
            this.fragmentsAccumulatorPanel.addAccumulatedValuesChangeListener((IAccumulatedValuesChangeListener)this);
        }
        Group group = new Group((Composite)this, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        group.setText(DOCUMENT_OPTIONS);
        this.buildEntireDocumentsButton = new Button((Composite)group, 16);
        this.buildEntireDocumentsButton.setSelection(true);
        this.buildEntireDocumentsButton.setText(BUILD_ENTIRE_DOCUMENTS);
        this.buildGlobalOnlyButton = new Button((Composite)group, 16);
        this.buildGlobalOnlyButton.setText(BUILD_GLOBAL_ONLY);
        Group typeGroup = new Group((Composite)this, 0);
        typeGroup.setLayout((Layout)new GridLayout(1, true));
        typeGroup.setLayoutData((Object)new GridData(768));
        typeGroup.setText(MAPPING_OPTIONS);
        this.buildMappingClassesButton = new Button((Composite)typeGroup, 32);
        this.buildMappingClassesButton.setText(BUILD_MAPPING_CLASSES);
        this.buildMappingClassesButton.setSelection(true);
        Group strategyGroup = new Group((Composite)typeGroup, 0);
        strategyGroup.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(768);
        gd.horizontalIndent = 10;
        strategyGroup.setLayoutData((Object)gd);
        strategyGroup.setText(STRATEGY_OPTIONS);
        MappingClassBuilderStrategy strategy = this.model.getMappingClassBuilderStrategy();
        if (strategy == null) {
            strategy = MappingClassFactory.getDefaultStrategy();
        }
        boolean isCompositorStrategy = strategy instanceof CompositorBasedBuilderStrategy;
        this.iterationStrategyButton = new Button((Composite)strategyGroup, 16);
        this.iterationStrategyButton.setText(MappingClassBuilderStrategy.iterationStrategyDescription);
        this.compositorStrategyButton = new Button((Composite)strategyGroup, 16);
        this.compositorStrategyButton.setText(MappingClassBuilderStrategy.compositorStrategyDescription);
        if (isCompositorStrategy) {
            this.compositorStrategyButton.setSelection(true);
            this.iterationStrategyButton.setSelection(false);
        } else {
            this.compositorStrategyButton.setSelection(false);
            this.iterationStrategyButton.setSelection(true);
        }
        this.iterationStrategyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVirtualDocumentWizardPanel.this.iterationStrategyButton.getSelection()) {
                    NewVirtualDocumentWizardPanel.this.model.setMappingClassBuilderStrategy(MappingClassBuilderStrategy.iterationStrategy);
                    MappingClassFactory.setDefaultStrategy((MappingClassBuilderStrategy)MappingClassBuilderStrategy.iterationStrategy);
                    NewVirtualDocumentWizardPanel.this.updateComponentEnabledStates();
                }
            }
        });
        this.compositorStrategyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVirtualDocumentWizardPanel.this.compositorStrategyButton.getSelection()) {
                    NewVirtualDocumentWizardPanel.this.model.setMappingClassBuilderStrategy(MappingClassBuilderStrategy.compositorStrategy);
                    MappingClassFactory.setDefaultStrategy((MappingClassBuilderStrategy)MappingClassBuilderStrategy.compositorStrategy);
                    NewVirtualDocumentWizardPanel.this.updateComponentEnabledStates();
                }
            }
        });
        Group datatypeGroup = new Group((Composite)typeGroup, 0);
        datatypeGroup.setLayout((Layout)new GridLayout(1, true));
        datatypeGroup.setLayoutData((Object)gd);
        datatypeGroup.setText(DATATYPE_OPTIONS);
        this.useSchemaTypeButton = new Button((Composite)datatypeGroup, 16);
        this.useSchemaTypeButton.setSelection(true);
        this.useSchemaTypeButton.setText(USE_SCHEMA_TYPE);
        this.useStringTypeButton = new Button((Composite)datatypeGroup, 16);
        this.useStringTypeButton.setSelection(false);
        this.useStringTypeButton.setText(USE_STRING);
        this.useSchemaTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVirtualDocumentWizardPanel.this.model.getUseSchemaTypes() != NewVirtualDocumentWizardPanel.this.useSchemaTypeButton.getSelection()) {
                    NewVirtualDocumentWizardPanel.this.model.setUseSchemaTypes(NewVirtualDocumentWizardPanel.this.useSchemaTypeButton.getSelection());
                    NewVirtualDocumentWizardPanel.this.updateComponentEnabledStates();
                }
            }
        });
        this.useStringTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVirtualDocumentWizardPanel.this.model.getUseSchemaTypes() != NewVirtualDocumentWizardPanel.this.useSchemaTypeButton.getSelection()) {
                    NewVirtualDocumentWizardPanel.this.model.setUseSchemaTypes(NewVirtualDocumentWizardPanel.this.useSchemaTypeButton.getSelection());
                    NewVirtualDocumentWizardPanel.this.updateComponentEnabledStates();
                }
            }
        });
        this.model.setBuildEntireDocuments(this.buildEntireDocumentsButton.getSelection());
        this.model.setBuildGlobalOnly(this.buildGlobalOnlyButton.getSelection());
        this.model.setBuildMappingClasses(this.buildMappingClassesButton.getSelection());
        this.model.setMappingClassBuilderStrategy(MappingClassFactory.getDefaultStrategy());
        this.buildEntireDocumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVirtualDocumentWizardPanel.this.model.getBuildEntireDocuments() != NewVirtualDocumentWizardPanel.this.buildEntireDocumentsButton.getSelection()) {
                    NewVirtualDocumentWizardPanel.this.model.setBuildEntireDocuments(NewVirtualDocumentWizardPanel.this.buildEntireDocumentsButton.getSelection());
                    NewVirtualDocumentWizardPanel.this.model.setBuildGlobalOnly(NewVirtualDocumentWizardPanel.this.buildGlobalOnlyButton.getSelection());
                    NewVirtualDocumentWizardPanel.this.updateComponentEnabledStates();
                }
            }
        });
        this.buildGlobalOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVirtualDocumentWizardPanel.this.model.getBuildGlobalOnly() != NewVirtualDocumentWizardPanel.this.buildGlobalOnlyButton.getSelection()) {
                    NewVirtualDocumentWizardPanel.this.model.setBuildGlobalOnly(NewVirtualDocumentWizardPanel.this.buildGlobalOnlyButton.getSelection());
                    NewVirtualDocumentWizardPanel.this.model.setBuildEntireDocuments(NewVirtualDocumentWizardPanel.this.buildEntireDocumentsButton.getSelection());
                    NewVirtualDocumentWizardPanel.this.updateComponentEnabledStates();
                }
            }
        });
        this.buildMappingClassesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVirtualDocumentWizardPanel.this.model.getBuildMappingClasses() != NewVirtualDocumentWizardPanel.this.buildMappingClassesButton.getSelection()) {
                    NewVirtualDocumentWizardPanel.this.model.setBuildMappingClasses(NewVirtualDocumentWizardPanel.this.buildMappingClassesButton.getSelection());
                    NewVirtualDocumentWizardPanel.this.updateComponentEnabledStates();
                }
            }
        });
    }

    protected void setModelBuilderStrategy(MappingClassBuilderStrategy theStrategy) {
        this.model.setMappingClassBuilderStrategy(theStrategy);
        if (this.compositorStrategyButton != null && theStrategy instanceof CompositorBasedBuilderStrategy) {
            this.compositorStrategyButton.setSelection(true);
            this.iterationStrategyButton.setSelection(false);
            this.updateComponentEnabledStates();
        } else if (this.iterationStrategyButton != null && theStrategy instanceof IterationBasedBuilderStrategy) {
            this.iterationStrategyButton.setSelection(true);
            this.compositorStrategyButton.setSelection(false);
            this.updateComponentEnabledStates();
        }
    }

    private void updateComponentEnabledStates() {
        this.buildMappingClassesButton.setEnabled(this.buildEntireDocumentsButton.getSelection());
        if (!this.buildEntireDocumentsButton.getSelection()) {
            this.buildMappingClassesButton.setSelection(false);
        }
        boolean enable = this.buildMappingClassesButton.getSelection();
        this.useSchemaTypeButton.setEnabled(enable);
        this.useStringTypeButton.setEnabled(enable);
        this.compositorStrategyButton.setEnabled(enable);
        this.iterationStrategyButton.setEnabled(enable);
    }

    private void browseButtonClicked() {
        final IDocumentsAndFragmentsPopulator thePopulator = this.displaySelectorDialog();
        if (thePopulator != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    NewVirtualDocumentWizardPanel.this.setPopulator(thePopulator);
                }
            };
            UiBusyIndicator.showWhile(null, (Runnable)runnable);
        }
    }

    public void setPopulator(IDocumentsAndFragmentsPopulator populator) {
        if (populator != null) {
            this.populator = populator;
            String itemName = populator.getItemName();
            this.fileNameText.setText(itemName);
            this.page.setErrorMessage(null);
            IResource resource = (IResource)populator.getItem();
            Preferences currentPrefs = ModelerCore.getPlugin().getPluginPreferences();
            if (ResourcesPlugin.getWorkspace().isAutoBuilding() && currentPrefs.getString("xsdPreferences.performValidation").equals("error")) {
                if (this.errorMarkersExist(resource)) {
                    this.page.setErrorMessage(Util.getString("NewVirtualDocumentWizardPage.invalidSchema"));
                    return;
                }
            } else {
                Preferences prefs = new Preferences();
                prefs.setValue("xsdPreferences.performValidation", "error");
                ValidationContext context = new ValidationContext(prefs);
                XsdResourceValidator xsdValidator = new XsdResourceValidator();
                try {
                    XSDValidatorWithProgress validatorWithProgress = new XSDValidatorWithProgress(xsdValidator, resource, context);
                    this.page.getWizard().getContainer().run(false, true, (IRunnableWithProgress)validatorWithProgress);
                    if (this.errorMarkersExist(resource)) {
                        this.page.setErrorMessage(Util.getString("NewVirtualDocumentWizardPage.invalidSchema"));
                        return;
                    }
                    resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                }
                catch (Exception e) {
                    Util.log((Throwable)e);
                    this.page.setErrorMessage(Util.getString("NewVirtualDocumentWizardPage.invalidSchema"));
                    return;
                }
            }
            if (NewVirtualDocumentWizardPage.getIncludeXMLDocuments()) {
                ArrayList availableDocuments = populator.getInitialAvailableDocuments();
                if (availableDocuments == null) {
                    availableDocuments = new ArrayList(0);
                }
                this.emptyList(this.documentsListViewer);
                for (Object item : availableDocuments) {
                    this.documentsListViewer.add(item);
                }
                Collection selectedDocuments = populator.getSelectedDocuments();
                this.documentsAccumulatorPanel.repopulateSelectedItems(selectedDocuments);
                this.documentsAccumulatorPanel.availableItemsHaveChanged();
            }
            if (NewVirtualDocumentWizardPage.getIncludeXMLFragments()) {
                ArrayList availableFragments = populator.getInitialAvailableFragments();
                if (availableFragments == null) {
                    availableFragments = new ArrayList(0);
                }
                this.emptyList(this.fragmentsListViewer);
                for (Object item : availableFragments) {
                    this.fragmentsListViewer.add(item);
                }
                Collection selectedFragments = populator.getSelectedFragments();
                this.fragmentsAccumulatorPanel.repopulateSelectedItems(selectedFragments);
                this.fragmentsAccumulatorPanel.availableItemsHaveChanged();
            }
            super.layout();
            this.model.setSelectedFragmentCount(this.getChosenCount());
        }
    }

    public void accumulatedValuesChanged(AccumulatorPanel source) {
        this.model.setSelectedFragmentCount(this.getChosenCount());
    }

    private void emptyList(TableViewer listViewer) {
        Table list = listViewer.getTable();
        if (list != null) {
            int count = list.getItemCount();
            for (int i = count - 1; i >= 0; --i) {
                Object item = listViewer.getElementAt(i);
                listViewer.remove(item);
            }
        }
        this.model.setSelectedFragmentCount(this.getChosenCount());
    }

    private IDocumentsAndFragmentsPopulator displaySelectorDialog() {
        Object[] selection;
        VirtualDocumentModelPopulator result = null;
        ModelWorkspaceTreeProvider provider = new ModelWorkspaceTreeProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)provider, (ITreeContentProvider)provider);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ModelingResourceFilter filter = new ModelingResourceFilter((ViewerFilter)new SchemaFileViewerFilter());
        dialog.addFilter((ViewerFilter)filter);
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null) {
                    return new StatusInfo("com.metamatrix.modeler.xml.ui", 4, NO_SCHEMA_SELECTED);
                }
                if (selection.length != 1) {
                    return new StatusInfo("com.metamatrix.modeler.xml.ui", 4, NO_SCHEMA_SELECTED);
                }
                if (!(selection[0] instanceof IFile)) {
                    return new StatusInfo("com.metamatrix.modeler.xml.ui", 4, MUST_SELECT_SCHEMA);
                }
                return new StatusInfo("com.metamatrix.modeler.xml.ui");
            }
        });
        dialog.setTitle(SELECT_SCHEMA_TITLE);
        dialog.setMessage(SELECT_SCHEMA_MSG);
        if (dialog.open() == 0 && (selection = dialog.getResult()).length == 1 && selection[0] instanceof IFile) {
            IFile schemaFile = (IFile)selection[0];
            result = new VirtualDocumentModelPopulator(schemaFile);
        }
        return result;
    }

    public IDocumentsAndFragmentsPopulator getPopulator() {
        if (this.populator == null || this.populator.getSelectedDocuments().isEmpty()) {
            return null;
        }
        return this.populator;
    }

    private int getChosenCount() {
        int count = 0;
        if (this.documentsAccumulatorPanel != null) {
            count += this.documentsAccumulatorPanel.getSelectedItems().size();
        }
        if (this.fragmentsAccumulatorPanel != null) {
            count += this.fragmentsAccumulatorPanel.getSelectedItems().size();
        }
        return count;
    }

    public void documentsAccumulatedValuesRemoved(Collection values) {
        this.model.setSelectedFragmentCount(this.getChosenCount());
        for (Object value : values) {
            this.documentsListViewer.add(value);
        }
    }

    public void fragmentsAccumulatedValuesRemoved(Collection values) {
        this.model.setSelectedFragmentCount(this.getChosenCount());
        for (Object value : values) {
            this.fragmentsListViewer.add(value);
        }
    }

    public void documentsAccumulatedValuesAdded(Collection values) {
        this.model.setSelectedFragmentCount(this.getChosenCount());
        for (Object value : values) {
            this.documentsListViewer.remove(value);
        }
    }

    public void fragmentsAccumulatedValuesAdded(Collection values) {
        this.model.setSelectedFragmentCount(this.getChosenCount());
        for (Object value : values) {
            this.fragmentsListViewer.remove(value);
        }
    }

    public Collection getDocumentsAvailableValues() {
        int count = this.documentsListViewer.getTable().getItemCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object value = this.documentsListViewer.getElementAt(i);
            values.add(value);
        }
        return values;
    }

    public Collection getFragmentsAvailableValues() {
        int count = this.fragmentsListViewer.getTable().getItemCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object value = this.fragmentsListViewer.getElementAt(i);
            values.add(value);
        }
        return values;
    }

    public int getDocumentsAvailableValuesCount() {
        int count = this.documentsListViewer.getTable().getItemCount();
        return count;
    }

    public int getFragmentsAvailableValuesCount() {
        int count = this.fragmentsListViewer.getTable().getItemCount();
        return count;
    }

    public Collection getDocumentsSelectedAvailableValues() {
        int[] selectionIndices = this.documentsListViewer.getTable().getSelectionIndices();
        ArrayList<Object> selectedValues = new ArrayList<Object>(selectionIndices.length);
        for (int i = 0; i < selectionIndices.length; ++i) {
            int index = selectionIndices[i];
            selectedValues.add(this.documentsListViewer.getElementAt(index));
        }
        return selectedValues;
    }

    public Collection getFragmentsSelectedAvailableValues() {
        int[] selectionIndices = this.fragmentsListViewer.getTable().getSelectionIndices();
        ArrayList<Object> selectedValues = new ArrayList<Object>(selectionIndices.length);
        for (int i = 0; i < selectionIndices.length; ++i) {
            int index = selectionIndices[i];
            selectedValues.add(this.fragmentsListViewer.getElementAt(index));
        }
        return selectedValues;
    }

    public int getDocumentsSelectedAvailableValuesCount() {
        if (this.documentsListViewer != null) {
            int count = this.documentsListViewer.getTable().getSelectionCount();
            return count;
        }
        return 0;
    }

    public int getFragmentsSelectedAvailableValuesCount() {
        if (this.fragmentsListViewer != null) {
            int count = this.fragmentsListViewer.getTable().getSelectionCount();
            return count;
        }
        return 0;
    }

    public Control documentsCreateControl(Composite parent) {
        this.documentsListViewer = new TableViewer(parent, 2);
        this.documentsListViewer.setLabelProvider((IBaseLabelProvider)this.accumulatorsLabelProvider);
        return this.documentsListViewer.getControl();
    }

    public Control fragmentsCreateControl(Composite parent) {
        this.fragmentsListViewer = new TableViewer(parent, 2);
        this.fragmentsListViewer.setLabelProvider((IBaseLabelProvider)this.accumulatorsLabelProvider);
        return this.fragmentsListViewer.getControl();
    }

    public void documentsAddSelectionListener(SelectionListener listener) {
        this.documentsListViewer.getTable().addSelectionListener(listener);
    }

    public void fragmentsAddSelectionListener(SelectionListener listener) {
        this.fragmentsListViewer.getTable().addSelectionListener(listener);
    }

    public void selectedDocumentsChanged() {
        if (this.populator != null) {
            this.model.setSelectedFragmentCount(this.getChosenCount());
            Collection selectedDocuments = this.documentsAccumulatorPanel.getSelectedItems();
            this.populator.setSelectedDocuments(selectedDocuments);
        }
    }

    public void selectedFragmentsChanged() {
        if (this.populator != null) {
            this.model.setSelectedFragmentCount(this.getChosenCount());
            Collection selectedFragments = this.fragmentsAccumulatorPanel.getSelectedItems();
            this.populator.setSelectedFragments(selectedFragments);
        }
    }

    private boolean errorMarkersExist(IResource resource) {
        if (resource.exists()) {
            IMarker[] markers = null;
            try {
                markers = ((IFile)resource).findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (CoreException theException) {
                Util.log((Throwable)theException);
            }
            if (markers != null && markers.length > 0) {
                for (int i = 0; i < markers.length; ++i) {
                    int severity = markers[i].getAttribute("severity", -1);
                    if (severity != 2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static class XSDValidatorWithProgress
    implements IRunnableWithProgress {
        private XsdResourceValidator validator;
        private IResource resource;
        private ValidationContext context;

        XSDValidatorWithProgress(XsdResourceValidator validator, IResource resource, ValidationContext context) {
            this.validator = validator;
            this.resource = resource;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(ModelerXmlUiConstants.Util.getString("XMLDocumentWizard.validateSchema"), -1);
            try {
                HashSet<IResource> resources = new HashSet<IResource>(1);
                resources.add(this.resource);
                this.validator.validationStarted(resources, this.context);
                ModelBuildUtil.validateResource((IProgressMonitor)monitor, (IResource)this.resource, (ResourceValidator)this.validator, (ValidationContext)this.context);
                this.validator.validationEnded(this.context);
            }
            finally {
                monitor.done();
            }
        }
    }
}

