/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.membership.spi.ldap;

import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.api.exception.security.UnsupportedCredentialException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.membership.service.SuccessfulAuthenticationToken;
import com.metamatrix.platform.security.membership.spi.MembershipDomain;
import com.metamatrix.platform.security.membership.spi.MembershipSourceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPMembershipDomain
implements MembershipDomain {
    public static final String ONELEVEL_SCOPE_VALUE = "ONELEVEL_SCOPE";
    public static final String OBJECT_SCOPE_VALUE = "OBJECT_SCOPE";
    public static final String SUBTREE_SCOPE_VALUE = "SUBTREE_SCOPE";
    public static final String GROUPS_GROUP_MEMBER_ATTRIBUTE = "groups.groupMember.attribute";
    public static final String GROUPS_ROOT_CONTEXT = "groups.rootContext";
    public static final String GROUPS_SEARCH_SCOPE = "groups.searchScope";
    public static final String GROUPS_SEARCH_FILTER = "groups.searchFilter";
    public static final String GROUPS_DISPLAY_NAME_ATTRIBUTE = "groups.displayName.attribute";
    public static final String USERS_MEMBER_OF_ATTRIBUTE = "users.memberOf.attribute";
    public static final String USERS_ROOT_CONTEXT = "users.rootContext";
    public static final String USERS_SEARCH_SCOPE = "users.searchScope";
    public static final String USERS_DISPLAY_NAME_ATTRIBUTE = "users.displayName.attribute";
    public static final String USERS_SEARCH_FILTER = "users.searchFilter";
    public static final String LDAP_URL = "ldapURL";
    public static final String LDAP_ADMIN_PASSWORD = "ldapAdmin.password";
    public static final String LDAP_ADMIN_DN = "ldapAdmin.dn";
    public static final String TXN_TIMEOUT_IN_MILLIS = "txnTimeoutInMillis";
    public static final String LDAP_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String LDAP_AUTH_TYPE = "simple";
    public static final String LDAP_USER_OBJECT_TYPE = "person";
    public static final String LDAP_REFERRAL_MODE = "follow";
    public static final String DEFAULT_SEARCH_FILTER = "(objectclass=*)";
    public static final String POOL_KEY = "com.sun.jndi.ldap.connect.pool";
    public static final String TIMEOUT_KEY = "com.sun.jndi.ldap.connect.timeout";
    public static final String DEFAULT_USERS_DISPLAY_NAME_ATTRIBUTE = "uid";
    public static final String DEFAULT_GROUPS_DISPLAY_NAME_ATTRIBUTE = "cn";
    public static final String USE_POOL = "usePool";
    private String domainName;
    private String ldapURL;
    private String ldapAdminUserDN;
    private String ldapAdminUserPass;
    private String ldapTxnTimeoutInMillis;
    private String ldapUsePool;
    private boolean usePool;
    private List usersRootContexts;
    private List groupsRootContexts;
    private Hashtable adminContext = new Hashtable();

    public void initialize(Properties props) throws ServiceStateException {
        String usePoolString;
        this.domainName = props.getProperty("domainName");
        LogManager.logTrace((String)"MEMBERSHIP", (String)("Initializing LDAP Domain: " + this.domainName));
        this.ldapTxnTimeoutInMillis = props.getProperty(TXN_TIMEOUT_IN_MILLIS);
        this.ldapAdminUserDN = LDAPMembershipDomain.getPropertyValue(props, LDAP_ADMIN_DN, null);
        this.ldapAdminUserPass = LDAPMembershipDomain.getPropertyValue(props, LDAP_ADMIN_PASSWORD, null);
        this.ldapURL = LDAPMembershipDomain.getPropertyValue(props, LDAP_URL, null);
        this.ldapUsePool = LDAPMembershipDomain.getPropertyValue(props, USE_POOL, null);
        this.usePool = true;
        if (this.ldapUsePool != null && this.ldapUsePool.equalsIgnoreCase(Boolean.FALSE.toString())) {
            this.usePool = false;
        }
        String string = usePoolString = this.usePool ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        if (this.ldapURL == null) {
            throw new ServiceStateException(PlatformPlugin.Util.getString("LDAPMembershipDomain.Required_property", (Object)LDAP_URL));
        }
        this.usersRootContexts = this.buildContexts(USERS_ROOT_CONTEXT, USERS_SEARCH_FILTER, USERS_DISPLAY_NAME_ATTRIBUTE, USERS_SEARCH_SCOPE, USERS_MEMBER_OF_ATTRIBUTE, DEFAULT_USERS_DISPLAY_NAME_ATTRIBUTE, props);
        this.groupsRootContexts = this.buildContexts(GROUPS_ROOT_CONTEXT, GROUPS_SEARCH_FILTER, GROUPS_DISPLAY_NAME_ATTRIBUTE, GROUPS_SEARCH_SCOPE, GROUPS_GROUP_MEMBER_ATTRIBUTE, DEFAULT_GROUPS_DISPLAY_NAME_ATTRIBUTE, props);
        if (props.getProperty(USERS_MEMBER_OF_ATTRIBUTE, "").trim().length() == 0 && props.getProperty(GROUPS_GROUP_MEMBER_ATTRIBUTE, "").trim().length() == 0) {
            LogManager.logWarning((String)"MEMBERSHIP", (String)PlatformPlugin.Util.getString("LDAPMembershipDomain.Require_memberof_property", (Object)this.domainName));
        }
        this.adminContext.put("java.naming.factory.initial", LDAP_INITIAL_CONTEXT_FACTORY);
        this.adminContext.put("java.naming.provider.url", this.ldapURL);
        this.adminContext.put("java.naming.referral", LDAP_REFERRAL_MODE);
        this.adminContext.put(POOL_KEY, usePoolString);
        if (this.ldapAdminUserDN != null && this.ldapAdminUserPass != null) {
            LogManager.logTrace((String)"MEMBERSHIP", (String)(this.domainName + ": Username was set to:" + this.ldapAdminUserDN));
            this.adminContext.put("java.naming.security.authentication", LDAP_AUTH_TYPE);
            this.adminContext.put("java.naming.security.principal", this.ldapAdminUserDN);
            this.adminContext.put("java.naming.security.credentials", this.ldapAdminUserPass);
        } else {
            LogManager.logTrace((String)"MEMBERSHIP", (String)(this.domainName + ": admin dn was blank; performing anonymous bind."));
            this.adminContext.put("java.naming.security.authentication", "none");
        }
        if (this.ldapTxnTimeoutInMillis != null) {
            this.adminContext.put(TIMEOUT_KEY, this.ldapTxnTimeoutInMillis);
        }
    }

    private List buildContexts(String rootContextsProp, String searchFilterProp, String displayAttributeProp, String searchScopeProp, String memberOfAttributeProp, String defaultDisplayName, Properties props) throws ServiceStateException {
        String rootContextsStr = props.getProperty(rootContextsProp, null);
        if (rootContextsStr == null) {
            throw new ServiceStateException(PlatformPlugin.Util.getString("LDAPMembershipDomain.Required_property", (Object)rootContextsProp));
        }
        String searchFilterStr = props.getProperty(searchFilterProp);
        String searchScopeStr = props.getProperty(searchScopeProp);
        String memberOfAttributeStr = props.getProperty(memberOfAttributeProp);
        String displayAttributeStr = props.getProperty(displayAttributeProp);
        String[] rootContexts = rootContextsStr.split("\\?");
        String[] displayAttributes = displayAttributeStr != null ? displayAttributeStr.split("\\?") : null;
        String[] searchFilters = searchFilterStr != null ? searchFilterStr.split("\\?") : null;
        String[] searchScopes = searchScopeStr != null ? searchScopeStr.split("\\?") : null;
        String[] memberOfAttributes = memberOfAttributeStr != null ? memberOfAttributeStr.split("\\?") : null;
        ArrayList<LdapContext> results = new ArrayList<LdapContext>();
        for (int i = 0; i < rootContexts.length; ++i) {
            LdapContext context = new LdapContext();
            results.add(context);
            context.context = rootContexts[i];
            context.displayAttribute = LDAPMembershipDomain.getContextValue(displayAttributes, i, defaultDisplayName);
            context.memberOfAttribute = LDAPMembershipDomain.getContextValue(memberOfAttributes, i, null);
            context.searchFilter = LDAPMembershipDomain.getContextValue(searchFilters, i, context.searchFilter);
            context.searchScope = this.getSearchScope(LDAPMembershipDomain.getContextValue(searchScopes, i, null));
        }
        return results;
    }

    private static String getContextValue(String[] values, int i, String defaultValue) {
        String value = null;
        if (values != null) {
            if (values.length > i) {
                value = values[i];
            } else if (values.length == 1) {
                value = values[0];
            }
        }
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    private static String getPropertyValue(Properties props, String key, String defaultValue) {
        String result = props.getProperty(key);
        if (result == null || result.trim().length() == 0) {
            return defaultValue;
        }
        return result.trim();
    }

    private int getSearchScope(String scope) {
        if (scope == null) {
            return 2;
        }
        if (scope.equals(OBJECT_SCOPE_VALUE)) {
            return 0;
        }
        if (scope.equals(ONELEVEL_SCOPE_VALUE)) {
            return 1;
        }
        return 2;
    }

    public void shutdown() throws ServiceStateException {
        LogManager.logTrace((String)"MEMBERSHIP", (String)(this.domainName + ": shutdown()"));
    }

    public SuccessfulAuthenticationToken authenticateUser(String username, Credentials credential, Serializable trustedPayload, String applicationName) throws UnsupportedCredentialException, InvalidUserException, LogonException, MembershipSourceException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "authenticateUser username", username, "applicationName", applicationName});
        if (username == null) {
            throw new UnsupportedCredentialException(PlatformPlugin.Util.getString("LDAPMembershipDomain.No_annonymous", (Object)this.domainName));
        }
        UserEntry ue = this.getUserEntry(username, false);
        if (credential == null) {
            throw new UnsupportedCredentialException(PlatformPlugin.Util.getString("LDAPMembershipDomain.No_annonymous", (Object)this.domainName));
        }
        Hashtable<String, String> connenv = new Hashtable<String, String>();
        connenv.put("java.naming.factory.initial", LDAP_INITIAL_CONTEXT_FACTORY);
        connenv.put("java.naming.provider.url", this.ldapURL);
        connenv.put("java.naming.security.authentication", LDAP_AUTH_TYPE);
        connenv.put("java.naming.security.principal", ue.getDn());
        connenv.put("java.naming.security.credentials", String.valueOf(credential.getCredentialsAsCharArray()));
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(connenv);
        }
        catch (NamingSecurityException nse) {
            throw new LogonException((Throwable)nse, nse.getMessage());
        }
        catch (NamingException ne) {
            throw new MembershipSourceException((Throwable)ne, ne.getMessage());
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    LogManager.logTrace((String)"MEMBERSHIP", (Throwable)ne, (String)(this.domainName + ": error closing context"));
                }
            }
        }
        if (credential.getCredentialsAsCharArray().length == 0) {
            username = "";
        }
        return new SuccessfulAuthenticationToken(trustedPayload, username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGroupNames() throws MembershipSourceException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, " getGroupNames() called"});
        DirContext ctx = null;
        try {
            ctx = this.getAdminContext();
            HashSet hashSet = new HashSet(this.getGroupNames(ctx, null, false).values());
            return hashSet;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    LogManager.logTrace((String)"MEMBERSHIP", (Throwable)ne, (String)(this.domainName + ": error closing context"));
                }
            }
        }
    }

    private DirContext getAdminContext() throws MembershipSourceException {
        try {
            return new InitialDirContext((Hashtable)this.adminContext.clone());
        }
        catch (AuthenticationException err) {
            throw new MembershipSourceException((Throwable)err, PlatformPlugin.Util.getString("LDAPMembershipDomain.Admin_credentials", (Object)this.domainName));
        }
        catch (NamingException err) {
            throw new MembershipSourceException((Throwable)err);
        }
    }

    public Set getGroupNamesForUser(String username) throws InvalidUserException, MembershipSourceException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "getGroupNamesForUser", username});
        if (username.length() == 0) {
            return Collections.EMPTY_SET;
        }
        UserEntry ue = this.getUserEntry(username, true);
        return ue.getGroups();
    }

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    private UserEntry getUserEntry(String username, boolean getGroups) throws MembershipSourceException, InvalidUserException {
        username = LDAPMembershipDomain.escapeLDAPSearchFilter(username);
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "getUserEntry", username, "getGroups", String.valueOf(getGroups)});
        DirContext ctx = null;
        try {
            ctx = this.getAdminContext();
            for (int i = 0; i < this.usersRootContexts.size(); ++i) {
                LdapContext context = (LdapContext)this.usersRootContexts.get(i);
                String contextName = context.context;
                SearchControls sControls = new SearchControls();
                sControls.setSearchScope(context.searchScope);
                if (context.memberOfAttribute != null) {
                    sControls.setReturningAttributes(new String[]{context.memberOfAttribute});
                }
                String singleUserSearchFilter = "(" + context.displayAttribute + "=" + username + ")";
                if (context.searchFilter.length() > 0) {
                    singleUserSearchFilter = "(&" + singleUserSearchFilter + context.searchFilter + ")";
                }
                LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "searching context", contextName, "with filter", singleUserSearchFilter, "and search scope", String.valueOf(context.searchScope)});
                NamingEnumeration<SearchResult> usersEnumeration = ctx.search(contextName, singleUserSearchFilter, sControls);
                if (usersEnumeration.hasMore()) {
                    SearchResult foundUser = usersEnumeration.next();
                    LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "found user", username, "in context", contextName});
                    if (usersEnumeration.hasMore()) {
                        LogManager.logWarning((String)"MEMBERSHIP", (String)(this.domainName + ": Only expected one user when performing lookup. Check to ensure the display name is unique."));
                    }
                    String RDN = foundUser.getName();
                    String dn = RDN + ',' + contextName;
                    HashSet<String> groupList = new HashSet<String>();
                    if (getGroups) {
                        Map groupNames = this.getGroupNames(ctx, dn, context.memberOfAttribute == null);
                        if (context.memberOfAttribute != null) {
                            Attribute memberOfAttr = foundUser.getAttributes().get(context.memberOfAttribute);
                            if (memberOfAttr != null) {
                                int groupCount = memberOfAttr.size();
                                for (int j = 0; j < groupCount; ++j) {
                                    String groupRdn;
                                    String groupDN = (String)memberOfAttr.get(i);
                                    if (groupDN == null || (groupRdn = (String)groupNames.get(groupDN)) == null) continue;
                                    groupList.add(groupDN);
                                    LogManager.logTrace((String)"MEMBERSHIP", (String)(this.domainName + "-----Adding user's group: " + groupDN));
                                }
                            }
                        } else {
                            groupList.addAll(groupNames.values());
                        }
                    }
                    UserEntry ue = new UserEntry(dn, groupList);
                    LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "UserEntry retrieved for username", username, ue.getDn()});
                    UserEntry userEntry = ue;
                    return userEntry;
                }
                LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "no user match found in context", contextName});
            }
        }
        catch (NamingException ne) {
            throw new MembershipSourceException((Throwable)ne);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    LogManager.logTrace((String)"MEMBERSHIP", (Throwable)ne, (String)(this.domainName + ": error closing context"));
                }
            }
        }
        LogManager.logInfo((String)"MEMBERSHIP", (String)(this.domainName + ": No user DN found for user: " + username + ", could not authenticate."));
        throw new InvalidUserException(username);
    }

    private Map getGroupNames(DirContext ctx, String userDn, boolean mustMatchDn) throws MembershipSourceException {
        LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "getGroupNames", userDn, "mustMatchDn", String.valueOf(mustMatchDn)});
        HashMap<String, String> groupNames = new HashMap<String, String>();
        try {
            for (int i = 0; i < this.groupsRootContexts.size(); ++i) {
                LdapContext context = (LdapContext)this.groupsRootContexts.get(i);
                String contextName = context.context;
                SearchControls groupSC = new SearchControls();
                groupSC.setSearchScope(context.searchScope);
                groupSC.setReturningAttributes(new String[]{context.displayAttribute});
                String searchFilter = context.searchFilter;
                if (userDn != null && context.memberOfAttribute != null) {
                    searchFilter = "(&(" + context.memberOfAttribute + "=" + userDn + ")" + searchFilter + ")";
                } else if (mustMatchDn) {
                    LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "skipping group context"});
                    continue;
                }
                LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "searching group context", contextName, "with filter", searchFilter, "and search scope", String.valueOf(context.searchScope)});
                NamingEnumeration<SearchResult> groupsEnum = ctx.search(contextName, searchFilter, groupSC);
                LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "Parsing through groups search results."});
                while (groupsEnum.hasMore()) {
                    String groupDisplayName;
                    Attribute groupDisplayNameAttr;
                    Attributes attrs;
                    SearchResult curGroup = groupsEnum.next();
                    String groupRDN = curGroup.getName();
                    String groupDN = groupRDN + ',' + contextName;
                    if (groupDN.charAt(0) == ',') {
                        groupDN = groupDN.substring(1);
                    }
                    if ((attrs = curGroup.getAttributes()) == null || (groupDisplayNameAttr = attrs.get(context.displayAttribute)) == null || (groupDisplayName = (String)groupDisplayNameAttr.get()) == null) continue;
                    groupNames.put(groupDN, groupDisplayName);
                    LogManager.logTrace((String)"MEMBERSHIP", (Object[])new Object[]{this.domainName, "Found groupDN", groupDN, "with display name", groupDisplayName});
                }
            }
        }
        catch (NamingException err) {
            throw new MembershipSourceException((Throwable)err);
        }
        return groupNames;
    }

    static class LdapContext {
        String context;
        String searchFilter = "(objectclass=*)";
        String displayAttribute;
        String memberOfAttribute;
        int searchScope = 2;

        LdapContext() {
        }
    }

    static class UserEntry {
        private String dn;
        private Set groups;

        public UserEntry(String dn, Set groups) {
            this.dn = dn;
            this.groups = groups;
        }

        public String getDn() {
            return this.dn;
        }

        public Set getGroups() {
            return this.groups;
        }
    }
}

