/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2LocalMessages;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDACrypto;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContext;
import com.metamatrix.util.UtilSecurityContextCreator;
import java.sql.SQLException;
import java.util.Calendar;

public class DRDALoginRequest
extends DRDARequest {
    private static String footprint = "$Revision:   3.39.1.2  $";
    public boolean workAroundv8Bug = false;
    public boolean useTXNMGR = false;
    private short securityMechanism;
    public boolean secMecNotSupported;
    private String newPassword;
    private byte[] serverSecToken;
    private byte[] secToken;
    UtilSecurityContext securityContext;
    private String kerberosSecurityPrincipal;

    public DRDALoginRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter) throws SQLException {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSecurityMechanism(String string, String string2) throws SQLException {
        if (string2.equalsIgnoreCase("DBEncryption") || string2.equalsIgnoreCase("requestDBEncryption")) {
            if (string != null && !string.equalsIgnoreCase("ClearText") && !string.equalsIgnoreCase("None") && !string.equalsIgnoreCase("EncryptedPassword") && !string.equalsIgnoreCase("EncryptedUIDPassword")) throw this.comm.exceptions.getException(7126);
            this.securityMechanism = (short)13;
            this.comm.encryptData = true;
            return;
        } else {
            if (string == null || string.equalsIgnoreCase("ClearText") || string.equalsIgnoreCase("None")) {
                this.securityMechanism = (short)3;
            } else if (string.equalsIgnoreCase("EncryptedPassword")) {
                this.securityMechanism = (short)7;
            } else if (string.equalsIgnoreCase("EncryptedUIDPassword")) {
                this.securityMechanism = (short)9;
            } else if (string.equalsIgnoreCase("NewPassword")) {
                this.securityMechanism = (short)5;
            } else if (string.equalsIgnoreCase("Client")) {
                this.securityMechanism = (short)4;
                this.implConn.user = System.getProperty("user.name");
            } else {
                this.securityMechanism = this.implConn.isKerberosConnection ? (short)11 : (short)3;
            }
            this.comm.encryptData = false;
        }
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    public void submitRequest() throws SQLException {
        try {
            this.clearReplyChannel();
            this.writer.empty();
            this.writeEXCSAT(false);
            this.writer.send();
            this.reader.receive();
            this.processReply(this.implConn.warnings);
            switch (this.securityMechanism) {
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    this.comm.drdaCrypto = new DRDACrypto(this.comm);
                    this.writeACCSEC(false);
                    this.writer.send();
                    this.reader.receive();
                    this.processReply(this.implConn.warnings);
                    try {
                        if (!this.implConn.isKerberosConnection) break;
                        if (this.implConn.servicePrincipalName == null || this.implConn.servicePrincipalName.equalsIgnoreCase("")) {
                            if (this.kerberosSecurityPrincipal != null) {
                                this.implConn.servicePrincipalName = this.kerberosSecurityPrincipal;
                            } else {
                                throw this.comm.exceptions.getException(7120);
                            }
                        }
                        this.securityContext = UtilSecurityContextCreator.createType4SecurityContext((String)this.implConn.servicePrincipalName);
                        break;
                    }
                    catch (UtilException utilException) {
                        throw this.implConn.exceptions.getException((Exception)((Object)utilException));
                    }
                }
                default: {
                    this.writeACCSEC(true);
                }
            }
            this.writeSECCHK();
            this.writeACCRDB();
            this.writer.send();
            this.reader.receive();
        }
        catch (UtilException utilException) {
            this.exception = utilException.getReason() == 1002 ? this.comm.exceptions.getException(7113) : this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    protected void writeEXCSAT(boolean bl) throws UtilException {
        int n = 0;
        n = bl ? this.writer.writePacketHeader((short)1, (short)64, 1) : this.writer.writePacketHeader((short)1, (short)0, 1);
        int n2 = this.writer.writeCodePoint((short)4161);
        int n3 = this.writer.writeCodePoint((short)4446);
        this.writer.writeString(this.comm.ExternalName);
        this.writer.writeCodePointLength(n3);
        int n4 = this.writer.writeCodePoint((short)5124);
        this.writer.writeInt16(5123);
        this.writer.writeInt16(7);
        this.writer.writeInt16(5236);
        this.writer.writeInt16(this.comm.CMNTCPIPLevel);
        this.writer.writeInt16(9223);
        if (this.workAroundv8Bug) {
            this.writer.writeInt16(6);
        } else {
            this.writer.writeInt16(this.comm.SQLAMLevel);
        }
        this.writer.writeInt16(9231);
        this.writer.writeInt16(7);
        this.writer.writeInt16(5184);
        this.writer.writeInt16(7);
        if (this.useTXNMGR) {
            this.writer.writeInt16(7169);
            this.writer.writeInt16(7);
        } else {
            this.writer.writeInt16(5312);
            this.writer.writeInt16(7);
            this.writer.writeInt16(5313);
            this.writer.writeInt16(5);
        }
        this.writer.writeCodePointLength(n4);
        int n5 = this.writer.writeCodePoint((short)4423);
        this.writer.writeString(this.comm.ProductReleaseLevel);
        this.writer.writeCodePointLength(n5);
        int n6 = this.writer.writeCodePoint((short)4461);
        this.writer.writeString(this.comm.ClientName);
        this.writer.writeCodePointLength(n6);
        String string = null;
        String string2 = this.implConn.connectProps.get("serverReleaseLevel");
        string = string2 == null ? this.comm.ProductReleaseLevel : (string2.startsWith("enable_") ? string2.substring(7) : this.comm.ProductReleaseLevel);
        int n7 = this.writer.writeCodePoint((short)4442);
        this.writer.writeString(string);
        this.writer.writeCodePointLength(n7);
        this.writer.writeCodePointLength(n2);
        this.writer.writePacketLength(n);
    }

    private void writeACCSEC(boolean bl) throws UtilException {
        int n = 0;
        n = bl ? this.writer.writePacketHeader((short)1, (short)64, 2) : this.writer.writePacketHeader((short)1, (short)0, 2);
        int n2 = this.writer.writeCodePoint((short)4205);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4514);
        this.writer.writeInt16(this.securityMechanism);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        switch (this.securityMechanism) {
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                int n3 = this.writer.writeCodePoint((short)4572);
                this.writer.writeBytes(this.comm.drdaCrypto.getConnectionKey());
                this.writer.writeCodePointLength(n3);
                break;
            }
        }
        this.writer.writeCodePointLength(n2);
        this.writer.writePacketLength(n);
    }

    private void writeSECCHK() throws UtilException, SQLException {
        int n;
        int n2;
        int n3 = 0;
        n3 = this.implConn.isKerberosConnection ? this.writer.writePacketHeader((short)1, (short)80, 3) : this.writer.writePacketHeader((short)1, (short)64, 3);
        int n4 = this.writer.writeCodePoint((short)4206);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4514);
        this.writer.writeInt16(this.securityMechanism);
        if (this.securityMechanism == 5 || this.securityMechanism == 4 || this.securityMechanism == 7 || this.securityMechanism == 3) {
            n2 = this.writer.writeCodePoint((short)4512);
            if (!this.comm.isUDBCompatible()) {
                this.implConn.user = this.implConn.user.toUpperCase();
            }
            this.writer.writeSensitiveString(this.implConn.user);
            this.writer.writeCodePointLength(n2);
        }
        if (this.securityMechanism == 5 || this.securityMechanism == 3) {
            n2 = this.writer.writeCodePoint((short)4513);
            this.writer.writeSensitiveString(this.implConn.password);
            this.writer.writeCodePointLength(n2);
        }
        if (this.securityMechanism == 5) {
            n2 = this.writer.writeCodePoint((short)4574);
            this.writer.writeSensitiveString(this.newPassword);
            this.writer.writeCodePointLength(n2);
        }
        if (this.securityMechanism == 10 || this.securityMechanism == 9 || this.securityMechanism == 7 || this.securityMechanism == 13) {
            this.comm.drdaCrypto.deriveDESKey(this.comm.drdaCrypto.getSharedSessionKey());
            if (this.securityMechanism == 7) {
                this.comm.drdaCrypto.deriveDESInitVector(this.comm.defaultCCSIDTransliterator.encode(this.implConn.user));
            } else {
                this.comm.drdaCrypto.deriveDESInitVector(this.serverSecToken);
            }
            if (this.securityMechanism != 7) {
                n2 = this.writer.writeCodePoint((short)4572);
                this.writer.writeBytes(this.comm.drdaCrypto.DES_Encrypt(this.implConn.user, this.comm.defaultCCSIDTransliterator));
                this.writer.writeCodePointLength(n2);
            }
            n2 = this.writer.writeCodePoint((short)4572);
            this.writer.writeBytes(this.comm.drdaCrypto.DES_Encrypt(this.implConn.password, this.comm.defaultCCSIDTransliterator));
            this.writer.writeCodePointLength(n2);
            if (this.securityMechanism == 10) {
                n = this.writer.writeCodePoint((short)4572);
                this.writer.writeBytes(this.comm.drdaCrypto.DES_Encrypt(this.newPassword, this.comm.defaultCCSIDTransliterator));
                this.writer.writeCodePointLength(n);
            }
        }
        this.writer.writeCodePointLength(n4);
        this.writer.writePacketLength(n3);
        if (this.implConn.isKerberosConnection) {
            n2 = this.writer.writePacketHeader((short)3, (short)64, 3);
            n = this.writer.writeCodePoint((short)4572);
            this.secToken = this.securityContext.getSecurityToken(null);
            this.writer.writeBytes(this.secToken);
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
        }
    }

    private void writeACCRDB() throws UtilException, SQLException {
        int n = this.writer.writePacketHeader((short)1, (short)0, 4);
        int n2 = this.writer.writeCodePoint((short)8193);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8463);
        this.writer.writeInt16(9223);
        int n3 = this.writer.writeCodePoint((short)8501);
        this.writeCorrelationToken();
        this.writer.writeCodePointLength(n3);
        this.writer.writeInt16(22);
        this.writer.writeInt16(8464);
        this.writer.writeFixedLengthEncodedString(this.implConn.databaseName, this.comm.defaultCCSIDTransliterator, 18, (byte)64);
        String string = this.comm.ProductData;
        if (this.implConn.user.length() > 7) {
            string = string.concat(this.implConn.user.substring(1, 8));
        } else {
            string = string.concat(this.implConn.user);
            for (int i = 0; i < 8 - this.implConn.user.length(); ++i) {
                string = string.concat(" ");
            }
        }
        string = string.concat(this.comm.ProductReleaseLevel + this.comm.ClientName + "                            ");
        this.writer.writeInt16(string.length() + 5);
        this.writer.writeInt16(8452);
        this.writer.writeInt8(string.length());
        this.writer.writeString(string);
        this.writer.writeInt16(12);
        this.writer.writeInt16(4398);
        this.writer.writeString(this.comm.ProductReleaseLevel);
        this.writer.writeInt16(13);
        this.writer.writeInt16(47);
        this.writer.writeString("QTDSQLASC");
        this.writer.writeInt16(22);
        this.writer.writeInt16(53);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4508);
        this.writer.writeInt16(this.comm.clientSBCS);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4509);
        this.writer.writeInt16(this.comm.clientDBCS);
        this.writer.writeInt16(6);
        this.writer.writeInt16(4510);
        this.writer.writeInt16(this.comm.clientMBCS);
        this.writer.writeInt16(5);
        this.writer.writeInt16(8474);
        this.writer.writeInt8(241);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8481);
        this.writer.writeInt16(9276);
        this.writer.writeInt16(6);
        this.writer.writeInt16(8480);
        this.writer.writeInt16(9254);
        this.writer.writeCodePointLength(n2);
        this.writer.writePacketLength(n);
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 4633: 
                case 5187: 
                case 5292: 
                case 8705: {
                    break;
                }
                case 4446: {
                    this.comm.ServerExternalName = this.reader.readString(n);
                    break;
                }
                case 4398: {
                    this.comm.ServerProductID = this.reader.readString(n);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (this.comm.ServerProductID.charAt(3) != '0') {
                        stringBuffer.append(this.comm.ServerProductID.charAt(3));
                    }
                    if (this.comm.ServerProductID.charAt(4) != '0') {
                        stringBuffer.append(this.comm.ServerProductID.charAt(4));
                    }
                    if (this.comm.ServerProductID.charAt(6) != '0') {
                        stringBuffer2.append(this.comm.ServerProductID.charAt(6));
                    }
                    if (this.comm.ServerProductID.length() >= 8) {
                        this.comm.databasePatchVersion = this.comm.ServerProductID.substring(7);
                    }
                    if (stringBuffer2.length() == 0) {
                        stringBuffer2.append('0');
                    }
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append('0');
                    }
                    this.comm.serverMajorVersion = Integer.valueOf(stringBuffer.toString());
                    this.comm.serverMinorVersion = Integer.valueOf(stringBuffer2.toString());
                    break;
                }
                case 4516: {
                    byte by = this.reader.readInt8();
                    if (by != 0) {
                        this.reader.readAndDiscardBytes(n - 1);
                        String[] stringArray = new String[2];
                        stringArray[0] = this.implConn.databaseName.toUpperCase();
                        switch (by) {
                            case 1: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7016, null);
                                break;
                            }
                            case 2: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7017, null);
                                break;
                            }
                            case 3: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7018, null);
                                break;
                            }
                            case 4: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7019, null);
                                break;
                            }
                            case 5: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7020, null);
                                break;
                            }
                            case 6: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7021, null);
                                break;
                            }
                            case 7: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7022, null);
                                break;
                            }
                            case 8: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7023, null);
                                break;
                            }
                            case 9: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7024, null);
                                break;
                            }
                            case 10: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7025, null);
                                break;
                            }
                            case 11: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7026, null);
                                break;
                            }
                            case 14: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7027, null);
                                break;
                            }
                            case 15: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7028, null);
                                break;
                            }
                            case 16: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7029, null);
                                break;
                            }
                            case 18: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7030, null);
                                break;
                            }
                            case 19: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7031, null);
                                break;
                            }
                            case 20: {
                                stringArray[1] = ((DB2LocalMessages)this.comm.exceptions.getMessages().getImplLocalMessages()).getString(7032, null);
                                break;
                            }
                        }
                        if (this.severityCode == 4) {
                            baseWarnings.add(7037, stringArray);
                            break;
                        }
                        if (this.severityCode != 0) {
                            this.exception = this.comm.exceptions.getException(7037, stringArray, "08004", -1403);
                            return false;
                        }
                    }
                    break;
                }
                case 5124: {
                    int n3 = n;
                    int n4 = 0;
                    block57: do {
                        short s = this.reader.readInt16();
                        short s2 = this.reader.readInt16();
                        n4 += 4;
                        switch (s) {
                            case 5123: {
                                this.comm.DDMAgentLevel = s2;
                                break;
                            }
                            case 5236: {
                                this.comm.CMNTCPIPLevel = s2;
                                break;
                            }
                            case 9223: {
                                this.comm.SQLAMLevel = s2;
                                break;
                            }
                            case 9231: {
                                this.comm.RDBLevel = s2;
                                break;
                            }
                            case 5184: {
                                this.comm.SECMGRLevel = s2;
                                break;
                            }
                            case 5312: {
                                this.comm.SYNCPTMGRLevel = s2;
                                break;
                            }
                            case 7169: {
                                this.comm.XAMGRLevel = s2;
                                if (!this.implConn.isXAImplConn || s2 != 0) continue block57;
                                throw this.comm.exceptions.getException(7115);
                            }
                            case 5313: {
                                this.comm.RSYNCMGRLevel = s2;
                            }
                        }
                    } while (n4 < n3);
                    break;
                }
                case 4461: {
                    this.comm.ServerName = this.reader.readString(n);
                    break;
                }
                case 4423: {
                    this.comm.ServerClassName = this.reader.readString(n);
                    break;
                }
                case 4442: {
                    this.comm.ServerReleaseLevel = this.reader.readString(n);
                    break;
                }
                case 47: {
                    this.comm.ServerTypDefname = this.reader.readString(n);
                    break;
                }
                case 53: {
                    int n5 = n;
                    int n6 = 0;
                    do {
                        this.reader.readAndDiscardBytes(2);
                        short s = this.reader.readInt16();
                        short s3 = this.reader.readInt16();
                        n6 += 6;
                        switch (s) {
                            case 4508: {
                                this.comm.sbcs = s3;
                                break;
                            }
                            case 4509: {
                                this.comm.dbcs = s3;
                                this.comm.isUnicodeDB = true;
                                break;
                            }
                            case 4510: {
                                this.comm.mbcs = s3;
                                break;
                            }
                            case 6419: {
                                this.comm.serverXmlCCSID = s3;
                            }
                        }
                    } while (n6 < n5);
                    this.comm.setServerSideTransliteration();
                    break;
                }
                case 8451: {
                    this.implConn.cancelToken = new byte[n];
                    this.reader.readBytes(this.implConn.cancelToken, 0, n);
                    break;
                }
                case 4572: {
                    this.serverSecToken = new byte[n];
                    this.reader.readBytes(this.serverSecToken, 0, n);
                    if (this.comm.drdaCrypto != null) {
                        this.comm.drdaCrypto.serverPubKeyBytes = this.serverSecToken;
                    }
                    break;
                }
                case 4514: {
                    if (this.securityMechanism != this.reader.readInt16()) {
                        this.secMecNotSupported = true;
                        throw this.comm.exceptions.getException(7108, "08000");
                    }
                    this.secMecNotSupported = false;
                    break;
                }
                case 4584: {
                    byte[] byArray = new byte[n];
                    this.reader.readBytes(byArray, 0, n);
                    if (this.comm.CMNTCPIPLevel < 8) {
                        this.comm.implConn.cancelHost = String.valueOf(byArray[0] & 0xFF) + "." + String.valueOf(byArray[1] & 0xFF) + "." + String.valueOf(byArray[2] & 0xFF) + "." + String.valueOf(byArray[3] & 0xFF);
                        this.comm.implConn.cancelPort = Integer.toString(((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF));
                        break;
                    }
                    this.comm.implConn.cancelHost = this.comm.drdaUtil.byteToHex(byArray[0]) + this.comm.drdaUtil.byteToHex(byArray[1]) + ":" + this.comm.drdaUtil.byteToHex(byArray[2]) + this.comm.drdaUtil.byteToHex(byArray[3]) + ":" + this.comm.drdaUtil.byteToHex(byArray[4]) + this.comm.drdaUtil.byteToHex(byArray[5]) + ":" + this.comm.drdaUtil.byteToHex(byArray[6]) + this.comm.drdaUtil.byteToHex(byArray[7]) + ":" + this.comm.drdaUtil.byteToHex(byArray[8]) + this.comm.drdaUtil.byteToHex(byArray[9]) + ":" + this.comm.drdaUtil.byteToHex(byArray[10]) + this.comm.drdaUtil.byteToHex(byArray[11]) + ":" + this.comm.drdaUtil.byteToHex(byArray[12]) + this.comm.drdaUtil.byteToHex(byArray[13]) + ":" + this.comm.drdaUtil.byteToHex(byArray[14]) + this.comm.drdaUtil.byteToHex(byArray[15]);
                    this.comm.implConn.cancelPort = Integer.toString(((byArray[16] & 0xFF) << 8) + (byArray[17] & 0xFF));
                    break;
                }
                case 6418: {
                    byte[] byArray = new byte[2];
                    byte[] byArray2 = new byte[n - 2];
                    this.reader.readBytes(byArray, 0, 2);
                    this.comm.implConn.cancelPort = Integer.toString(((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF));
                    int n7 = this.reader.readInt16() - 4;
                    this.reader.readAndDiscardBytes(2);
                    this.comm.implConn.cancelHost = this.reader.readString(n7);
                    break;
                }
                case 4585: {
                    this.reader.readAndDiscardBytes(n);
                    this.comm.implConn.warnings.add(7112);
                    break;
                }
                case 7170: {
                    this.kerberosSecurityPrincipal = this.reader.readString(n);
                    break;
                }
                case 4512: 
                case 8485: 
                case 8501: 
                case 9294: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        return true;
    }

    private void writeCorrelationToken() throws UtilException, SQLException {
        String string = "";
        string = this.comm.ClientAddress + ".";
        int n = this.comm.getSocket().getLocalPort();
        String string2 = Integer.toHexString(n);
        if (string2.length() < 4) {
            for (int i = 0; i < 4 - string2.length(); ++i) {
                string2 = "0" + string2;
            }
        } else if (string2.length() > 4) {
            string2 = string2.substring(0, 4);
        }
        if (n < 40960) {
            char[] cArray = new char[]{'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', '0', 'P'};
            char[] cArray2 = string2.toCharArray();
            cArray2[0] = cArray[n / 4096];
            string2 = new String(cArray2);
        }
        string = string + string2.toUpperCase();
        this.writer.writeEncodedString(string, this.comm.defaultCCSIDTransliterator);
        Calendar calendar = Calendar.getInstance();
        short s = (short)calendar.get(10);
        short s2 = (short)calendar.get(12);
        short s3 = (short)calendar.get(13);
        byte[] byArray = new byte[]{(byte)(s >>> 8 & 0xFF), (byte)(s >>> 0 & 0xFF), (byte)(s2 >>> 8 & 0xFF), (byte)(s2 >>> 0 & 0xFF), (byte)(s3 >>> 8 & 0xFF), (byte)(s3 >>> 0 & 0xFF)};
        this.writer.writeBytes(byArray);
    }
}

