/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.proc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.NullTupleSource;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.proc.ProcedurePlan;
import com.metamatrix.query.processor.proc.RepeatedInstruction;
import com.metamatrix.query.processor.proc.UpdateCountTupleSource;
import com.metamatrix.query.processor.program.Program;
import com.metamatrix.query.processor.program.ProgramEnvironment;
import com.metamatrix.query.processor.program.ProgramInstruction;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.util.VariableContext;
import com.metamatrix.query.tempdata.TempTableStore;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcedureEnvironment
extends ProgramEnvironment {
    private Map tupleSourceMap = new HashMap();
    private Map tupleSourceIDMap = new HashMap();
    private Map currentRowMap = new HashMap();
    private static ElementSymbol ROWS_UPDATED = new ElementSymbol("VARIABLES.ROWS_UPDATED");
    private static int NO_ROWS_UPDATED = 0;
    private ProcedurePlan plan;
    private VariableContext currentVarContext;
    private boolean isUpdateProcedure = true;
    private TupleSource lastTupleSource;
    private List outputElements;
    private TempTableStore tempTableStore;
    private LinkedList tempContext = new LinkedList();

    public ProcedureEnvironment() {
        this.currentVarContext = new VariableContext();
        this.currentVarContext.setValue(ROWS_UPDATED, (Object)new Integer(NO_ROWS_UPDATED));
    }

    public void initialize(ProcessorPlan plan) {
        this.plan = (ProcedurePlan)plan;
    }

    private TupleSource getUpdateCountAsToupleSource() {
        Object rowCount = this.currentVarContext.getValue(ROWS_UPDATED);
        if (rowCount == null) {
            rowCount = new Integer(NO_ROWS_UPDATED);
        }
        ArrayList<Object> updateResult = new ArrayList<Object>(1);
        updateResult.add(rowCount);
        return new UpdateCountTupleSource(updateResult);
    }

    public VariableContext getCurrentVariableContext() {
        return this.currentVarContext;
    }

    public void executePlan(Object command, String rsName) throws MetaMatrixComponentException {
        boolean isExecSQLInstruction = rsName.equals("EXECSQL_INSTRUCTION");
        if (isExecSQLInstruction) {
            this.removeResults("EXECSQL_INSTRUCTION");
        }
        TupleSourceID tsID = this.plan.registerRequest(command);
        TupleSource source = this.plan.getResults(tsID);
        source.openSource();
        this.tupleSourceIDMap.put(rsName.toUpperCase(), tsID);
        this.tupleSourceMap.put(rsName.toUpperCase(), source);
        if (isExecSQLInstruction) {
            this.lastTupleSource = source;
        }
    }

    public void pop() throws MetaMatrixComponentException {
        super.pop();
        Set current = this.getTempContext();
        Set tempTables = this.getLocalTempTables();
        tempTables.addAll(current);
        Iterator i = tempTables.iterator();
        while (i.hasNext()) {
            this.removeResults((String)i.next());
        }
        this.tempContext.removeLast();
    }

    public void push(Program program) {
        super.push(program);
        Set current = this.getTempContext();
        Set tempTables = this.getLocalTempTables();
        current.addAll(tempTables);
        this.tempContext.add(new HashSet());
    }

    public void incrementProgramCounter() throws MetaMatrixComponentException {
        Program program = this.peek();
        ProgramInstruction instr = program.getCurrentInstruction();
        if (instr instanceof RepeatedInstruction) {
            RepeatedInstruction repeated = (RepeatedInstruction)instr;
            repeated.postInstruction(this);
        }
        super.incrementProgramCounter();
    }

    private Set getLocalTempTables() {
        Set tempTables = this.tempTableStore.getAllTempTables();
        for (int i = 0; i < this.tempContext.size() - 1; ++i) {
            tempTables.removeAll((Set)this.tempContext.get(i));
        }
        return tempTables;
    }

    public Set getTempContext() {
        if (this.tempContext.isEmpty()) {
            this.tempContext.addLast(new HashSet());
        }
        return (Set)this.tempContext.getLast();
    }

    public List getCurrentRow(String rsName) {
        return (List)this.currentRowMap.get(rsName.toUpperCase());
    }

    public boolean iterateCursor(String rsName) throws MetaMatrixComponentException {
        String rsKey = rsName.toUpperCase();
        TupleSource source = (TupleSource)this.tupleSourceMap.get(rsKey);
        if (source == null) {
            return false;
        }
        List row = source.nextTuple();
        this.currentRowMap.put(rsKey, row);
        return row != null;
    }

    public void removeResults(String rsName) throws MetaMatrixComponentException {
        String rsKey = rsName.toUpperCase();
        TupleSource source = (TupleSource)this.tupleSourceMap.get(rsKey);
        if (source != null) {
            source.closeSource();
            TupleSourceID tsID = (TupleSourceID)this.tupleSourceIDMap.get(rsKey);
            this.plan.removeTupleSource(tsID);
            this.tupleSourceMap.remove(rsKey);
            this.tupleSourceIDMap.remove(rsKey);
            this.currentRowMap.remove(rsKey);
            this.tempTableStore.removeTempTableByName(rsKey);
        }
    }

    public List getSchema(String rsName) throws MetaMatrixComponentException {
        String rsKey = rsName.toUpperCase();
        TupleSource source = (TupleSource)this.tupleSourceMap.get(rsKey);
        if (source == null) {
            throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ERR.015.006.0037", (Object)rsName));
        }
        List schema = source.getSchema();
        if (schema == null) {
            throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ERR.015.006.0038"));
        }
        return schema;
    }

    public boolean resultSetExists(String rsName) {
        String rsKey = rsName.toUpperCase();
        boolean exists = this.tupleSourceMap.containsKey(rsKey);
        return exists;
    }

    public ProcessorDataManager getDataManager() {
        return this.plan.getDataManager();
    }

    public CommandContext getContext() {
        return this.plan.getContext();
    }

    public boolean isUpdateProcedure() {
        return this.isUpdateProcedure;
    }

    public void setUpdateProcedure(boolean b) {
        this.isUpdateProcedure = b;
    }

    public TupleSource getFinalTupleSource() {
        if (this.isUpdateProcedure) {
            return this.getUpdateCountAsToupleSource();
        }
        if (this.lastTupleSource == null) {
            return new NullTupleSource(null);
        }
        return this.lastTupleSource;
    }

    public List getOutputElements() {
        return this.outputElements;
    }

    public void setOutputElements(List outputElements) {
        this.outputElements = outputElements;
    }

    public void reset() {
        this.tupleSourceMap.clear();
        this.tupleSourceIDMap.clear();
        this.currentRowMap.clear();
        this.currentVarContext = new VariableContext();
        this.currentVarContext.setValue(ROWS_UPDATED, (Object)new Integer(NO_ROWS_UPDATED));
        this.lastTupleSource = null;
    }

    public void close() {
        for (String name : new ArrayList(this.tupleSourceMap.keySet())) {
            try {
                this.removeResults(name);
            }
            catch (MetaMatrixComponentException metaMatrixComponentException) {}
        }
    }

    public TempTableStore getTempTableStore() {
        return this.tempTableStore;
    }

    public void setTempTableStore(TempTableStore tempTableStore) {
        this.tempTableStore = tempTableStore;
    }
}

