/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplBlobEmulated;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplClobEmulated;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.sqlserver.SQLServerColumn;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplDatabaseMetaData;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import java.sql.SQLException;

public class SQLServerImplResultSet
extends BaseImplResultSet {
    private static String footprint = "$Revision:   3.23.1.3  $";
    TDSRequest tdsRequest;
    boolean isClosed;
    int statementLongDataCache;

    public void reset() {
        super.reset();
        this.isClosed = false;
        this.tdsRequest = null;
    }

    public void initialize(TDSRequest tDSRequest, int n) {
        this.statementLongDataCache = n;
        this.tdsRequest = tDSRequest;
    }

    public void internalClose() throws SQLException {
        this.tdsRequest.completeRowProcessing(this.warnings);
        this.isClosed = true;
    }

    public void close() throws SQLException {
        if (!this.isClosed) {
            this.internalClose();
        }
        this.reset();
        this.getConnection().putImplResultSet(this);
    }

    public TDSConnection getTDSConnection() {
        return ((SQLServerImplStatement)this.implStatement).conn;
    }

    public int getColumnAccess() {
        if (this.tdsRequest.hasLongColumns() && (this.statementLongDataCache == -1 || this.tdsRequest.conn.maxMemoryPerLongDataCache < 0 && this.statementLongDataCache < 0)) {
            return 1;
        }
        return 2;
    }

    protected SQLServerConnection getConnection() {
        return ((SQLServerImplConnection)this.implStatement.implConnection).connection;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        if (this.tdsRequest.getRow(this.warnings, this.statementLongDataCache)) {
            return true;
        }
        this.internalClose();
        return false;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        SQLServerColumn sQLServerColumn = this.tdsRequest.getColumnDataForRow(n, n2, this.statementLongDataCache);
        switch (this.implStatement.databaseMetaDataResultSet) {
            case 0: {
                break;
            }
            case 1: {
                if (n <= 5) break;
                return new BaseData((BaseConnection)this.getConnection());
            }
            case 15: {
                if (n == 1) {
                    n = 2;
                } else if (n == 2) {
                    n = 1;
                }
                sQLServerColumn = this.tdsRequest.getColumnDataForRow(n, n2, this.statementLongDataCache);
                break;
            }
            case 2: {
                if (n == 5) {
                    short s = sQLServerColumn.data.getShort(this.exceptions);
                    short s2 = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(s);
                    BaseData baseData = new BaseData((BaseConnection)this.getConnection());
                    baseData.setShort(s2);
                    return baseData;
                }
                if (n <= 18) break;
                return new BaseData((BaseConnection)this.getConnection());
            }
            case 6: {
                if (n != 6) break;
                short s = sQLServerColumn.data.getShort(this.exceptions);
                short s3 = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(s);
                BaseData baseData = new BaseData((BaseConnection)this.getConnection());
                baseData.setShort(s3);
                return baseData;
            }
            case 7: 
            case 18: {
                if (n != 3) break;
                short s = sQLServerColumn.data.getShort(this.exceptions);
                short s4 = SQLServerImplDatabaseMetaData.mapODBCTypeToJDBCType(s);
                BaseData baseData = new BaseData((BaseConnection)this.getConnection());
                baseData.setShort(s4);
                return baseData;
            }
            case 13: {
                if (n == 4) {
                    if (!sQLServerColumn.data.isNull) break;
                    BaseData baseData = new BaseData((BaseConnection)this.getConnection());
                    baseData.setBoolean(false);
                    return baseData;
                }
                if (n != 8 || !sQLServerColumn.data.isNull) break;
                BaseData baseData = new BaseData((BaseConnection)this.getConnection());
                baseData.setInteger(0);
                return baseData;
            }
        }
        if (this.tdsRequest.currentIsLongOfColumns[n - 1]) {
            int n3 = sQLServerColumn.TDSType == 34 || sQLServerColumn.TDSType == -15 && !((SQLServerImplConnection)this.implStatement.implConnection).xmlDescribeTypeIsChar ? (n2 == 19 ? 19 : 14) : (sQLServerColumn.TDSType == 99 ? (n2 == 20 ? 20 : 18) : (n2 == 20 ? 20 : (n2 == 15 ? 15 : 18)));
            if (sQLServerColumn.longDataCached) {
                TDSConnection tDSConnection = this.getTDSConnection();
                switch (sQLServerColumn.TDSType) {
                    case 35: 
                    case 99: {
                        if (n3 == 20) {
                            BaseImplClobEmulated baseImplClobEmulated = new BaseImplClobEmulated(this.exceptions, sQLServerColumn.longData);
                            sQLServerColumn.data.setClob((BaseImplClob)baseImplClobEmulated);
                            sQLServerColumn.releaseLongDataAtNextFetch = true;
                            break;
                        }
                        sQLServerColumn.data.setUCS2InputStream(sQLServerColumn.longData.getInputStream());
                        sQLServerColumn.releaseLongDataAtNextFetch = false;
                        break;
                    }
                    case 34: {
                        if (n3 == 19) {
                            BaseImplBlobEmulated baseImplBlobEmulated = new BaseImplBlobEmulated(this.exceptions, sQLServerColumn.longData);
                            sQLServerColumn.data.setBlob((BaseImplBlob)baseImplBlobEmulated);
                            if (tDSConnection.maxMemoryPerLongDataCache == -1) {
                                sQLServerColumn.longData = null;
                                break;
                            }
                            sQLServerColumn.releaseLongDataAtNextFetch = true;
                            break;
                        }
                        sQLServerColumn.data.setBinaryStream(sQLServerColumn.longData.getInputStream());
                        sQLServerColumn.releaseLongDataAtNextFetch = false;
                        break;
                    }
                    case -15: {
                        if (((SQLServerImplConnection)this.implStatement.implConnection).xmlDescribeTypeIsChar) {
                            if (n3 == 20) {
                                BaseImplClobEmulated baseImplClobEmulated = new BaseImplClobEmulated(this.exceptions, sQLServerColumn.longData);
                                sQLServerColumn.data.setClob((BaseImplClob)baseImplClobEmulated);
                                sQLServerColumn.releaseLongDataAtNextFetch = false;
                                break;
                            }
                            sQLServerColumn.data.setUCS2InputStream(sQLServerColumn.longData.getInputStream());
                            sQLServerColumn.releaseLongDataAtNextFetch = false;
                            break;
                        }
                        if (n3 == 19) {
                            BaseImplBlobEmulated baseImplBlobEmulated = new BaseImplBlobEmulated(this.exceptions, sQLServerColumn.longData);
                            sQLServerColumn.data.setBlob((BaseImplBlob)baseImplBlobEmulated);
                            if (tDSConnection.maxMemoryPerLongDataCache == -1) {
                                sQLServerColumn.longData = null;
                                break;
                            }
                            sQLServerColumn.releaseLongDataAtNextFetch = true;
                            break;
                        }
                        sQLServerColumn.data.setBinaryStream(sQLServerColumn.longData.getInputStream());
                        sQLServerColumn.releaseLongDataAtNextFetch = false;
                    }
                }
            } else if (sQLServerColumn.data.isNull) {
                sQLServerColumn.data.setNull(n3);
            }
        }
        return sQLServerColumn.data;
    }
}

