/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.command;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.resolver.CommandResolver;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.resolver.util.ResolverVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.GroupContext;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynamicCommandResolver
implements CommandResolver {
    public void resolveCommand(Command command, boolean useMetadataCommands, TempMetadataAdapter metadata, AnalysisRecord analysis, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        ElementSymbol column;
        DynamicCommand dynamicCmd = (DynamicCommand)command;
        Iterator columns = dynamicCmd.getAsColumns().iterator();
        HashSet groups = new HashSet();
        if (dynamicCmd.getIntoGroup() == null) {
            while (columns.hasNext()) {
                column = (ElementSymbol)columns.next();
                column.setMetadataID((Object)new TempMetadataID(column.getShortCanonicalName(), column.getType()));
            }
        } else if (dynamicCmd.getIntoGroup().isTempGroupSymbol()) {
            while (columns.hasNext()) {
                column = (ElementSymbol)columns.next();
                column.setName(dynamicCmd.getIntoGroup().getCanonicalName() + "." + column.getShortName());
            }
        }
        ResolverVisitor.resolveLanguageObject((LanguageObject)dynamicCmd, groups, (GroupContext)dynamicCmd.getExternalGroupContexts(), (QueryMetadataInterface)metadata);
        String sqlType = DataTypeManager.getDataTypeName((Class)dynamicCmd.getSql().getType());
        String targetType = "string";
        if (!targetType.equals(sqlType) && !DataTypeManager.isImplicitConversion((String)sqlType, (String)targetType)) {
            throw new QueryResolverException(QueryPlugin.Util.getString("DynamicCommandResolver.SQL_String", (Object)sqlType));
        }
        if (dynamicCmd.getUsing() != null && !dynamicCmd.getUsing().isEmpty()) {
            Iterator i = dynamicCmd.getUsing().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ElementSymbol id = (ElementSymbol)entry.getKey();
                id.setName("USING." + id.getShortName());
                id.setGroupSymbol(new GroupSymbol("USING"));
                id.setType(((Expression)entry.getValue()).getType());
                id.setMetadataID((Object)new TempMetadataID(id.getCanonicalName(), id.getType()));
            }
        }
        if (dynamicCmd.getIntoGroup() != null) {
            GroupSymbol symbol = dynamicCmd.getIntoGroup();
            List symbols = dynamicCmd.getAsColumns();
            ResolverUtil.resolveImplicitTempGroup(metadata, symbol, symbols);
        }
    }
}

