/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards;

import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Binding;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Fault;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Message;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Model;
import com.metamatrix.modeler.modelgenerator.wsdl.model.ModelGenerationException;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Operation;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Port;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Service;
import com.metamatrix.modeler.modelgenerator.wsdl.model.WSDLElement;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.ModelGeneratorWsdlUiConstants;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.util.ModelGeneratorWsdlUiUtil;
import com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.WSDLImportWizardManager;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.util.WizardUtil;
import com.metamatrix.ui.internal.widget.DefaultTreeViewerController;
import com.metamatrix.ui.internal.widget.ITreeViewerController;
import com.metamatrix.ui.internal.wizard.AbstractWizardPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectWsdlOperationsPage
extends AbstractWizardPage
implements Listener,
FileUtils.Constants,
StringUtil.Constants,
ModelGeneratorWsdlUiConstants,
ModelGeneratorWsdlUiConstants.Images {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlOperationsPage == null ? (class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlOperationsPage = SelectWsdlOperationsPage.class$("com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.SelectWsdlOperationsPage")) : class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlOperationsPage));
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private TreeViewer treeViewer;
    private Tree tree;
    private boolean treeExpanded = false;
    private CheckboxTreeController controller;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Text detailsTextBox;
    private WSDLImportWizardManager importManager;
    private Model wsdlModel = null;
    private boolean initializing = false;
    static /* synthetic */ Class class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlOperationsPage;

    public SelectWsdlOperationsPage(WSDLImportWizardManager theImportManager) {
        super(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlOperationsPage == null ? (class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlOperationsPage = SelectWsdlOperationsPage.class$("com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards.SelectWsdlOperationsPage")) : class$com$metamatrix$modeler$modelgenerator$wsdl$ui$internal$wizards$SelectWsdlOperationsPage)), SelectWsdlOperationsPage.getString("title"));
        this.importManager = theImportManager;
        this.importManager.setSelectedOperations(new ArrayList());
        this.setImageDescriptor(ModelGeneratorWsdlUiUtil.getImageDescriptor("icons/full/wizban/new_wsdl_wiz.gif"));
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.tree) {
                this.updateTreeSelectionDetails();
            }
            if (event.widget == this.selectAllButton) {
                this.setAllNodesSelected(true);
            }
            if (event.widget == this.deselectAllButton) {
                this.setAllNodesSelected(false);
            }
            if (validate) {
                this.setPageStatus();
            }
        }
    }

    private void updateTreeSelectionDetails() {
        TreeItem[] selections = this.tree.getSelection();
        if (selections != null && selections.length > 0) {
            TreeItem selectedItem = selections[0];
            this.updateSelectionDetailsArea(selectedItem.getData());
        }
    }

    public void createControl(Composite theParent) {
        boolean COLUMNS = true;
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        pnlMain.setLayout((Layout)layout);
        this.setControl((Control)pnlMain);
        SashForm splitter = new SashForm(pnlMain, 512);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        splitter.setLayoutData((Object)gid);
        this.createCheckboxTreeComposite((Composite)splitter, SelectWsdlOperationsPage.getString("checkboxTreeGroup.title"));
        this.createDetailsComposite((Composite)splitter);
        splitter.setWeights(new int[]{70, 30});
        this.restoreState();
    }

    private void createCheckboxTreeComposite(Composite parent, String title) {
        Composite checkBoxTreeComposite = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        checkBoxTreeComposite.setLayout((Layout)layout);
        Group group = WidgetFactory.createGroup((Composite)checkBoxTreeComposite, (String)title, (int)1808, (int)1, (int)2);
        this.controller = new CheckboxTreeController();
        this.treeViewer = WidgetFactory.createTreeViewer((Composite)group, (int)36, (int)1808, (ITreeViewerController)this.controller);
        this.tree = this.treeViewer.getTree();
        this.tree.addListener(13, (Listener)this);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new CheckboxTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CheckboxTreeLabelProvider());
        this.treeViewer.setInput(null);
        Composite buttonComposite = WidgetFactory.createPanel((Composite)group, (int)0, (int)1040);
        layout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)layout);
        this.selectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SelectWsdlOperationsPage.getString("selectAllButton.text"), (int)768);
        this.selectAllButton.setToolTipText(SelectWsdlOperationsPage.getString("selectAllButton.tipText"));
        this.deselectAllButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SelectWsdlOperationsPage.getString("deselectAllButton.text"), (int)768);
        this.deselectAllButton.setToolTipText(SelectWsdlOperationsPage.getString("deselectAllButton.tipText"));
        this.selectAllButton.addListener(13, (Listener)this);
        this.deselectAllButton.addListener(13, (Listener)this);
    }

    private void createDetailsComposite(Composite parent) {
        Composite detailsComposite = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        detailsComposite.setLayout((Layout)layout);
        CLabel theLabel = new CLabel(detailsComposite, 0);
        theLabel.setText(SelectWsdlOperationsPage.getString("detailsTextbox.title"));
        GridData gridData = new GridData(0);
        gridData.horizontalSpan = 1;
        theLabel.setLayoutData((Object)gridData);
        this.detailsTextBox = WidgetFactory.createTextBox((Composite)detailsComposite, (int)0, (int)1808);
        this.detailsTextBox.setEditable(false);
    }

    private void updateSelectionDetailsArea(Object selectedObject) {
        StringBuffer sb = new StringBuffer();
        if (selectedObject instanceof Service) {
            Service theService = (Service)selectedObject;
            sb.append(theService.getName() + " [Service]\n");
            sb.append("id: " + theService.getId());
        } else if (selectedObject instanceof Port) {
            Port thePort = (Port)selectedObject;
            sb.append(thePort.getName() + " [Port]\n");
            sb.append("id: " + thePort.getId());
        } else if (selectedObject instanceof Binding) {
            this.addBindingDetails((Binding)selectedObject, sb);
        } else if (selectedObject instanceof Operation) {
            this.addOperationDetails((Operation)selectedObject, sb);
        } else if (selectedObject instanceof Message) {
            Message theMessage = (Message)selectedObject;
            sb.append(theMessage.getName() + " [Message]\n");
            sb.append("id: " + theMessage.getId());
        }
        this.detailsTextBox.setText(sb.toString());
    }

    private void addBindingDetails(Binding binding, StringBuffer sb) {
        sb.append(binding.getName() + " [Binding]\n");
        sb.append("id: \t\t" + binding.getId() + '\n');
        sb.append("uri: \t" + binding.getTransportURI() + '\n');
        sb.append("style: \t" + binding.getStyle());
    }

    private void addOperationDetails(Operation operation, StringBuffer sb) {
        sb.append(operation.getName() + " [Operation]\n");
        sb.append("id: \t\t\t\t\t" + operation.getId() + '\n');
        Message inMsg = operation.getInputMessage();
        String inMsgName = inMsg != null ? inMsg.getName() : "none";
        sb.append("input message: \t" + inMsgName + '\n');
        Message outMsg = operation.getOutputMessage();
        String outMsgName = outMsg != null ? outMsg.getName() : "none";
        sb.append("output message: \t" + outMsgName + '\n');
        Fault[] faults = operation.getFaults();
        sb.append("fault names: \t\t");
        if (faults == null || faults.length == 0) {
            sb.append("none");
        } else {
            for (int i = 0; i < faults.length; ++i) {
                Fault theFault = faults[i];
                sb.append(theFault.getName());
                if (i == faults.length - 1) continue;
                sb.append(", ");
            }
        }
        if (!operation.canModel()) {
            String[] errorMsgs = operation.getProblemMessages();
            for (int i = 0; i < errorMsgs.length; ++i) {
                sb.append('\n');
                sb.append(errorMsgs[i]);
            }
        }
    }

    public void dispose() {
        this.saveState();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("ModelGeneratorWsdlUi");
            settings = temp == null ? settings.addNewSection("ModelGeneratorWsdlUi") : temp;
        }
        return settings;
    }

    private static String getString(String theKey) {
        return ModelGeneratorWsdlUiConstants.UTIL.getString(PREFIX + theKey);
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void setPageStatus() {
        boolean hasSelections;
        boolean bl = hasSelections = this.importManager.getSelectedOperations().size() > 0;
        if (!hasSelections) {
            WizardUtil.setPageComplete((WizardPage)this, (String)SelectWsdlOperationsPage.getString("noSelections.msg"), (int)3);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        this.getContainer().updateButtons();
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            try {
                this.wsdlModel = this.importManager.getWSDLModel();
            }
            catch (ModelGenerationException e) {
                this.wsdlModel = null;
                Status exStatus = new Status(4, "com.metamatrix.modeler.modelgenerator.wsdl.ui", 0, SelectWsdlOperationsPage.getString("dialog.wsdlParseError.msg"), (Throwable)e);
                Shell shell = this.getShell();
                ErrorDialog.openError((Shell)shell, null, (String)SelectWsdlOperationsPage.getString("dialog.wsdlParseError.title"), (IStatus)exStatus);
            }
            this.treeViewer.setInput((Object)this.wsdlModel);
            this.importManager.setSelectedOperations(new ArrayList());
            this.treeViewer.expandToLevel(4);
            this.setAllNodesSelected(true);
            this.setPageStatus();
        }
        super.setVisible(isVisible);
    }

    private void setAllNodesSelected(boolean bSelected) {
        TreeItem[] items = this.tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            this.setAllSelected(items[i], bSelected);
        }
    }

    private void setAllSelected(TreeItem item, boolean checked) {
        WidgetUtil.setChecked((TreeItem)item, (boolean)checked, (boolean)false, (ITreeViewerController)this.controller);
        TreeItem[] children = item.getItems();
        for (int ndx = 0; ndx < children.length; ++ndx) {
            this.setAllSelected(children[ndx], checked);
        }
    }

    private boolean hasValidOperation(Object object) {
        boolean hasValid = false;
        if (object instanceof Model) {
            Service[] services = ((Model)object).getServices();
            for (int i = 0; i < services.length; ++i) {
                if (!this.hasValidOperation(services[i])) continue;
                hasValid = true;
                break;
            }
        } else if (object instanceof Service) {
            Port[] ports = ((Service)object).getPorts();
            for (int i = 0; i < ports.length; ++i) {
                if (!this.hasValidOperation(ports[i])) continue;
                hasValid = true;
                break;
            }
        } else if (object instanceof Port) {
            Binding binding = ((Port)object).getBinding();
            if (this.hasValidOperation(binding)) {
                hasValid = true;
            }
        } else if (object instanceof Binding) {
            Operation[] operations = ((Binding)object).getOperations();
            for (int i = 0; i < operations.length; ++i) {
                if (!this.hasValidOperation(operations[i])) continue;
                hasValid = true;
                break;
            }
        } else if (object instanceof Operation) {
            hasValid = ((Operation)object).canModel();
        }
        return hasValid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CheckboxTreeController
    extends DefaultTreeViewerController {
        private CheckboxTreeController() {
        }

        public void checkedStateToggled(TreeItem item) {
        }

        public boolean isItemCheckable(TreeItem item) {
            Object node = item.getData();
            if (node instanceof Service || node instanceof Binding || node instanceof Port || node instanceof Operation) {
                return SelectWsdlOperationsPage.this.hasValidOperation(node);
            }
            return false;
        }

        public void update(TreeItem item, boolean selected) {
            Object dataObj = item.getData();
            if (dataObj != null) {
                boolean checked;
                boolean bl = checked = !WidgetUtil.isUnchecked((TreeItem)item);
                if (this.isItemCheckable(item)) {
                    item.setChecked(checked);
                }
                item.setGrayed(WidgetUtil.isPartiallyChecked((TreeItem)item));
                if (selected) {
                    this.updateChildren(item, checked);
                    for (TreeItem parent = item.getParentItem(); parent != null; parent = parent.getParentItem()) {
                        int state = 4;
                        TreeItem[] children = parent.getItems();
                        int ndx = children.length;
                        while (--ndx >= 0) {
                            TreeItem child = children[ndx];
                            if (WidgetUtil.isPartiallyChecked((TreeItem)child)) {
                                state = 4;
                                break;
                            }
                            int childState = WidgetUtil.getCheckedState((TreeItem)child);
                            if (state == 4) {
                                state = childState;
                                continue;
                            }
                            if (state == childState) continue;
                            state = 4;
                            break;
                        }
                        if (state == WidgetUtil.getCheckedState((TreeItem)parent)) continue;
                        WidgetUtil.setCheckedState((TreeItem)parent, (int)state, (boolean)false, (ITreeViewerController)this);
                    }
                }
                if (dataObj instanceof Operation && SelectWsdlOperationsPage.this.hasValidOperation(dataObj)) {
                    this.updateCheckedOperations((Operation)dataObj, checked);
                }
                if (!this.isItemCheckable(item)) {
                    item.setGrayed(true);
                    item.setChecked(false);
                } else {
                    item.setGrayed(false);
                }
            }
        }

        private void updateCheckedOperations(Operation operation, boolean checked) {
            List selectedOperations = SelectWsdlOperationsPage.this.importManager.getSelectedOperations();
            if (checked && operation.canModel() && !selectedOperations.contains(operation)) {
                selectedOperations.add(operation);
                SelectWsdlOperationsPage.this.importManager.setSelectedOperations(selectedOperations);
                SelectWsdlOperationsPage.this.setPageStatus();
            } else if (!checked && selectedOperations.contains(operation)) {
                selectedOperations.remove(operation);
                SelectWsdlOperationsPage.this.importManager.setSelectedOperations(selectedOperations);
                SelectWsdlOperationsPage.this.setPageStatus();
            }
        }

        private void updateChildren(TreeItem item, boolean checked) {
            TreeItem[] children = item.getItems();
            int ndx = children.length;
            while (--ndx >= 0) {
                TreeItem child = children[ndx];
                if (child.getData() == null) continue;
                this.updateChildren(child, checked);
                WidgetUtil.setChecked((TreeItem)child, (boolean)checked, (boolean)false, (ITreeViewerController)this);
            }
        }

        public void itemExpanded(TreeExpansionEvent event) {
            if (SelectWsdlOperationsPage.this.treeExpanded) {
                super.itemExpanded(event);
            } else {
                TreeItem item = ((TreeViewer)event.getTreeViewer()).getTree().getSelection()[0];
                if (item.getData() != null) {
                    this.updateChildren(item, false);
                }
                SelectWsdlOperationsPage.this.treeExpanded = true;
            }
            SelectWsdlOperationsPage.this.updateTreeSelectionDetails();
        }

        public void itemCollapsed(TreeExpansionEvent event) {
            super.itemCollapsed(event);
            SelectWsdlOperationsPage.this.updateTreeSelectionDetails();
        }
    }

    private class CheckboxTreeContentProvider
    implements ITreeContentProvider {
        private CheckboxTreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object node) {
            if (SelectWsdlOperationsPage.this.wsdlModel != null) {
                if (node instanceof Model) {
                    return ((Model)node).getServices();
                }
                if (node instanceof Service) {
                    return ((Service)node).getPorts();
                }
                if (node instanceof Port) {
                    return new Object[]{((Port)node).getBinding()};
                }
                if (node instanceof Binding) {
                    return ((Binding)node).getOperations();
                }
            }
            return StringUtil.Constants.EMPTY_STRING_ARRAY;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object node) {
            if (SelectWsdlOperationsPage.this.wsdlModel != null) {
                if (node instanceof Model) {
                    return null;
                }
                if (node instanceof Service) {
                    return null;
                }
                if (node instanceof Port) {
                    return ((Port)node).getService();
                }
                if (node instanceof Binding) {
                    return ((Binding)node).getPort();
                }
                if (node instanceof Operation) {
                    return ((Operation)node).getBinding();
                }
            }
            return null;
        }

        public boolean hasChildren(Object node) {
            if (SelectWsdlOperationsPage.this.wsdlModel != null) {
                if (node instanceof Model) {
                    return ((Model)node).getServices().length > 0;
                }
                if (node instanceof Service) {
                    return ((Service)node).getPorts().length > 0;
                }
                if (node instanceof Port) {
                    return ((Port)node).getBinding() != null;
                }
                if (node instanceof Binding) {
                    return ((Binding)node).getOperations().length > 0;
                }
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class CheckboxTreeLabelProvider
    extends LabelProvider {
        private final Image SERVICE_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/service_obj.gif");
        private final Image PORT_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/port_obj.gif");
        private final Image OPERATION_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/operation_obj.gif");
        private final Image BINDING_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/binding_obj.gif");
        private final Image INVALID_OPERATION_ICON_IMG = ModelGeneratorWsdlUiUtil.getImage("icons/full/obj16/operation_invalid_obj.gif");
        final WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();

        private CheckboxTreeLabelProvider() {
        }

        public Image getImage(Object node) {
            if (node instanceof Service) {
                return this.SERVICE_ICON_IMG;
            }
            if (node instanceof Port) {
                return this.PORT_ICON_IMG;
            }
            if (node instanceof Operation) {
                if (SelectWsdlOperationsPage.this.hasValidOperation(node)) {
                    return this.OPERATION_ICON_IMG;
                }
                return this.INVALID_OPERATION_ICON_IMG;
            }
            if (node instanceof Binding) {
                return this.BINDING_ICON_IMG;
            }
            return null;
        }

        public String getText(Object node) {
            if (node instanceof Model) {
                return "theModel";
            }
            if (node instanceof WSDLElement) {
                return ((WSDLElement)node).getName();
            }
            return "unknownElement";
        }
    }
}

