/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.internal.ui.sqleditor.component;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.query.internal.ui.sqleditor.component.BlockDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeConstants;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeFactory;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeUtils;
import com.metamatrix.query.internal.ui.sqleditor.component.ExpressionDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.FromDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.QueryDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.SelectDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.SetQueryDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.SymbolDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.UnaryFromClauseDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.WhereDisplayNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.resolver.util.QueryValidationResult;
import com.metamatrix.query.resolver.util.QueryValidator;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.MultipleElementSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.util.ElementSymbolOptimizer;
import com.metamatrix.query.ui.UiConstants;
import com.metamatrix.query.ui.UiPlugin;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class QueryDisplayComponent
implements DisplayNodeConstants,
UiConstants {
    private static final String DEFAULT_QUERY = UiConstants.Util.getString("QueryDisplayComponent.defaultSqlText");
    private static final String QUERY_NOT_PARSABLE_MSG = UiConstants.Util.getString("QueryDisplayComponent.queryNotParsableMsg");
    private static final String QUERY_PARSABLE_NOT_RESOLVABLE_MSG = UiConstants.Util.getString("QueryDisplayComponent.queryParsableNotResolvableMsg");
    private static final String QUERY_NOT_VALID_MSG = UiConstants.Util.getString("QueryDisplayComponent.queryNotValidMsg");
    private static final String RESOLVER_ERROR_MSG = UiConstants.Util.getString("QueryDisplayComponent.resolverErrorMsg");
    private static final String EMPTY_SQL_MSG = UiConstants.Util.getString("QueryDisplayComponent.emptySqlMsg");
    private static final String DEFAULT_SQL_MSG = UiConstants.Util.getString("QueryDisplayComponent.defaultSqlMsg");
    private static final String MONITOR_CHECKING_DISPLAY_NODES = UiConstants.Util.getString("QueryDisplayComponent.checkingDisplayNodes");
    private static final String MONITOR_VALIDATING_SQL = UiConstants.Util.getString("QueryDisplayComponent.validatingSQL");
    private static final String MONITOR_PREPARING_RESULTS = UiConstants.Util.getString("QueryDisplayComponent.preparingResults");
    private QueryValidator queryValidator = null;
    private int queryType = 0;
    private QueryValidationResult validationResult;
    private boolean isParsable = false;
    private boolean isResolvable = false;
    private boolean isValidatable = false;
    private String statusMessage = null;
    private int errorStart = -1;
    private int errorEnd = -1;
    private DisplayNode sqlDisplayNode = null;
    private Command command = null;
    private boolean optimizerEnabled = true;
    private boolean optimizerOn = false;
    private boolean isOptimized = false;
    private PropertyChangeSupport propChgSupport = new PropertyChangeSupport(this);
    private String sqlText = null;

    public QueryDisplayComponent(QueryValidator queryValidator, int type) {
        this.queryValidator = queryValidator;
        this.queryType = type;
    }

    public void addPropertyListener(PropertyChangeListener listener) {
        this.propChgSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyListener(PropertyChangeListener listener) {
        this.propChgSupport.removePropertyChangeListener(listener);
    }

    public void setQueryValidator(QueryValidator validator) {
        this.queryValidator = validator;
        this.validationResult = null;
    }

    private void setText(String sqlString) {
        this.setText(sqlString, true, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setText(String sqlString, boolean doResolveAndValidate, QueryValidationResult theResult) {
        this.setText(sqlString, doResolveAndValidate, theResult, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setText(String sqlString, boolean doResolveAndValidate, QueryValidationResult theResult, IProgressMonitor monitor) {
        this.isOptimized = false;
        boolean setSqlText = false;
        if (this.isEmptySql(this.sqlText) || !this.sqlText.equalsIgnoreCase(sqlString)) {
            setSqlText = true;
        }
        if (setSqlText) {
            this.sqlText = sqlString;
            this.validateSql(sqlString, doResolveAndValidate, theResult, monitor);
            if (this.isResolvable) {
                if (this.isOptimizerEnabled()) {
                    if (this.isOptimizerOn()) {
                        this.optimize();
                    } else {
                        this.deoptimize();
                    }
                } else {
                    String startingSQL = this.command.toString();
                    ElementSymbolOptimizer.fullyQualifyElements((Command)this.command);
                    if (startingSQL != null && !startingSQL.equalsIgnoreCase(this.command.toString())) {
                        this.validateSql(this.command.toString(), doResolveAndValidate, theResult, monitor);
                    }
                }
            }
        }
    }

    public void reset() {
        this.sqlDisplayNode = null;
        this.sqlText = null;
    }

    private void validateSql(String inputSqlString, boolean doResolveAndValidate, QueryValidationResult theResult) {
        this.validateSql(inputSqlString, doResolveAndValidate, theResult, (IProgressMonitor)new NullProgressMonitor());
    }

    private void validateSql(String inputSqlString, boolean doResolveAndValidate, QueryValidationResult theResult, IProgressMonitor monitor) {
        IStatus status;
        Iterator iter;
        String sqlString = inputSqlString;
        if (sqlString == null || this.isEmptySql(sqlString)) {
            sqlString = "";
        }
        if (this.queryValidator == null || !this.queryValidator.isValidRoot()) {
            this.sqlDisplayNode = DisplayNodeFactory.createUnknownQueryDisplayNode(null, (String)"");
            return;
        }
        monitor.subTask(MONITOR_CHECKING_DISPLAY_NODES);
        monitor.worked(5);
        if (!sqlString.trim().toUpperCase().startsWith("CREATE") && this.sqlDisplayNode != null) {
            StringBuffer text = new StringBuffer();
            boolean replaced = false;
            iter = this.sqlDisplayNode.getDisplayNodeList().iterator();
            while (iter.hasNext()) {
                DisplayNode node = (DisplayNode)iter.next();
                if (node.isVisible()) {
                    if (replaced) continue;
                    text.append(sqlString);
                    replaced = true;
                    continue;
                }
                if (!replaced && node.getParent() instanceof BlockDisplayNode && "END".equals(node.toString())) {
                    text.append(sqlString);
                }
                text.append(node.toString());
            }
            sqlString = text.toString();
        }
        Collection statusList = Collections.EMPTY_LIST;
        monitor.subTask(MONITOR_VALIDATING_SQL);
        monitor.worked(5);
        if (!doResolveAndValidate && theResult != null) {
            this.validationResult = theResult;
        } else {
            try {
                this.validationResult = this.queryValidator.validateSql(sqlString, this.queryType, false, false);
            }
            catch (Exception ex) {
                this.command = null;
                this.sqlDisplayNode = DisplayNodeFactory.createUnknownQueryDisplayNode(null, (String)sqlString);
                StringBuffer buff = new StringBuffer("Error encountered while validating the transformation.");
                buff.append("\nPlease check the Message log for exceptions");
                this.statusMessage = buff.toString();
                return;
            }
        }
        monitor.subTask(MONITOR_PREPARING_RESULTS);
        monitor.worked(20);
        this.isParsable = this.validationResult.isParsable();
        this.isResolvable = this.validationResult.isResolvable();
        this.isValidatable = this.validationResult.isValidatable();
        statusList = this.validationResult.getStatusList();
        this.command = this.validationResult.getCommand();
        if (!this.isParsable) {
            this.command = null;
            this.sqlDisplayNode = DisplayNodeFactory.createUnknownQueryDisplayNode(null, (String)sqlString);
            if (this.isEmptySql(sqlString)) {
                this.statusMessage = EMPTY_SQL_MSG;
            } else if (this.isDefaultSql(sqlString)) {
                this.statusMessage = DEFAULT_SQL_MSG;
            } else {
                StringBuffer buff = new StringBuffer(QUERY_NOT_PARSABLE_MSG);
                if (statusList != null && !statusList.isEmpty()) {
                    iter = statusList.iterator();
                    while (iter.hasNext()) {
                        status = (IStatus)iter.next();
                        buff.append("\n" + status.getMessage());
                    }
                }
                this.statusMessage = buff.toString();
            }
        } else {
            this.sqlDisplayNode = DisplayNodeFactory.createDisplayNode(null, (Object)this.command);
            if (!this.isResolvable) {
                StringBuffer buff = new StringBuffer(QUERY_PARSABLE_NOT_RESOLVABLE_MSG);
                if (statusList != null && !statusList.isEmpty()) {
                    iter = statusList.iterator();
                    while (iter.hasNext()) {
                        status = (IStatus)iter.next();
                        buff.append("\n" + RESOLVER_ERROR_MSG + ":" + " " + status.getMessage());
                    }
                }
                this.statusMessage = buff.toString();
            } else if (!this.isValidatable) {
                StringBuffer buff = new StringBuffer(QUERY_NOT_VALID_MSG);
                if (statusList != null && !statusList.isEmpty()) {
                    iter = statusList.iterator();
                    while (iter.hasNext()) {
                        status = (IStatus)iter.next();
                        buff.append("\n" + status.getMessage());
                    }
                }
                this.statusMessage = buff.toString();
            }
        }
        this.sqlDisplayNode.setStartIndex(0);
        this.propChgSupport.firePropertyChange(null, null, null);
    }

    public void setOptimizerEnabled(boolean status) {
        this.optimizerEnabled = status;
    }

    public void setOptimizerOn(boolean status) {
        this.optimizerOn = status;
        if (this.optimizerEnabled) {
            if (this.optimizerOn) {
                this.optimize();
            } else {
                this.deoptimize();
            }
        }
    }

    public boolean isOptimized() {
        return this.isOptimized;
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    public boolean isOptimizerOn() {
        return this.optimizerOn;
    }

    public boolean canOptimize() {
        boolean result = true;
        if (!this.isResolvable()) {
            result = false;
        } else if (this.command != null && this.command instanceof CreateUpdateProcedureCommand) {
            result = false;
        }
        return result;
    }

    public DisplayNode getDisplayNode() {
        return this.sqlDisplayNode;
    }

    public List getDisplayNodeList() {
        if (this.sqlDisplayNode != null) {
            return this.sqlDisplayNode.getDisplayNodeList();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isParsable() {
        return this.isParsable;
    }

    public boolean isResolvable() {
        return this.isResolvable;
    }

    public boolean isValidatable() {
        return this.isValidatable;
    }

    public boolean isDefaultQuery() {
        String str = this.toString();
        return this.isDefaultSql(str);
    }

    private boolean isDefaultSql(String sqlString) {
        StringBuffer sb = new StringBuffer(sqlString);
        StringUtil.replaceAll((StringBuffer)sb, (String)"\n", (String)"");
        StringUtil.replaceAll((StringBuffer)sb, (String)"\t", (String)" ");
        StringUtil.replaceAll((StringBuffer)sb, (String)"  ", (String)" ");
        String newString = sb.toString();
        return newString != null && DEFAULT_QUERY != null && newString.trim().equalsIgnoreCase(DEFAULT_QUERY.trim());
    }

    public boolean isEmptyQuery() {
        String str = this.toString();
        return this.isEmptySql(str);
    }

    private boolean isEmptySql(String sqlString) {
        boolean result = false;
        if (sqlString == null) {
            result = true;
        } else {
            StringBuffer sb = new StringBuffer(sqlString);
            StringUtil.replaceAll((StringBuffer)sb, (String)"\n", (String)"");
            StringUtil.replaceAll((StringBuffer)sb, (String)"\t", (String)"");
            StringUtil.replaceAll((StringBuffer)sb, (String)"  ", (String)" ");
            String newString = sb.toString();
            if (newString != null && newString.trim().length() == 0) {
                result = true;
            }
        }
        return result;
    }

    public int getProjectedSymbolCount() {
        List symbols;
        if (this.command != null && (symbols = this.command.getProjectedSymbols()) != null) {
            return symbols.size();
        }
        return 0;
    }

    public boolean isSelectStar() {
        Select select;
        boolean isSelectStar = false;
        if (this.isParsable && this.command != null && this.command instanceof Query && (select = ((Query)this.command).getSelect()) != null) {
            isSelectStar = select.isStar();
        }
        return isSelectStar;
    }

    public void expandSelect() {
        Command command = this.getCommand();
        if (this.isSelectStar() && command instanceof Query) {
            Query query = (Query)command;
            boolean expandSelect = false;
            List syms = query.getSelect().getSymbols();
            for (int i = 0; i < syms.size(); ++i) {
                if (!(syms.get(i) instanceof MultipleElementSymbol)) continue;
                expandSelect = true;
                break;
            }
            if (expandSelect) {
                List symbols = query.getProjectedSymbols();
                StringBuffer selectStr = new StringBuffer("SELECT ");
                for (int i = 0; i < symbols.size(); ++i) {
                    if (i != 0) {
                        selectStr.append(", ");
                    }
                    String symbolName = ((SelectSymbol)symbols.get(i)).toString();
                    selectStr.append(symbolName);
                }
                if (symbols.size() > 0) {
                    selectStr.append(" \n");
                }
                this.replaceSelect(selectStr.toString());
            }
        }
    }

    public boolean canExpandSelect(int index) {
        boolean canExpand = false;
        DisplayNode commandNode = this.getCommandDisplayNodeAtIndex(index);
        if (this.isParsable && commandNode != null) {
            QueryDisplayNode qdn;
            if (commandNode instanceof QueryDisplayNode) {
                canExpand = this.canExpand((Query)commandNode.getLanguageObject());
            } else if (commandNode instanceof SetQueryDisplayNode && (qdn = ((SetQueryDisplayNode)commandNode).getQueryAtIndex(index)) != null) {
                canExpand = this.canExpand((Query)qdn.getLanguageObject());
            }
        }
        return canExpand;
    }

    public void expandSelect(int index) {
        if (!this.canExpandSelect(index)) {
            return;
        }
        DisplayNode commandDisplayNode = this.getCommandDisplayNodeAtIndex(index);
        if (commandDisplayNode != null && commandDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)commandDisplayNode;
            SelectDisplayNode selectDisplayNode = (SelectDisplayNode)queryDisplayNode.getClauseDisplayNode(6);
            Query query = (Query)queryDisplayNode.getLanguageObject();
            List symbols = query.getProjectedSymbols();
            StringBuffer selectStr = new StringBuffer("SELECT ");
            for (int i = 0; i < symbols.size(); ++i) {
                if (i != 0) {
                    selectStr.append(", ");
                }
                String symbolName = ((SelectSymbol)symbols.get(i)).toString();
                selectStr.append(symbolName);
            }
            if (symbols.size() > 0) {
                selectStr.append(" \n");
            }
            int startIndex = selectDisplayNode.getStartIndex();
            int endIndex = selectDisplayNode.getEndIndex();
            this.replace(startIndex, endIndex + 1, selectStr.toString());
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public int getErrorStart() {
        return this.errorStart;
    }

    public int getErrorEnd() {
        return this.errorEnd;
    }

    public DisplayNode getQueryClauseAtIndex(int index) {
        DisplayNode node = this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode ? ((QueryDisplayNode)this.sqlDisplayNode).getClauseAtIndex(index) : (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof SetQueryDisplayNode ? ((SetQueryDisplayNode)this.sqlDisplayNode).getClauseAtIndex(index) : null);
        if (node == null) {
            UiPlugin.getDefault().getPluginUtil().log(4, null, "DisplayNode: " + this.sqlDisplayNode.getClass() + "generated null result at index " + index);
        }
        return node;
    }

    public DisplayNode getCommandDisplayNodeAtIndex(int index) {
        DisplayNode commandDisplayNode = null;
        List nodes = this.getDisplayNodesAtIndex(index);
        if (nodes.size() == 2) {
            DisplayNode node1 = (DisplayNode)nodes.get(0);
            DisplayNode node2 = (DisplayNode)nodes.get(1);
            if (DisplayNodeUtils.isWithinSubQueryNode((DisplayNode)node2)) {
                commandDisplayNode = DisplayNodeUtils.getSubQueryCommandDisplayNode((DisplayNode)node2);
            } else if (DisplayNodeUtils.isWithinSubQueryNode((DisplayNode)node1)) {
                commandDisplayNode = DisplayNodeUtils.getSubQueryCommandDisplayNode((DisplayNode)node1);
            } else {
                commandDisplayNode = DisplayNodeUtils.getCommandForNode((DisplayNode)node2);
                if (commandDisplayNode == null) {
                    commandDisplayNode = DisplayNodeUtils.getCommandForNode((DisplayNode)node1);
                }
            }
        } else if (nodes.size() == 1) {
            commandDisplayNode = DisplayNodeUtils.getCommandForNode((DisplayNode)((DisplayNode)nodes.get(0)));
        }
        return commandDisplayNode;
    }

    public int getQueryIndex(int index) {
        QueryDisplayNode queryDisplayNode = null;
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            if (queryDisplayNode.isAnywhereWithin(index)) {
                return 0;
            }
        } else if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof SetQueryDisplayNode) {
            SetQueryDisplayNode setQueryDisplayNode = (SetQueryDisplayNode)this.sqlDisplayNode;
            return setQueryDisplayNode.getQueryIndex(index);
        }
        return -1;
    }

    public QueryDisplayNode getQueryDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = null;
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode && queryIndex == 0) {
            queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
        } else if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof SetQueryDisplayNode) {
            SetQueryDisplayNode setQueryDisplayNode = (SetQueryDisplayNode)this.sqlDisplayNode;
            queryDisplayNode = setQueryDisplayNode.getQueryDisplayNode(queryIndex);
        }
        return queryDisplayNode;
    }

    public List getDisplayNodesAtIndex(int index) {
        List allNodes = this.getDisplayNodeList();
        return DisplayNodeUtils.getDisplayNodesAtIndex((List)allNodes, (int)index);
    }

    public SelectDisplayNode getSelectDisplayNode() {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            return (SelectDisplayNode)queryDisplayNode.getClauseDisplayNode(6);
        }
        return null;
    }

    public SelectDisplayNode getSelectDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = this.getQueryDisplayNode(queryIndex);
        if (queryDisplayNode != null) {
            return (SelectDisplayNode)queryDisplayNode.getClauseDisplayNode(6);
        }
        return null;
    }

    public FromDisplayNode getFromDisplayNode() {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            return (FromDisplayNode)queryDisplayNode.getClauseDisplayNode(8);
        }
        return null;
    }

    public FromDisplayNode getFromDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = this.getQueryDisplayNode(queryIndex);
        if (queryDisplayNode != null) {
            return (FromDisplayNode)queryDisplayNode.getClauseDisplayNode(8);
        }
        return null;
    }

    public WhereDisplayNode getWhereDisplayNode() {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            return (WhereDisplayNode)queryDisplayNode.getClauseDisplayNode(9);
        }
        return null;
    }

    public WhereDisplayNode getWhereDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = this.getQueryDisplayNode(queryIndex);
        if (queryDisplayNode != null) {
            return (WhereDisplayNode)queryDisplayNode.getClauseDisplayNode(9);
        }
        return null;
    }

    public List getSelectSymbolDisplayNodes() {
        SelectDisplayNode selectNode = this.getSelectDisplayNode();
        if (selectNode != null) {
            return selectNode.getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    public List getSelectSymbolDisplayNodes(int queryIndex) {
        SelectDisplayNode selectNode = this.getSelectDisplayNode(queryIndex);
        if (selectNode != null) {
            return selectNode.getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isIndexWithin(int index, int type) {
        boolean result = false;
        if (this.isParsable()) {
            result = DisplayNodeUtils.isIndexWithin((List)this.getDisplayNodeList(), (int)index, (int)type);
        }
        return result;
    }

    public boolean isInsertAllowed(int index, int type) {
        boolean result = false;
        if (this.isParsable()) {
            result = DisplayNodeUtils.isInsertAllowed((List)this.getDisplayNodeList(), (int)index, (int)type);
        }
        return result;
    }

    public boolean isSupportedAtIndex(int itemType, int index) {
        if (this.isDefaultQuery()) {
            String currentQuery = this.toString().toUpperCase();
            int endIndexOfSelect = currentQuery.indexOf("SELECT") + "SELECT".length();
            int startIndexOfFrom = currentQuery.indexOf("FROM");
            int endIndexOfFrom = currentQuery.indexOf("FROM") + "FROM".length();
            if (itemType == 0 && index >= endIndexOfSelect && index <= startIndexOfFrom) {
                return true;
            }
            return itemType == 1 && index >= endIndexOfFrom;
        }
        if (!this.isParsable()) {
            return false;
        }
        DisplayNode node = this.getQueryClauseAtIndex(index);
        if (node != null) {
            switch (itemType) {
                case 0: {
                    return node.supportsElement();
                }
                case 1: {
                    return node.supportsGroup();
                }
                case 3: {
                    return node.supportsExpression();
                }
                case 2: {
                    return node.supportsCriteria();
                }
            }
        }
        return false;
    }

    public void insertGroup(String groupName, int index) {
        if (this.isDefaultQuery()) {
            this.setText(DEFAULT_QUERY + groupName);
            return;
        }
        if (!this.isSupportedAtIndex(1, index)) {
            return;
        }
        DisplayNode clauseNode = this.getQueryClauseAtIndex(index);
        if (clauseNode instanceof FromDisplayNode) {
            if (!this.containsGroup((FromDisplayNode)clauseNode, groupName)) {
                int nodeIndex = this.getDisplayNodeInsertIndex(index);
                boolean canOptimize = this.canOptimize();
                if (canOptimize) {
                    this.deoptimize();
                }
                this.insertSymbolNameAtNodeIndex(groupName, nodeIndex);
                if (canOptimize) {
                    this.optimize();
                }
            }
        } else {
            int nodeIndex = this.getDisplayNodeInsertIndex(index);
            boolean canOptimize = this.canOptimize();
            if (canOptimize) {
                this.deoptimize();
            }
            this.insertSymbolNameAtNodeIndex(groupName, nodeIndex);
            if (canOptimize) {
                this.optimize();
            }
        }
    }

    public void insertGroups(List groupNames, int index) {
        if (this.isDefaultQuery()) {
            StringBuffer sb = new StringBuffer();
            int nNames = groupNames.size();
            for (int i = 0; i < nNames; ++i) {
                if (i == 0) {
                    sb.append((String)groupNames.get(i));
                    continue;
                }
                sb.append(", " + (String)groupNames.get(i));
            }
            this.setText(DEFAULT_QUERY + sb.toString());
            return;
        }
        int nGroups = groupNames.size();
        if (nGroups == 0) {
            return;
        }
        for (int i = nGroups - 1; i >= 0; --i) {
            this.insertGroup((String)groupNames.get(i), index);
        }
    }

    public void insertElement(String elementName, String parentName, int index) {
        boolean canOptimize;
        if (this.isDefaultQuery()) {
            this.setText("SELECT " + elementName + " " + "FROM" + " " + parentName);
            return;
        }
        if (!this.isSupportedAtIndex(0, index)) {
            return;
        }
        boolean insertAtEndOfSelect = false;
        if (this.isSelectStar()) {
            int starIndex = 0;
            Iterator iter = this.getSelectSymbolDisplayNodes().iterator();
            while (iter.hasNext()) {
                LanguageObject langObj;
                DisplayNode node = (DisplayNode)iter.next();
                if (!(node instanceof SymbolDisplayNode) || !((langObj = node.getLanguageObject()) instanceof MultipleElementSymbol)) continue;
                starIndex = node.getStartIndex();
                break;
            }
            if (index > starIndex) {
                insertAtEndOfSelect = true;
            }
            this.expandSelect();
        }
        int nodeIndex = this.getDisplayNodeInsertIndex(index);
        this.insertGroupAtEndOfFrom(parentName);
        if (insertAtEndOfSelect) {
            index = this.getSelectDisplayNode().getEndIndex();
            nodeIndex = this.getDisplayNodeInsertIndex(index);
        }
        if ((canOptimize = this.canOptimize()) && this.isOptimized()) {
            this.deoptimize();
        }
        this.insertSymbolNameAtNodeIndex(elementName, nodeIndex);
        if (canOptimize && this.isOptimizerOn()) {
            this.optimize();
        }
    }

    public void insertElements(List elementNames, List parentNames, int index) {
        if (this.isDefaultQuery()) {
            StringBuffer elementSB = new StringBuffer();
            int nNames = elementNames.size();
            for (int i = 0; i < nNames; ++i) {
                if (i == 0) {
                    elementSB.append((String)elementNames.get(i));
                    continue;
                }
                elementSB.append(", " + (String)elementNames.get(i));
            }
            ArrayList<String> uniqueGroups = new ArrayList<String>();
            Iterator iter = parentNames.iterator();
            while (iter.hasNext()) {
                String grp = (String)iter.next();
                if (uniqueGroups.contains(grp)) continue;
                uniqueGroups.add(grp);
            }
            StringBuffer groupSB = new StringBuffer();
            int nGrps = uniqueGroups.size();
            for (int i = 0; i < nGrps; ++i) {
                if (i == 0) {
                    groupSB.append((String)uniqueGroups.get(i));
                    continue;
                }
                groupSB.append(", " + (String)uniqueGroups.get(i));
            }
            this.setText("SELECT " + elementSB.toString() + " FROM " + groupSB.toString());
            return;
        }
        int nElems = elementNames.size();
        int nParents = parentNames.size();
        if (nParents != nElems || nElems == 0) {
            return;
        }
        for (int i = nElems - 1; i >= 0; --i) {
            this.insertElement((String)elementNames.get(i), (String)parentNames.get(i), index);
        }
    }

    public String toDisplayString() {
        if (this.sqlDisplayNode != null) {
            return this.sqlDisplayNode.toDisplayString();
        }
        return "";
    }

    public String toString() {
        if (this.sqlDisplayNode != null) {
            return this.sqlDisplayNode.toString();
        }
        return "";
    }

    public void optimize() {
        if (this.canOptimize()) {
            if (!this.isOptimized) {
                String unoptimizedSql = this.command.toString();
                QueryMetadataInterface resolver = this.getQueryResolver();
                try {
                    ElementSymbolOptimizer.optimizeElements((Command)this.command, (QueryMetadataInterface)resolver);
                }
                catch (QueryMetadataException e) {
                    e.printStackTrace();
                }
                catch (MetaMatrixComponentException e) {
                    e.printStackTrace();
                }
                this.isOptimized = true;
                if (unoptimizedSql != null && !unoptimizedSql.equalsIgnoreCase(this.command.toString())) {
                    this.validateSql(this.command.toString(), true, null);
                }
            }
        } else {
            this.isOptimized = false;
        }
    }

    public void deoptimize() {
        if (this.canOptimize()) {
            if (this.isOptimized) {
                String optimizedSql = this.command.toString();
                ElementSymbolOptimizer.fullyQualifyElements((Command)this.command);
                this.isOptimized = false;
                if (optimizedSql != null && !optimizedSql.equalsIgnoreCase(this.command.toString())) {
                    this.validateSql(this.command.toString(), true, null);
                }
            }
        } else {
            this.isOptimized = false;
        }
    }

    private QueryMetadataInterface getQueryResolver() {
        QueryMetadataInterface resolver = null;
        if (this.queryValidator != null) {
            resolver = this.queryValidator.getQueryMetadata();
        }
        return resolver;
    }

    private int getDisplayNodeInsertIndex(int cursorIndex) {
        List allNodes = this.getDisplayNodeList();
        for (int i = 0; i < allNodes.size(); ++i) {
            DisplayNode node = (DisplayNode)allNodes.get(i);
            if (!node.isAnywhereWithin(cursorIndex)) continue;
            return i + 1;
        }
        return -1;
    }

    private boolean canExpand(Query query) {
        boolean canExpand = false;
        if (query != null) {
            List symbols;
            Select select = query.getSelect();
            boolean hasMultiSymbol = false;
            if (select != null) {
                List syms = select.getSymbols();
                for (int i = 0; i < syms.size(); ++i) {
                    if (!(syms.get(i) instanceof MultipleElementSymbol)) continue;
                    hasMultiSymbol = true;
                    break;
                }
            }
            if (hasMultiSymbol && (symbols = query.getProjectedSymbols()).size() > 0) {
                canExpand = true;
            }
        }
        return canExpand;
    }

    private void replace(int startIndex, int endIndex, String str) {
        StringBuffer sb = new StringBuffer(this.toString());
        sb.replace(startIndex, endIndex, str);
        this.setText(sb.toString());
    }

    private void replaceSelect(String selectStr) {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            StringBuffer sb = new StringBuffer("");
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            Iterator iter = queryDisplayNode.getChildren().iterator();
            while (iter.hasNext()) {
                DisplayNode clauseNode = (DisplayNode)iter.next();
                if (clauseNode instanceof SelectDisplayNode) {
                    sb.append(selectStr);
                    continue;
                }
                sb.append(clauseNode.toString());
            }
            this.setText(sb.toString());
        }
    }

    private void insertGroupAtEndOfFrom(String groupName) {
        FromDisplayNode fromNode = this.getFromDisplayNode();
        if (fromNode != null) {
            int fromEndIndex = fromNode.getEndIndex();
            this.insertGroup(groupName, fromEndIndex - 1);
        }
    }

    private boolean containsGroup(FromDisplayNode fromClause, String groupName) {
        if (fromClause != null) {
            From from = (From)fromClause.getLanguageObject();
            List groups = from.getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                GroupSymbol symbol = (GroupSymbol)iter.next();
                if (!symbol.getName().equals(groupName)) continue;
                return true;
            }
        }
        return false;
    }

    private void insertSymbolName(String symbolName, int index) {
        DisplayNode clauseNode = this.getQueryClauseAtIndex(index);
        List displayNodes = this.getDisplayNodesAtIndex(index);
        int nNodes = displayNodes.size();
        DisplayNode displayNode = null;
        if (nNodes == 2) {
            displayNode = (DisplayNode)displayNodes.get(0);
            if (displayNode instanceof SymbolDisplayNode || displayNode instanceof UnaryFromClauseDisplayNode) {
                displayNode = (DisplayNode)displayNodes.get(1);
            }
        } else if (nNodes == 1) {
            displayNode = (DisplayNode)displayNodes.get(0);
        } else {
            return;
        }
        if (clauseNode != null && !DisplayNodeUtils.hasSymbol((DisplayNode)clauseNode) && !DisplayNodeUtils.hasExpression((DisplayNode)clauseNode)) {
            this.insertString("," + symbolName + " ", displayNode.getEndIndex() + 1);
        } else if (displayNode.isInExpression()) {
            ExpressionDisplayNode expressionNode = DisplayNodeUtils.getExpressionForNode((DisplayNode)displayNode);
            int startIndex = expressionNode.getStartIndex();
            if (index == startIndex) {
                this.insertString(" " + symbolName + ",", expressionNode.getStartIndex());
            } else {
                this.insertString("," + symbolName + " ", expressionNode.getEndIndex() + 1);
            }
        } else if (displayNode instanceof SymbolDisplayNode || displayNode instanceof UnaryFromClauseDisplayNode) {
            int startIndex = displayNode.getStartIndex();
            if (index == startIndex) {
                this.insertString(" " + symbolName + ",", displayNode.getStartIndex());
            } else {
                this.insertString("," + symbolName + " ", displayNode.getEndIndex() + 1);
            }
        } else if (clauseNode != null) {
            int startOfNextSymbol = DisplayNodeUtils.getStartIndexOfNextSymbol((DisplayNode)clauseNode, (int)index);
            int endOfPrevSymbol = DisplayNodeUtils.getEndIndexOfPreviousSymbol((DisplayNode)clauseNode, (int)index);
            int startOfNextExpr = DisplayNodeUtils.getStartIndexOfNextExpression((DisplayNode)clauseNode, (int)index);
            int endOfPrevExpr = DisplayNodeUtils.getEndIndexOfPreviousExpression((DisplayNode)clauseNode, (int)index);
            int startOfNext = this.getSmallestNonNegative(startOfNextSymbol, startOfNextExpr);
            int endOfPrev = this.getLargestNonNegative(endOfPrevSymbol, endOfPrevExpr);
            if (startOfNext != -1 && endOfPrev != -1) {
                this.insertString(" " + symbolName + ",", startOfNext);
            } else if (startOfNext != -1) {
                this.insertString(" " + symbolName + ",", startOfNext);
            } else if (endOfPrev != -1) {
                this.insertString("," + symbolName + " ", endOfPrev);
            }
        }
    }

    private int getSmallestNonNegative(int intOne, int intTwo) {
        if (intOne < 0 && intTwo < 0) {
            return -1;
        }
        int minimum = Math.min(intOne, intTwo);
        if (minimum < 0) {
            return Math.max(intOne, intTwo);
        }
        return minimum;
    }

    private int getLargestNonNegative(int intOne, int intTwo) {
        if (intOne < 0 && intTwo < 0) {
            return -1;
        }
        return Math.max(intOne, intTwo);
    }

    private void insertSymbolNameAtNodeIndex(String symbolName, int nodeIndex) {
        List allNodes = this.getDisplayNodeList();
        if (nodeIndex < 0 || nodeIndex > allNodes.size()) {
            return;
        }
        int index = 0;
        if (nodeIndex == allNodes.size()) {
            DisplayNode node = (DisplayNode)allNodes.get(nodeIndex - 1);
            index = node.getEndIndex() - 1;
        } else {
            DisplayNode node = (DisplayNode)allNodes.get(nodeIndex);
            index = node.getStartIndex();
        }
        this.insertSymbolName(symbolName, index);
    }

    private void insertString(String str, int index) {
        StringBuffer currentSQL = new StringBuffer(this.toString());
        currentSQL.insert(index, str);
        this.setText(currentSQL.toString());
    }

    public int getCorrectedIndex(int visibleCursorIndex) {
        int theIndex = visibleCursorIndex;
        if (this.sqlDisplayNode != null) {
            Iterator iter = this.sqlDisplayNode.getDisplayNodeList().iterator();
            while (iter.hasNext()) {
                DisplayNode node = (DisplayNode)iter.next();
                if (!node.isVisible()) continue;
                theIndex = visibleCursorIndex + node.getStartIndex();
                break;
            }
        }
        return theIndex;
    }

    public DisplayNode getFirstVisibleNode() {
        Iterator iter = this.sqlDisplayNode.getDisplayNodeList().iterator();
        while (iter.hasNext()) {
            DisplayNode node = (DisplayNode)iter.next();
            if (!node.isVisible()) continue;
            return node;
        }
        return null;
    }
}

