/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.modelgenerator.xml.IUiConstants;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import com.metamatrix.modeler.modelgenerator.xml.wizards.RootElementAccumulatorSource;
import com.metamatrix.modeler.modelgenerator.xml.wizards.StateManager;
import com.metamatrix.modeler.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import com.metamatrix.modeler.schema.tools.model.schema.RootElement;
import com.metamatrix.ui.internal.widget.accumulator.AccumulatorPanel;
import com.metamatrix.ui.internal.widget.accumulator.IAccumulatedValuesChangeListener;
import com.metamatrix.ui.internal.widget.accumulator.IAccumulatorSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

class RootElementsPanel
extends Composite
implements IUiConstants,
IUiConstants.HelpContexts,
IUiConstants.Images,
IAccumulatedValuesChangeListener {
    private static PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();
    private static final String MAPPING_OPTIONS = util.getString("RootElementsPage.mappingOptions");
    private static final String USE_STRING = util.getString("RootElementsPage.useString");
    private static final String USE_SCHEMA_TYPE = util.getString("RootElementsPage.useSchemaType");
    private static final int ACCUMULATOR_RESET_BUTTON_VERTICAL_MARGIN = 4;
    public static final int DOCUMENTS = 1;
    private TableViewer documentsListViewer;
    private AccumulatorPanel documentsAccumulatorPanel = null;
    private ILabelProvider accumulatorsLabelProvider;
    private Button useSchemaTypeButton;
    private Button useStringTypeButton;
    private XsdAsRelationalImportWizard wizard;
    private StateManager manager;
    private boolean selectionsChanged = false;

    public RootElementsPanel(Composite parent, XsdAsRelationalImportWizard wizard) {
        super(parent, 0);
        this.wizard = wizard;
        this.manager = wizard.getStateManager();
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.accumulatorsLabelProvider = ModelUtilities.getEMFLabelProvider();
        Group documentsAccumulatorComposite = new Group((Composite)this, 0);
        String documentsGroupName = util.getString("RootElementsPage.virtualXMLDocumentsLabel");
        documentsAccumulatorComposite.setText(documentsGroupName);
        GridLayout documentsAccumulatorCompositeLayout = new GridLayout();
        documentsAccumulatorComposite.setLayout((Layout)documentsAccumulatorCompositeLayout);
        documentsAccumulatorCompositeLayout.marginWidth = 0;
        documentsAccumulatorCompositeLayout.marginHeight = 2;
        RootElementAccumulatorSource documentsAccumulatorSource = new RootElementAccumulatorSource(this);
        String documentsAvailableHdr = util.getString("RootElementsPage.documentsAccumulatorLeftLabel");
        String documentsSelectedHdr = util.getString("RootElementsPage.documentsAccumulatorRightLabel");
        this.documentsAccumulatorPanel = new AccumulatorPanel((Composite)documentsAccumulatorComposite, (IAccumulatorSource)documentsAccumulatorSource, new ArrayList(), this.accumulatorsLabelProvider, documentsAvailableHdr, documentsSelectedHdr, 4, -1, -1, -1);
        this.documentsAccumulatorPanel.addAccumulatedValuesChangeListener((IAccumulatedValuesChangeListener)this);
        Group typeGroup = new Group((Composite)this, 0);
        typeGroup.setLayout((Layout)new GridLayout(1, true));
        typeGroup.setLayoutData((Object)new GridData(768));
        typeGroup.setText(MAPPING_OPTIONS);
        this.useStringTypeButton = new Button((Composite)typeGroup, 16);
        this.useStringTypeButton.setSelection(true);
        this.useStringTypeButton.setText(USE_STRING);
        this.useSchemaTypeButton = new Button((Composite)typeGroup, 16);
        this.useSchemaTypeButton.setSelection(false);
        this.useSchemaTypeButton.setText(USE_SCHEMA_TYPE);
        this.useSchemaTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RootElementsPanel.this.wizard.setUseSchemaTypes(RootElementsPanel.this.useSchemaTypeButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.useStringTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RootElementsPanel.this.wizard.setUseSchemaTypes(RootElementsPanel.this.useSchemaTypeButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ArrayList availableRoots;
            try {
                availableRoots = this.manager.getPotentialRoots();
            }
            catch (Exception e) {
                Status status = new Status(4, ((Object)((Object)this.wizard)).getClass().getName(), 4, e.getMessage(), (Throwable)e);
                Shell shell = this.getShell();
                ErrorDialog.openError((Shell)shell, (String)util.getString("RootElementsPage.exception"), (String)e.getMessage(), (IStatus)status);
                return;
            }
            ArrayList<RootElement> selectedRoots = new ArrayList<RootElement>();
            if (availableRoots == null) {
                availableRoots = new ArrayList();
            }
            this.emptyList(this.documentsListViewer);
            Iterator iter = availableRoots.iterator();
            while (iter.hasNext()) {
                RootElement root = (RootElement)iter.next();
                if (root.isUseAsRoot()) {
                    selectedRoots.add(root);
                    continue;
                }
                this.documentsListViewer.add((Object)root);
            }
            this.documentsAccumulatorPanel.repopulateSelectedItems(selectedRoots);
            this.documentsAccumulatorPanel.availableItemsHaveChanged();
        }
    }

    public void accumulatedValuesChanged(AccumulatorPanel source) {
    }

    private void emptyList(TableViewer listViewer) {
        Table list = listViewer.getTable();
        if (list != null) {
            int count = list.getItemCount();
            for (int i = count - 1; i >= 0; --i) {
                Object item = listViewer.getElementAt(i);
                listViewer.remove(item);
            }
        }
    }

    public void documentsAccumulatedValuesRemoved(Collection values) {
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            this.documentsListViewer.add(value);
        }
    }

    public void documentsAccumulatedValuesAdded(Collection values) {
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            this.documentsListViewer.remove(value);
        }
    }

    public Collection getDocumentsAvailableValues() {
        int count = this.documentsListViewer.getTable().getItemCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object value = this.documentsListViewer.getElementAt(i);
            values.add(value);
        }
        return values;
    }

    public int getDocumentsAvailableValuesCount() {
        int count = this.documentsListViewer.getTable().getItemCount();
        return count;
    }

    public Collection getDocumentsSelectedAvailableValues() {
        int[] selectionIndices = this.documentsListViewer.getTable().getSelectionIndices();
        ArrayList<Object> selectedValues = new ArrayList<Object>(selectionIndices.length);
        for (int i = 0; i < selectionIndices.length; ++i) {
            int index = selectionIndices[i];
            selectedValues.add(this.documentsListViewer.getElementAt(index));
        }
        return selectedValues;
    }

    public int getDocumentsSelectedAvailableValuesCount() {
        if (this.documentsListViewer != null) {
            int count = this.documentsListViewer.getTable().getSelectionCount();
            return count;
        }
        return 0;
    }

    public Control documentsCreateControl(Composite parent) {
        this.documentsListViewer = new TableViewer(parent, 2);
        this.documentsListViewer.setLabelProvider((IBaseLabelProvider)this.accumulatorsLabelProvider);
        return this.documentsListViewer.getControl();
    }

    public void documentsAddSelectionListener(SelectionListener listener) {
        this.documentsListViewer.getTable().addSelectionListener(listener);
    }

    public void selectedDocumentsChanged() {
        Collection selectedRoots = this.documentsAccumulatorPanel.getSelectedItems();
        this.manager.setSelectedRoots(selectedRoots);
    }

    public boolean isSelectionsChanged() {
        return this.selectionsChanged;
    }

    public void setSelectionsChanged(boolean selectionsChanged) {
        this.selectionsChanged = selectionsChanged;
    }
}

