/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.data.Request;
import com.metamatrix.modeler.jdbc.data.Results;
import com.metamatrix.modeler.jdbc.data.ResultsMetadata;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import com.metamatrix.modeler.modelgenerator.xml.jdbc.ui.util.JdbcUiUtil;
import com.metamatrix.modeler.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.ui.UiPlugin;
import com.metamatrix.ui.internal.InternalUiConstants;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.util.WizardUtil;
import com.metamatrix.ui.internal.widget.AbstractTableLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class JdbcImportObjectsPage
extends WizardPage {
    private static PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportObjectsPage == null ? (class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportObjectsPage = JdbcImportObjectsPage.class$("com.metamatrix.modeler.modelgenerator.xml.wizards.JdbcImportObjectsPage")) : class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportObjectsPage));
    private static final String TITLE = JdbcImportObjectsPage.getString("title");
    private static final int COLUMN_COUNT = 1;
    private static final String INITIAL_MESSAGE_ID = "initialMessage";
    private static final String STATUS_LABEL_ID = "statusLabel";
    private static final String INVALID_PAGE_MESSAGE = JdbcImportObjectsPage.getString("invalidPageMessage");
    private static final String NO_OBJECTS = JdbcImportObjectsPage.getString("noObjects");
    private static final String AND = "and";
    private static final String REFRESH_TOOLTIP = JdbcImportObjectsPage.getString("refreshTooltip");
    private static final int[] SPLITTER_WEIGHTS = new int[]{30, 70};
    private static final String NA = JdbcImportObjectsPage.getString("na");
    private static final String REQUEST_ERROR_MESSAGE_ID = "requestErrorMessage";
    private JdbcDatabase db;
    private SashForm splitter;
    private ViewForm objsView;
    private TreeViewer treeViewer;
    private CTabFolder tabFolder;
    private SelectionAdapter tabListener;
    private CLabel dbLabel;
    private CLabel statusLabel;
    private JdbcNode selectedNode;
    private Map counts = new HashMap(0);
    private boolean refreshSelections = true;
    static /* synthetic */ Class class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportObjectsPage;

    private static String getString(String id) {
        return util.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, String parameter) {
        return util.getString(I18N_PREFIX + id, (Object)parameter);
    }

    public JdbcImportObjectsPage() {
        super(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportObjectsPage == null ? (class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportObjectsPage = JdbcImportObjectsPage.class$("com.metamatrix.modeler.modelgenerator.xml.wizards.JdbcImportObjectsPage")) : class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportObjectsPage)), TITLE, null);
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0){

            public Point computeSize(int widthHint, int heightHint, boolean changed) {
                Point size = super.computeSize(widthHint, heightHint, changed);
                size.x = 800;
                return size;
            }
        };
        pg.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)pg);
        this.splitter = WidgetFactory.createSplitter((Composite)pg);
        this.objsView = new ViewForm((Composite)this.splitter, 2048);
        this.dbLabel = new CLabel((Composite)this.objsView, 0);
        this.dbLabel.setImage(XmlImporterUiPlugin.getDefault().getImage("icons/full/obj16/database.gif"));
        GridData gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        this.dbLabel.setLayoutData((Object)gridData);
        this.objsView.setTopLeft((Control)this.dbLabel);
        ToolBar bar = new ToolBar((Composite)this.objsView, 0x800000);
        ToolBarManager mgr = new ToolBarManager(bar);
        Action action = new Action(){

            public void run() {
                JdbcImportObjectsPage.this.refresh();
            }
        };
        action.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/clcl16/refresh_nav.gif"));
        action.setToolTipText(REFRESH_TOOLTIP);
        mgr.add((IAction)action);
        mgr.update(true);
        this.objsView.setTopRight((Control)bar);
        this.treeViewer = new TreeViewer((Composite)this.objsView, 2848);
        Tree tree = this.treeViewer.getTree();
        this.objsView.setContent((Control)tree);
        this.treeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.treeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TreeItem treeItem = (TreeItem)e.item;
                    JdbcNode jdbcNode = (JdbcNode)treeItem.getData();
                    JdbcImportObjectsPage.this.treeViewer.getTree().setSelection(new TreeItem[]{treeItem});
                    JdbcImportObjectsPage.this.nodeSelected(jdbcNode);
                    JdbcImportObjectsPage.this.setNodeSelected(jdbcNode, treeItem, jdbcNode.getSelectionMode() != 1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object node) {
                return ((JdbcNode)node).getName();
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JdbcNode node = (JdbcNode)((IStructuredSelection)event.getSelection()).getFirstElement();
                JdbcImportObjectsPage.this.nodeSelected(node);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JdbcImportObjectsPage.this.nodeDoubleClicked(event);
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                JdbcImportObjectsPage.this.nodeExpanded(event);
            }
        });
        ViewForm tabView = new ViewForm((Composite)this.splitter, 2048);
        this.tabFolder = WidgetFactory.createTabFolder((Composite)tabView);
        tabView.setContent((Control)this.tabFolder);
        this.tabListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportObjectsPage.this.tabSelected();
            }
        };
        this.splitter.setWeights(SPLITTER_WEIGHTS);
        this.statusLabel = new CLabel(pg, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.statusLabel.setLayoutData((Object)gridData);
        Button deselectAllButton = WidgetFactory.createButton((Composite)pg, (String)InternalUiConstants.Widgets.DESELECT_ALL_BUTTON);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportObjectsPage.this.deselectAllButtonSelected();
            }
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            XsdAsRelationalImportWizard wizard = (XsdAsRelationalImportWizard)this.getWizard();
            if (null == wizard.getDatabase() || wizard.userSettings.isUpdatedRootSelections()) {
                wizard.userSettings.setUpdatedRootSelections(false);
                SchemaModel model = wizard.getStateManager().getProcessedModel();
                wizard.schemaChanged(model);
            }
            this.db = wizard.getDatabase();
            this.refresh();
        }
        super.setVisible(visible);
    }

    protected void deselectAllButtonSelected() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            JdbcNode node = (JdbcNode)item.getData();
            this.setNodeSelected(node, item, false);
        }
    }

    void nodeDoubleClicked(DoubleClickEvent event) {
        Object node;
        this.treeViewer.setExpandedState(node, !this.treeViewer.getExpandedState(node = ((IStructuredSelection)event.getSelection()).getFirstElement()));
    }

    void nodeExpanded(TreeExpansionEvent event) {
        this.updateCheckBoxes(WidgetUtil.findTreeItem((Object)event.getElement(), (TreeViewer)this.treeViewer).getItems());
    }

    void nodeSelected(JdbcNode node) {
        if (node == null || node == this.selectedNode) {
            return;
        }
        this.selectedNode = node;
        this.tabFolder.removeSelectionListener((SelectionListener)this.tabListener);
        CTabItem[] items = this.tabFolder.getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            items[ndx].dispose();
        }
        try {
            String[] names = node.getNamesOfResults();
            if (names.length == 0) {
                WidgetFactory.createTab((CTabFolder)this.tabFolder, (String)NA);
                return;
            }
            for (int ndx2 = 0; ndx2 < names.length; ++ndx2) {
                WidgetFactory.createTab((CTabFolder)this.tabFolder, (String)names[ndx2]);
            }
            this.tabFolder.addSelectionListener((SelectionListener)this.tabListener);
            if (names.length > 0) {
                this.tabFolder.setSelection(this.tabFolder.getItem(0));
                this.tabFolder.notifyListeners(13, new Event());
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
    }

    protected void refresh() {
        this.db.refresh();
        String name = this.db.getName();
        this.dbLabel.setText(name);
        this.treeViewer.setInput((Object)this.db);
        if (this.isRefreshSelections()) {
            this.selectAll();
            this.setRefreshSelections(false);
        }
        this.validatePage(this.treeViewer.getTree().getItems());
        if (this.isPageComplete()) {
            this.setMessage(JdbcImportObjectsPage.getString(INITIAL_MESSAGE_ID, name));
        }
        try {
            JdbcNode[] nodes = this.db.getChildren();
            for (int ndx = 0; ndx < nodes.length; ++ndx) {
                JdbcNode node = nodes[ndx];
                if (node.getSelectionMode() == 0) continue;
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                break;
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
    }

    void tabSelected() {
        CTabFolder tabFolder = this.tabFolder;
        CTabItem tab = tabFolder.getSelection();
        if (tab.getControl() != null) {
            return;
        }
        try {
            Request rqst = this.selectedNode.getRequest(this.selectedNode.getNamesOfResults()[tabFolder.getSelectionIndex()]);
            if (!rqst.invoke()) {
                IStatus status = rqst.getProblems();
                util.log(status);
                Image img = status.getSeverity() == 4 ? JFaceResources.getImage((String)"dialog_message_error_image") : JFaceResources.getImage((String)"dialog_messasge_warning_image");
                String msg = WidgetUtil.getCauseMessage((String)JdbcImportObjectsPage.getString(REQUEST_ERROR_MESSAGE_ID, tab.getText()), (IStatus)status);
                Composite panel = WidgetFactory.createPanel((Composite)this.tabFolder, (int)8, (int)1808, (int)1, (int)2);
                CLabel label = new CLabel(panel, 128);
                label.setImage(img);
                GridData gridData = new GridData(2);
                gridData.horizontalSpan = 1;
                label.setLayoutData((Object)gridData);
                WidgetFactory.createWrappingLabel((Composite)panel, (int)1808, (String)msg);
                tab.setControl((Control)panel);
                return;
            }
            final Results results = rqst.getResults();
            List metadatas = results.getMetadata().getColumnMetadata();
            if (metadatas.isEmpty()) {
                Object obj;
                Object[] row = results.getRows();
                if (row.length > 0 && (obj = row[0]) != null) {
                    CLabel label2 = new CLabel((Composite)this.tabFolder, 64);
                    label2.setText(obj.toString());
                    GridData gridData2 = new GridData(2);
                    gridData2.horizontalSpan = 1;
                    label2.setLayoutData((Object)gridData2);
                }
            } else {
                TableViewer viewer = new TableViewer((Composite)this.tabFolder, 2816);
                tab.setControl((Control)viewer.getTable());
                viewer.setLabelProvider((IBaseLabelProvider)new AbstractTableLabelProvider(){

                    public String getColumnText(Object row, int column) {
                        Object obj = ((List)row).get(column);
                        return obj == null ? "" : obj.toString();
                    }
                });
                viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return results.getRows();
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                Table table = viewer.getTable();
                table.setHeaderVisible(true);
                Iterator iter = metadatas.iterator();
                while (iter.hasNext()) {
                    TableColumn col = new TableColumn(table, 0);
                    ResultsMetadata.ColumnMetadata metadata = (ResultsMetadata.ColumnMetadata)iter.next();
                    col.setText(metadata.getLabel());
                    switch (metadata.getType()) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            col.setAlignment(131072);
                        }
                    }
                }
                viewer.setInput((Object)this);
                TableColumn[] cols = table.getColumns();
                for (int ndx = 0; ndx < cols.length; ++ndx) {
                    cols[ndx].pack();
                }
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
    }

    protected void setNodeSelected(JdbcNode node, TreeItem item, boolean selected) {
        node.setSelected(selected);
        this.updateCheckBox(item);
        for (TreeItem parent = item.getParentItem(); parent != null; parent = parent.getParentItem()) {
            this.updateCheckBox(parent);
        }
        this.validatePage(item.getItems());
    }

    protected void updateCheckBox(TreeItem item) {
        JdbcNode node = (JdbcNode)item.getData();
        if (node == null) {
            return;
        }
        int selection = node.getSelectionMode();
        item.setChecked(selection != 0);
        item.setGrayed(selection == 2);
    }

    private void updateCheckBoxes(TreeItem[] items) {
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            this.updateCheckBoxes(item.getItems());
            this.updateCheckBox(item);
        }
    }

    private void updateCounts(JdbcNode[] nodes) throws JdbcException {
        int ndx = nodes.length;
        while (--ndx >= 0) {
            JdbcNode node = nodes[ndx];
            int selection = node.getSelectionMode();
            if (selection == 0) continue;
            if (node.allowsChildren()) {
                this.updateCounts(node.getChildren());
                continue;
            }
            if (selection != 1) continue;
            String name = node.getTypeName();
            Integer count = (Integer)this.counts.get(name);
            if (count == null) {
                this.counts.put(name, new Integer(1));
                continue;
            }
            this.counts.put(name, new Integer(count + 1));
        }
    }

    protected void validatePage(TreeItem[] items) {
        try {
            boolean valid;
            this.counts.clear();
            this.updateCounts(this.db.getChildren());
            this.updateCheckBoxes(items);
            boolean bl = valid = this.counts.size() > 0;
            if (valid) {
                StringBuffer msg = new StringBuffer();
                Set set = this.counts.entrySet();
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (msg.length() > 0) {
                        if (set.size() > 2) {
                            msg.append(',');
                        }
                        msg.append(' ');
                        if (!iter.hasNext()) {
                            msg.append(util.keyExists(AND) ? util.getString(AND) : AND);
                            msg.append(' ');
                        }
                    }
                    msg.append(entry.getValue());
                    msg.append(' ');
                    msg.append(entry.getKey().toString().toLowerCase());
                    this.statusLabel.setText(JdbcImportObjectsPage.getString(STATUS_LABEL_ID, msg.toString()));
                    WizardUtil.setPageComplete((WizardPage)this);
                }
            } else {
                this.statusLabel.setText(JdbcImportObjectsPage.getString(STATUS_LABEL_ID, NO_OBJECTS));
                WizardUtil.setPageComplete((WizardPage)this, (String)INVALID_PAGE_MESSAGE, (int)3);
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
    }

    protected void selectAll() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            JdbcNode node = (JdbcNode)item.getData();
            this.setNodeSelected(node, item, true);
        }
    }

    public final JdbcDatabase getDatabase() {
        return this.db;
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new TreeContentProvider();
    }

    public boolean isRefreshSelections() {
        return this.refreshSelections;
    }

    public void setRefreshSelections(boolean refreshSelections) {
        this.refreshSelections = refreshSelections;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object node) {
            try {
                JdbcNode[] nodes = ((JdbcNode)node).getChildren();
                ArrayList<JdbcNode> filteredNodes = new ArrayList<JdbcNode>(nodes.length);
                for (int i = 0; i < nodes.length; ++i) {
                    JdbcNode child = nodes[i];
                    if (child.getType() == 107 && child.getName().equalsIgnoreCase("relationship")) continue;
                    filteredNodes.add(child);
                }
                return filteredNodes.toArray();
            }
            catch (JdbcException err) {
                JdbcUiUtil.showAccessError(err);
                return null;
            }
        }

        public Object[] getElements(Object inputElement) {
            try {
                ArrayList<JdbcNode> result = new ArrayList<JdbcNode>();
                JdbcNode[] catalogs = JdbcImportObjectsPage.this.db.getChildren();
                for (int i = 0; i < catalogs.length; ++i) {
                    JdbcNode catalog = catalogs[i];
                    JdbcNode[] element = catalog.getChildren();
                    if (!this.hasChildren(element[0])) continue;
                    result.add(catalog);
                }
                return result.toArray();
            }
            catch (JdbcException err) {
                JdbcUiUtil.showAccessError(err);
                return null;
            }
        }

        public Object getParent(Object node) {
            return ((JdbcNode)node).getParent();
        }

        public boolean hasChildren(Object node) {
            try {
                int relationshipCount = 0;
                List<JdbcNode> nodes = Arrays.asList(((JdbcNode)node).getChildren());
                Iterator<JdbcNode> iter = nodes.iterator();
                while (iter.hasNext()) {
                    JdbcNode child = iter.next();
                    if (child.getType() != 107 || !child.getName().equalsIgnoreCase("relationship")) continue;
                    ++relationshipCount;
                }
                return nodes.size() - relationshipCount > 0;
            }
            catch (JdbcException err) {
                JdbcUiUtil.showAccessError(err);
                return false;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

