/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.io;

import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseType;
import MITI.sdk.MIRBusinessRule;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRDatabaseCatalog;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRGeneralization;
import MITI.sdk.MIRIndex;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRType;
import MITI.sdk.MIRTypeValue;
import MITI.util.MIRIterator;
import com.metamatrix.bridges.BridgeConstants;
import com.metamatrix.bridges.BridgesPlugin;
import com.metamatrix.bridges.io.BridgeFeatureHelper;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.bridges.io.BridgeModelProcessor;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.bridges.BridgeOption;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.LogicalRelationship;
import com.metamatrix.metamodels.relational.LogicalRelationshipEnd;
import com.metamatrix.metamodels.relational.MultiplicityKind;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.metamodels.relational.View;
import com.metamatrix.metamodels.relationship.Relationship;
import com.metamatrix.metamodels.relationship.RelationshipFactory;
import com.metamatrix.metamodels.relationship.RelationshipMetamodelPlugin;
import com.metamatrix.metamodels.relationship.RelationshipType;
import com.metamatrix.metamodels.uml2.util.PrimitiveTypeManager;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.MMXmiResource;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Constraint;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.EnumerationLiteral;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.LiteralString;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Namespace;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.ValueSpecification;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class BridgeEntityFactory
implements BridgeConstants {
    private static final String NULL = "NULL";
    private static final int MAX_MAP_SIZE = 1500;
    private static final char UNDERSCORE_CHARACTER = '_';
    private static final char DASH_CHARACTER = '-';
    private static final char SPACE_CHARACTER = ' ';
    private final CoreFactory coreFactory = CoreFactory.eINSTANCE;
    private final RelationalFactory relationalFactory = RelationalFactory.eINSTANCE;
    private final RelationshipFactory relationshipFactory = RelationshipFactory.eINSTANCE;
    private final UML2Factory umlFactory = UML2Factory.eINSTANCE;
    private final XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    private final BridgeImporter importer;
    private final BridgeModelProcessor processor;
    private final BridgeFeatureHelper featureHelper;
    private final StringNameValidator nameValidator;
    private final HashMap physicalById = new HashMap();
    private final HashMap logicalById = new HashMap();
    private final HashMap relationshipMap = new HashMap();
    private final HashMap dtMap = new HashMap();
    private final HashMap physicalRoots = new HashMap();
    private final Collection associations = new ArrayList();
    private final Collection rootRelationships = new ArrayList();
    private final Collection rootRelationshipNames = new ArrayList();
    private final Collection generalizations = new ArrayList();
    private final HashSet indexNames = new HashSet();
    private final PrimitiveTypeManager umlTypeMgr;
    private final DatatypeManager dtMgr;
    private List entityRelationships;
    private AnnotationContainer physicalAnnotations;
    private AnnotationContainer logicalAnnotations;
    private AnnotationContainer relationshipAnnotations;
    private Model umlRoot;
    private boolean processingLogical = false;
    private final boolean createLogicalAsRelational;
    private boolean needsUmlDTImport;
    private int count = 0;
    public static boolean HEADLESS;
    static /* synthetic */ java.lang.Class class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl;
    static /* synthetic */ java.lang.Class class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl;
    static /* synthetic */ java.lang.Class class$org$eclipse$uml2$UML2Package;

    public BridgeEntityFactory(BridgeModelProcessor processor, BridgeImporter importer) {
        ArgCheck.isNotNull((Object)importer);
        this.importer = importer;
        this.processor = processor;
        this.needsUmlDTImport = true;
        this.featureHelper = new BridgeFeatureHelper(this, importer);
        this.nameValidator = new StringNameValidator();
        this.createLogicalAsRelational = importer.createLogicalAsRelational();
        if (HEADLESS) {
            this.umlTypeMgr = null;
            this.dtMgr = null;
        } else {
            this.umlTypeMgr = PrimitiveTypeManager.INSTANCE;
            this.dtMgr = ModelerCore.getWorkspaceDatatypeManager();
        }
    }

    public void setProcessingLogical(boolean isProcessingLogical) {
        this.processingLogical = isProcessingLogical;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createEntity(MIRSQLViewEntity mirView, Object parent) {
        this.doStatus((MIRObject)mirView);
        long id = mirView.getUUID();
        byte dl = mirView.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        View relView = null;
        if (this.processingLogical) {
            if (!this.createLogicalAsRelational) return parent;
            if (isPhysicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateView", (Object)mirView.getDisplayName());
                throw new DesignLevelException(msg);
            }
            relView = this.relationalFactory.createView();
            this.addLogicalEntity(id, (EObject)relView);
            View table = (View)this.getPhysicalObject(id);
            this.createRelationship((EObject)table, (EObject)relView, null, this.getRelationshipType("Manifestation"), id);
        } else {
            if (isLogicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateView", (Object)mirView.getDisplayName());
                throw new DesignLevelException(msg);
            }
            relView = this.relationalFactory.createView();
            this.addPhysicalEntity(id, (EObject)relView);
        }
        if (parent instanceof Schema) {
            relView.setSchema((Schema)parent);
        } else if (parent instanceof Catalog) {
            relView.setCatalog((Catalog)parent);
        } else if (this.processingLogical) {
            this.processor.getLogicalResource().getContents().add((Object)relView);
        } else {
            this.addPhysicalRoot(id, (EObject)relView);
        }
        String name = this.processingLogical ? mirView.getName() : this.getPhysicalName((MIRObject)mirView);
        String validatedName = this.getValidName(name);
        relView.setName(validatedName);
        this.featureHelper.setValues(relView, mirView);
        return relView;
    }

    public Object createEntity(MIRClass mirClass, Object parent) {
        this.doStatus((MIRObject)mirClass);
        long id = mirClass.getUUID();
        byte dl = mirClass.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        Object obj = null;
        if (this.processingLogical) {
            if (isPhysicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateUmlClass", (Object)mirClass.getDisplayName());
                throw new DesignLevelException(msg);
            }
            obj = this.createLogicalAsRelational ? this.relationalFactory.createBaseTable() : this.umlFactory.createClass();
            BaseTable table = (BaseTable)this.getPhysicalObject(mirClass.getUUID());
            this.createRelationship((EObject)table, (EObject)obj, null, this.getRelationshipType("Manifestation"), mirClass.getUUID());
        } else {
            if (isLogicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateBaseTable", (Object)mirClass.getDisplayName());
                throw new DesignLevelException(msg);
            }
            obj = this.relationalFactory.createBaseTable();
        }
        String name = this.processingLogical ? mirClass.getName() : this.getPhysicalName((MIRObject)mirClass);
        String validatedName = this.getValidName(name);
        if (obj instanceof BaseTable) {
            BaseTable bt = obj;
            bt.setName(validatedName);
            if (parent instanceof Schema) {
                bt.setSchema((Schema)parent);
            } else if (parent instanceof Catalog) {
                bt.setCatalog((Catalog)parent);
            } else if (this.processingLogical) {
                this.processor.getLogicalResource().getContents().add((Object)bt);
            } else {
                this.addPhysicalRoot(id, (EObject)bt);
            }
            this.featureHelper.setValues((EObject)bt, (MIRElement)mirClass);
            if (this.processingLogical) {
                this.addLogicalEntity(id, (EObject)bt);
            } else {
                this.addPhysicalEntity(id, (EObject)bt);
            }
        } else if (obj instanceof Class) {
            Class clazz = (Class)obj;
            clazz.setName(validatedName);
            this.featureHelper.setValues(clazz, mirClass);
            this.addLogicalEntity(id, (EObject)clazz);
            if (parent instanceof Class) {
                ((Class)parent).getNestedClassifiers().add((Object)clazz);
            } else if (parent instanceof Model) {
                ((Model)parent).getOwnedMembers().add((Object)clazz);
            } else if (parent instanceof Package) {
                ((Package)parent).getOwnedMembers().add((Object)clazz);
            } else if (parent == null) {
                this.umlRoot.getOwnedMembers().add((Object)clazz);
            }
        }
        if (obj == null) {
            return parent;
        }
        return obj;
    }

    public Object createEntity(MIRDatabaseCatalog mirCat, Object parent) {
        this.doStatus((MIRObject)mirCat);
        byte dl = mirCat.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        if (this.processingLogical) {
            if (!isPhysicalOnly && this.createLogicalAsRelational) {
                Catalog catalog = this.relationalFactory.createCatalog();
                String name = this.getPhysicalName((MIRObject)mirCat);
                String validatedName = this.getValidName(name);
                mirCat.setName(validatedName);
                this.featureHelper.setValues(catalog, mirCat);
                this.processor.getLogicalResource().getContents().add((Object)catalog);
                return catalog;
            }
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateCatalog", (Object)mirCat.getDisplayName());
            throw new DesignLevelException(msg);
        }
        if (isLogicalOnly) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateCatalog", (Object)mirCat.getDisplayName());
            throw new DesignLevelException(msg);
        }
        Catalog catalog = this.relationalFactory.createCatalog();
        String name = this.getPhysicalName((MIRObject)mirCat);
        String validatedName = this.getValidName(name);
        mirCat.setName(validatedName);
        this.featureHelper.setValues(catalog, mirCat);
        this.processor.getPhysicalResource().getContents().add((Object)catalog);
        return catalog;
    }

    public Object createEntity(MIRDatabaseSchema mirSchema, Object parent) {
        this.doStatus((MIRObject)mirSchema);
        byte dl = mirSchema.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        if (this.processingLogical) {
            if (isPhysicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateCatalog", (Object)mirSchema.getDisplayName());
                throw new DesignLevelException(msg);
            }
            if (this.importer.createLogicalAsRelational()) {
                Schema relSchema = this.relationalFactory.createSchema();
                String name = this.getPhysicalName((MIRObject)mirSchema);
                if (name == null || name.trim().length() == 0) {
                    name = "DatabaseSchema";
                }
                String validatedName = this.getValidName(name);
                relSchema.setName(validatedName);
                this.featureHelper.setValues((EObject)relSchema, (MIRElement)mirSchema);
                if (parent instanceof Catalog) {
                    relSchema.setCatalog((Catalog)parent);
                } else if (parent == null || parent instanceof ModelAnnotation) {
                    this.processor.getLogicalResource().getContents().add((Object)relSchema);
                }
                return relSchema;
            }
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateSchema", (Object)mirSchema.getDisplayName());
            throw new DesignLevelException(msg);
        }
        if (isLogicalOnly) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateSchema", (Object)mirSchema.getDisplayName());
            throw new DesignLevelException(msg);
        }
        Schema relSchema = this.relationalFactory.createSchema();
        String name = this.getPhysicalName((MIRObject)mirSchema);
        if (name == null || name.trim().length() == 0) {
            name = "DatabaseSchema";
        }
        String validatedName = this.getValidName(name);
        relSchema.setName(validatedName);
        this.featureHelper.setValues((EObject)relSchema, (MIRElement)mirSchema);
        if (parent instanceof Catalog) {
            relSchema.setCatalog((Catalog)parent);
        } else if (parent == null || parent instanceof ModelAnnotation) {
            this.processor.getPhysicalResource().getContents().add((Object)relSchema);
        }
        return relSchema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createEntity(MIRSQLViewAttribute mirAttr, Object parent) {
        this.doStatus((MIRObject)mirAttr);
        long id = mirAttr.getUUID();
        byte dl = mirAttr.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        Column col = null;
        if (this.processingLogical) {
            if (isPhysicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateUmlProp", (Object)mirAttr.getDisplayName());
                throw new DesignLevelException(msg);
            }
            if (!this.createLogicalAsRelational) return parent;
            col = this.relationalFactory.createColumn();
            String validatedName = this.getValidName(mirAttr.getName());
            col.setName(validatedName);
            this.addLogicalEntity(id, (EObject)col);
            Column physCol = (Column)this.getPhysicalObject(id);
            if (physCol != null) {
                MIRClassifier clazz = mirAttr.getClassifier();
                Relationship parentRel = (Relationship)this.getRelationshipObject(clazz.getUUID());
                if (parentRel != null) {
                    Relationship rel = this.createRelationship((EObject)physCol, (EObject)col, parentRel, this.getRelationshipType("Manifestation"), id);
                    String name = BridgesPlugin.Util.getString("BridgeEntityFactory.Default_Relationship_Name", (Object)physCol.getName(), (Object)col.getName());
                    rel.setName(name);
                } else {
                    String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.MissingParentRelationship");
                    this.importer.log(msg, 4, null);
                }
            }
        } else {
            if (isLogicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateColumn", (Object)mirAttr.getDisplayName());
                throw new DesignLevelException(msg);
            }
            col = this.relationalFactory.createColumn();
            String name = this.getPhysicalName((MIRObject)mirAttr);
            String validatedName = this.getValidName(name);
            col.setName(validatedName);
            this.addPhysicalEntity(id, (EObject)col);
        }
        this.featureHelper.setValues(col, mirAttr);
        if (parent instanceof Table) {
            ((Table)parent).getColumns().add((Object)col);
            if (mirAttr.getType() != null) {
                this.setType((MIRFeature)mirAttr, col);
                return col;
            } else {
                MIRFeature sourceFeature = mirAttr.getSourceFeature();
                if (sourceFeature == null) return col;
                this.setType(sourceFeature, col);
            }
            return col;
        }
        this.logInvalidParent((EObject)col, parent);
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object createEntity(MIRAttribute mirAttr, Object parent) {
        this.doStatus((MIRObject)mirAttr);
        long id = mirAttr.getUUID();
        byte dl = mirAttr.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        if (this.processingLogical) {
            if (isPhysicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateUmlProp", (Object)mirAttr.getDisplayName());
                throw new DesignLevelException(msg);
            }
            Property newEntity = null;
            if (this.importer.createLogicalAsRelational()) {
                String validatedName = this.getValidName(mirAttr.getName());
                Column col = this.relationalFactory.createColumn();
                newEntity = col;
                col.setName(validatedName);
                if (!(parent instanceof Table)) {
                    this.logInvalidParent((EObject)col, parent);
                    return parent;
                }
                ((Table)parent).getColumns().add((Object)col);
                this.featureHelper.setValues(col, mirAttr);
                this.addLogicalEntity(id, (EObject)col);
                this.setType((MIRFeature)mirAttr, col);
            } else {
                Property prop;
                newEntity = prop = this.umlFactory.createProperty();
                String validName = this.createValidUMLName(mirAttr.getName());
                prop.setName(validName);
                if (!(parent instanceof Class)) {
                    this.logInvalidParent((EObject)prop, parent);
                    return parent;
                }
                this.addLogicalEntity(mirAttr.getUUID(), (EObject)prop);
                ((Class)parent).getOwnedAttributes().add((Object)prop);
                this.featureHelper.setValues(prop, mirAttr);
                this.setType(mirAttr, prop);
            }
            Column col = (Column)this.getPhysicalObject(mirAttr.getUUID());
            if (col != null && newEntity != null) {
                MIRClassifier clazz = mirAttr.getClassifier();
                Relationship parentRel = (Relationship)this.getRelationshipObject(clazz.getUUID());
                if (parentRel != null) {
                    Relationship rel = this.createRelationship((EObject)col, (EObject)newEntity, parentRel, this.getRelationshipType("Manifestation"), id);
                    String name = BridgesPlugin.Util.getString("BridgeEntityFactory.Default_Relationship_Name", (Object)col.getName(), (Object)this.getName(newEntity));
                    rel.setName(name);
                } else {
                    String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.MissingParentRelationship");
                    this.importer.log(msg, 4, null);
                }
            }
            if (newEntity != null) {
                return newEntity;
            }
            return parent;
        }
        if (parent instanceof RelationalEntity) {
            if (isLogicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateColumn", (Object)mirAttr.getDisplayName());
                throw new DesignLevelException(msg);
            }
            String name = this.getPhysicalName((MIRObject)mirAttr);
            String validatedName = this.getValidName(name);
            Column col = this.relationalFactory.createColumn();
            col.setName(validatedName);
            this.featureHelper.setValues(col, mirAttr);
            if (parent instanceof Table) {
                ((Table)parent).getColumns().add((Object)col);
                this.addPhysicalEntity(mirAttr.getUUID(), (EObject)col);
                this.setType((MIRFeature)mirAttr, col);
                return col;
            }
            this.logInvalidParent((EObject)col, parent);
        }
        return parent;
    }

    public Object createEntity(MIRCandidateKey mirKey, Object parent) {
        this.doStatus((MIRObject)mirKey);
        byte dl = mirKey.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        if (this.processingLogical) {
            if (isPhysicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateKey", (Object)mirKey.getDisplayName());
                throw new DesignLevelException(msg);
            }
            if (this.importer.createLogicalAsRelational()) {
                if (parent instanceof BaseTable) {
                    String validatedName = this.getValidName(mirKey.getName());
                    PrimaryKey relKey = null;
                    if (mirKey.getPrimaryOfClass() != null) {
                        relKey = this.relationalFactory.createPrimaryKey();
                        ((BaseTable)parent).setPrimaryKey(relKey);
                    } else {
                        relKey = this.relationalFactory.createUniqueConstraint();
                        ((BaseTable)parent).getUniqueConstraints().add((Object)relKey);
                    }
                    relKey.setName(validatedName);
                    this.featureHelper.setValues((UniqueKey)relKey, mirKey);
                    this.addLogicalEntity(mirKey.getUUID(), (EObject)relKey);
                    return relKey;
                }
                this.logInvalidParent((EObject)this.relationalFactory.createPrimaryKey(), parent);
                return parent;
            }
            return parent;
        }
        if (isLogicalOnly) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateKey", (Object)mirKey.getDisplayName());
            throw new DesignLevelException(msg);
        }
        if (parent instanceof BaseTable) {
            String name = this.getPhysicalName((MIRObject)mirKey);
            String validatedName = this.getValidName(name);
            PrimaryKey relKey = null;
            if (mirKey.getPrimaryOfClass() != null) {
                relKey = this.relationalFactory.createPrimaryKey();
                ((BaseTable)parent).setPrimaryKey(relKey);
            } else {
                relKey = this.relationalFactory.createUniqueConstraint();
                ((BaseTable)parent).getUniqueConstraints().add((Object)relKey);
            }
            relKey.setName(validatedName);
            this.featureHelper.setValues((UniqueKey)relKey, mirKey);
            this.addPhysicalEntity(mirKey.getUUID(), (EObject)relKey);
            return relKey;
        }
        this.logInvalidParent((EObject)this.relationalFactory.createPrimaryKey(), parent);
        return parent;
    }

    public Object createEntity(MIRForeignKey mirKey, Object parent) {
        this.doStatus((MIRObject)mirKey);
        byte dl = mirKey.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        boolean isLogicalOnly = this.isLogicalOnly(dl);
        if (this.processingLogical) {
            if (isPhysicalOnly) {
                String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateKey", (Object)mirKey.getDisplayName());
                throw new DesignLevelException(msg);
            }
            if (this.importer.createLogicalAsRelational()) {
                if (parent instanceof BaseTable) {
                    ForeignKey relFK = this.relationalFactory.createForeignKey();
                    BaseTable bt = (BaseTable)parent;
                    String name = mirKey.getName();
                    if (name == null || name.trim().length() == 0) {
                        name = "FKey";
                    }
                    String validatedName = this.getValidName(name);
                    if (bt.getForeignKeys().isEmpty()) {
                        relFK.setName(validatedName);
                    } else {
                        ArrayList<String> fkNames = new ArrayList<String>();
                        Iterator fks = bt.getForeignKeys().iterator();
                        while (fks.hasNext()) {
                            ForeignKey nxt = (ForeignKey)fks.next();
                            if (nxt == relFK) continue;
                            fkNames.add(nxt.getName());
                        }
                        String uniqueName = this.nameValidator.createUniqueName(validatedName, fkNames);
                        if (uniqueName != null) {
                            relFK.setName(uniqueName);
                        } else {
                            relFK.setName(validatedName);
                        }
                    }
                    bt.getForeignKeys().add((Object)relFK);
                    this.featureHelper.setValues(relFK, mirKey);
                    this.addLogicalEntity(mirKey.getUUID(), (EObject)relFK);
                    return relFK;
                }
                this.logInvalidParent((EObject)this.relationalFactory.createForeignKey(), parent);
                return parent;
            }
            return parent;
        }
        if (isLogicalOnly) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateKey", (Object)mirKey.getDisplayName());
            throw new DesignLevelException(msg);
        }
        if (parent instanceof BaseTable) {
            ForeignKey relFK = this.relationalFactory.createForeignKey();
            BaseTable bt = (BaseTable)parent;
            String name = this.getPhysicalName((MIRObject)mirKey);
            if (name == null || name.trim().length() == 0) {
                name = "FKey";
            }
            String validatedName = this.getValidName(name);
            if (bt.getForeignKeys().isEmpty()) {
                relFK.setName(validatedName);
            } else {
                ArrayList<String> fkNames = new ArrayList<String>();
                Iterator fks = bt.getForeignKeys().iterator();
                while (fks.hasNext()) {
                    ForeignKey nxt = (ForeignKey)fks.next();
                    if (nxt == relFK) continue;
                    fkNames.add(nxt.getName());
                }
                String uniqueName = this.nameValidator.createUniqueName(validatedName, fkNames);
                if (uniqueName != null) {
                    relFK.setName(uniqueName);
                } else {
                    relFK.setName(validatedName);
                }
            }
            bt.getForeignKeys().add((Object)relFK);
            this.featureHelper.setValues(relFK, mirKey);
            this.addPhysicalEntity(mirKey.getUUID(), (EObject)relFK);
            return relFK;
        }
        this.logInvalidParent((EObject)this.relationalFactory.createForeignKey(), parent);
        return parent;
    }

    public Object createEntity(MIRGeneralization mirGen, Object parent) {
        this.generalizations.add(mirGen);
        return parent;
    }

    public Object createEntity(MIRIndex mirIndex, Object parent) {
        this.doStatus((MIRObject)mirIndex);
        if (this.processingLogical) {
            return parent;
        }
        Index index = this.relationalFactory.createIndex();
        if (parent instanceof Table) {
            String uniqueName;
            String name = this.getPhysicalName((MIRObject)mirIndex);
            String validatedName = this.getValidName(name);
            Table table = (Table)parent;
            validatedName = table.getName() == null ? validatedName : table.getName() + "_" + validatedName;
            String tmp = this.nameValidator.createValidName(validatedName);
            if (tmp != null) {
                validatedName = tmp;
            }
            if ((uniqueName = this.nameValidator.createUniqueName(validatedName, (Collection)this.indexNames)) != null) {
                index.setName(uniqueName);
                this.indexNames.add(uniqueName);
            } else {
                index.setName(validatedName);
                this.indexNames.add(validatedName);
            }
            index.setUnique(false);
            this.featureHelper.setValues(index, mirIndex);
            EObject grandparent = table.eContainer();
            if (grandparent instanceof Schema) {
                index.setSchema((Schema)grandparent);
            } else if (grandparent instanceof Catalog) {
                index.setCatalog((Catalog)grandparent);
            } else {
                this.logInvalidParent((EObject)index, grandparent);
            }
            this.addPhysicalEntity(mirIndex.getUUID(), (EObject)index);
            return index;
        }
        this.logInvalidParent((EObject)index, parent);
        return parent;
    }

    public Object createEntity(MIRDesignPackage mirDesignPackage, Object parent) {
        this.doStatus((MIRObject)mirDesignPackage);
        if (this.importer.createLogicalAsRelational()) {
            return parent;
        }
        Package pkg = this.umlFactory.createPackage();
        String validName = this.createValidUMLName(mirDesignPackage.getName());
        pkg.setName(validName);
        this.featureHelper.setValues((EObject)pkg, (MIRElement)mirDesignPackage);
        this.addLogicalEntity(mirDesignPackage.getUUID(), (EObject)pkg);
        if (parent == null) {
            this.umlRoot.getOwnedMembers().add((Object)pkg);
        } else if (parent instanceof Package) {
            ((Package)parent).getOwnedMembers().add((Object)pkg);
        } else {
            this.logInvalidParent((EObject)pkg, parent);
        }
        return pkg;
    }

    public Object createEntity(MIRAssociation mirAssoc, Object parent) {
        this.doStatus((MIRObject)mirAssoc);
        byte dl = mirAssoc.getDesignLevel();
        boolean isPhysicalOnly = this.isPhysicalOnly(dl);
        if (isPhysicalOnly) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.dleCreateUmlAssociation", (Object)mirAssoc.getDisplayName());
            this.importer.log(msg, 2, null);
        }
        if (this.processingLogical && !isPhysicalOnly) {
            this.associations.add(mirAssoc);
        }
        return parent;
    }

    public Object createEntity(MIRObject mirObject, Object parent) {
        this.doStatus(mirObject);
        String originalName = mirObject.getName();
        String validatedName = this.nameValidator.createValidName(originalName);
        if (validatedName == null) {
            validatedName = originalName;
        }
        if (!(mirObject instanceof MIRBusinessRule)) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unmapped_entity_error_1", (Object)mirObject.getClass().getName());
            this.importer.log(msg, 4, null);
        }
        return parent;
    }

    private boolean isPhysicalOnly(byte dl) {
        if (this.processor.isPhysicalOnlyModel()) {
            return true;
        }
        return dl == 2;
    }

    private boolean isLogicalOnly(byte dl) {
        if (this.processor.isLogicalOnlyModel()) {
            return true;
        }
        return dl == 1;
    }

    private Annotation getAnnotation(EObject annotatedObject, int rsrcType) {
        AnnotationContainer cntr = null;
        switch (rsrcType) {
            case 0: {
                cntr = this.logicalAnnotations;
                break;
            }
            case 1: {
                cntr = this.physicalAnnotations;
                break;
            }
            case 2: {
                cntr = this.relationshipAnnotations;
                break;
            }
        }
        if (cntr == null) {
            return null;
        }
        Annotation ann = cntr.findAnnotation(annotatedObject);
        if (ann == null) {
            ann = this.coreFactory.createAnnotation();
            ann.setAnnotatedObject(annotatedObject);
            ann.setAnnotationContainer(cntr);
        }
        return ann;
    }

    public void addAnnotation(EObject annotatedObject, String msg, int rsrcType) {
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        if (annotatedObject instanceof XSDConcreteComponent) {
            XsdUtil.addUserInfoAttribute((XSDConcreteComponent)((XSDConcreteComponent)annotatedObject), (String)msg);
        } else {
            Annotation ann = this.getAnnotation(annotatedObject, rsrcType);
            if (ann != null) {
                ann.setDescription(msg);
            }
        }
    }

    public void addTag(EObject annotatedObject, String tagName, String msg) {
        int rsrcType = this.getResourceType(annotatedObject);
        this.addTag(annotatedObject, tagName, msg, rsrcType);
    }

    public void addTag(EObject annotatedObject, String tagName, String msg, int rsrcType) {
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        String validTagName = this.getValidName(tagName);
        if (annotatedObject instanceof XSDConcreteComponent) {
            XsdUtil.addApplicationInfoTag((XSDConcreteComponent)((XSDConcreteComponent)annotatedObject), (String)validTagName, (String)msg);
        } else {
            Annotation annotation = this.getAnnotation(annotatedObject, rsrcType);
            if (annotation != null) {
                annotation.getTags().put((Object)validTagName, (Object)msg);
            }
        }
    }

    public String getTag(EObject annotatedObject, String tagName) {
        if (annotatedObject == null) {
            return null;
        }
        int rsrcType = this.getResourceType(annotatedObject);
        Annotation annotation = this.getAnnotation(annotatedObject, rsrcType);
        if (annotation == null) {
            return null;
        }
        return (String)annotation.getTags().get((Object)tagName);
    }

    public void postProcess() {
        String msg;
        this.importer.getProgressMonitor().worked(15000);
        String postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_1");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        try {
            Iterator physRootMaps = this.physicalRoots.values().iterator();
            ArrayList<Object> primaryRoots = new ArrayList<Object>();
            ArrayList<EObject> secondaryRoots = new ArrayList<EObject>();
            while (physRootMaps.hasNext()) {
                HashMap nextMap = (HashMap)physRootMaps.next();
                Iterator physRoots = nextMap.values().iterator();
                while (physRoots.hasNext()) {
                    EObject next = (EObject)physRoots.next();
                    if (next.eContainer() != null) continue;
                    if (next instanceof Table) {
                        primaryRoots.add(next);
                        continue;
                    }
                    secondaryRoots.add(next);
                }
            }
            primaryRoots.addAll(secondaryRoots);
            Resource physicalRsrc = this.processor.getPhysicalResource();
            if (physicalRsrc instanceof MtkXmiResourceImpl) {
                ((MtkXmiResourceImpl)physicalRsrc).addMany(primaryRoots);
            } else {
                physicalRsrc.getContents().addAll(primaryRoots);
            }
        }
        catch (Throwable e) {
            msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_1_1");
            this.importer.log(msg, 4, (Exception)new MetaMatrixCoreException(e));
        }
        this.physicalRoots.clear();
        this.importer.getProgressMonitor().worked(2000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_2");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        this.importer.getProgressMonitor().worked(4000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_3");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        this.relationshipMap.clear();
        this.importer.getProgressMonitor().worked(2000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_4");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        this.importer.getProgressMonitor().worked(1000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_5");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        try {
            Iterator associationsItr = this.associations.iterator();
            while (associationsItr.hasNext()) {
                this.createAssociation((MIRAssociation)associationsItr.next());
            }
        }
        catch (Throwable e4) {
            msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_5_5");
            this.importer.log(msg, 4, (Exception)new MetaMatrixCoreException(e4));
        }
        this.associations.clear();
        this.importer.getProgressMonitor().worked(1000);
        postProcessTask = BridgesPlugin.Util.getString("BridgeEntityFactory.Post_Processing_models_6");
        this.importer.getProgressMonitor().subTask(postProcessTask);
        XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
        xsdImport.setNamespace("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
        xsdImport.setSchemaLocation("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
        this.processor.getDatatypeResource().getSchema().getContents().add(0, (Object)xsdImport);
        try {
            Resource relRsrc = this.processor.getRelationshipResource();
            if (relRsrc instanceof MtkXmiResourceImpl) {
                ((MtkXmiResourceImpl)relRsrc).addMany(this.rootRelationships);
            } else {
                relRsrc.getContents().addAll(this.rootRelationships);
            }
        }
        catch (Throwable e5) {
            String msg2 = BridgesPlugin.Util.getString("BridgeEntityFactory.Unexpected_exception_during_post_processing_step_6_6");
            this.importer.log(msg2, 4, (Exception)new MetaMatrixCoreException(e5));
        }
        this.rootRelationships.clear();
        this.rootRelationshipNames.clear();
        Iterator mirGens = this.generalizations.iterator();
        while (mirGens.hasNext()) {
            MIRGeneralization next = (MIRGeneralization)mirGens.next();
            MIRIterator subtypes = next.getSubtypeClassIterator();
            while (subtypes.hasNext()) {
                MIRClassifier mirSubtype = (MIRClassifier)subtypes.next();
                Object subClass = this.getLogicalObject(mirSubtype.getUUID());
                if (subClass == null) {
                    String msg3 = BridgesPlugin.Util.getString("BridgeEntityFactory.noSubtype", (Object)next.getName());
                    this.importer.log(msg3, 4, null);
                    continue;
                }
                MIRIterator supertypes = next.getSupertypeClassIterator();
                while (supertypes.hasNext()) {
                    MIRClassifier mirSupertype = (MIRClassifier)supertypes.next();
                    Object superClass = this.getLogicalObject(mirSupertype.getUUID());
                    if (superClass == null) {
                        String msg4 = BridgesPlugin.Util.getString("BridgeEntityFactory.noSupertype", (Object)next.getName());
                        this.importer.log(msg4, 4, null);
                        continue;
                    }
                    if (this.createLogicalAsRelational) {
                        BaseTable relSuperClass = (BaseTable)superClass;
                        BaseTable relSubClass = (BaseTable)subClass;
                        String sub = BridgesPlugin.Util.getString("BridgeEntityFactory.subClass");
                        String sup = BridgesPlugin.Util.getString("BridgeEntityFactory.superClass");
                        String subs = this.getTag((EObject)relSuperClass, sub);
                        if (subs == null) {
                            this.addTag((EObject)relSuperClass, sub, relSubClass.getName());
                        } else {
                            String newSubs = subs + ", " + relSubClass.getName();
                            this.addTag((EObject)relSuperClass, sub, newSubs);
                        }
                        this.addTag((EObject)relSubClass, sup, relSuperClass.getName());
                        continue;
                    }
                    Class umlSubClass = (Class)subClass;
                    Class umlSuperClass = (Class)superClass;
                    Generalization gen = umlSubClass.createGeneralization((Classifier)umlSuperClass);
                    this.featureHelper.setValues((EObject)gen, (MIRElement)next);
                }
            }
        }
        this.physicalById.clear();
        this.logicalById.clear();
        this.importer.getProgressMonitor().worked(1000);
    }

    public int getResourceType(Object obj) {
        if (obj instanceof EObject) {
            Resource rsrc = ((EObject)obj).eResource();
            if (rsrc == this.processor.getPhysicalResource()) {
                return 1;
            }
            if (rsrc == this.processor.getLogicalResource()) {
                return 0;
            }
            if (rsrc == this.processor.getRelationshipResource()) {
                return 2;
            }
            if (rsrc == this.processor.getDatatypeResource()) {
                return 3;
            }
            if (rsrc == null) {
                if (((EObject)obj).eClass().getEPackage().getClass() == (class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl == null ? (class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl = BridgeEntityFactory.class$("com.metamatrix.metamodels.relational.impl.RelationalPackageImpl")) : class$com$metamatrix$metamodels$relational$impl$RelationalPackageImpl)) {
                    return 1;
                }
                if (((EObject)obj).eClass().getEPackage().getClass() == (class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl == null ? (class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl = BridgeEntityFactory.class$("com.metamatrix.metamodels.relationship.impl.RelationshipPackageImpl")) : class$com$metamatrix$metamodels$relationship$impl$RelationshipPackageImpl)) {
                    return 2;
                }
                if ((class$org$eclipse$uml2$UML2Package == null ? (class$org$eclipse$uml2$UML2Package = BridgeEntityFactory.class$("org.eclipse.uml2.UML2Package")) : class$org$eclipse$uml2$UML2Package).isAssignableFrom(((EObject)obj).eClass().getEPackage().getClass())) {
                    return 0;
                }
            }
        }
        return -1;
    }

    public void initializeResources(MIRModel model) {
        Resource relationshipModel;
        Resource logicalResrc;
        Resource physResrc;
        XSDResourceImpl datatypeModel = this.processor.getDatatypeResource();
        if (datatypeModel != null) {
            XSDSchema schema = this.xsdFactory.createXSDSchema();
            schema.setIncrementalUpdate(false);
            datatypeModel.getContents().add((Object)schema);
            Map map = schema.getQNamePrefixToNamespaceMap();
            String schemaForSchemaPrefixText = "xs";
            map.put(schemaForSchemaPrefixText, "http://www.w3.org/2001/XMLSchema");
            schema.setSchemaForSchemaQNamePrefix(schemaForSchemaPrefixText);
        }
        if ((physResrc = this.processor.getPhysicalResource()) != null) {
            ModelAnnotation ma = this.coreFactory.createModelAnnotation();
            ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            ma.setModelType(ModelType.PHYSICAL_LITERAL);
            physResrc.getContents().add((Object)ma);
            ModelContents physicalContents = new ModelContents(physResrc);
            this.physicalAnnotations = physicalContents.getAnnotationContainer(true);
        }
        if ((logicalResrc = this.processor.getLogicalResource()) != null) {
            ModelAnnotation ma = this.coreFactory.createModelAnnotation();
            logicalResrc.getContents().add((Object)ma);
            ModelContents logicalContents = new ModelContents(logicalResrc);
            if (this.importer.createLogicalAsRelational()) {
                ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                ma.setModelType(ModelType.VIRTUAL_LITERAL);
            } else {
                ma.setPrimaryMetamodelUri("http://www.eclipse.org/uml2/1.0.0/UML");
                ma.setModelType(ModelType.PHYSICAL_LITERAL);
                this.umlRoot = this.umlFactory.createModel();
                this.umlRoot.setName(this.importer.getTargetLogicalModelShortName());
                logicalResrc.getContents().add((Object)this.umlRoot);
            }
            this.logicalAnnotations = logicalContents.getAnnotationContainer(true);
        }
        if ((relationshipModel = this.processor.getRelationshipResource()) != null) {
            ModelAnnotation ma = this.coreFactory.createModelAnnotation();
            ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relationship");
            ma.setModelType(ModelType.PHYSICAL_LITERAL);
            relationshipModel.getContents().add((Object)ma);
            ModelContents relationshipContents = new ModelContents(relationshipModel);
            this.relationshipAnnotations = relationshipContents.getAnnotationContainer(true);
        }
        this.addSourceFileInfo(model);
    }

    public void initEntityRelationships() {
        this.entityRelationships = new ArrayList();
    }

    public void processPropertyType(EObject mmEntity, MIRPropertyType mirPropType) {
        if (mmEntity == null || mirPropType == null) {
            return;
        }
        boolean isPhysicalOnly = this.processor.isPhysicalOnlyModel();
        boolean isLogicalOnly = this.processor.isLogicalOnlyModel();
        byte dl = mirPropType.getDesignLevel();
        if (!isPhysicalOnly) {
            boolean bl = isPhysicalOnly = 2 == dl;
        }
        if (!isLogicalOnly) {
            boolean bl = isLogicalOnly = 1 == dl;
        }
        if (this.processingLogical) {
            if (isPhysicalOnly) {
                return;
            }
            DataType umlDT = (DataType)this.getLogicalObject(mirPropType.getUUID());
            if (umlDT == null) {
                umlDT = this.createUMLType((MIRType)mirPropType);
            }
            if (!this.existsEntityRelationship(mmEntity, (EObject)umlDT, this.entityRelationships)) {
                Relationship rel = this.createRelationship(mmEntity, (EObject)umlDT, null, this.getRelationshipType("Usage"), mirPropType.getUUID());
                String name = BridgesPlugin.Util.getString("BridgeEntityFactory.Uses_Relationship_Name", (Object)this.getName(mmEntity), (Object)umlDT.getName());
                String uniqueName = this.nameValidator.createValidUniqueName(name, this.rootRelationshipNames);
                rel.setName(uniqueName);
                this.rootRelationshipNames.add(uniqueName);
                this.entityRelationships.add(rel);
            }
            return;
        }
        if (isLogicalOnly) {
            return;
        }
        XSDSimpleTypeDefinition xsdDT = (XSDSimpleTypeDefinition)this.getDatatypeObject(mirPropType.getUUID());
        if (xsdDT == null) {
            xsdDT = this.createXSDType((MIRType)mirPropType);
        }
        if (!this.existsEntityRelationship(mmEntity, (EObject)xsdDT, this.entityRelationships)) {
            Relationship rel = this.createRelationship(mmEntity, (EObject)xsdDT, null, this.getRelationshipType("Usage"), mirPropType.getUUID());
            String name = BridgesPlugin.Util.getString("BridgeEntityFactory.Uses_Relationship_Name", (Object)this.getName(mmEntity), (Object)xsdDT.getName());
            String uniqueName = this.nameValidator.createValidUniqueName(name, this.rootRelationshipNames);
            rel.setName(uniqueName);
            this.rootRelationshipNames.add(uniqueName);
            this.entityRelationships.add(rel);
        }
    }

    private boolean existsEntityRelationship(EObject sourceObj, EObject targetObj, List existingRels) {
        boolean exists = false;
        if (existingRels != null) {
            Iterator iter = existingRels.iterator();
            while (iter.hasNext()) {
                Relationship rel = (Relationship)iter.next();
                EList targets = rel.getTargets();
                EList sources = rel.getSources();
                if (targets.size() != 1 || sources.size() != 1 || sourceObj != sources.get(0) || targetObj != targets.get(0)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public void cleanup() {
        this.dtMap.clear();
        this.logicalById.clear();
        this.physicalById.clear();
        this.physicalRoots.clear();
        this.indexNames.clear();
        this.logicalAnnotations = null;
        this.physicalAnnotations = null;
        this.relationshipAnnotations = null;
    }

    public boolean isProcessingLogical() {
        return this.processingLogical;
    }

    public String getName(Object obj) {
        if (obj == null) {
            return NULL;
        }
        if (obj instanceof EObject) {
            EObject eObj = (EObject)obj;
            EStructuralFeature namesf = eObj.eClass().getEStructuralFeature("name");
            if (namesf != null && eObj.eGet(namesf) != null) {
                return (String)eObj.eGet(namesf);
            }
            return eObj.eClass().getName();
        }
        return obj.toString();
    }

    public String getPhysicalName(MIRObject mirObj) {
        if (mirObj == null) {
            return null;
        }
        if (mirObj instanceof MIRModelObject) {
            MIRModelObject mo = (MIRModelObject)mirObj;
            String physicalName = mo.getPhysicalName();
            if (physicalName == null || physicalName.trim().length() == 0) {
                physicalName = mo.getName();
            }
            return physicalName;
        }
        return null;
    }

    private DataType createUMLType(MIRType mirType) {
        XSDSimpleTypeDefinition baseType;
        if (!mirType.getUserDefined() && (baseType = this.getBaseType(mirType.getDataType())) != null) {
            return this.getPrimitiveTypeForType(baseType);
        }
        DataType umlType = null;
        if (mirType.getTypeValueCount() == 0) {
            umlType = this.umlFactory.createDataType();
        } else {
            umlType = this.umlFactory.createEnumeration();
            MIRIterator vals = mirType.getTypeValueIterator();
            while (vals.hasNext()) {
                MIRTypeValue nextVal = (MIRTypeValue)vals.next();
                EnumerationLiteral lit = this.umlFactory.createEnumerationLiteral();
                String validName = this.createValidUMLName(nextVal.getName());
                lit.setName(validName);
                ((Enumeration)umlType).getOwnedLiterals().add(0, (Object)lit);
            }
        }
        String validName = this.createValidUMLName(mirType.getName());
        umlType.setName(validName);
        this.featureHelper.setValues(umlType, mirType);
        this.addLogicalEntity(mirType.getUUID(), (EObject)umlType);
        this.umlRoot.getOwnedMembers().add((Object)umlType);
        return umlType;
    }

    private XSDSimpleTypeDefinition createXSDType(MIRType mirType) {
        if (!mirType.getUserDefined()) {
            return this.getBaseType(mirType.getDataType());
        }
        XSDSimpleTypeDefinition xsdType = (XSDSimpleTypeDefinition)this.getDatatypeObject(mirType.getUUID());
        if (xsdType != null) {
            return xsdType;
        }
        if (mirType instanceof MIRBaseType) {
            return this.getBaseType(mirType.getName());
        }
        if (mirType instanceof MIRDerivedType) {
            XSDSchema schema = this.processor.getDatatypeResource().getSchema();
            MIRDerivedType derivedType = (MIRDerivedType)mirType;
            xsdType = this.xsdFactory.createXSDSimpleTypeDefinition();
            xsdType.setName(this.getValidUniqueName((EObject)schema, (EObject)xsdType, this.getValidName(mirType.getName())));
            schema.getContents().add((Object)xsdType);
            this.addDatatypeEntity(mirType.getUUID(), (EObject)xsdType);
            MIRConcreteType mirSuperType = derivedType.getDerivedFromConcreteType();
            XSDSimpleTypeDefinition tmp = xsdType;
            while (mirSuperType != null) {
                if (mirSuperType instanceof MIRBaseType) {
                    XSDSimpleTypeDefinition baseType = this.getBaseType(mirSuperType.getDataType());
                    tmp.setBaseTypeDefinition(baseType);
                    mirSuperType = null;
                    continue;
                }
                if (!(mirSuperType instanceof MIRDerivedType)) continue;
                XSDSimpleTypeDefinition xsdSuperType = (XSDSimpleTypeDefinition)this.getDatatypeObject(mirType.getUUID());
                if (xsdSuperType == null) {
                    xsdSuperType = this.xsdFactory.createXSDSimpleTypeDefinition();
                    xsdSuperType.setName(this.getValidUniqueName((EObject)schema, (EObject)xsdType, this.getValidName(mirSuperType.getName())));
                    schema.getContents().add((Object)xsdSuperType);
                    this.featureHelper.setValues(xsdSuperType, (MIRType)mirSuperType);
                    this.addDatatypeEntity(mirSuperType.getUUID(), (EObject)xsdSuperType);
                    tmp.setBaseTypeDefinition(xsdSuperType);
                    tmp = xsdSuperType;
                    mirSuperType = ((MIRDerivedType)mirSuperType).getDerivedFromConcreteType();
                    continue;
                }
                mirSuperType = null;
            }
            this.featureHelper.setValues(xsdType, (MIRType)derivedType);
            return xsdType;
        }
        return null;
    }

    private void createAssociation(MIRAssociation mirAssoc) {
        Object sourceClass = null;
        Object targetClass = null;
        MIRAssociationRole sourceRole = null;
        MIRAssociationRole targetRole = null;
        MIRIterator roles = mirAssoc.getAssociationRoleIterator();
        while (roles.hasNext()) {
            MIRClass mirClass;
            MIRAssociationRole role = (MIRAssociationRole)roles.next();
            if (role.getSource()) {
                sourceRole = role;
                mirClass = role.getAssociatedClass();
                sourceClass = this.getLogicalObject(mirClass.getUUID());
                continue;
            }
            targetRole = role;
            mirClass = role.getAssociatedClass();
            targetClass = this.getLogicalObject(mirClass.getUUID());
        }
        if (sourceClass == null || targetClass == null) {
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Association_did_not_have_both_a_source_and_target_role", (Object)mirAssoc.getName());
            this.importer.log(msg, 4, null);
            return;
        }
        int sourceUpper = this.getMultiplicityUpperBound(sourceRole.getMultiplicity());
        int sourceLower = this.getMultiplicityLowerBound(sourceRole.getMultiplicity());
        int targetUpper = this.getMultiplicityUpperBound(targetRole.getMultiplicity());
        int targetLower = this.getMultiplicityLowerBound(targetRole.getMultiplicity());
        String sourceName = sourceRole.getName() == null ? this.getName(sourceClass) : sourceRole.getName();
        String targetName = targetRole.getName() == null ? this.getName(targetClass) : targetRole.getName();
        AggregationKind sourceAggregation = mirAssoc.getAggregation() ? AggregationKind.SHARED_LITERAL : AggregationKind.NONE_LITERAL;
        AggregationKind targetAggregation = AggregationKind.NONE_LITERAL;
        String tempName = this.getName(sourceClass) + '-' + this.getName(targetClass);
        if (this.createLogicalAsRelational) {
            LogicalRelationship rel = this.relationalFactory.createLogicalRelationship();
            rel.setName(tempName);
            BaseTable srcTbl = (BaseTable)sourceClass;
            BaseTable trgtTbl = (BaseTable)targetClass;
            if (srcTbl.getSchema() != null) {
                rel.setSchema(srcTbl.getSchema());
            } else if (srcTbl.getCatalog() != null) {
                rel.setCatalog(srcTbl.getCatalog());
            } else {
                this.processor.getLogicalResource().getContents().add((Object)rel);
            }
            LogicalRelationshipEnd srcEnd = this.relationalFactory.createLogicalRelationshipEnd();
            srcEnd.setName(targetRole.getName());
            srcEnd.setTable((Table)srcTbl);
            rel.getEnds().add((Object)srcEnd);
            LogicalRelationshipEnd trgtEnd = this.relationalFactory.createLogicalRelationshipEnd();
            trgtEnd.setName(sourceRole.getName());
            trgtEnd.setTable((Table)trgtTbl);
            rel.getEnds().add((Object)trgtEnd);
            if (sourceLower == 0) {
                if (sourceUpper == -1) {
                    trgtEnd.setMultiplicity(MultiplicityKind.ZERO_TO_MANY_LITERAL);
                } else {
                    trgtEnd.setMultiplicity(MultiplicityKind.ZERO_TO_ONE_LITERAL);
                }
            } else if (sourceLower == 1 && sourceUpper == 1) {
                trgtEnd.setMultiplicity(MultiplicityKind.ONE_LITERAL);
            } else {
                trgtEnd.setMultiplicity(MultiplicityKind.MANY_LITERAL);
            }
            if (targetLower == 0) {
                if (targetUpper == -1) {
                    srcEnd.setMultiplicity(MultiplicityKind.ZERO_TO_MANY_LITERAL);
                } else {
                    srcEnd.setMultiplicity(MultiplicityKind.ZERO_TO_ONE_LITERAL);
                }
            } else if (targetLower == 1 && targetUpper == 1) {
                srcEnd.setMultiplicity(MultiplicityKind.ONE_LITERAL);
            } else {
                srcEnd.setMultiplicity(MultiplicityKind.MANY_LITERAL);
            }
        } else {
            LiteralString stringValue;
            Constraint constraint;
            Class sourceClazz = (Class)sourceClass;
            Class targetClazz = (Class)targetClass;
            Association association = sourceClazz.createAssociation(sourceRole.getNavigable(), sourceAggregation, targetName, targetLower, targetUpper, (Type)targetClazz, targetRole.getNavigable(), targetAggregation, sourceName, sourceLower, sourceUpper);
            String uniqueName = this.getUniqueName(association.eContainer(), (EObject)association, tempName);
            association.setName(uniqueName);
            if (sourceRole.getExtraConstraint() != null && sourceRole.getExtraConstraint().length() > 0) {
                constraint = this.umlFactory.createConstraint();
                constraint.getConstrainedElements().add((Object)association);
                stringValue = this.umlFactory.createLiteralString();
                stringValue.setValue(sourceRole.getExtraConstraint());
                constraint.setSpecification((ValueSpecification)stringValue);
                constraint.setNamespace((Namespace)sourceClazz);
            }
            if (targetRole.getExtraConstraint() != null && targetRole.getExtraConstraint().length() > 0) {
                constraint = this.umlFactory.createConstraint();
                constraint.getConstrainedElements().add((Object)association);
                stringValue = this.umlFactory.createLiteralString();
                stringValue.setValue(targetRole.getExtraConstraint());
                constraint.setSpecification((ValueSpecification)stringValue);
                constraint.setNamespace((Namespace)targetClazz);
            }
        }
    }

    private int getMultiplicityLowerBound(String multiplicity) {
        if (multiplicity == null) {
            return -1;
        }
        int dots = multiplicity.indexOf("..");
        if (dots == -1) {
            if (!multiplicity.equals("*")) {
                return Integer.parseInt(multiplicity);
            }
            return -1;
        }
        return Integer.parseInt(multiplicity.substring(0, dots));
    }

    private int getMultiplicityUpperBound(String multiplicity) {
        if (multiplicity == null) {
            return -1;
        }
        int dots = multiplicity.indexOf("..");
        if (dots == -1) {
            if (multiplicity.equals("*")) {
                return -1;
            }
            return Integer.parseInt(multiplicity);
        }
        String upper = multiplicity.substring(dots + 2);
        if (upper.equals("*")) {
            return -1;
        }
        return Integer.parseInt(upper);
    }

    private void logInvalidParent(EObject child, Object parent) {
        String childName = child == null ? NULL : child.eClass().getName();
        String parentName = NULL;
        parentName = parent instanceof EObject ? (parent == null ? NULL : ((EObject)parent).eClass().getName()) : (parent == null ? NULL : parent.getClass().getName());
        String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.invalidParent", (Object)childName, (Object)parentName);
        this.importer.log(msg, 4, null);
    }

    private void setType(MIRAttribute mirAttr, Property prop) {
        MIRType mirType = mirAttr.getType();
        DataType umlType = (DataType)this.getLogicalObject(mirType.getUUID());
        if (umlType != null) {
            prop.setType((Type)umlType);
            return;
        }
        if (mirType instanceof MIRBaseType) {
            XSDSimpleTypeDefinition xsdType = this.getBaseType(mirType.getName());
            umlType = this.getPrimitiveTypeForType(xsdType);
            prop.setType((Type)umlType);
            if (this.needsUmlDTImport && umlType != null) {
                this.needsUmlDTImport = false;
                Resource logicalRsrc = this.processor.getLogicalResource();
                if (logicalRsrc instanceof MtkXmiResourceImpl) {
                    this.addModelImport((EmfResource)((MtkXmiResourceImpl)logicalRsrc), umlType.eResource());
                }
            }
            return;
        }
        umlType = this.createUMLType(mirType);
        prop.setType((Type)umlType);
    }

    private void setType(MIRFeature mirAttr, Column col) {
        MIRType mirType = mirAttr.getType();
        if (mirType == null) {
            return;
        }
        XSDSimpleTypeDefinition xsdType = (XSDSimpleTypeDefinition)this.getDatatypeObject(mirType.getUUID());
        if (xsdType != null) {
            col.setType((EObject)xsdType);
            return;
        }
        xsdType = this.createXSDType(mirType);
        col.setType((EObject)xsdType);
    }

    private void doStatus(MIRObject mirObject) {
        if ((long)this.count++ % this.importer.getProgressDelta() == 0L) {
            this.importer.getProgressMonitor().subTask(this.importer.getConversionString() + BridgesPlugin.Util.getString("BridgeEntityFactory._creating__1") + mirObject.getDisplayName());
        }
    }

    private PrimitiveType getPrimitiveTypeForType(XSDSimpleTypeDefinition type) {
        if (type == null || HEADLESS) {
            return null;
        }
        try {
            XSDSimpleTypeDefinition builtIn = (XSDSimpleTypeDefinition)this.dtMgr.getDatatypeForXsdType((EObject)type);
            String name = builtIn == null || builtIn.getName().equals("anySimpleType") ? "string" : builtIn.getName();
            return this.umlTypeMgr.getPrimitiveType(name);
        }
        catch (Exception e) {
            String name = type == null ? "string" : type.getName();
            String msg = BridgesPlugin.Util.getString("BridgeEntityFactory.Error_getting_primitive_type_for", (Object)name);
            this.importer.log(msg, 4, e);
            return this.umlTypeMgr.getPrimitiveType("string");
        }
    }

    private RelationshipType getRelationshipType(String typeName) {
        RelationshipType type = RelationshipMetamodelPlugin.getBuiltInRelationshipTypeManager().getBuiltInRelationshipType(typeName);
        if (type == null) {
            // empty if block
        }
        return type;
    }

    private void addSourceFileInfo(MIRModel mirModel) {
        XSDResourceImpl datatypeModel;
        Resource relationshipModel;
        Resource logicalResrc;
        MIRMetadataOrigin metadata = mirModel.getMetadataOrigin();
        if (metadata == null) {
            return;
        }
        String modelName = metadata.getSource();
        String toolName = metadata.getToolName();
        String toolVer = metadata.getToolVersion();
        String date = new Date().toString();
        String description = BridgesPlugin.Util.getString("BridgeEntityFactory.descrptionString2", (Object)date, (Object)modelName);
        StringBuffer buffer = new StringBuffer(description);
        buffer.append("\n");
        buffer.append("Tool Name: ");
        buffer.append(toolName);
        buffer.append("\n");
        buffer.append("Tool Version: ");
        buffer.append(toolVer);
        Resource physResrc = this.processor.getPhysicalResource();
        Collection udps = this.importer.getUdps();
        if (physResrc != null) {
            ModelAnnotation ma = this.getModelAnnotation(physResrc);
            ma.setDescription(buffer.toString());
            this.addUdpTags(ma, udps);
        }
        if ((logicalResrc = this.processor.getLogicalResource()) != null) {
            ModelAnnotation ma = this.getModelAnnotation(logicalResrc);
            ma.setDescription(buffer.toString());
            this.addUdpTags(ma, udps);
        }
        if ((relationshipModel = this.processor.getRelationshipResource()) != null) {
            ModelAnnotation ma = this.getModelAnnotation(relationshipModel);
            ma.setDescription(buffer.toString());
            this.addUdpTags(ma, udps);
        }
        if ((datatypeModel = this.processor.getDatatypeResource()) != null) {
            XSDSchema schema = datatypeModel.getSchema();
            XsdUtil.addApplicationInfoTag((XSDConcreteComponent)schema, (String)"description", (String)buffer.toString());
            XSDAnnotation annotation = XsdUtil.getAnnotation((XSDConcreteComponent)schema);
            this.addUdpTags(annotation, udps);
        }
    }

    private ModelAnnotation getModelAnnotation(Resource rsrc) {
        if (rsrc == null) {
            return null;
        }
        Iterator contents = rsrc.getContents().iterator();
        while (contents.hasNext()) {
            Object next = contents.next();
            if (!(next instanceof ModelAnnotation)) continue;
            return (ModelAnnotation)next;
        }
        return null;
    }

    private void addUdpTags(ModelAnnotation ma, Collection udps) {
        EMap tags = ma.getTags();
        Iterator it = udps.iterator();
        String name = null;
        String val = null;
        while (it.hasNext()) {
            try {
                BridgeOption next = (BridgeOption)it.next();
                name = next.getName();
                String string = val = next.getSavedValue() == null ? new String() : next.getSavedValue();
                if (name == null) continue;
                tags.put((Object)name, (Object)val);
            }
            catch (Exception e) {
                String err = BridgesPlugin.Util.getString("BridgeEntityFactory.Error_creating_User_Defined_Property_Tag", (Object)name, val);
                this.importer.log(err, 4, e);
            }
        }
    }

    private void addUdpTags(XSDAnnotation annotation, Collection udps) {
        Iterator it = udps.iterator();
        String name = null;
        String val = null;
        while (it.hasNext()) {
            try {
                BridgeOption next = (BridgeOption)it.next();
                name = next.getName();
                String string = val = next.getSavedValue() == null ? new String() : next.getSavedValue();
                if (name == null) continue;
                String validName = this.getValidName(name);
                XsdUtil.addApplicationInfoTag((XSDConcreteComponent)annotation, (String)validName, (String)val);
            }
            catch (Exception e) {
                String err = BridgesPlugin.Util.getString("BridgeEntityFactory.Error_creating_User_Defined_Property_Tag", (Object)name, val);
                this.importer.log(err, 4, e);
            }
        }
    }

    private String getValidUniqueName(EObject parent, EObject child, String name) {
        String uniqueName = name;
        try {
            Iterator siblings;
            ArrayList<String> siblingNames = new ArrayList<String>();
            Iterator iterator = siblings = parent == null ? child.eResource().getContents().iterator() : parent.eContents().iterator();
            while (siblings.hasNext()) {
                Object next = siblings.next();
                if (next == child || next.getClass() != child.getClass()) continue;
                siblingNames.add(this.getName(next));
            }
            uniqueName = this.nameValidator.createValidUniqueName(name, siblingNames);
            if (uniqueName == null) {
                uniqueName = name;
            }
        }
        catch (Exception e) {
            uniqueName = name;
        }
        return uniqueName;
    }

    private String getValidName(String originalName) {
        String validatedName = this.nameValidator.createValidName(originalName);
        if (validatedName == null) {
            validatedName = originalName;
        }
        return validatedName;
    }

    private String getUniqueName(EObject parent, EObject child, String name) {
        String uniqueName = name;
        try {
            Iterator siblings;
            ArrayList<String> siblingNames = new ArrayList<String>();
            Iterator iterator = siblings = parent == null ? child.eResource().getContents().iterator() : parent.eContents().iterator();
            while (siblings.hasNext()) {
                Object next = siblings.next();
                if (next == child || next.getClass() != child.getClass()) continue;
                siblingNames.add(this.getName(next));
            }
            uniqueName = this.nameValidator.createUniqueName(name, siblingNames);
            if (uniqueName == null) {
                uniqueName = name;
            }
        }
        catch (Exception e) {
            uniqueName = name;
        }
        return uniqueName;
    }

    private void addPhysicalEntity(long id, EObject entity) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap<Long, EObject> map = (HashMap<Long, EObject>)this.physicalById.get(mapNo);
        if (map == null) {
            map = new HashMap<Long, EObject>();
            this.physicalById.put(mapNo, map);
        }
        map.put(longID, entity);
    }

    public Object getPhysicalObject(long id) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap map = (HashMap)this.physicalById.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(longID);
    }

    private void addLogicalEntity(long id, EObject entity) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap<Long, EObject> map = (HashMap<Long, EObject>)this.logicalById.get(mapNo);
        if (map == null) {
            map = new HashMap<Long, EObject>();
            this.logicalById.put(mapNo, map);
        }
        map.put(longID, entity);
    }

    private void addModelImport(EmfResource owner, Resource ref) {
        ModelEditor me = ModelerCore.getModelEditor();
        try {
            me.addModelImport((MMXmiResource)owner, ref);
        }
        catch (ModelerCoreException err) {
            this.importer.log(err.getMessage(), 4, (Exception)((Object)err));
        }
    }

    public Object getLogicalObject(long id) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap map = (HashMap)this.logicalById.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(longID);
    }

    private void addDatatypeEntity(long id, EObject entity) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap<Long, EObject> map = (HashMap<Long, EObject>)this.dtMap.get(mapNo);
        if (map == null) {
            map = new HashMap<Long, EObject>();
            this.dtMap.put(mapNo, map);
        }
        map.put(longID, entity);
    }

    private Object getDatatypeObject(long id) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap map = (HashMap)this.dtMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(longID);
    }

    private void addRelationshipEntity(long id, EObject entity) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap<Long, EObject> map = (HashMap<Long, EObject>)this.relationshipMap.get(mapNo);
        if (map == null) {
            map = new HashMap<Long, EObject>();
            this.relationshipMap.put(mapNo, map);
        }
        map.put(longID, entity);
    }

    private Object getRelationshipObject(long id) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap map = (HashMap)this.relationshipMap.get(mapNo);
        if (map == null) {
            return null;
        }
        return map.get(longID);
    }

    private void addPhysicalRoot(long id, EObject entity) {
        Long longID = new Long(id);
        Integer mapNo = new Integer(longID.intValue() / 1500);
        HashMap<Long, EObject> map = (HashMap<Long, EObject>)this.physicalRoots.get(mapNo);
        if (map == null) {
            map = new HashMap<Long, EObject>();
            this.physicalRoots.put(mapNo, map);
        }
        map.put(longID, entity);
    }

    private XSDSimpleTypeDefinition getBaseType(String bt) {
        if (HEADLESS) {
            return null;
        }
        try {
            XSDSimpleTypeDefinition type = null;
            if (bt.equals("SQL_VARCHAR")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("string");
            } else if (bt.equals("SQL_INTEGER")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("integer");
            } else if (bt.equals("SQL_CHAR")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("string");
            } else if (bt.equals("SQL_LONGVARCHAR")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("string");
            } else if (bt.equals("SQL_NUMERIC") || bt.equals("SQL_DECIMAL")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("decimal");
            } else if (bt.equals("SQL_DATE")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("date");
            } else if (bt.equals("SQL_TIMESTAMP")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("timestamp");
            } else if (bt.equals("undefined")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("string");
            } else if (bt.equals("SQL_LONGVARBINARY") || bt.equals("SQL_BLOB") || bt.equals("SQL_VARBINARY")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("blob");
            } else if (bt.equals("SQL_CLOB")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("clob");
            } else if (bt.equals("SQL_BOOLEAN")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("boolean");
            } else if (bt.equals("SQL_SMALLINT")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("short");
            } else if (bt.equals("SQL_FLOAT")) {
                type = (XSDSimpleTypeDefinition)this.dtMgr.getBuiltInDatatype("float");
            } else {
                String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unexpected_data_type_found", (Object)bt);
                this.importer.log(msg, 4, null);
            }
            return type;
        }
        catch (ModelerCoreException e) {
            String msg = BridgesPlugin.Util.getString("BridgeFeatureMapper.Unable_to_determine_Datatype_for1", (Object)bt);
            this.importer.log(msg, 4, (Exception)((Object)e));
            return null;
        }
    }

    private String createValidUMLName(String name) {
        StringBuffer newName = new StringBuffer(name);
        boolean changed = false;
        int length = newName.length();
        int maxLength = this.nameValidator.getMaximumLength();
        int index = 0;
        while (index < length) {
            char c = newName.charAt(index);
            if (index == 0) {
                if (!Character.isLetter(c)) {
                    newName.deleteCharAt(index);
                    --length;
                    changed = true;
                    continue;
                }
                ++index;
                continue;
            }
            if (maxLength > 0 && length > maxLength) {
                length = maxLength;
                newName = new StringBuffer(newName.substring(0, maxLength));
                changed = true;
            }
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != ' ') {
                newName.setCharAt(index, '_');
                ++index;
                changed = true;
                continue;
            }
            ++index;
        }
        if (changed) {
            return newName.toString();
        }
        return name;
    }

    private Relationship createRelationship(EObject sourceObj, EObject targetObj, Relationship parent, RelationshipType type, long uuid) {
        if (sourceObj == null || targetObj == null) {
            return null;
        }
        Relationship rel = this.relationshipFactory.createRelationship();
        if (parent == null) {
            this.rootRelationships.add(rel);
        } else {
            parent.getOwnedRelationships().add((Object)rel);
        }
        rel.setType(type);
        rel.getSources().add((Object)sourceObj);
        rel.getTargets().add((Object)targetObj);
        this.addRelationshipEntity(uuid, (EObject)rel);
        String name = BridgesPlugin.Util.getString("BridgeEntityFactory.Default_Relationship_Name", (Object)this.getName(sourceObj), (Object)this.getName(targetObj));
        rel.setName(name);
        return rel;
    }

    static /* synthetic */ java.lang.Class class$(String x0) {
        try {
            return java.lang.Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DesignLevelException
    extends RuntimeException {
        public DesignLevelException() {
        }

        public DesignLevelException(String detailMsg) {
            super(detailMsg);
        }
    }
}

