/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl;

import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.NullableType;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.RelationalPackage;
import com.metamatrix.metamodels.relational.Schema;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.MetamodelDescriptor;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.dqp.internal.config.VdbDefnHelper;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelBuildingException;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.modeler.modelgenerator.wsdl.SoapBindingInfo;
import com.metamatrix.modeler.modelgenerator.wsdl.TableBuilder;
import com.metamatrix.modeler.modelgenerator.wsdl.util.ExtensionPropertyManager;
import com.metamatrix.modeler.modelgenerator.wsdl.util.NameUtil;
import com.metamatrix.modeler.schema.tools.model.jdbc.Column;
import com.metamatrix.modeler.schema.tools.model.jdbc.DataType;
import com.metamatrix.modeler.schema.tools.model.jdbc.Table;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.SoapDataTypeImpl;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.vdb.edit.VdbEditingContext;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RelationalModelBuilder {
    private static final String RESPONSE_IN_PATTERN_NAME = "ResponseInRequired";
    private ExtensionPropertyManager m_extPropManager = null;
    private Map m_namespaces;
    private ArrayList m_foreignKeys;
    private HashMap m_tables;
    private HashMap m_bindings;
    private ModelResource modelResource;
    private HashMap catalogs;
    private HashMap replacementCatalogNames = new HashMap();
    static /* synthetic */ Class class$org$eclipse$core$runtime$IProgressMonitor;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$metamatrix$modeler$dqp$DqpPlugin;

    public RelationalModelBuilder(Map namespaces) {
        this.m_namespaces = namespaces;
        this.m_tables = new HashMap();
        this.m_foreignKeys = new ArrayList();
        this.m_bindings = new HashMap();
    }

    public IFile createModel(Collection tables, String modelFile, IContainer container) throws ModelBuildingException {
        boolean isDimension = ModelGeneratorWsdlPlugin.isDimension();
        Object rootContext = ModelGeneratorWsdlPlugin.getRootContext();
        IFile retVal = null;
        try {
            retVal = this.createRelationalModel(tables, modelFile, container);
            if (isDimension) {
                Boolean ret;
                Path projModelPath = new Path(container.getName() + "/" + modelFile);
                VdbDefnHelper helper = null;
                if (rootContext instanceof InternalVdbEditingContext) {
                    ((VdbEditingContext)rootContext).addModel(null, (IPath)projModelPath, false);
                    helper = DqpPlugin.getInstance().getVdbDefnHelper((InternalVdbEditingContext)rootContext);
                } else {
                    Class<?> objClass = rootContext.getClass();
                    Method addModel = objClass.getMethod("addModel", class$org$eclipse$core$runtime$IProgressMonitor == null ? (class$org$eclipse$core$runtime$IProgressMonitor = RelationalModelBuilder.class$("org.eclipse.core.runtime.IProgressMonitor")) : class$org$eclipse$core$runtime$IProgressMonitor, class$java$io$File == null ? (class$java$io$File = RelationalModelBuilder.class$("java.io.File")) : class$java$io$File, class$java$lang$String == null ? (class$java$lang$String = RelationalModelBuilder.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
                    String strPath = retVal.getFullPath().toString();
                    File modFile = retVal.getLocation().toFile();
                    addModel.invoke(rootContext, null, modFile, strPath, Boolean.FALSE);
                    Method getVdbDefnHelper = (class$com$metamatrix$modeler$dqp$DqpPlugin == null ? (class$com$metamatrix$modeler$dqp$DqpPlugin = RelationalModelBuilder.class$("com.metamatrix.modeler.dqp.DqpPlugin")) : class$com$metamatrix$modeler$dqp$DqpPlugin).getMethod("getVdbDefnHelper", Class.forName("com.metamatrix.vdb.edit.VdbContextEditor"));
                    helper = (VdbDefnHelper)getVdbDefnHelper.invoke((Object)DqpPlugin.getInstance(), rootContext);
                }
                Method saveDefn = helper.getClass().getMethod("saveDefn", null);
                Object saveRet = saveDefn.invoke((Object)helper, null);
                if (saveRet != null && saveRet instanceof Boolean && !(ret = (Boolean)saveRet).booleanValue()) {
                    throw new ModelBuildingException(new Exception("unable to save VDB"));
                }
                container.refreshLocal(2, null);
                Iterator iter = this.m_bindings.values().iterator();
                while (iter.hasNext()) {
                    SoapBindingInfo info = (SoapBindingInfo)iter.next();
                    String name = info.generateUniqueName();
                    info.createConnectorBinding(modelFile, name, rootContext);
                }
            } else {
                container.refreshLocal(2, null);
            }
            if (!ModelEditorManager.isOpen((IFile)retVal)) {
                ModelEditorManager.activate((IFile)retVal, (boolean)true);
            }
        }
        catch (IOException e) {
            throw new ModelBuildingException(e);
        }
        catch (CoreException e) {
            throw new ModelBuildingException(e);
        }
        catch (NullPointerException npe) {
            throw new ModelBuildingException(npe);
        }
        catch (Exception e) {
            throw new ModelBuildingException(e);
        }
        return retVal;
    }

    private IFile createRelationalModel(Collection tables, String modelFile, IContainer container) throws CoreException, IOException, ModelBuildingException {
        Resource resource;
        ModelAnnotation modelAnnotation;
        Path modelPath = new Path(modelFile);
        IFile iFile = container.getFile((IPath)modelPath);
        File f = iFile.getLocation().toFile();
        boolean newModel = !f.exists();
        this.modelResource = ModelerCore.create((IFile)iFile);
        Container cntr = ModelerCore.getModelContainer();
        this.m_extPropManager = new ExtensionPropertyManager(cntr, ModelGeneratorWsdlPlugin.isDimension());
        if (newModel) {
            modelAnnotation = this.modelResource.getModelAnnotation();
            modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            modelAnnotation.setExtensionPackage(this.m_extPropManager.getExtensionPackage());
        } else {
            modelAnnotation = this.modelResource.getModelAnnotation();
            ModelType modelType = this.modelResource.getModelType();
            if (null == modelType) {
                modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
            } else if (modelType.getValue() != 0) {
                String message = ModelGeneratorWsdlPlugin.Util.getString("RelationalModelBuilder.exception.unsupported.metamodel.virtual");
                Exception e = new Exception(message);
                throw new ModelBuildingException(e);
            }
            MetamodelDescriptor descriptor = this.modelResource.getPrimaryMetamodelDescriptor();
            if (null == descriptor) {
                modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            } else if (!descriptor.getNamespaceURI().equals("http://www.metamatrix.com/metamodels/Relational")) {
                String message = ModelGeneratorWsdlPlugin.Util.getString("RelationalModelBuilder.exception.unsupported.metamodel");
                Exception e = new Exception(message);
                throw new ModelBuildingException(e);
            }
            modelAnnotation.setExtensionPackage(this.m_extPropManager.getExtensionPackage());
        }
        try {
            resource = this.modelResource.getEmfResource();
        }
        catch (ModelWorkspaceException e) {
            throw new ModelBuildingException(e);
        }
        if (!newModel) {
            this.findOperationNameConflicts(resource, tables);
        }
        this.createModelContents(tables, resource);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                RelationalModelBuilder.this.modelResource.save(monitor, false);
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            operation.run((IProgressMonitor)monitor);
        }
        catch (Exception ex) {
            if (ex instanceof InvocationTargetException) {
                throw new ModelBuildingException(((InvocationTargetException)ex).getTargetException());
            }
            throw new ModelBuildingException(ex);
        }
        return iFile;
    }

    private void findOperationNameConflicts(Resource resource, Collection tables) throws ModelBuildingException {
        if (null == this.catalogs) {
            this.catalogs = new HashMap();
        }
        EList contents = resource.getContents();
        Iterator iter = contents.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Catalog)) continue;
            Catalog catalog = (Catalog)obj;
            this.catalogs.put(catalog.getName(), catalog);
        }
        Iterator tabIter = tables.iterator();
        while (tabIter.hasNext()) {
            TableBuilder.TableWrapper tabWrap = (TableBuilder.TableWrapper)tabIter.next();
            Table tab = tabWrap.getTable();
            String catalogName = tab.getCatalog();
            if (!this.catalogs.containsKey(catalogName)) continue;
            Catalog catalog = (Catalog)this.catalogs.get(catalogName);
            String schemaName = tab.getSchema();
            Iterator schemaIter = catalog.getSchemas().iterator();
            while (schemaIter.hasNext()) {
                Schema schema = (Schema)schemaIter.next();
                if (!schemaName.equals(schema.getName())) continue;
                boolean done = false;
                int counter = 1;
                while (!done) {
                    String newCatalog = catalogName + '_' + counter;
                    if (!this.catalogs.containsKey(newCatalog)) {
                        this.replacementCatalogNames.put(catalogName, newCatalog);
                        done = true;
                        continue;
                    }
                    ++counter;
                }
            }
        }
    }

    private void createModelContents(Collection tables, Resource r) throws ModelBuildingException {
        Iterator tableIter = tables.iterator();
        if (null == this.catalogs) {
            this.catalogs = new HashMap();
        }
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        HashMap bindings = new HashMap();
        while (tableIter.hasNext()) {
            Schema schema;
            Catalog cat;
            TableBuilder.TableWrapper tabWrap = (TableBuilder.TableWrapper)tableIter.next();
            Table tab = tabWrap.getTable();
            SoapBindingInfo info = tabWrap.getSoapBindingInfo();
            if (info != null && this.m_bindings.get(info) == null) {
                this.m_bindings.put(info, info);
            }
            boolean isRequest = tabWrap.isRequest();
            String catalogName = tab.getCatalog();
            if (this.replacementCatalogNames.containsKey(catalogName)) {
                catalogName = (String)this.replacementCatalogNames.get(catalogName);
            }
            if ((cat = (Catalog)this.catalogs.get(catalogName)) == null) {
                cat = RelationalPackage.eINSTANCE.getRelationalFactory().createCatalog();
                cat.setName(catalogName);
                r.getContents().add((Object)cat);
                this.catalogs.put(catalogName, cat);
            }
            if ((schema = (Schema)schemas.get(tab.getSchema())) == null) {
                schema = RelationalPackage.eINSTANCE.getRelationalFactory().createSchema();
                schema.setName(tab.getSchema());
                schema.setCatalog(cat);
                schemas.put(tab.getSchema(), schema);
            }
            BaseTable relTab = RelationalPackage.eINSTANCE.getRelationalFactory().createBaseTable();
            relTab.setCatalog(cat);
            relTab.setSchema(schema);
            relTab.setName(tab.getName());
            if (!isRequest) {
                relTab.setNameInSource(tab.getOutputXPath().toString());
            }
            if (isRequest && tabWrap.getSoapAction() != null) {
                this.m_extPropManager.setSoapAction((com.metamatrix.metamodels.relational.Table)relTab, tabWrap.getSoapAction());
            }
            this.m_extPropManager.setTableNamespace((com.metamatrix.metamodels.relational.Table)relTab, tab);
            if (isRequest) {
                relTab.setNameInSource("/");
                this.m_extPropManager.setTableXPathForInput((com.metamatrix.metamodels.relational.Table)relTab, tab);
            }
            Column[] cols = tab.getColumns();
            for (int i = 0; i < cols.length; ++i) {
                if (isRequest && cols[i].getName().endsWith("_mmid")) continue;
                try {
                    com.metamatrix.metamodels.relational.Column col = this.addColumn((com.metamatrix.metamodels.relational.Table)relTab, cols[i], isRequest);
                    if (col.getName().equals("ResponseIn")) {
                        this.addResponseInAccessPattern((com.metamatrix.metamodels.relational.Table)relTab, col);
                    }
                    if (col.getName().equals("mmid")) {
                        PrimaryKey key = RelationalPackage.eINSTANCE.getRelationalFactory().createPrimaryKey();
                        relTab.setPrimaryKey(key);
                        key.getColumns().add((Object)col);
                        key.setName(col.getName() + "_PK");
                    }
                    if (!cols[i].isForeignKey()) continue;
                    this.addForeignKey(new FKWrapper(col, relTab, tab.getCatalog(), tab.getSchema()));
                    continue;
                }
                catch (ModelerCoreException e) {
                    throw new ModelBuildingException(e);
                }
            }
            this.m_tables.put(tab.getCatalog() + '.' + tab.getSchema() + '.' + tab.getName(), relTab);
        }
        this.createForeignKeys();
    }

    private void addForeignKey(FKWrapper wrapper) {
        this.m_foreignKeys.add(wrapper);
    }

    private void addResponseInAccessPattern(com.metamatrix.metamodels.relational.Table relTab, com.metamatrix.metamodels.relational.Column column) {
        AccessPattern accessPattern = RelationalPackage.eINSTANCE.getRelationalFactory().createAccessPattern();
        accessPattern.setName(RESPONSE_IN_PATTERN_NAME);
        accessPattern.setTable(relTab);
        accessPattern.getColumns().add((Object)column);
    }

    private com.metamatrix.metamodels.relational.Column addColumn(com.metamatrix.metamodels.relational.Table relTab, Column column, boolean isRequest) throws ModelerCoreException {
        com.metamatrix.metamodels.relational.Column relCol = RelationalPackage.eINSTANCE.getRelationalFactory().createColumn();
        relTab.getColumns().add((Object)relCol);
        relCol.setName(NameUtil.normalizeNameForRelationalTable(column.getName()));
        relCol.setLength(512);
        String prefix = this.lookupNamespacePrefix(column.getDataType().getTypeNamespace());
        DataType dataType = column.getDataType();
        if (dataType instanceof SoapDataTypeImpl) {
            SoapDataTypeImpl soapDataType = (SoapDataTypeImpl)dataType;
            String arrayNamespacePrefix = this.lookupNamespacePrefix(soapDataType.getArrayNamespace());
            StringBuffer typeBuffer = new StringBuffer();
            typeBuffer.append(this.lookupNamespacePrefix("http://www.w3.org/2001/XMLSchema"));
            typeBuffer.append(":type=\"");
            typeBuffer.append(arrayNamespacePrefix);
            typeBuffer.append(":");
            typeBuffer.append(soapDataType.getArrayName());
            typeBuffer.append("\";");
            typeBuffer.append(this.lookupNamespacePrefix("http://schemas.xmlsoap.org/soap/encoding/"));
            typeBuffer.append(":arrayType=\"");
            typeBuffer.append(arrayNamespacePrefix);
            typeBuffer.append(":");
            typeBuffer.append(soapDataType.getTypeName());
            typeBuffer.append("\";");
            typeBuffer.append(this.lookupNamespacePrefix("http://www.w3.org/2001/XMLSchema"));
            typeBuffer.append(":");
            typeBuffer.append(arrayNamespacePrefix);
            typeBuffer.append("=\"");
            typeBuffer.append(soapDataType.getArrayNamespace());
            typeBuffer.append("\"");
            relCol.setNativeType(typeBuffer.toString());
        } else {
            relCol.setNativeType(prefix + ":" + column.getDataType().getTypeName());
        }
        EObject type = this.getTypeForColumn(column);
        relCol.setType(type);
        relCol.setPrecision(12);
        if (!isRequest) {
            if (column.getOutputXPath() != null) {
                relCol.setNameInSource(column.getOutputXPath().toString());
            }
            if (column.getName().endsWith("mmid")) {
                relCol.setNullable(NullableType.NO_NULLS_LITERAL);
            }
        }
        if (isRequest) {
            this.m_extPropManager.setColumnXPathForInput(relCol, column);
        }
        if (null != column.getMultipleValues()) {
            this.m_extPropManager.setMultipleValue(relCol, column);
        }
        this.m_extPropManager.setColumnIsInputParameter(relCol, column);
        this.m_extPropManager.setAllowEmptyInputElement(relCol, column, isRequest);
        this.m_extPropManager.setRole(relCol, column);
        return relCol;
    }

    private EObject getTypeForColumn(Column column) throws ModelerCoreException {
        DatatypeManager dtMgr = ModelerCore.getBuiltInTypesManager();
        EObject type = null;
        if (column.getDataType().getTypeNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            String name = column.getDataType().getTypeName();
            type = dtMgr.getBuiltInDatatype(name);
            if (type == null) {
                type = dtMgr.getBuiltInDatatype("string");
            }
        } else {
            type = dtMgr.getBuiltInDatatype("string");
        }
        return type;
    }

    public String lookupNamespacePrefix(String namespaceURI) {
        String prefix = null;
        Iterator iter = this.m_namespaces.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!this.m_namespaces.get(key).equals(namespaceURI)) continue;
            prefix = key;
            break;
        }
        return prefix;
    }

    private void createForeignKeys() {
        Iterator keyIter = this.m_foreignKeys.iterator();
        while (keyIter.hasNext()) {
            FKWrapper wrap = (FKWrapper)keyIter.next();
            BaseTable tab = wrap.getTable();
            com.metamatrix.metamodels.relational.Column col = wrap.getColumn();
            String colName = col.getName();
            String parentTable = colName.substring(0, colName.length() - ("mmid".length() + 1));
            String catalogName = NameUtil.normalizeNameForRelationalTable(wrap.getCatalogName());
            String schemaName = NameUtil.normalizeNameForRelationalTable(wrap.getSchemaName());
            String parentTable2 = NameUtil.normalizeNameForRelationalTable(parentTable);
            BaseTable parent = (BaseTable)this.m_tables.get(catalogName + '.' + schemaName + '.' + parentTable2);
            if (null == parent) continue;
            PrimaryKey pk = parent.getPrimaryKey();
            ForeignKey fkey = RelationalPackage.eINSTANCE.getRelationalFactory().createForeignKey();
            tab.getForeignKeys().add((Object)fkey);
            fkey.setName("FK_" + parentTable);
            fkey.setUniqueKey((UniqueKey)pk);
            fkey.getColumns().add((Object)col);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FKWrapper {
        private com.metamatrix.metamodels.relational.Column m_col;
        private BaseTable m_tab;
        private String m_catalogName;
        private String m_schemaName;

        public FKWrapper(com.metamatrix.metamodels.relational.Column col, BaseTable tab, String catalogName, String schemaName) {
            this.m_col = col;
            this.m_tab = tab;
            this.m_catalogName = catalogName;
            this.m_schemaName = schemaName;
        }

        public com.metamatrix.metamodels.relational.Column getColumn() {
            return this.m_col;
        }

        public BaseTable getTable() {
            return this.m_tab;
        }

        public String getCatalogName() {
            return this.m_catalogName;
        }

        public String getSchemaName() {
            return this.m_schemaName;
        }
    }
}

