/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseBlob;
import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplBlob;
import com.metamatrix.jdbc.db2.DB2ImplClob;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDAColumn;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilJDKVersionChecker;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;

public class DRDAStatementRequest
extends DRDARequest {
    private static String footprint = "$Revision:   3.76.1.12  $";
    public BaseColumns columnDescriptions;
    public UtilPagedTempBuffer lobBuffer;
    public boolean cursorIsScrollable;
    public short cursorUpdateAbility;
    public short cursorSensitivity;
    public int[] doubleByteColumns;
    public BaseParameters parameterDescriptions;
    private UtilVectorUnsynced fdocaMap;
    private boolean hasEarlyDesc;
    public int numResultSets;
    public boolean isStoredProcedureRS;
    public DRDAPkgNamCsn[] packageNameCsnList;
    public DB2ImplResultSet[] resultSetArray;
    public boolean reExecutingWithParamInfos;
    public boolean reExecutingWithClobSubstitution;
    int[] lobColumns;
    int lobInsertPos = 0;
    public DRDAParameter lobLocParam;
    public boolean hasLobCols;
    public int lastLobColumnNum;
    public boolean processingQRYDTA = false;
    public UtilVectorUnsynced storedProcedureParams;
    public boolean hasClobColumns = false;
    int[] type;
    public int numParams;
    public short queryProtocol;
    final int[] Declets = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 10, 11, 42, 43, 74, 75, 106, 107, 78, 79, 26, 27, 58, 59, 90, 91, 122, 123, 94, 95, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 138, 139, 170, 171, 202, 203, 234, 235, 206, 207, 154, 155, 186, 187, 218, 219, 250, 251, 222, 223, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 266, 267, 298, 299, 330, 331, 362, 363, 334, 335, 282, 283, 314, 315, 346, 347, 378, 379, 350, 351, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 394, 395, 426, 427, 458, 459, 490, 491, 462, 463, 410, 411, 442, 443, 474, 475, 506, 507, 478, 479, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 522, 523, 554, 555, 586, 587, 618, 619, 590, 591, 538, 539, 570, 571, 602, 603, 634, 635, 606, 607, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 752, 753, 754, 755, 756, 757, 758, 759, 760, 761, 650, 651, 682, 683, 714, 715, 746, 747, 718, 719, 666, 667, 698, 699, 730, 731, 762, 763, 734, 735, 768, 769, 770, 771, 772, 773, 774, 775, 776, 777, 784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 778, 779, 810, 811, 842, 843, 874, 875, 846, 847, 794, 795, 826, 827, 858, 859, 890, 891, 862, 863, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 906, 907, 938, 939, 970, 971, 1002, 1003, 974, 975, 922, 923, 954, 955, 986, 987, 1018, 1019, 990, 991, 12, 13, 268, 269, 524, 525, 780, 781, 46, 47, 28, 29, 284, 285, 540, 541, 796, 797, 62, 63, 44, 45, 300, 301, 556, 557, 812, 813, 302, 303, 60, 61, 316, 317, 572, 573, 828, 829, 318, 319, 76, 77, 332, 333, 588, 589, 844, 845, 558, 559, 92, 93, 348, 349, 604, 605, 860, 861, 574, 575, 108, 109, 364, 365, 620, 621, 876, 877, 814, 815, 124, 125, 380, 381, 636, 637, 892, 893, 830, 831, 14, 15, 270, 271, 526, 527, 782, 783, 110, 111, 30, 31, 286, 287, 542, 543, 798, 799, 126, 127, 140, 141, 396, 397, 652, 653, 908, 909, 174, 175, 156, 157, 412, 413, 668, 669, 924, 925, 190, 191, 172, 173, 428, 429, 684, 685, 940, 941, 430, 431, 188, 189, 444, 445, 700, 701, 956, 957, 446, 447, 204, 205, 460, 461, 716, 717, 972, 973, 686, 687, 220, 221, 476, 477, 732, 733, 988, 989, 702, 703, 236, 237, 492, 493, 748, 749, 1004, 1005, 942, 943, 252, 253, 508, 509, 764, 765, 1020, 1021, 958, 959, 142, 143, 398, 399, 654, 655, 910, 911, 238, 239, 158, 159, 414, 415, 670, 671, 926, 927, 254, 255};

    public DRDAStatementRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter, DRDAPkgNamCsn dRDAPkgNamCsn) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
        this.packageConsistencyToken = dRDAPkgNamCsn;
        this.chainCommit = true;
        this.hasLobCols = false;
    }

    public void setParameters(BaseParameters baseParameters) {
        this.parameterDescriptions = baseParameters;
        if (baseParameters != null) {
            this.numParams = this.parameterDescriptions.count();
        }
        this.lobInsertPos = 0;
        if (this.lobColumns != null) {
            for (int i = 0; i < this.lobColumns.length - 1; ++i) {
                this.lobColumns[i] = 0;
            }
        }
    }

    public BaseColumns getColumns() {
        return new BaseColumns();
    }

    public void setToPrepared() throws SQLException {
        try {
            this.clearExceptions();
            this.storedProcedureParams = null;
            this.writer.empty();
            this.lobLocParam = null;
            this.lobInsertPos = 0;
            this.fdocaMap = null;
            this.hasEarlyDesc = false;
            this.numRowsAffected = 0;
            this.checkingForAdditionalUpdateCounts = false;
            this.processingQRYDTA = false;
            this.isCursorOpen = false;
            this.isStoredProcedure = false;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void reset() throws SQLException {
        this.clearExceptions();
        this.chainCommit = true;
        this.hasClobColumns = false;
        this.lastLobColumnNum = 0;
        this.columnDescriptions = null;
        this.isStoredProcedure = false;
        this.lobLocParam = null;
        this.numResultSets = 0;
        this.packageNameCsnList = null;
        this.parameterDescriptions = null;
        this.reExecutingWithClobSubstitution = false;
        this.reExecutingWithParamInfos = false;
        this.resultSetArray = null;
        if (this.storedProcedureParams != null) {
            this.storedProcedureParams.clear();
        }
        this.lobColumns = null;
        this.lobInsertPos = 0;
        if (this.fdocaMap != null) {
            this.fdocaMap.clear();
        }
        this.hasEarlyDesc = false;
    }

    public final void writePRPSQLSTT(String string, boolean bl, boolean bl2) throws SQLException {
        try {
            int n;
            int n2;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n2 = this.writer.writePacketHeader((short)1, (short)64, 1);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n2 = 2;
            }
            n = this.writer.writePacketHeader((short)1, (short)80, n2);
            int n3 = this.writer.writeCodePoint((short)8205);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8470);
            if (bl) {
                this.writer.writeInt8(241);
                if (this.comm.supportsExtendedTypSQLDA) {
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(8518);
                    this.writer.writeInt8(4);
                }
            } else {
                this.writer.writeInt8(240);
            }
            this.writer.writeCodePointLength(n3);
            this.writer.writePacketLength(n);
            int n4 = 0;
            short s = 3;
            if (this.comm.encryptData) {
                s = 4;
            }
            n4 = bl2 ? this.writer.writePacketHeader(s, (short)0, n2) : this.writer.writePacketHeader(s, (short)64, n2);
            int n5 = this.writer.writeCodePoint((short)9236);
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt8(0);
                this.writer.writeEncodedStringWithLength32(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt8(255);
            } else if (this.comm.serverType == 2) {
                this.writer.writeInt16(0);
                this.writer.writeEncodedStringWithLength16(string, this.comm.SingleByteClientTransliterator);
            } else {
                this.writer.writeEncodedStringWithLength16(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt16(0);
            }
            this.writer.writeCodePointLength(n5);
            if (this.comm.encryptData) {
                this.writer.writeEncryptedPacketLength(n4);
            } else {
                this.writer.writePacketLength(n4);
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public final void writeDSCSQLSTT() throws SQLException {
        try {
            int n;
            int n2;
            int n3 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n4 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n4);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = this.writer.writePacketHeader((short)1, (short)0, n3);
            n = this.writer.writeCodePoint((short)8200);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8518);
            if (this.comm.supportsExtendedTypSQLDA) {
                this.writer.writeInt8(5);
            } else {
                this.writer.writeInt8(1);
            }
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public final void writeFDODSC() throws UtilException, SQLException {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.numParams;
            boolean bl = false;
            boolean bl2 = false;
            int n5 = this.comm.drdaUtil.getRowLength(this.parameterDescriptions, this.numParams, this.comm.exceptions, this.implConn.db2Connection, this.doubleByteColumns);
            boolean bl3 = false;
            if (n5 > 32000 && this.comm.enableFullSizeLobs && this.comm.allowsInsertIntoVarcharAsClob) {
                bl2 = true;
            }
            if (n4 > 84) {
                this.lobColumns = new int[n4];
                bl2 = false;
                n2 = n4 / 84;
                n3 = n4 % 84;
                if (n3 == 0) {
                    --n2;
                    n3 = 84;
                }
                n = 255;
            } else {
                n = n4 * 3 + 3;
            }
            this.writer.writeInt8(n);
            this.writer.writeBytes(DRDAConstants.GDA);
            for (int i = 0; i < n4; ++i) {
                int n6;
                bl = false;
                if (n2 != 0 && i % 84 == 0 && i != 0) {
                    n6 = 0;
                    n6 = n2 > 1 ? 255 : 3 * n3 + 3;
                    this.writer.writeInt8(n6);
                    this.writer.writeInt8(127);
                    this.writer.writeInt8(0);
                    --n2;
                }
                n6 = i + 1;
                BaseParameter baseParameter = this.parameterDescriptions.getInput(n6);
                BaseParameterInfo baseParameterInfo = this.parameterDescriptions.getParameterInfoOrNull(i);
                if (baseParameter == null) {
                    baseParameter = this.parameterDescriptions.getOutput(n6);
                    bl = true;
                } else if (this.isStoredProcedure) {
                    BaseParameter baseParameter2 = this.parameterDescriptions.getOutput(n6);
                    if (baseParameter2 != null) {
                        bl = true;
                    }
                    if (baseParameterInfo == null) {
                        baseParameterInfo = this.parameterDescriptions.getParameterInfo(i);
                    }
                    if (baseParameter.sqlType != -3 && baseParameter.sqlType != -2 && baseParameter.sqlType != -4 && baseParameter.sqlType != 2004) {
                        baseParameter.sqlType = baseParameterInfo.sqlType;
                        baseParameter.scale = baseParameterInfo.scale;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("CHAR")) {
                        baseParameter.sqlType = -2;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("VARCHAR")) {
                        baseParameter.sqlType = -3;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("BLOB")) {
                        baseParameter.sqlType = 2004;
                        baseParameterInfo.sqlType = 2004;
                    } else {
                        baseParameter.sqlType = -4;
                    }
                }
                int n7 = 0;
                int n8 = -1;
                int n9 = 0;
                boolean bl4 = false;
                n9 = baseParameter.scale <= 0 ? 0 : (baseParameter.sqlType == 3 || baseParameter.sqlType == 2 ? baseParameter.scale : 0);
                if (baseParameter != null) {
                    switch (baseParameter.sqlType) {
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            long l = 0L;
                            boolean bl5 = true;
                            if (!baseParameter.isNull()) {
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 20: {
                                        if (this.doubleByteColumns != null && this.doubleByteColumns[i] != 0) {
                                            if (baseParameter.getType() == 17) {
                                                l = ((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions)).determineLength();
                                                break;
                                            }
                                            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
                                            baseParameter.setData((Object)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions));
                                            l = ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                            this.comm.DoubleByteClientTransliterator.encode(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)l, utilPagedTempBuffer.getOutputStream());
                                            l = utilPagedTempBuffer.getSize() / 2L;
                                            baseParameter.setData(17, (Object)new BaseInputStreamWrapper(utilPagedTempBuffer.getInputStream(), utilPagedTempBuffer.getSize(), (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions));
                                            break;
                                        }
                                        if (baseParameter.getType() == 16) {
                                            l = ((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions)).determineLength();
                                            break;
                                        }
                                        UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
                                        l = ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                        this.comm.MultiByteClientTransliterator.encode(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)l, utilPagedTempBuffer.getOutputStream());
                                        l = utilPagedTempBuffer.getSize();
                                        baseParameter.setData(16, (Object)new BaseInputStreamWrapper(utilPagedTempBuffer.getInputStream(), utilPagedTempBuffer.getSize(), (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions));
                                        break;
                                    }
                                    case 2: {
                                        l = ((byte[])baseParameter.getObject()).length;
                                        break;
                                    }
                                    default: {
                                        if (this.lobLocParam != null) {
                                            baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                            l = baseParameter.getBytes(-1, this.comm.exceptions).length;
                                            break;
                                        }
                                        String string = baseParameter.getString(-1, this.comm.exceptions);
                                        if (this.comm.useMultiByteCPForParams) {
                                            baseParameter.setBytes(BaseParameter.stringToBytes((String)string, (UtilTransliterator)this.comm.MultiByteClientTransliterator, (BaseExceptions)this.comm.exceptions));
                                        } else {
                                            baseParameter.setBytes(BaseParameter.stringToBytes((String)string, (UtilTransliterator)this.comm.SingleByteClientTransliterator, (BaseExceptions)this.comm.exceptions));
                                        }
                                        l = baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    }
                                }
                            }
                            if (this.doubleByteColumns != null && this.doubleByteColumns[i] != 0) {
                                if (this.doubleByteColumns[i] == 412 || this.doubleByteColumns[i] == 413 && l != 0L) {
                                    baseParameter.sqlType = 2005;
                                    if (this.lobColumns == null) {
                                        this.lobColumns = new int[84];
                                    }
                                    if (!baseParameter.isNull()) {
                                        this.lobColumns[this.lobInsertPos++] = n6;
                                    }
                                } else {
                                    if (l == 0L) {
                                        bl3 = true;
                                    }
                                    baseParameter.sqlType = -1;
                                }
                            } else if ((l <= 32704L || this.comm.serverOS == 8 && l <= 32740L) && !bl2) {
                                if (this.isStoredProcedure && !bl && l <= 254L && l != 0L) {
                                    if (!baseParameter.isNull() && baseParameterInfo.sqlType != 12 && baseParameterInfo.sqlType != -1) {
                                        baseParameter.sqlType = 1;
                                        bl5 = false;
                                    }
                                } else {
                                    baseParameter.sqlType = -1;
                                }
                            } else if (!this.comm.enableFullSizeLobs || l == 0L) {
                                baseParameter.sqlType = -1;
                            } else {
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 20: {
                                        break;
                                    }
                                    default: {
                                        if (baseParameter.isNull) break;
                                        baseParameter.setBinaryStream(baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions));
                                    }
                                }
                                baseParameter.sqlType = 2005;
                                if (this.lobColumns == null) {
                                    this.lobColumns = new int[84];
                                }
                                if (!baseParameter.isNull()) {
                                    this.lobColumns[this.lobInsertPos++] = n6;
                                }
                            }
                            boolean bl6 = this.doubleByteColumns != null && this.doubleByteColumns[i] != 0;
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, bl6, bl3);
                            n7 = this.type[0];
                            int n10 = this.type[1];
                            n8 = bl5 ? n10 : (int)l;
                            if (this.lobLocParam != null) {
                                n7 = this.lobLocParam.fdocaType;
                                n8 = this.lobLocParam.fdocaLen;
                                baseParameter.sqlType = -2;
                                baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                            }
                            bl4 = true;
                            bl3 = false;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            long l = 0L;
                            if (baseParameterInfo != null) {
                                baseParameter.sqlType = baseParameterInfo.sqlType;
                                if (baseParameterInfo.nativeTypeName == "ROWID") {
                                    baseParameter.nativeType = 30;
                                }
                            }
                            if (!baseParameter.isNull()) {
                                switch (baseParameter.getType()) {
                                    case 2: {
                                        l += (long)baseParameter.getBytes(-1, this.comm.exceptions).length;
                                        break;
                                    }
                                    case 19: {
                                        l += ((BaseBlob)baseParameter.getObject()).length();
                                        break;
                                    }
                                    case 14: {
                                        l += ((BaseInputStreamWrapper)baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                        break;
                                    }
                                    default: {
                                        baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                        l += (long)baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    }
                                }
                            }
                            if (baseParameter.getType() == 14 && this.comm.sendStreamAsBlob) {
                                baseParameter.sqlType = 2004;
                            }
                            if (l <= 32704L && baseParameter.sqlType != 2004) {
                                baseParameter.sqlType = -4;
                            } else if (this.comm.enableFullSizeLobs) {
                                baseParameter.sqlType = 2004;
                                if (this.lobColumns == null) {
                                    this.lobColumns = new int[84];
                                }
                                if (!baseParameter.isNull() && l != 0L) {
                                    this.lobColumns[this.lobInsertPos++] = n6;
                                }
                            } else {
                                baseParameter.sqlType = -4;
                            }
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                            n7 = this.type[0];
                            n8 = this.type[1];
                            if (this.lobLocParam != null) {
                                n7 = this.lobLocParam.fdocaType;
                                n8 = this.lobLocParam.fdocaLen;
                                baseParameter.sqlType = -2;
                                baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                            }
                            bl4 = true;
                            break;
                        }
                        case 6: 
                        case 8: {
                            if (!this.comm.supportsDECFLOAT) break;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            boolean bl5 = false;
                            byte[] byArray = new byte[16];
                            if (baseParameter.getType() == 7) {
                                double d = baseParameter.getDoubleNoConvert();
                                if (d == Double.POSITIVE_INFINITY) {
                                    bl7 = true;
                                } else if (d == Double.NEGATIVE_INFINITY) {
                                    bl7 = true;
                                    bl5 = true;
                                } else if (Double.doubleToLongBits(d) == 9221120237041090560L) {
                                    bl8 = true;
                                }
                            } else if (baseParameter.getType() == 6) {
                                float f = baseParameter.getFloatNoConvert();
                                if (f == Float.POSITIVE_INFINITY) {
                                    bl7 = true;
                                } else if (f == Float.NEGATIVE_INFINITY) {
                                    bl7 = true;
                                }
                                if (f == Float.NaN) {
                                    bl8 = true;
                                }
                            }
                            if (!bl7 && !bl8) break;
                            n9 = 0;
                            n8 = 16;
                            bl4 = true;
                            n7 = 187;
                            if (bl7) {
                                byArray[0] = bl5 ? -8 : 120;
                            } else if (bl8) {
                                byArray[0] = 124;
                            }
                            baseParameter.setData(2, (Object)byArray);
                            break;
                        }
                        case 2: 
                        case 3: {
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                            n7 = this.type[0];
                            if (baseParameter.isNull()) {
                                if (bl) {
                                    BaseParameterInfo baseParameterInfo2 = this.parameterDescriptions.getParameterInfo(i);
                                    n9 = baseParameterInfo2.scale;
                                    n8 = baseParameterInfo2.precision;
                                    if (baseParameterInfo2.nativeTypeName.compareTo("DECFLOAT") == 0) {
                                        n7 = 187;
                                    }
                                } else {
                                    n8 = this.comm.serverOS == 8 ? 31 : 0;
                                    n9 = 0;
                                }
                                baseParameter.setNull(8);
                                break;
                            }
                            if (baseParameter.getType() == 2) {
                                if (baseParameter.getBytesNoConvert().length == 16) {
                                    n9 = 0;
                                    n8 = 16;
                                    bl4 = true;
                                    n7 = 187;
                                    break;
                                }
                                n9 = baseParameter.scale;
                                n8 = baseParameter.getBytes(-1, this.comm.exceptions).length * 2 - 1;
                                break;
                            }
                            boolean bl9 = false;
                            boolean bl8 = false;
                            boolean bl5 = false;
                            byte[] byArray = new byte[16];
                            BigDecimal bigDecimal = new BigDecimal(0.0);
                            if (baseParameter.getType() == 7) {
                                double d = baseParameter.getDoubleNoConvert();
                                if (d == Double.POSITIVE_INFINITY) {
                                    bl9 = true;
                                } else if (d == Double.NEGATIVE_INFINITY) {
                                    bl9 = true;
                                    bl5 = true;
                                } else if (Double.doubleToLongBits(d) == 9221120237041090560L) {
                                    bl8 = true;
                                }
                            } else if (baseParameter.getType() == 6) {
                                float f = baseParameter.getFloatNoConvert();
                                if (f == Float.POSITIVE_INFINITY) {
                                    bl9 = true;
                                } else if (f == Float.NEGATIVE_INFINITY) {
                                    bl9 = true;
                                    bl5 = true;
                                }
                                if (Float.floatToIntBits(f) == 2143289344) {
                                    bl8 = true;
                                }
                            }
                            if (bl9 || bl8) {
                                n9 = 0;
                                n8 = 16;
                                bl4 = true;
                                n7 = 187;
                                if (bl9) {
                                    byArray[0] = bl5 ? -8 : 120;
                                } else if (bl8) {
                                    byArray[0] = 124;
                                }
                                baseParameter.setData(2, (Object)byArray);
                                break;
                            }
                            baseParameter.setBigDecimal(baseParameter.getBigDecimal(this.comm.exceptions));
                            bigDecimal = baseParameter.getBigDecimal(this.comm.exceptions);
                            BigInteger bigInteger = bigDecimal.unscaledValue();
                            String string = bigInteger.toString();
                            int n15 = string.length();
                            if (baseParameterInfo != null && baseParameterInfo.nativeTypeName.equals("DECFLOAT")) {
                                baseParameterInfo.precision = baseParameterInfo.precision == 8 ? 16 : 34;
                            }
                            boolean bl10 = bl5 = bigDecimal.signum() == -1;
                            if (bl5) {
                                --n15;
                            }
                            baseParameter.scale = bigDecimal.scale();
                            n9 = bigDecimal.scale();
                            n8 = 0;
                            if (this.comm.supportsDECFLOAT && (bigDecimal.scale() > 13 || bigDecimal.scale() < -31 || n15 > 31 && !bl9 && !bl8)) {
                                int n16;
                                n9 = 0;
                                n8 = 16;
                                bl4 = true;
                                n7 = 187;
                                int n17 = bigDecimal.scale();
                                n17 *= -1;
                                if ((n17 += 6176) < 0 || n17 > 12287) {
                                    throw this.comm.exceptions.getException(6104, "22003");
                                }
                                n14 = (n17 & 0x3000) >> 12;
                                n13 = n17 & 0xFFF;
                                n12 = 0;
                                if (bl5) {
                                    n12 = 1;
                                }
                                if (n15 > 34) {
                                    n15 = 34;
                                }
                                n11 = n15 > 33 ? string.charAt(n12) - 48 & 0xFFFFFFFF : 0;
                                int n18 = n17 > 12287 ? 30 : (n11 > 7 ? 0x18 | n14 << 1 | n11 & 1 : n14 << 3 | n11 & 7);
                                int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                                int n19 = n15 - 1;
                                for (n16 = 10; n16 >= 0 && n19 >= 0; --n16) {
                                    int n20 = string.charAt(n12 + n19--) - 48 & 0xFFFFFFFF;
                                    int n21 = n19 >= 0 ? string.charAt(n12 + n19--) - 48 & 0xFFFFFFFF : 0;
                                    int n22 = n19 >= 0 ? string.charAt(n12 + n19--) - 48 & 0xFFFFFFFF : 0;
                                    int n23 = n22 * 100 + n21 * 10 + n20;
                                    nArray[n16] = this.Declets[n23];
                                }
                                if (bl5) {
                                    byArray[0] = -128;
                                }
                                byArray[0] = (byte)(byArray[0] | n18 << 2);
                                byArray[0] = (byte)(byArray[0] | n13 >> 10 & 3);
                                byArray[1] = (byte)(byArray[1] | (n13 & 0x3FC) >> 2);
                                byArray[2] = (byte)(byArray[2] | (n13 & 3) << 6);
                                for (n16 = 0; n16 < 11; ++n16) {
                                    if (nArray[n16] == 0) continue;
                                    int n24 = 2 + n16 + (n16 + 1) / 4;
                                    int n25 = n24 + 1;
                                    int n26 = (n16 + 1) % 4 * 2 + 2;
                                    int n27 = 10 - n26;
                                    int n28 = n26;
                                    int n29 = 8 - n26;
                                    int n30 = 1023 << n26;
                                    int n31 = 1023 >>> n27;
                                    int n32 = n24;
                                    byArray[n32] = (byte)(byArray[n32] | (byte)((nArray[n16] & n30) >> n28 & 0xFF));
                                    int n33 = n25;
                                    byArray[n33] = (byte)(byArray[n33] | (byte)((nArray[n16] & n31) << n29 & 0xFF));
                                }
                                baseParameter.setData(2, (Object)byArray);
                                break;
                            }
                            StringBuffer stringBuffer = null;
                            stringBuffer = (double)UtilJDKVersionChecker.getJVMVersion() >= 1.5 ? new StringBuffer(this.drdaUtil.bigDecToPlainString(bigDecimal)) : new StringBuffer(bigDecimal.toString());
                            if (stringBuffer.charAt(0) == '-') {
                                stringBuffer.append('D');
                            } else {
                                stringBuffer.append('C');
                            }
                            for (n14 = 0; n14 < stringBuffer.length(); ++n14) {
                                if (stringBuffer.charAt(n14) != '.' && stringBuffer.charAt(n14) != '-') continue;
                                stringBuffer.deleteCharAt(n14);
                            }
                            n8 = stringBuffer.length() - 1;
                            if (this.isStoredProcedure) {
                                n8 = baseParameterInfo.precision;
                                n9 = baseParameter.scale > baseParameterInfo.scale ? baseParameter.scale : baseParameterInfo.scale;
                                n14 = baseParameterInfo.scale - bigDecimal.scale();
                                n13 = stringBuffer.length() - 1;
                                for (n11 = 0; n11 < n14; ++n11) {
                                    stringBuffer.insert(n13, 0);
                                }
                                n11 = n8 - (stringBuffer.length() - 1);
                                for (n12 = 0; n12 < n11; ++n12) {
                                    stringBuffer.insert(0, 0);
                                }
                            }
                            if (stringBuffer.length() % 2 != 0) {
                                stringBuffer.insert(0, 0);
                            }
                            baseParameter.setData(2, (Object)this.drdaUtil.convertStringBufferToDRDADecimal(stringBuffer));
                            break;
                        }
                        case -7: 
                        case -6: 
                        case 16: {
                            baseParameter.sqlType = 5;
                        }
                        case 5: {
                            n9 = 0;
                            break;
                        }
                        case 7: {
                            boolean bl8;
                            boolean bl5;
                            if (!baseParameter.isNull()) {
                                if (baseParameter.getType() == 6 && !this.isStoredProcedure) {
                                    baseParameter.setDouble(baseParameter.getDouble(this.comm.exceptions));
                                    baseParameter.sqlType = 6;
                                    if (!this.comm.supportsDECFLOAT) break;
                                    boolean bl11 = false;
                                    bl8 = false;
                                    bl5 = false;
                                    byte[] byArray = new byte[16];
                                    if (baseParameter.getType() == 7) {
                                        double d = baseParameter.getDoubleNoConvert();
                                        if (d == Double.POSITIVE_INFINITY) {
                                            bl11 = true;
                                        } else if (d == Double.NEGATIVE_INFINITY) {
                                            bl11 = true;
                                            bl5 = true;
                                        } else if (Double.doubleToLongBits(d) == 9221120237041090560L) {
                                            bl8 = true;
                                        }
                                    } else if (baseParameter.getType() == 6) {
                                        float f = baseParameter.getFloatNoConvert();
                                        if (f == Float.POSITIVE_INFINITY) {
                                            bl11 = true;
                                        } else if (f == Float.NEGATIVE_INFINITY) {
                                            bl11 = true;
                                        }
                                        if (f == Float.NaN) {
                                            bl8 = true;
                                        }
                                    }
                                    if (!bl11 && !bl8) break;
                                    n9 = 0;
                                    n8 = 16;
                                    bl4 = true;
                                    n7 = 187;
                                    if (bl11) {
                                        byArray[0] = bl5 ? -8 : 120;
                                    } else if (bl8) {
                                        byArray[0] = 124;
                                    }
                                    baseParameter.setData(2, (Object)byArray);
                                    break;
                                }
                                baseParameter.setFloat(baseParameter.getFloat(this.comm.exceptions));
                                break;
                            }
                            baseParameter.setNull(6);
                            break;
                        }
                        case -5: {
                            bl4 = true;
                            break;
                        }
                    }
                }
                if (n8 == -1) {
                    this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                    n7 = this.type[0];
                    n8 = this.type[1];
                }
                this.writer.writeInt8(n7);
                baseParameter.nativeType = n7;
                if (bl4) {
                    if (!this.comm.isServerBigEndianOS) {
                        this.reader.interpretAsBigEndian = false;
                    }
                    this.writer.writeInt16(n8);
                } else if (baseParameter.sqlType == 3 || baseParameter.sqlType == 2) {
                    this.writer.writeInt8(n8);
                    this.writer.writeInt8(n9);
                } else {
                    this.writer.writeInt8(n9);
                    this.writer.writeInt8(n8);
                }
                this.reader.interpretAsBigEndian = true;
            }
            this.writer.writeBytes(DRDAConstants.ROWDESC);
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
    }

    public final void writeFDODTA() throws SQLException {
        try {
            boolean bl = false;
            this.writer.writeInt8(0);
            block32: for (int i = 0; i < this.numParams; ++i) {
                bl = false;
                int n = i + 1;
                BaseParameter baseParameter = this.parameterDescriptions.get(n, 1);
                if (baseParameter == null) {
                    baseParameter = this.parameterDescriptions.get(n, 2);
                    bl = true;
                }
                if (baseParameter == null) continue;
                if (baseParameter.isNull()) {
                    this.writer.writeInt8(255);
                    continue;
                }
                if (this.lobLocParam != null) {
                    if (this.lobLocParam.fdocaType % 2 != 0) {
                        this.writer.writeInt8(0);
                    }
                } else {
                    this.writer.writeInt8(0);
                }
                switch (baseParameter.sqlType) {
                    case 2004: {
                        baseParameter.setBinaryStream(baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions));
                        if (this.comm.SQLAMLevel >= 8) {
                            this.writer.writeInt8(2);
                            this.writer.writeInt64((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                            continue block32;
                        }
                        this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                        continue block32;
                    }
                    case 2005: {
                        if (this.comm.SQLAMLevel >= 8) {
                            this.writer.writeInt8(2);
                            if (this.doubleByteColumns != null && this.doubleByteColumns[i] != 0) {
                                this.writer.writeInt64((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength() / 2);
                                continue block32;
                            }
                            this.writer.writeInt64((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                            continue block32;
                        }
                        if (this.doubleByteColumns != null && this.doubleByteColumns[i] != 0) {
                            this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength() / 2);
                            continue block32;
                        }
                        this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                        continue block32;
                    }
                    case -7: {
                        if (baseParameter.getBoolean(this.comm.exceptions)) {
                            if (this.comm.serverOS == 3 || this.comm.serverOS == 8) {
                                this.writer.writeInt8(49);
                                continue block32;
                            }
                            this.writer.writeInt8(241);
                            continue block32;
                        }
                        if (this.comm.serverOS == 3 || this.comm.serverOS == 8) {
                            this.writer.writeInt8(48);
                            continue block32;
                        }
                        this.writer.writeInt8(240);
                        continue block32;
                    }
                    case 5: {
                        this.writer.writeInt16(baseParameter.getShort(this.comm.exceptions));
                        continue block32;
                    }
                    case 4: {
                        this.writer.writeInt32(baseParameter.getInteger(this.comm.exceptions));
                        continue block32;
                    }
                    case -5: {
                        if (baseParameter.nativeType == 23 || baseParameter.nativeType == 22) {
                            this.writer.writeInt64(baseParameter.getLong(this.comm.exceptions));
                            continue block32;
                        }
                        this.writer.writeIEEE64BitDouble(baseParameter.getDouble(this.comm.exceptions));
                        continue block32;
                    }
                    case 6: 
                    case 8: {
                        if (baseParameter.nativeType == 187 || baseParameter.nativeType == 186) {
                            this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                            continue block32;
                        }
                        this.writer.writeIEEE64BitDouble(baseParameter.getDouble(this.comm.exceptions));
                        continue block32;
                    }
                    case 7: {
                        this.writer.writeIEEE32BitFloat(baseParameter.getFloat(this.comm.exceptions));
                        continue block32;
                    }
                    case 2: 
                    case 3: {
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case 91: {
                        this.writer.writeEncodedString(baseParameter.getDate(this.comm.exceptions).toString(), this.comm.SingleByteClientTransliterator);
                        continue block32;
                    }
                    case 92: {
                        Object object = new StringBuffer(baseParameter.getTime(this.comm.exceptions).toString());
                        ((StringBuffer)object).setCharAt(2, '.');
                        ((StringBuffer)object).setCharAt(5, '.');
                        this.writer.writeEncodedString(((StringBuffer)object).toString(), this.comm.SingleByteClientTransliterator);
                        continue block32;
                    }
                    case 93: {
                        Object object = baseParameter.getTimestamp(this.comm.exceptions);
                        String string = object.toString();
                        int n2 = 20;
                        String string2 = string.substring(string.lastIndexOf(".") + 1);
                        if (string.length() > n2) {
                            string = string.substring(0, n2);
                        }
                        if (string2.length() > 6) {
                            string2 = string2.substring(0, 6);
                        } else {
                            while (string2.length() < 6) {
                                string2 = string2 + "0";
                            }
                        }
                        StringBuffer stringBuffer = new StringBuffer(string + string2);
                        stringBuffer.setCharAt(10, '-');
                        stringBuffer.setCharAt(13, '.');
                        stringBuffer.setCharAt(16, '.');
                        this.writer.writeEncodedString(stringBuffer.toString(), this.comm.SingleByteClientTransliterator);
                        continue block32;
                    }
                    case 1: {
                        switch (baseParameter.getType()) {
                            case 18: {
                                this.writer.writeReader(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 16: {
                                this.writer.writeStream(baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 15: {
                                this.writer.writeStream(baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 17: {
                                this.writer.writeStream(baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                        }
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case -1: 
                    case 12: {
                        switch (baseParameter.getType()) {
                            case 18: {
                                this.writer.writeReaderWithLength16(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 16: {
                                this.writer.writeStreamWithLength16(baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 15: {
                                this.writer.writeStreamWithLength16(baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 17: {
                                this.writer.writeStreamWithLength16(baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                        }
                        this.writer.writeInt16(baseParameter.getBytes(-1, this.comm.exceptions).length);
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case -2: {
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case -4: 
                    case -3: {
                        if (baseParameter.getType() == 14) {
                            this.writer.writeStreamWithLength16(baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                            continue block32;
                        }
                        this.writer.writeInt16(baseParameter.getBytes(-1, this.comm.exceptions).length);
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                    }
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 9242: {
                    this.processFDODSC(n, false);
                    break;
                }
                case 9227: {
                    this.processSQLCINRD();
                    break;
                }
                case 8450: {
                    this.queryProtocol = this.reader.readInt16();
                    break;
                }
                case 8709: {
                    this.isCursorOpen = true;
                    this.moreData = true;
                    break;
                }
                case 8521: {
                    if (this.reader.readInt8() == 241) {
                        this.cursorIsScrollable = true;
                        break;
                    }
                    this.cursorIsScrollable = false;
                    break;
                }
                case 8528: {
                    this.cursorUpdateAbility = this.reader.readInt8();
                    break;
                }
                case 8535: {
                    this.cursorSensitivity = this.reader.readInt8();
                    break;
                }
                case 9243: {
                    if ((short)(n + 4) == -32760) {
                        n = this.reader.readInt32();
                    }
                    this.processingQRYDTA = true;
                    if (this.processMode == 1 || this.processMode == 0) {
                        return false;
                    }
                    break;
                }
                case 8706: {
                    this.isCursorOpen = false;
                    if (this.continuingQuery) {
                        this.exception = this.comm.exceptions.getException(7080);
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 8716: {
                    break;
                }
                case 8715: 
                case 8722: {
                    this.moreData = false;
                    break;
                }
                case 8719: {
                    this.reader.readAndDiscardBytes(n);
                    this.isCursorOpen = false;
                    this.moreData = false;
                    break;
                }
                case 8479: {
                    if (this.reader.readUnsignedInt8() == 241) {
                        this.isCursorHeldOpen = true;
                    }
                    break;
                }
                case 8469: {
                    this.implConn.endUnitOfWork(this.reader.readInt8());
                    break;
                }
                case 9233: {
                    if (n == 32772) {
                        this.reader.readAndDiscardBytes(4);
                    }
                    this.processSQLCA(baseWarnings);
                    if (this.comm.SQLAMLevel >= 7) {
                        this.processSQLDH(baseWarnings);
                    }
                    this.processSQLDA(baseWarnings);
                    return this.processMode != 3;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        return true;
    }

    public void processEXTDTAParam(DRDAParameter dRDAParameter, boolean bl) throws SQLException {
        try {
            int n = new Long(dRDAParameter.lobLength).intValue();
            boolean bl2 = false;
            if (n != 0) {
                int n2 = 0;
                short s = this.reader.readInt16();
                this.reader.readAndDiscardBytes(2);
                n2 = s == -32760 ? this.reader.readInt32() : (s == -32764 ? -1 : s - 4);
                if (dRDAParameter.isNullable && this.comm.SQLAMLevel >= 7) {
                    bl2 = this.reader.readUnsignedInt8() == 255;
                    --n2;
                }
                if (bl) {
                    this.reader.readAndDiscardBytes(n2);
                } else {
                    long l = 0L;
                    this.lobBuffer = new UtilPagedTempBuffer();
                    if (!bl2) {
                        if (dRDAParameter.baseParam.sqlType == 2005) {
                            this.lobBuffer = this.cacheEXTDTA(dRDAParameter.baseParam.sqlType, dRDAParameter.baseParam.transliterator, n2);
                            dRDAParameter.baseParam.setData(20, (Object)new DB2ImplClob(this.implConn, this.lobBuffer));
                        } else {
                            this.lobBuffer = this.cacheEXTDTA(dRDAParameter.baseParam.sqlType, null, n2);
                            dRDAParameter.baseParam.setData(19, (Object)new DB2ImplBlob(n, this.implConn, this.lobBuffer));
                        }
                    } else if (dRDAParameter.baseParam.sqlType == 2005) {
                        dRDAParameter.baseParam.setData(20, (Object)new DB2ImplClob(this.implConn, this.lobBuffer));
                    } else {
                        dRDAParameter.baseParam.setData(19, (Object)new DB2ImplBlob(0L, this.implConn, this.lobBuffer));
                    }
                }
            } else {
                this.lobBuffer = new UtilPagedTempBuffer();
                if (dRDAParameter.baseParam.sqlType == 2005) {
                    dRDAParameter.baseParam.setData(20, (Object)new DB2ImplClob(this.implConn, this.lobBuffer));
                } else {
                    dRDAParameter.baseParam.setData(19, (Object)new DB2ImplBlob(0L, this.implConn, this.lobBuffer));
                }
            }
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
        dRDAParameter.readExtendedData = true;
    }

    public final void processFDODSC(int n, boolean bl) throws UtilException, SQLException {
        int n2 = n;
        String[] stringArray = new String[1];
        boolean bl2 = true;
        do {
            int n3 = this.reader.readUnsignedInt8asInt();
            byte by = this.reader.readInt8();
            n3 -= 2;
            n2 -= 2;
            switch (by) {
                case 118: {
                    this.reader.readAndDiscardBytes(1);
                    --n2;
                    if (bl) {
                        n2 -= this.updateParameterDescriptions();
                        break;
                    }
                    n2 -= this.updateColumnDescriptions();
                    break;
                }
                case 127: {
                    if (bl) {
                        n2 -= this.updateParameterDescriptions();
                        break;
                    }
                    n2 -= this.updateColumnDescriptions();
                    break;
                }
                case 120: {
                    short s;
                    short s2 = this.reader.readInt16();
                    n2 -= 2;
                    byte[] byArray = new byte[2];
                    this.reader.readBytes(byArray, 0, byArray.length);
                    n2 -= byArray.length;
                    if (byArray[0] != 1) {
                        s = this.reader.readInt8();
                        --n2;
                        break;
                    }
                    s = this.reader.readUnsignedInt8();
                    byte by2 = this.reader.readInt8();
                    byte by3 = this.reader.readInt8();
                    int[] nArray = new int[]{this.reader.readUnsignedInt8(), s, this.reader.readUnsignedInt8(), this.reader.readInt32(), this.reader.readInt8(), this.reader.readInt8(), this.reader.readUnsignedInt16()};
                    if (this.fdocaMap == null) {
                        this.fdocaMap = new UtilVectorUnsynced();
                    }
                    int n4 = this.fdocaMap.size();
                    for (int i = 0; i < n4; ++i) {
                        if (((int[])this.fdocaMap.get(i))[0] != nArray[0]) continue;
                        this.fdocaMap.set(i, (Object)nArray);
                    }
                    this.fdocaMap.addElement((Object)nArray);
                    this.hasEarlyDesc = true;
                    n2 -= 13;
                    break;
                }
                case 112: 
                case 113: {
                    this.reader.readAndDiscardBytes(n3);
                    n2 -= n3;
                    break;
                }
                default: {
                    stringArray[0] = Integer.toHexString(by);
                    this.exception = this.comm.exceptions.getException(7073, stringArray);
                    this.reader.readAndDiscardBytes(n3);
                    n2 -= n3;
                }
            }
        } while (n2 != 0);
    }

    private final int updateColumnDescriptions() throws UtilException, SQLException {
        int n = this.columnDescriptions.count(0);
        boolean bl = false;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            bl = false;
            n2 = -1;
            if (i % 84 == 0 && i != 0) {
                this.reader.readAndDiscardBytes(3);
                n3 += 3;
            }
            DRDAColumn dRDAColumn = (DRDAColumn)this.columnDescriptions.get(i + 1);
            dRDAColumn.fdocaType = this.reader.readUnsignedInt8();
            boolean bl2 = false;
            if (this.hasEarlyDesc) {
                n4 = this.fdocaMap.size();
                for (int j = 0; j < n4; ++j) {
                    if (((int[])this.fdocaMap.get(j))[0] != dRDAColumn.fdocaType) continue;
                    bl = true;
                    n2 = j;
                    dRDAColumn.fdocaType = ((int[])this.fdocaMap.get(j))[1];
                    int n5 = ((int[])this.fdocaMap.get(n2))[3];
                    boolean bl3 = bl2 = n5 == 65535;
                    if (n5 != 1200 && n5 != 13488) continue;
                    dRDAColumn.isDoubleByteColumn = true;
                }
            } else {
                boolean bl4 = bl2 = dRDAColumn.typeName.indexOf("BIT DATA") != -1;
            }
            if (this.hasClobColumns && !this.comm.enableFullSizeLobs) {
                if (dRDAColumn.type != 2005) {
                    dRDAColumn.type = this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, false, bl2);
                }
            } else {
                dRDAColumn.type = this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "" ? this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, true, bl2) : this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, false, bl2);
            }
            dRDAColumn.fdocaScale = 0;
            dRDAColumn.setLongDataBuffer();
            dRDAColumn.isNullable = dRDAColumn.fdocaType % 2 == 0 ? 0 : 1;
            if (dRDAColumn.transliterator == null) {
                switch (dRDAColumn.fdocaType) {
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: {
                        dRDAColumn.transliterator = this.comm.XMLServerTransliterator;
                        break;
                    }
                    default: {
                        dRDAColumn.transliterator = this.comm.SingleByteServerTransliterator;
                    }
                }
            }
            if (!bl2 && bl && this.implConn.codePageOverride == null) {
                if (((int[])this.fdocaMap.get(n2))[3] != 0) {
                    dRDAColumn.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(((int[])this.fdocaMap.get(n2))[3]));
                } else if (this.implConn.codePageOverride != null) {
                    dRDAColumn.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(dRDAColumn.transliteratorCharSet);
                }
            }
            switch (dRDAColumn.type) {
                case 2004: {
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                    dRDAColumn.fdocaLen = this.reader.readUnsignedInt16();
                    dRDAColumn.isSigned = false;
                    this.hasLobCols = true;
                    this.lastLobColumnNum = i + 1;
                    if (dRDAColumn.precision != 0 || dRDAColumn.fdocaLen != 32777) break;
                    dRDAColumn.precision = Integer.MAX_VALUE;
                    dRDAColumn.displaySize = Integer.MAX_VALUE;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen * 2;
                    dRDAColumn.isSigned = false;
                    break;
                }
                case 3: {
                    if (dRDAColumn.fdocaType == 186 || dRDAColumn.fdocaType == 187) {
                        dRDAColumn.fdocaLen = this.reader.readInt16();
                        dRDAColumn.scale = dRDAColumn.fdocaScale;
                        if (dRDAColumn.fdocaLen == 8) {
                            dRDAColumn.displaySize = 23;
                            break;
                        }
                        dRDAColumn.displaySize = 43;
                        break;
                    }
                    n4 = this.reader.readInt8();
                    if (dRDAColumn.precision < n4) {
                        dRDAColumn.precision = n4;
                    }
                    dRDAColumn.fdocaLen = dRDAColumn.precision / 2 + 1;
                    dRDAColumn.scale = dRDAColumn.fdocaScale = (int)this.reader.readInt8();
                    dRDAColumn.displaySize = dRDAColumn.precision + 3;
                    break;
                }
                case 2: {
                    dRDAColumn.fdocaLen = dRDAColumn.precision = (int)this.reader.readInt8();
                    dRDAColumn.scale = dRDAColumn.fdocaScale = (int)this.reader.readInt8();
                    dRDAColumn.displaySize = dRDAColumn.precision + 3;
                    break;
                }
                case 5: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 5;
                    dRDAColumn.displaySize = 6;
                    break;
                }
                case 4: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 10;
                    dRDAColumn.displaySize = 11;
                    break;
                }
                case -5: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 19;
                    dRDAColumn.displaySize = 20;
                    break;
                }
                case 7: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 7;
                    dRDAColumn.displaySize = dRDAColumn.precision + 6;
                    break;
                }
                case 6: 
                case 8: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 15;
                    dRDAColumn.displaySize = dRDAColumn.precision + 7;
                    break;
                }
                case 2005: {
                    this.lastLobColumnNum = i + 1;
                    if (this.comm.enableFullSizeLobs) {
                        if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                            this.useOUTOVRlob = true;
                        }
                        dRDAColumn.fdocaLen = this.reader.readUnsignedInt16();
                        dRDAColumn.isSigned = false;
                        dRDAColumn.isCaseSensitive = true;
                        this.hasLobCols = true;
                    } else {
                        this.hasClobColumns = true;
                        dRDAColumn.isCaseSensitive = true;
                        dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                        dRDAColumn.displaySize = dRDAColumn.fdocaLen;
                        dRDAColumn.scale = dRDAColumn.fdocaScale;
                        dRDAColumn.isSigned = false;
                    }
                    if (dRDAColumn.precision != 0 || dRDAColumn.fdocaLen != 32777) break;
                    dRDAColumn.precision = Integer.MAX_VALUE;
                    dRDAColumn.displaySize = Integer.MAX_VALUE;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    dRDAColumn.isCaseSensitive = true;
                    if (dRDAColumn.isDoubleByteColumn) {
                        dRDAColumn.fdocaLen *= 2;
                    }
                }
                default: {
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen;
                    if (dRDAColumn.isDoubleByteColumn && dRDAColumn.type == 1) {
                        dRDAColumn.fdocaLen *= 2;
                    }
                    dRDAColumn.isSigned = false;
                    dRDAColumn.scale = dRDAColumn.type == 93 ? 6 : dRDAColumn.fdocaScale;
                }
            }
            n3 += 3;
        }
        return n3;
    }

    private final int updateParameterDescriptions() throws UtilException, SQLException {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < this.numParams; ++i) {
            int n5;
            bl2 = false;
            n3 = -1;
            if (i % 84 == 0 && i != 0) {
                this.reader.readAndDiscardBytes(3);
                n4 += 3;
            }
            int n6 = i + 1;
            BaseParameter baseParameter = this.parameterDescriptions.getOutput(n6);
            bl = true;
            if (baseParameter == null) {
                baseParameter = this.parameterDescriptions.getInput(n6);
                bl = false;
            }
            n2 = this.reader.readUnsignedInt8();
            boolean bl3 = false;
            if (this.hasEarlyDesc) {
                n5 = this.fdocaMap.size();
                for (int j = 0; j < n5; ++j) {
                    if (((int[])this.fdocaMap.get(j))[0] != n2) continue;
                    bl2 = true;
                    n3 = j;
                    n2 = ((int[])this.fdocaMap.get(j))[1];
                    bl3 = ((int[])this.fdocaMap.get(n3))[3] == 65535;
                }
            }
            n5 = this.drdaUtil.Drda2JdbcType(n2, false, bl3);
            switch (n2) {
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    baseParameter.transliterator = this.comm.XMLServerTransliterator;
                }
            }
            if (!bl3) {
                if (bl2) {
                    if (((int[])this.fdocaMap.get(n3))[3] != 0) {
                        baseParameter.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(((int[])this.fdocaMap.get(n3))[3]));
                    }
                } else {
                    baseParameter.transliterator = n2 == 54 || n2 == 55 || n2 == 56 || n2 == 57 || n2 == 58 || n2 == 59 ? this.comm.DoubleByteServerTransliterator : this.comm.SingleByteServerTransliterator;
                }
            }
            switch (n5) {
                case 2: 
                case 3: {
                    if (n2 == 186 || n2 == 187) {
                        n = this.reader.readInt16();
                        by = 0;
                        break;
                    }
                    n = this.reader.readInt8();
                    by = this.reader.readInt8();
                    break;
                }
                default: {
                    by = 0;
                    n = this.reader.readUnsignedInt16();
                }
            }
            n4 += 3;
            if (this.storedProcedureParams == null) {
                this.storedProcedureParams = new UtilVectorUnsynced();
            }
            this.storedProcedureParams.add((Object)new DRDAParameter(baseParameter, n2, n, by, bl));
        }
        return n4;
    }

    public final void updateParameterData() throws UtilException, SQLException {
        int n = this.storedProcedureParams.size();
        boolean bl = false;
        byte by = this.reader.readInt8();
        if (by == -1) {
            bl = true;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            DRDAParameter dRDAParameter = (DRDAParameter)this.storedProcedureParams.get(i);
            dRDAParameter.isNullable = dRDAParameter.fdocaType % 2 != 0;
            BaseParameterInfo baseParameterInfo = this.parameterDescriptions.getParameterInfo(i);
            boolean bl2 = false;
            if (dRDAParameter.isNullable && !bl) {
                n2 = this.reader.readUnsignedInt8();
                bl2 = n2 == 255 || n2 == 128;
            }
            n2 = this.drdaUtil.Drda2JdbcType(dRDAParameter.fdocaType, false, false);
            if (!bl2 && !bl) {
                switch (n2) {
                    case 1: {
                        if (dRDAParameter.fdocaType == 54 || dRDAParameter.fdocaType == 55) {
                            dRDAParameter.baseParam.setData(10, (Object)this.reader.readEncodedString(dRDAParameter.fdocaLen * 2, dRDAParameter.baseParam.transliterator));
                            break;
                        }
                        dRDAParameter.baseParam.setData(10, (Object)this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        break;
                    }
                    case -1: 
                    case 12: {
                        short s = this.reader.readInt16();
                        if (dRDAParameter.fdocaType == 56 || dRDAParameter.fdocaType == 57 || dRDAParameter.fdocaType == 58 || dRDAParameter.fdocaType == 59) {
                            dRDAParameter.baseParam.setData(10, (Object)this.reader.readEncodedString(s * 2, dRDAParameter.baseParam.transliterator));
                        } else {
                            dRDAParameter.baseParam.setData(10, (Object)this.reader.readEncodedString(s, dRDAParameter.baseParam.transliterator));
                        }
                        if (baseParameterInfo == null || baseParameterInfo.sqlType != 2005) break;
                        dRDAParameter.baseParam.sqlType = 2005;
                        break;
                    }
                    case 2005: {
                        if (this.comm.SQLAMLevel >= 8) {
                            byte by2 = this.reader.readInt8();
                            dRDAParameter.lobLength = this.reader.readInt64();
                        } else {
                            dRDAParameter.lobLength = this.reader.readUnsignedInt32();
                        }
                        dRDAParameter.hasExtendedData = true;
                        if (dRDAParameter.fdocaType == 204 || dRDAParameter.fdocaType == 205) {
                            dRDAParameter.baseParam.transliterator = this.comm.DoubleByteServerTransliterator;
                            dRDAParameter.baseParam.sqlType = n2;
                            break;
                        }
                        dRDAParameter.baseParam.transliterator = dRDAParameter.baseParam.transliterator;
                        dRDAParameter.baseParam.sqlType = n2;
                        break;
                    }
                    case 2004: {
                        if (this.comm.SQLAMLevel >= 8) {
                            byte by3 = this.reader.readInt8();
                            dRDAParameter.lobLength = this.reader.readInt64();
                        } else {
                            dRDAParameter.lobLength = this.reader.readUnsignedInt32();
                        }
                        dRDAParameter.hasExtendedData = true;
                        break;
                    }
                    case -5: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(5, (Object)new Long(this.reader.readInt64()));
                        break;
                    }
                    case 5: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(3, (Object)new Short(this.reader.readInt16()));
                        break;
                    }
                    case 4: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(4, (Object)new Integer(this.reader.readInt32()));
                        break;
                    }
                    case 6: 
                    case 8: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        if (this.comm.serverOS == 3) {
                            long l = this.drdaUtil.ibm2IeeeDoubleFloat(this.reader.readInt64());
                            dRDAParameter.baseParam.setData(7, (Object)new Double(Double.longBitsToDouble(l)));
                            break;
                        }
                        dRDAParameter.baseParam.setData(7, (Object)new Double(this.reader.readIEEE64BitDouble()));
                        break;
                    }
                    case 7: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        if (this.comm.serverOS == 3) {
                            int n3 = this.drdaUtil.ibm2IeeeSingleFloat(this.reader.readInt32());
                            dRDAParameter.baseParam.setData(6, (Object)new Float(Float.intBitsToFloat(n3)));
                            break;
                        }
                        dRDAParameter.baseParam.setData(6, (Object)new Float(this.reader.readIEEE32BitFloat()));
                        break;
                    }
                    case 3: {
                        Object object;
                        int n4;
                        if (dRDAParameter.fdocaType == 186 || dRDAParameter.fdocaType == 187) {
                            n4 = dRDAParameter.fdocaLen;
                            dRDAParameter.baseParam.scale = 0;
                            object = new byte[n4];
                            this.reader.readBytes((byte[])object, 0, n4);
                            this.drdaUtil.convertDecFloatValue((byte[])object, (BaseData)dRDAParameter.baseParam, 0);
                            break;
                        }
                        n4 = dRDAParameter.fdocaLen / 2 + 1;
                        object = new byte[n4];
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        this.reader.readBytes((byte[])object, 0, n4);
                        StringBuffer stringBuffer = new StringBuffer();
                        if ((object[n4 - 1] & 0xF) == 13) {
                            stringBuffer.append('-');
                        }
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = false;
                        for (int j = 0; j < n4 - 1; ++j) {
                            n7 = object[j];
                            n5 = n7 >>> 4 & 0xF;
                            n6 = n7 & 0xF;
                            stringBuffer.append(String.valueOf(n5) + String.valueOf(n6));
                        }
                        stringBuffer.append(String.valueOf(object[n4 - 1] >>> 4 & 0xF));
                        dRDAParameter.baseParam.setData(8, (Object)new BigDecimal(new BigInteger(stringBuffer.toString()), dRDAParameter.fdocaScale));
                        break;
                    }
                    case 2: {
                        int n8 = dRDAParameter.fdocaLen;
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        Object object = new StringBuffer(this.reader.readEncodedString(n8 - 1, dRDAParameter.baseParam.transliterator));
                        byte by4 = this.reader.readInt8();
                        if ((by4 >>> 4 & 0xF) == 13) {
                            ((StringBuffer)object).insert(0, '-');
                        }
                        ((StringBuffer)object).append(String.valueOf(by4 & 0xF));
                        dRDAParameter.baseParam.setData(8, (Object)new BigDecimal(new BigInteger(((StringBuffer)object).toString()), dRDAParameter.fdocaScale));
                        break;
                    }
                    case 91: {
                        StringBuffer stringBuffer;
                        Object object;
                        Date date = null;
                        if (this.isStoredProcedure) {
                            object = this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator);
                            if (((String)object).charAt(4) != '-') {
                                stringBuffer = new StringBuffer(10);
                                stringBuffer.append(((String)object).substring(6));
                                stringBuffer.append('-');
                                stringBuffer.append(((String)object).substring(0, 2));
                                stringBuffer.append('-');
                                stringBuffer.append(((String)object).substring(3, 5));
                                date = Date.valueOf(stringBuffer.toString());
                            } else {
                                date = Date.valueOf((String)object);
                            }
                        } else {
                            date = Date.valueOf(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        }
                        dRDAParameter.baseParam.setData(11, (Object)date);
                        break;
                    }
                    case 92: {
                        StringBuffer stringBuffer = new StringBuffer(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        stringBuffer.setCharAt(2, ':');
                        stringBuffer.setCharAt(5, ':');
                        dRDAParameter.baseParam.setData(12, (Object)Time.valueOf(stringBuffer.toString()));
                        break;
                    }
                    case 93: {
                        StringBuffer stringBuffer = new StringBuffer(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        stringBuffer.setCharAt(10, ' ');
                        stringBuffer.setCharAt(13, ':');
                        stringBuffer.setCharAt(16, ':');
                        dRDAParameter.baseParam.setData(13, (Object)BaseTimestamp.valueOf((String)stringBuffer.toString()));
                        break;
                    }
                    case -2: {
                        byte[] byArray = new byte[dRDAParameter.fdocaLen];
                        this.reader.readBytes(byArray, 0, dRDAParameter.fdocaLen);
                        dRDAParameter.baseParam.setData(2, (Object)byArray);
                        break;
                    }
                    case -4: 
                    case -3: {
                        short s = this.reader.readInt16();
                        Object object = new byte[s];
                        if (s != 0) {
                            this.reader.readBytes((byte[])object, 0, s);
                        }
                        dRDAParameter.baseParam.setData(2, object);
                    }
                }
                this.reader.interpretAsBigEndian = true;
                continue;
            }
            if (!dRDAParameter.isOutParam) continue;
            dRDAParameter.baseParam.setNull(BaseData.getJavaObjectType(null, (int)dRDAParameter.baseParam.sqlType));
            if (baseParameterInfo == null || baseParameterInfo.sqlType != 2005) continue;
            dRDAParameter.baseParam.sqlType = 2005;
        }
    }

    public final void processSQLCINRD() throws UtilException, SQLException {
        if (this.comm.SQLAMLevel >= 7) {
            this.processSQLDH(this.implConn.warnings);
            this.processSQLDA(this.implConn.warnings);
        } else {
            if (!this.comm.isServerBigEndianOS) {
                this.reader.interpretAsBigEndian = false;
            }
            int n = this.reader.readInt16();
            this.columnDescriptions = null;
            this.columnDescriptions = new BaseColumns();
            this.reader.interpretAsBigEndian = true;
            for (int i = 0; i < n; ++i) {
                DRDAColumn dRDAColumn = new DRDAColumn(1);
                dRDAColumn.baseDataObj = new BaseData(10, null, (BaseConnection)this.implConn.db2Connection);
                dRDAColumn.name = this.reader.readMutuallyExclusiveFDOCAString(i + 1);
                dRDAColumn.label = this.reader.readMutuallyExclusiveFDOCAString(dRDAColumn.name);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.columnDescriptions.add((BaseColumn)dRDAColumn);
                this.reader.interpretAsBigEndian = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void processSQLDA(BaseWarnings var1_1) throws UtilException, SQLException {
        if (!this.comm.isServerBigEndianOS) {
            this.reader.interpretAsBigEndian = false;
        }
        var2_2 = this.reader.readInt16();
        if (this.processMode != 4) {
            this.columnDescriptions = null;
            this.columnDescriptions = new BaseColumns();
        }
        for (var3_3 = 0; var3_3 < var2_2; ++var3_3) {
            if (!this.comm.isServerBigEndianOS) {
                this.reader.interpretAsBigEndian = false;
            }
            var4_4 = this.reader.readInt16();
            var5_5 = this.reader.readInt16();
            var6_6 = 0;
            var6_6 = this.comm.SQLAMLevel >= 6 ? new Long(this.reader.readInt64()).intValue() : this.reader.readInt32();
            var7_7 = this.reader.readInt16();
            if (var7_7 == 412 || var7_7 == 413) {
                if (this.doubleByteColumns == null) {
                    this.doubleByteColumns = new int[var2_2];
                } else if (var2_2 > this.doubleByteColumns.length) {
                    this.doubleByteColumns = new int[var2_2];
                }
                this.doubleByteColumns[var3_3] = var7_7;
            }
            this.reader.interpretAsBigEndian = true;
            var8_8 = this.reader.readInt16();
            var9_9 = (var8_8 & 65535) == 65535;
            var10_10 = false;
            if (this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "" && var9_9) {
                var10_10 = true;
                var9_9 = false;
                var8_8 = 0;
            }
            var11_11 = this.drdaUtil.DB2ToJdbcType(var7_7, var9_9, var6_6);
            var12_12 = new DRDAColumn(var11_11);
            var12_12.typeName = this.drdaUtil.getDB2TypeName(var7_7, var9_9, var6_6);
            if (var8_8 != 0 && !var9_9) {
                if (var8_8 == 1200 || var8_8 == 13488 || var7_7 == 468 || var7_7 == 469 || var7_7 == 464 || var7_7 == 465) {
                    var12_12.isDoubleByteColumn = true;
                }
                var12_12.transliteratorCharSet = Integer.toString(var8_8);
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            } else if (var10_10) {
                var12_12.transliteratorCharSet = this.implConn.charSetFor65535;
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            } else if (var12_12.typeName.equals("XML")) {
                var12_12.transliterator = this.comm.XMLServerTransliterator;
                if (var6_6 == 0) {
                    var6_6 = 0x7FFFFFFF;
                    var12_12.displaySize = 0x7FFFFFFF;
                }
            } else {
                var12_12.transliterator = this.comm.defaultCCSIDTransliterator;
            }
            if (this.implConn.codePageOverride != null) {
                var12_12.transliteratorCharSet = this.implConn.codePageOverride;
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            }
            var12_12.isNullable = var7_7 % 2 == 0 ? 0 : 1;
            var12_12.baseDataObj = new BaseData(10, null, (BaseConnection)this.implConn.db2Connection);
            switch (var11_11) {
                case 2004: {
                    this.lastLobColumnNum = var3_3 + 1;
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                }
                case -4: 
                case -3: 
                case -2: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = var6_6;
                    var12_12.displaySize = var6_6 * 2;
                    if (var12_12.displaySize < 0) {
                        var12_12.displaySize = 0x7FFFFFFF;
                    }
                    var12_12.isSigned = false;
                    break;
                }
                case 2: 
                case 3: {
                    if (var7_7 == 996 || var7_7 == 997) {
                        var12_12.scale = 0;
                        if (var6_6 == 16) {
                            var12_12.precision = 34;
                            var12_12.displaySize = 42;
                        } else {
                            var12_12.precision = 16;
                            var12_12.displaySize = 23;
                        }
                        var12_12.fdocaLen = var6_6;
                        break;
                    }
                    var12_12.precision = var4_4;
                    var12_12.scale = var5_5;
                    var12_12.displaySize = var12_12.precision + 3;
                    var12_12.fdocaLen = var12_12.precision / 2 + 1;
                    break;
                }
                case 5: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 5;
                    var12_12.displaySize = 6;
                    break;
                }
                case 4: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 10;
                    var12_12.displaySize = 11;
                    break;
                }
                case -5: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 19;
                    var12_12.displaySize = 20;
                    break;
                }
                case 7: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 7;
                    var12_12.displaySize = var12_12.precision + 6;
                    break;
                }
                case 6: 
                case 8: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 15;
                    var12_12.displaySize = var12_12.precision + 7;
                    break;
                }
                case 2005: {
                    this.lastLobColumnNum = var3_3 + 1;
                    if (!this.comm.enableFullSizeLobs) {
                        this.hasClobColumns = true;
                    }
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                    if (var7_7 != 412) ** GOTO lbl118
                    var12_12.fdocaType = 205;
                    ** GOTO lbl120
lbl118:
                    // 1 sources

                    if (var7_7 == 413) {
                        var12_12.fdocaType = 204;
                    }
                }
lbl120:
                // 5 sources

                case -1: 
                case 1: 
                case 12: {
                    var12_12.isCaseSensitive = true;
                }
                default: {
                    var12_12.fdocaLen = var6_6;
                    if (var12_12.isDoubleByteColumn && var12_12.type == 1) {
                        var12_12.fdocaLen *= 2;
                    }
                    var12_12.precision = var6_6;
                    var12_12.displaySize = var6_6;
                    var12_12.isSigned = false;
                    var12_12.scale = var11_11 == 93 ? 6 : (int)var5_5;
                }
            }
            if (this.comm.SQLAMLevel < 7) {
                var12_12.name = this.reader.readMutuallyExclusiveFDOCAString(var3_3 + 1);
                var12_12.label = this.reader.readMutuallyExclusiveFDOCAString(var12_12.name);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                if (this.comm.SQLAMLevel >= 6) {
                    this.processSQLUDT(var12_12, var1_1);
                }
            } else {
                this.processSQLDOPT(var12_12, var3_3, var1_1);
            }
            if (this.processMode == 4) {
                this.drdaUtil.convertColumnDescToParamDesc(var12_12, this.parameterDescriptions.getParameterInfo(var3_3));
                continue;
            }
            this.columnDescriptions.add((BaseColumn)var12_12);
        }
    }

    public final void processSQLDH(BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            String string = this.reader.readMutuallyExclusiveFDOCAString(this.implConn.user);
        }
    }

    public final void processSQLDOPT(DRDAColumn dRDAColumn, int n, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            this.reader.readAndDiscardBytes(2);
            dRDAColumn.name = this.reader.readMutuallyExclusiveFDOCAString(n + 1);
            dRDAColumn.label = this.reader.readMutuallyExclusiveFDOCAString(dRDAColumn.name);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.processSQLUDT(dRDAColumn, baseWarnings);
            this.processSQLDX(dRDAColumn, n, baseWarnings);
        }
    }

    public final void processSQLUDT(DRDAColumn dRDAColumn, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            if (this.comm.SQLAMLevel >= 7) {
                this.reader.readAndDiscardBytes(4);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
            } else {
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
            }
        }
    }

    public final void processSQLDX(DRDAColumn dRDAColumn, int n, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            if (this.reader.readInt16() == 1) {
                dRDAColumn.isKey = true;
            }
            this.reader.readAndDiscardBytes(2);
            short s = this.reader.readInt16();
            if (s != 0) {
                dRDAColumn.isAutoIncrement = true;
            }
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readMutuallyExclusiveFDOCAString(0);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
        }
    }
}

