/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.testing.tools;

import com.metamatrix.connector.testing.tools.DQPManager;
import com.metamatrix.jdbc.api.Connection;
import java.util.Map;
import junit.framework.TestCase;

public abstract class BaseTestDQPQuery
extends TestCase {
    private DQPManager manager;
    private String vdbIdentifier;
    private String dqpPath = "/build/dqp/dqp.properties";

    public abstract String getVDBName();

    public abstract String getVDBPath();

    public abstract Map getConnectorDefinitionPaths();

    public abstract Map getExtensionModules();

    public BaseTestDQPQuery() throws Exception {
        try {
            this.manager = new DQPManager(this.dqpPath);
            this.manager.getQueryConnection(this.getVDBName());
            this.manager.disconnect();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (null == this.vdbIdentifier) {
            throw new Exception("The vdbIdentifier is null, the vdb did not import correctly");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public Connection getQueryConnection() throws Exception {
        return this.manager.getQueryConnection(this.getVDBIdentifierName());
    }

    private String getVDBIdentifierName() throws Exception {
        if (null != this.vdbIdentifier) {
            int separatorIndex = this.vdbIdentifier.indexOf("|");
            return this.vdbIdentifier.substring(0, separatorIndex);
        }
        throw new Exception("The vdbIdentifier is null");
    }

    private String getVDBIdentifierVersion() throws Exception {
        if (null != this.vdbIdentifier) {
            int separatorIndex = this.vdbIdentifier.indexOf("|");
            return this.vdbIdentifier.substring(separatorIndex + 1);
        }
        throw new Exception("The vdbIdentifier is null");
    }
}

