/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.jdbc.DataType;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.DataTypeImpl;
import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.QName;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.MergedColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.QNameImpl;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public abstract class BaseColumn
implements Column {
    private SchemaObject table;
    protected boolean pk;
    protected XSDSimpleTypeDefinition type;

    public BaseColumn(boolean pk, XSDSimpleTypeDefinition type) {
        this.pk = pk;
        this.type = type;
        this.table = null;
    }

    public void setTable(SchemaObject table) {
        this.table = table;
    }

    public SchemaObject getTable() {
        return this.table;
    }

    public boolean isPrimaryKey() {
        return this.pk;
    }

    public String getBaseType() {
        XSDSimpleTypeDefinition primitiveType = this.type.getRootTypeDefinition();
        String retval = primitiveType.getName();
        return retval;
    }

    public QName getTypeName() {
        QNameImpl retval = new QNameImpl(this.type.getTargetNamespace(), this.type.getName());
        return retval;
    }

    public XSDSimpleTypeDefinition getType() {
        return this.type;
    }

    public Column mergeIntoParent(Relationship tableRelationship, int iOccurence) {
        MergedColumn mergedColumn = new MergedColumn(this, tableRelationship, iOccurence);
        SchemaObject parent = tableRelationship.getParent();
        parent.addAttribute(mergedColumn);
        return mergedColumn;
    }

    public String toString() {
        return this.getSimpleName();
    }

    protected DataType getDataType() {
        String typeName = this.type.getName();
        String namespace = this.type.getTargetNamespace();
        if (null == typeName) {
            typeName = this.type.getRootType().getName();
            namespace = this.type.getRootType().getTargetNamespace();
        }
        return new DataTypeImpl(typeName, namespace);
    }
}

