/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce;

import com.metamatrix.data.exception.ConnectorException;

public class SalesforceConnectorException
extends ConnectorException {
    private boolean critical;
    private String failedAction;
    private String failedDetail;
    private String failedScope;

    protected String getToStringType() {
        return "SalesforceConnectorException";
    }

    public SalesforceConnectorException(String scope, String action, String detail, Throwable cause) {
        super(cause, "scope=" + (scope == null ? "not specified" : scope) + ",action=" + (action == null ? "not specified" : action) + ",detail=" + (detail == null ? "not specified" : detail));
        this.failedScope = scope;
        this.failedAction = action;
        this.failedDetail = detail;
        this.critical = this.representsCriticalError(detail + this.toString());
    }

    public SalesforceConnectorException(String message) {
        super(message);
    }

    public SalesforceConnectorException(Throwable e, String message) {
        super(e, message);
    }

    public SalesforceConnectorException(Throwable e) {
        super(e);
    }

    private boolean representsCriticalError(String text) {
        String scan = text == null ? "" : text.trim().toLowerCase();
        return scan.indexOf("invalid session id") > 0 || scan.indexOf("illegal session") > 0 || scan.indexOf("session not found") > 0 || scan.indexOf("missing session key") > 0 || scan.indexOf("login()") > 0;
    }

    public boolean isCritical() {
        return this.failedScope.trim().toLowerCase().startsWith("login") || this.critical;
    }

    public String getFailedScope() {
        return this.failedScope;
    }

    public String getFailedAction() {
        return this.failedAction;
    }

    public String getFailedDetail() {
        return this.failedDetail;
    }
}

