/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.sql.symbol.Expression;
import java.util.List;
import java.util.Map;

public class LimitNode
extends RelationalNode {
    private final Expression limitExpr;
    private final Expression offsetExpr;
    private int limit;
    private int offset;
    private int rowCounter;
    private boolean offsetPhase = true;

    public LimitNode(int nodeID, Expression limitExpr, Expression offsetExpr) {
        super(nodeID);
        this.limitExpr = limitExpr;
        this.offsetExpr = offsetExpr;
    }

    protected TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        TupleBatch resultBatch;
        List[] originalTuples;
        List[] tuples;
        TupleBatch batch = null;
        if (this.offsetPhase) {
            while (this.rowCounter <= this.offset) {
                batch = this.getChildren()[0].nextBatch();
                this.rowCounter += batch.getRowCount();
                if (!batch.getTerminationFlag()) continue;
            }
            tuples = null;
            if (this.rowCounter > this.offset) {
                originalTuples = batch.getAllTuples();
                int rowsToKeep = this.rowCounter - this.offset;
                tuples = new List[rowsToKeep];
                System.arraycopy(originalTuples, batch.getRowCount() - rowsToKeep, tuples, 0, tuples.length);
            } else {
                tuples = new List[]{};
            }
            resultBatch = new TupleBatch(1, tuples);
            resultBatch.setTerminationFlag(batch.getTerminationFlag());
            batch = resultBatch;
            this.offsetPhase = false;
            this.rowCounter = 0;
        } else {
            batch = this.getChildren()[0].nextBatch();
        }
        tuples = null;
        if (this.limit < 0 || this.rowCounter + batch.getRowCount() <= this.limit) {
            tuples = batch.getAllTuples();
        } else {
            originalTuples = batch.getAllTuples();
            tuples = new List[this.limit - this.rowCounter];
            System.arraycopy(originalTuples, 0, tuples, 0, tuples.length);
        }
        resultBatch = new TupleBatch(this.rowCounter + 1, tuples);
        this.rowCounter += resultBatch.getRowCount();
        if (this.rowCounter == this.limit || batch.getTerminationFlag()) {
            resultBatch.setTerminationFlag(true);
            if (!batch.getTerminationFlag()) {
                this.getChildren()[0].close();
            }
        }
        return resultBatch;
    }

    public void open() throws MetaMatrixComponentException {
        super.open();
        try {
            this.limit = -1;
            if (this.limitExpr != null) {
                Integer limitVal = (Integer)ExpressionEvaluator.evaluate(this.limitExpr, null, null);
                this.limit = limitVal;
            }
            if (this.offsetExpr != null) {
                Integer offsetVal = (Integer)ExpressionEvaluator.evaluate(this.offsetExpr, null, null);
                this.offset = offsetVal;
                Assertion.assertTrue((this.offset >= 0 ? 1 : 0) != 0);
            } else {
                this.offset = 0;
            }
            this.offsetPhase = this.offset > 0;
        }
        catch (ExpressionEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void reset() {
        super.reset();
        this.rowCounter = 0;
        this.offsetPhase = true;
    }

    protected void getNodeString(StringBuffer buf) {
        super.getNodeString(buf);
        if (this.limitExpr != null) {
            buf.append("limit ");
            buf.append(this.limitExpr);
        }
        if (this.offsetExpr != null) {
            buf.append(" offset ");
            buf.append(this.offsetExpr);
        }
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Limit");
        props.put("rowOffset", this.offsetExpr);
        props.put("rowLimit", this.limitExpr);
        return props;
    }

    public Object clone() {
        Expression clonedLimit = null;
        if (this.limitExpr != null) {
            clonedLimit = (Expression)this.limitExpr.clone();
        }
        Expression clonedOffset = null;
        if (this.offsetExpr != null) {
            clonedOffset = (Expression)this.offsetExpr.clone();
        }
        LimitNode node = new LimitNode(this.getID(), clonedLimit, clonedOffset);
        this.copy(this, node);
        node.rowCounter = this.rowCounter;
        return node;
    }
}

