/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public final class SizeUtility {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final boolean IS_64BIT = System.getProperty("sun.arch.data.model", "32").indexOf("64") != -1;
    public static final int REFERENCE_SIZE = IS_64BIT ? 8 : 4;

    private SizeUtility() {
    }

    public static long getBatchSize(String[] types, List[] data) {
        if (types == null) {
            return SizeUtility.getSize(data);
        }
        int colLength = types.length;
        int rowLength = data.length;
        long size = 16L + SizeUtility.alignMemory(rowLength * REFERENCE_SIZE);
        size += (long)rowLength * (48L + SizeUtility.alignMemory(colLength * REFERENCE_SIZE));
        for (int col = 0; col < colLength; ++col) {
            Class type = DataTypeManager.getDataTypeClass((String)types[col]);
            if (type == DataTypeManager.DefaultDataClasses.CHAR || type == DataTypeManager.DefaultDataClasses.BOOLEAN || type == DataTypeManager.DefaultDataClasses.BYTE || type == DataTypeManager.DefaultDataClasses.SHORT || type == DataTypeManager.DefaultDataClasses.INTEGER || type == DataTypeManager.DefaultDataClasses.LONG || type == DataTypeManager.DefaultDataClasses.FLOAT || type == DataTypeManager.DefaultDataClasses.DOUBLE) {
                size += (long)(20 * rowLength);
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.DATE || type == DataTypeManager.DefaultDataClasses.TIME || type == DataTypeManager.DefaultDataClasses.TIMESTAMP) {
                size += (long)(32 * rowLength);
                continue;
            }
            if (type == DataTypeManager.DefaultDataClasses.NULL) continue;
            for (int row = 0; row < rowLength; ++row) {
                size += SizeUtility.getSize(data[row].get(col));
            }
        }
        return size;
    }

    public static long getSize(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> type = obj.getClass();
        if (type == DataTypeManager.DefaultDataClasses.CHAR || type == DataTypeManager.DefaultDataClasses.BOOLEAN || type == DataTypeManager.DefaultDataClasses.BYTE || type == DataTypeManager.DefaultDataClasses.SHORT || type == DataTypeManager.DefaultDataClasses.INTEGER || type == DataTypeManager.DefaultDataClasses.LONG || type == DataTypeManager.DefaultDataClasses.FLOAT || type == DataTypeManager.DefaultDataClasses.DOUBLE) {
            return 20L;
        }
        if (type == DataTypeManager.DefaultDataClasses.DATE || type == DataTypeManager.DefaultDataClasses.TIME || type == DataTypeManager.DefaultDataClasses.TIMESTAMP) {
            return 32L;
        }
        if (type == DataTypeManager.DefaultDataClasses.STRING) {
            int length = ((String)obj).length();
            if (length > 0) {
                return SizeUtility.alignMemory(40 + 2 * length);
            }
            return 40L;
        }
        if (obj instanceof List) {
            int total = 16;
            if (obj instanceof LinkedList) {
                total += 8;
                Iterator i = ((List)obj).iterator();
                while (i.hasNext()) {
                    total = (int)((long)total + (16L + SizeUtility.getSize(i.next())));
                }
            } else if (obj instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)obj;
                int arraySize = arrayList.size();
                int maxEnsuredSize = arraySize < 10 ? 10 : arraySize * 3 / 2;
                total = (int)((long)total + (24L + SizeUtility.alignMemory(maxEnsuredSize * REFERENCE_SIZE)));
                if (arraySize > 0) {
                    for (int i = 0; i < arraySize; ++i) {
                        total = (int)((long)total + SizeUtility.getSize(arrayList.get(i)));
                    }
                }
            } else if (obj instanceof Vector) {
                List arrayList = (List)obj;
                int arraySize = arrayList.size();
                int maxEnsuredSize = arraySize < 10 ? 10 : arraySize * 2;
                total = (int)((long)total + (16L + SizeUtility.alignMemory(maxEnsuredSize * REFERENCE_SIZE)));
            } else {
                List list = (List)obj;
                int arraySize = list.size();
                total = (int)((long)total + (16L + SizeUtility.alignMemory(arraySize * REFERENCE_SIZE)));
                if (arraySize > 0) {
                    for (int i = 0; i < arraySize; ++i) {
                        total = (int)((long)total + SizeUtility.getSize(list.get(i)));
                    }
                }
            }
            return total;
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_DECIMAL) {
            int bitLength = ((BigDecimal)obj).unscaledValue().bitLength();
            return 72L + SizeUtility.alignMemory(4 + (bitLength >> 3));
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_INTEGER) {
            int bitLength = ((BigInteger)obj).bitLength();
            return 56L + SizeUtility.alignMemory(4 + (bitLength >> 3));
        }
        if (type.isArray() && !type.getComponentType().isPrimitive()) {
            Object[] rows = (Object[])obj;
            long total = 16L + SizeUtility.alignMemory(rows.length * REFERENCE_SIZE);
            for (int i = 0; i < rows.length; ++i) {
                total += SizeUtility.getSize(rows[i]);
            }
            return total;
        }
        return 8L + SizeUtility.alignMemory(4L + SizeUtility.getSerializedSize(obj));
    }

    private static long alignMemory(long numBytes) {
        long remainder = numBytes % 8L;
        if (remainder != 0L) {
            numBytes += 8L - remainder;
        }
        return numBytes;
    }

    private static long getSerializedSize(Object anObj) {
        if (anObj instanceof Serializable) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(anObj);
                out.flush();
                long size = bout.size();
                out.close();
                bout.close();
                return size;
            }
            catch (IOException e) {
                throw new MetaMatrixRuntimeException((Throwable)e, CommonPlugin.Util.getString("ERR.003.006.0037"));
            }
        }
        if (anObj instanceof byte[]) {
            return ((byte[])anObj).length;
        }
        throw new MetaMatrixRuntimeException(CommonPlugin.Util.getString("ERR.003.006.0038"));
    }
}

