/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.capabilities;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import java.util.List;

public class ConnectorCapabilitiesFinder
implements CapabilitiesFinder {
    private VDBService vdbService;
    private DataService dataService;
    private RequestMessage requestMessage;

    public ConnectorCapabilitiesFinder(VDBService vdbService, DataService dataService, RequestMessage requestMessage) {
        this.vdbService = vdbService;
        this.dataService = dataService;
        this.requestMessage = requestMessage;
    }

    public SourceCapabilities findCapabilities(String modelName) throws MetaMatrixComponentException {
        List bindings = this.vdbService.getConnectorBindingNames(this.requestMessage.getVdbName(), this.requestMessage.getVdbVersion(), modelName);
        for (int i = 0; i < bindings.size(); ++i) {
            try {
                String connBinding = (String)bindings.get(i);
                ConnectorID connector = this.dataService.selectConnector(connBinding);
                return this.dataService.getCapabilities(this.requestMessage, connector);
            }
            catch (MetaMatrixComponentException e) {
                if (i != bindings.size() - 1) continue;
                throw e;
            }
        }
        return null;
    }
}

