/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ui.table;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.internal.core.ObjectExtension;
import com.metamatrix.modeler.internal.ui.properties.ModelObjectPropertySource;
import com.metamatrix.modeler.internal.ui.properties.udp.ExtensionPropertyDescriptor;
import com.metamatrix.modeler.internal.ui.properties.udp.ExtensionPropertySource;
import com.metamatrix.modeler.internal.ui.table.ClipboardPasteStatusRecord;
import com.metamatrix.modeler.internal.ui.table.ModelObjectTableModel;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.ui.UiConstants;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class ModelRowElement {
    private EObject modelObject;
    private ModelObjectTableModel tableModel;
    private IPropertySource propertySource;
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$IItemPropertySource;

    public ModelRowElement(EObject modelObject, ModelObjectTableModel tableModel) {
        this.modelObject = modelObject;
        this.tableModel = tableModel;
        this.propertySource = tableModel.getPropertySource(modelObject);
    }

    public final Object getValueObject(String propertyID) {
        if (propertyID.equals(UiConstants.LOCATION_KEY)) {
            return ModelUtilities.getEMFLabelProvider().getText((Object)this.modelObject.eContainer());
        }
        if (propertyID.equals(UiConstants.DESCRIPTION_KEY)) {
            return ModelObjectUtilities.getDescription((EObject)this.modelObject);
        }
        Object value = this.propertySource.getPropertyValue((Object)propertyID);
        if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper) {
            value = ((ItemPropertyDescriptor.PropertyValueWrapper)value).getEditableValue((Object)this.modelObject);
        }
        return value;
    }

    public final String getInvalidValueMessage(String propertyID, Object value) {
        String result = null;
        Object object = this.propertySource.getEditableValue();
        IItemPropertySource itemSource = (IItemPropertySource)ModelerCore.getMetamodelRegistry().getAdapterFactory().adapt(object, (Object)(class$org$eclipse$emf$edit$provider$IItemPropertySource == null ? (class$org$eclipse$emf$edit$provider$IItemPropertySource = ModelRowElement.class$("org.eclipse.emf.edit.provider.IItemPropertySource")) : class$org$eclipse$emf$edit$provider$IItemPropertySource));
        IItemPropertyDescriptor itemDescriptor = itemSource.getPropertyDescriptor(object, (Object)propertyID);
        if (itemDescriptor != null) {
            EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(object);
            if (value instanceof String) {
                if (ModelerCore.getModelEditor().isDatatypeFeature(this.modelObject, feature)) {
                    try {
                        String theValue = this.getDatatypeShortString((String)value);
                        EObject testValue = ModelerCore.getDatatypeManager((EObject)this.modelObject, (boolean)true).findDatatype(theValue);
                        if (testValue == null) {
                            result = UiConstants.Util.getString("ModelRowElement.invalidValueError", value, (Object)propertyID);
                        }
                    }
                    catch (ModelerCoreException mce) {
                        ModelerCore.Util.log(4, (Throwable)mce, mce.getMessage());
                    }
                } else if (feature.getEType() instanceof EDataType) {
                    EDataType dt = (EDataType)feature.getEType();
                    EPackage ePackage = dt.getEPackage();
                    EFactory fac = ePackage.getEFactoryInstance();
                    try {
                        fac.createFromString(dt, (String)value);
                    }
                    catch (Exception e) {
                        result = UiConstants.Util.getString("ModelRowElement.invalidValueError", value, (Object)propertyID);
                    }
                }
            } else {
                result = UiConstants.Util.getString("ModelRowElement.unsupportedError", (Object)propertyID);
            }
        }
        return result;
    }

    private String getDatatypeShortString(String longString) {
        if (longString == null) {
            return null;
        }
        String modValue = longString;
        int colonIndex = longString.indexOf(58);
        if (colonIndex != -1) {
            modValue = longString.substring(0, colonIndex).trim();
        }
        return modValue;
    }

    public final String getReferenceColumnMessage(String propertyID, Object value) {
        String result = null;
        Object object = this.propertySource.getEditableValue();
        IItemPropertySource itemSource = (IItemPropertySource)ModelerCore.getMetamodelRegistry().getAdapterFactory().adapt(object, (Object)(class$org$eclipse$emf$edit$provider$IItemPropertySource == null ? (class$org$eclipse$emf$edit$provider$IItemPropertySource = ModelRowElement.class$("org.eclipse.emf.edit.provider.IItemPropertySource")) : class$org$eclipse$emf$edit$provider$IItemPropertySource));
        IItemPropertyDescriptor itemDescriptor = itemSource.getPropertyDescriptor(object, (Object)propertyID);
        if (itemDescriptor != null) {
            EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(object);
            if (value instanceof String && !ModelerCore.getModelEditor().isDatatypeFeature(this.modelObject, feature) && !(feature.getEType() instanceof EDataType)) {
                result = ClipboardPasteStatusRecord.REFERENCE_COLUMN_MSG;
            }
        }
        return result;
    }

    public final String getInvalidValueMessage(ExtensionPropertyDescriptor propertyID, Object value) {
        ObjectExtension objExt;
        ExtensionPropertySource eps;
        String result = null;
        EObject eObj = propertyID.getExtensionObject();
        if (eObj != null && eObj instanceof ObjectExtension && !(eps = new ExtensionPropertySource((objExt = (ObjectExtension)eObj).getExtendedObject())).canConvertToCorrectDatatype(propertyID, value)) {
            result = UiConstants.Util.getString("ModelRowElement.invalidValueError", value, (Object)propertyID.toString());
        }
        return result;
    }

    public final void setValue(String propertyID, Object value) {
        if (propertyID.equals(UiConstants.DESCRIPTION_KEY)) {
            String desc = ModelObjectUtilities.getDescription((EObject)this.modelObject);
            if (desc == null) {
                if (value != null && !"".equals(value)) {
                    ModelObjectUtilities.setDescription((EObject)this.modelObject, (String)((String)value), (Object)this);
                }
            } else if (!desc.equals(value)) {
                ModelObjectUtilities.setDescription((EObject)this.modelObject, (String)((String)value), (Object)this);
            }
        } else if (!propertyID.equals(UiConstants.LOCATION_KEY)) {
            try {
                Object currentValue;
                Object object = this.propertySource.getEditableValue();
                IItemPropertySource itemSource = (IItemPropertySource)ModelerCore.getMetamodelRegistry().getAdapterFactory().adapt(object, (Object)(class$org$eclipse$emf$edit$provider$IItemPropertySource == null ? (class$org$eclipse$emf$edit$provider$IItemPropertySource = ModelRowElement.class$("org.eclipse.emf.edit.provider.IItemPropertySource")) : class$org$eclipse$emf$edit$provider$IItemPropertySource));
                IItemPropertyDescriptor itemDescriptor = itemSource.getPropertyDescriptor(object, (Object)propertyID);
                if (itemDescriptor != null) {
                    EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(object);
                    if (value instanceof String && ModelerCore.getModelEditor().isDatatypeFeature(this.modelObject, feature)) {
                        String theValue = this.getDatatypeShortString((String)value);
                        try {
                            value = ModelerCore.getDatatypeManager((EObject)this.modelObject, (boolean)true).findDatatype(theValue);
                        }
                        catch (ModelerCoreException mce) {
                            ModelerCore.Util.log(4, (Throwable)mce, mce.getMessage());
                        }
                    }
                }
                if ((currentValue = this.propertySource.getPropertyValue(this.tableModel.getPropertyId(propertyID))) == null) {
                    if (value != null) {
                        this.propertySource.setPropertyValue(this.tableModel.getPropertyId(propertyID), value);
                    }
                } else if (!currentValue.equals(value)) {
                    this.propertySource.setPropertyValue(this.tableModel.getPropertyId(propertyID), value);
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelRowElement.setValueError", value, (Object)propertyID, (Object)this.modelObject.eClass().getName());
                UiConstants.Util.log(4, (Throwable)e, message);
                String title = UiConstants.Util.getString("ModelRowElement.setValueErrorTitle");
                MessageDialog.openError(null, (String)title, (String)message);
            }
        }
    }

    public final void setValue(ExtensionPropertyDescriptor descriptor, Object value) {
        try {
            if (this.propertySource instanceof ModelObjectPropertySource) {
                ((ModelObjectPropertySource)this.propertySource).setPropertyValue((Object)descriptor, value);
            }
        }
        catch (Exception e) {
            String message = UiConstants.Util.getString("ModelRowElement.setValueError", value, (Object)descriptor.toString(), (Object)this.modelObject.eClass().getName());
            UiConstants.Util.log(4, (Throwable)e, message);
            String title = UiConstants.Util.getString("ModelRowElement.setValueErrorTitle");
            MessageDialog.openError(null, (String)title, (String)message);
        }
    }

    public final Object getValue(int index) {
        String result = null;
        Object propertyId = this.tableModel.getPropertyIdAtIndex(index);
        if (this.tableModel.isLocationColumn(propertyId)) {
            result = ModelUtilities.getEMFLabelProvider().getText((Object)this.modelObject.eContainer());
        } else if (this.tableModel.isDescriptionColumn(propertyId)) {
            result = ModelObjectUtilities.getDescription((EObject)this.modelObject);
        } else {
            IPropertyDescriptor descriptor = this.tableModel.getPropertyDescriptor(propertyId);
            result = descriptor.getLabelProvider().getText(this.propertySource.getPropertyValue(propertyId));
        }
        return result;
    }

    public final Object getPropertyIdForColumn(int index) {
        return this.tableModel.getPropertyIdAtIndex(index);
    }

    public EObject getModelObject() {
        return this.modelObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

