/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.BulkInsert;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ProjectIntoNode
extends RelationalNode {
    private GroupSymbol intoGroup;
    private List intoElements;
    private String modelName;
    private Insert insertCommand;
    private TupleBatch currentBatch;
    private int batchRow = 1;
    private int insertCount = 0;
    private boolean isTempGroupInsert = false;
    private boolean doBatching = false;
    private boolean doBulkInsert = false;
    private TupleSource tupleSource = null;
    private int tupleSourcesReceived = 0;
    private int requestsRegistered = 0;
    private int tupleSourcesProcessed = 0;
    private static int execCount;

    public ProjectIntoNode(int nodeID) {
        super(nodeID);
    }

    public void reset() {
        super.reset();
        this.currentBatch = null;
        this.batchRow = 1;
        this.insertCount = 0;
        this.isTempGroupInsert = false;
        this.tupleSource = null;
        this.tupleSourcesReceived = 0;
        this.tupleSourcesProcessed = 0;
        this.requestsRegistered = 0;
        this.insertCommand = null;
    }

    public void setIntoGroup(GroupSymbol group) {
        this.intoGroup = group;
    }

    public void setIntoElements(List intoElements) {
        this.intoElements = intoElements;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void open() throws MetaMatrixComponentException {
        super.open();
        this.insertCommand = new Insert();
        this.insertCommand.setGroup(this.intoGroup);
        this.insertCommand.setVariables((Collection)this.intoElements);
        this.isTempGroupInsert = this.intoGroup.isTempGroupSymbol();
        if (this.isTempGroupInsert) {
            ArrayList<Reference> values = new ArrayList<Reference>(this.intoElements.size());
            for (int i = 0; i < this.intoElements.size(); ++i) {
                Reference ref = new Reference(i, (Expression)((SingleElementSymbol)this.intoElements.get(i)));
                values.add(ref);
            }
            this.insertCommand.setValues(values);
        }
    }

    public TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        if (!this.isTempGroupInsert) {
            if (this.tupleSourcesReceived < this.requestsRegistered) {
                throw BlockedException.INSTANCE;
            }
            if (this.requestsRegistered > 0 && this.tupleSourcesProcessed != this.requestsRegistered) {
                Integer count = (Integer)this.tupleSource.nextTuple().get(0);
                this.insertCount += count.intValue();
                ++this.tupleSourcesProcessed;
            }
        }
        while (true) {
            if (this.currentBatch == null || !this.currentBatch.getTerminationFlag() && this.batchRow > this.currentBatch.getEndRow()) {
                this.currentBatch = this.getChildren()[0].nextBatch();
                this.batchRow = this.currentBatch.getBeginRow();
            }
            if (this.currentBatch.getRowCount() > 0) {
                if (this.batchRow <= this.currentBatch.getEndRow()) {
                    if (this.isTempGroupInsert) {
                        int batchSize = this.doBulkInsertForTemp();
                        this.batchRow += batchSize;
                        this.insertCount += batchSize;
                    } else {
                        if (this.doBulkInsert) {
                            int batchSize = this.doBulkInsert();
                            this.batchRow += batchSize;
                            ++this.requestsRegistered;
                            throw BlockedException.INSTANCE;
                        }
                        if (this.doBatching) {
                            int batchSize = this.currentBatch.getRowCount();
                            int endRow = this.currentBatch.getEndRow();
                            ArrayList<Insert> rows = new ArrayList<Insert>(endRow - this.batchRow);
                            for (int rowNum = this.batchRow; rowNum <= endRow; ++rowNum) {
                                Insert insert = new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.convertValueTypes(this.currentBatch.getTuple(rowNum), this.intoElements), this.intoElements));
                                rows.add(insert);
                            }
                            this.registerRequest((Command)new BatchedUpdateCommand(rows));
                            this.batchRow += batchSize;
                            ++this.requestsRegistered;
                            throw BlockedException.INSTANCE;
                        }
                        this.registerRequest((Command)new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.convertValueTypes(this.currentBatch.getTuple(this.batchRow), this.intoElements), this.intoElements)));
                        ++this.batchRow;
                        ++this.requestsRegistered;
                        throw BlockedException.INSTANCE;
                    }
                }
                if (this.batchRow <= this.currentBatch.getEndRow() || !this.currentBatch.getTerminationFlag()) continue;
                return this.endWork();
            }
            if (this.currentBatch.getTerminationFlag()) break;
        }
        return this.endWork();
    }

    private int doBulkInsertForTemp() throws MetaMatrixComponentException {
        int batchSize = this.currentBatch.getRowCount();
        BulkInsert insert = new BulkInsert(this.intoGroup, this.intoElements);
        int endRow = this.currentBatch.getEndRow();
        ArrayList<List> rows = new ArrayList<List>(endRow - this.batchRow);
        for (int rowNum = this.batchRow; rowNum <= endRow; ++rowNum) {
            rows.add(this.currentBatch.getTuple(rowNum));
        }
        insert.setRows(rows);
        this.registerRequest((Command)insert);
        return batchSize;
    }

    private int doBulkInsert() throws MetaMatrixComponentException {
        int batchSize = this.currentBatch.getRowCount();
        BulkInsert insert = new BulkInsert(this.intoGroup, this.intoElements);
        int endRow = this.currentBatch.getEndRow();
        ArrayList<List> rows = new ArrayList<List>(endRow - this.batchRow);
        for (int rowNum = this.batchRow; rowNum <= endRow; ++rowNum) {
            rows.add(this.convertValueTypes(this.currentBatch.getTuple(rowNum), this.intoElements));
        }
        insert.setRows(rows);
        this.registerRequest((Command)insert);
        return batchSize;
    }

    private void registerRequest(Command command) throws MetaMatrixComponentException {
        this.getDataManager().registerRequest(this.getContext().getProcessorID(), command, this.modelName, this.getID(), execCount++);
    }

    private TupleBatch endWork() throws MetaMatrixComponentException {
        ArrayList<Integer> outputRow = new ArrayList<Integer>(1);
        outputRow.add(new Integer(this.insertCount));
        this.addBatchRow(outputRow);
        this.terminateBatches();
        return this.pullBatch();
    }

    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.intoGroup);
    }

    public Object clone() {
        ProjectIntoNode clonedNode = new ProjectIntoNode(super.getID());
        super.copy((RelationalNode)this, (RelationalNode)clonedNode);
        clonedNode.intoGroup = (GroupSymbol)this.intoGroup.clone();
        clonedNode.intoElements = new ArrayList(this.intoElements);
        clonedNode.modelName = this.modelName;
        clonedNode.doBatching = this.doBatching;
        clonedNode.doBulkInsert = this.doBulkInsert;
        return clonedNode;
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Project Into");
        props.put("intoGrp", this.intoGroup.toString());
        ArrayList<String> selectCols = new ArrayList<String>(this.intoElements.size());
        for (int i = 0; i < this.intoElements.size(); ++i) {
            selectCols.add(this.intoElements.get(i).toString());
        }
        props.put("selectCols", selectCols);
        return props;
    }

    private List convertValuesToConstants(List values, List elements) {
        ArrayList<Constant> constants = new ArrayList<Constant>(values.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol es = (ElementSymbol)elements.get(i);
            Class type = es.getType();
            constants.add(new Constant(values.get(i), type));
        }
        return constants;
    }

    private List convertValueTypes(List values, List elements) {
        ArrayList<Object> result = new ArrayList<Object>(values.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol es = (ElementSymbol)elements.get(i);
            Class type = es.getType();
            Constant value = ResolverUtil.convertConstant((Expression)new Constant(values.get(i)), type);
            if (!type.getName().equals("com.metamatrix.common.types.NullType")) {
                Assertion.isNotNull((Object)value);
            }
            result.add(value.getValue());
        }
        return result;
    }

    protected void setTupleSource(TupleSource tupleSource, int nodeID) {
        this.tupleSource = tupleSource;
        ++this.tupleSourcesReceived;
    }

    public void setDoBatching(boolean doBatching) {
        this.doBatching = doBatching;
    }

    public void setDoBulkInsert(boolean doBulkInsert) {
        this.doBulkInsert = doBulkInsert;
    }

    public boolean isTempGroupInsert() {
        return this.intoGroup.isTempGroupSymbol();
    }
}

