/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.proc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.lob.ValueID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.proc.ProcedureEnvironment;
import com.metamatrix.query.sql.lang.BulkInsert;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ProxyDataManager
implements ProcessorDataManager {
    private ProcessorDataManager processorDataManager;
    private ProcedureEnvironment env;
    private Map processors = new HashMap();
    private Map tempTableTupleSources = new HashMap();
    private Map tupleSourceIDRowCount = new HashMap();
    private BufferManager bufferMgr;

    public ProxyDataManager(ProcessorDataManager processorDataManager, ProcedureEnvironment env, BufferManager bufferMgr) {
        this.processorDataManager = processorDataManager;
        this.env = env;
        this.bufferMgr = bufferMgr;
    }

    public void registerProcessor(Object processorID, QueryProcessor processor) {
        if (!this.processors.containsKey(processorID)) {
            this.processors.put(processorID, processor);
        }
    }

    public void registerRequest(Object processorID, Command command, String modelName, int nodeID, int execCount) throws MetaMatrixComponentException {
        GroupSymbol thisSymbol = this.getGroupSymbol(command);
        LogManager.logTrace("XML_PLAN", new Object[]{"Proxy Data Manager, register request for group symbol", thisSymbol});
        if (thisSymbol != null && this.env.isTempGroup(thisSymbol)) {
            TupleSource tempGroupSource = this.env.getTempGroupSource(thisSymbol.getName());
            QueryProcessor processor = (QueryProcessor)this.processors.get(processorID);
            if (tempGroupSource != null && !(command instanceof Insert)) {
                processor.connectTupleSource(tempGroupSource, nodeID);
                LogManager.logTrace("XML_PLAN", new Object[]{"Proxy Data Manager connected tuple source for group symbol", thisSymbol});
            } else {
                if (command instanceof Insert) {
                    this.saveTempTableData(command, thisSymbol);
                }
                processor.connectTupleSource(new TupleSource(){

                    public List getSchema() {
                        return Collections.EMPTY_LIST;
                    }

                    public void openSource() throws MetaMatrixComponentException {
                    }

                    public List nextTuple() throws MetaMatrixComponentException {
                        return null;
                    }

                    public void closeSource() throws MetaMatrixComponentException {
                    }
                }, nodeID);
            }
            return;
        }
        LogManager.logTrace("XML_PLAN", new Object[]{"Proxy Data Manager, group symbol", thisSymbol, "is not temp group symbol"});
        this.processorDataManager.registerRequest(processorID, command, modelName, nodeID, execCount);
    }

    private void saveTempTableData(Command command, GroupSymbol group) throws MetaMatrixComponentException {
        Insert insert = (Insert)command;
        TupleSourceID tsID = (TupleSourceID)this.tempTableTupleSources.get(group.getName().toUpperCase());
        if (tsID == null) {
            tsID = this.createTempGroupSource(group.getName(), insert.getVariables());
            this.tempTableTupleSources.put(group.getName().toUpperCase(), tsID);
            try {
                this.bufferMgr.setStatus(tsID, 2);
            }
            catch (TupleSourceNotFoundException err) {
                Assertion.failed((String)"Could not find local tuple source for inserting into temp table.");
            }
        }
        if (insert instanceof BulkInsert) {
            this.addTupleBatch(tsID, (BulkInsert)insert);
        } else {
            this.addTuple(tsID, insert.getValues());
        }
    }

    public void unregisterProcessor(Object processorID) {
        this.processors.remove(processorID);
    }

    private GroupSymbol getGroupSymbol(Command command) {
        if (command instanceof Query) {
            Query query = (Query)command;
            GroupSymbol gs = (GroupSymbol)query.getFrom().getGroups().iterator().next();
            return gs;
        }
        if (command instanceof Insert) {
            return ((Insert)command).getGroup();
        }
        return null;
    }

    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, MetaMatrixComponentException {
        return this.processorDataManager.lookupCodeValue(context, codeTableName, returnElementName, keyElementName, keyValue);
    }

    TupleSourceID createTempGroupSource(String groupName, List elements) throws MetaMatrixComponentException {
        TupleSourceID tsId = null;
        try {
            tsId = this.bufferMgr.createTupleSource(elements, TypeRetrievalUtil.getTypeNames((List)elements), this.env.getContext().getConnectionID(), 1);
            TupleSource ts = this.bufferMgr.getTupleSource(tsId);
            ts.openSource();
            this.env.setTempGroupSource(groupName, ts);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e.getMessage());
        }
        return tsId;
    }

    void addTuple(TupleSourceID tsId, List data) throws MetaMatrixComponentException {
        try {
            Integer rowCount = (Integer)this.tupleSourceIDRowCount.get(tsId);
            int rowsInserted = rowCount == null ? 0 : rowCount;
            this.tupleSourceIDRowCount.put(tsId, new Integer(rowsInserted + 1));
            ArrayList<Object> tuple = new ArrayList<Object>(data.size());
            for (int i = 0; i < data.size(); ++i) {
                Object value = data.get(i);
                if (value instanceof Reference) {
                    try {
                        tuple.add(((Reference)value).getValue());
                        continue;
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new MetaMatrixComponentException(e.getMessage());
                    }
                }
                tuple.add(((Constant)value).getValue());
            }
            TupleBatch tupleBatch = new TupleBatch(rowsInserted + 1, new List[]{tuple});
            this.bufferMgr.addTupleBatch(tsId, tupleBatch);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e.getMessage());
        }
    }

    void addTupleBatch(TupleSourceID tsId, BulkInsert insert) throws MetaMatrixComponentException {
        try {
            List tuples = insert.getRows();
            Integer rowCount = (Integer)this.tupleSourceIDRowCount.get(tsId);
            int rowsInserted = rowCount == null ? 0 : rowCount;
            this.tupleSourceIDRowCount.put(tsId, new Integer(rowsInserted + tuples.size()));
            TupleBatch tupleBatch = new TupleBatch(rowsInserted + 1, tuples);
            this.bufferMgr.addTupleBatch(tsId, tupleBatch);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException(e.getMessage());
        }
    }

    void cleanup() {
        Iterator iter = this.tupleSourceIDRowCount.keySet().iterator();
        while (iter.hasNext()) {
            try {
                TupleSourceID tsID = (TupleSourceID)iter.next();
                this.bufferMgr.removeTupleSource(tsID);
            }
            catch (Exception exception) {}
        }
    }

    public void registerLobRequest(Object processorID, ValueID id, int chunkSize) throws MetaMatrixComponentException {
        if (this.processorDataManager != null) {
            this.processorDataManager.registerLobRequest(processorID, id, chunkSize);
        }
    }
}

