/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.modeler.internal.jdbc.JdbcManagerImpl;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcManager;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.metadata.Includes;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNodeVisitor;
import com.metamatrix.modeler.jdbc.metadata.impl.ImportSettingsSelectionVisitor;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcDatabaseImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeSelections;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.BundleContext;

public class JdbcPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.metamatrix.modeler.jdbc";
    private static final String BUNDLE_NAME = "com.metamatrix.modeler.jdbc.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.modeler.jdbc", "com.metamatrix.modeler.jdbc.i18n", ResourceBundle.getBundle("com.metamatrix.modeler.jdbc.i18n"));
    private static final ResourceLocator RESOURCE_LOCATOR = new ResourceLocator(){

        public URL getBaseURL() {
            if (INSTANCE != null) {
                URL baseUrl;
                try {
                    baseUrl = Platform.resolve((URL)INSTANCE.getBundle().getEntry("/"));
                }
                catch (IOException iOException) {
                    baseUrl = null;
                }
                return baseUrl;
            }
            try {
                URI uri = URI.createURI((String)this.getClass().getResource("plugin.properties").toString());
                URL baseUrl = new URL(String.valueOf(uri.trimSegments(1).toString()) + "/");
                return baseUrl;
            }
            catch (IOException exception) {
                throw new WrappedException((Exception)exception);
            }
        }

        public Object getImage(String key) {
            try {
                URL baseUrl = this.getBaseURL();
                URL url = new URL(baseUrl + "icons/" + key + ".gif");
                InputStream inputStream = url.openStream();
                inputStream.close();
                return url;
            }
            catch (MalformedURLException exception) {
                throw new WrappedException((Exception)exception);
            }
            catch (IOException iOException) {
                throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
            }
        }

        public String getString(String key) {
            return Util.getString(key);
        }

        public String getString(String key, Object[] substitutions) {
            return Util.getString(key, substitutions);
        }

        public String getString(String key, boolean translate) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.getString(key, substitutions);
        }
    };
    private static JdbcPlugin INSTANCE = null;
    public static boolean DEBUG = false;

    public static ResourceLocator getPluginResourceLocator() {
        return RESOURCE_LOCATOR;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public static JdbcManager createJdbcManager(String name, Resource model) throws JdbcException {
        JdbcManagerImpl mgr = new JdbcManagerImpl(name, model);
        mgr.start();
        return mgr;
    }

    public static JdbcDatabase getJdbcDatabase(JdbcSource source, Connection connection) {
        IStatus status;
        ArgCheck.isNotNull((Object)source);
        ArgCheck.isNotNull((Object)connection);
        JdbcNodeSelections selectionsCache = new JdbcNodeSelections();
        JdbcImportSettings settings = source.getImportSettings();
        if (settings != null) {
            selectionsCache.initialize(settings);
        }
        boolean existingSelections = selectionsCache.hasSelectionModes();
        JdbcDatabaseImpl result = new JdbcDatabaseImpl(connection, source.getName(), selectionsCache);
        if (!existingSelections && (status = result.selectDefaultNodes()).getSeverity() == 4) {
            Util.log(status);
        }
        if (settings != null) {
            Includes includes = result.getIncludes();
            EList includedTableTypes = settings.getIncludedTableTypes();
            String[] typesToInclude = includedTableTypes.toArray(new String[includedTableTypes.size()]);
            includes.setIncludedTableTypes(typesToInclude);
            includes.setApproximateIndexes(settings.isIncludeApproximateIndexes());
            includes.setIncludeForeignKeys(settings.isIncludeForeignKeys());
            includes.setIncludeIndexes(settings.isIncludeIndexes());
            includes.setIncludeProcedures(settings.isIncludeProcedures());
            includes.setUniqueIndexesOnly(settings.isIncludeUniqueIndexes());
        }
        return result;
    }

    public static JdbcImportSettings ensureNonNullImportSettings(JdbcSource source) {
        ArgCheck.isNotNull((Object)source);
        JdbcImportSettings settings = source.getImportSettings();
        if (settings == null) {
            settings = JdbcFactory.eINSTANCE.createJdbcImportSettings();
            source.setImportSettings(settings);
        }
        return settings;
    }

    public static void recordJdbcDatabaseSelections(JdbcSource source, JdbcDatabase database) throws JdbcException {
        ArgCheck.isNotNull((Object)source);
        ArgCheck.isNotNull((Object)database);
        JdbcImportSettings settings = JdbcPlugin.ensureNonNullImportSettings(source);
        ImportSettingsSelectionVisitor visitor = new ImportSettingsSelectionVisitor(settings);
        database.accept((JdbcNodeVisitor)visitor, 2);
    }
}

