/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.loader;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBModelDefn;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.vdb.edit.VdbContext;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.loader.VDBDefnXMLHelper;
import com.metamatrix.vdb.edit.loader.VDBWriter;
import com.metamatrix.vdb.edit.loader.VdbProcessingException;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.Severity;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.edit.materialization.ScriptType;
import com.metamatrix.vdb.internal.edit.VdbContextImpl;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import com.metamatrix.vdb.internal.runtime.model.BasicModelInfo;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBDefn;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBModelDefn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.jdom.Element;

public class VDBReader {
    private static final String TEMP_VDB_NAME = "tmp.vdb";
    private static final Random random = new Random(System.currentTimeMillis());
    public static final String[] VDB_READER_EXTENSIONS = new String[]{".def", ".vdb"};
    private VdbContext editor = null;
    private TempDirectory tempVDBFiles = null;
    private ConfigurationModelContainer configContainer = null;

    protected VDBReader() {
    }

    protected VDBReader(ConfigurationModelContainer configContainerModel) {
        this.configContainer = configContainerModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidVDBDefFileIncluded(String vdbArchiveFileName) throws Exception {
        VDBReader factory = new VDBReader();
        try {
            factory.createVDBContextEditor(new File(vdbArchiveFileName));
            boolean bl = factory.isValidDefnFile();
            return bl;
        }
        finally {
            factory.cleanup(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidVDBDefFileIncluded(byte[] vdbArchive) throws Exception {
        VDBReader factory = new VDBReader();
        try {
            factory.createVDBContextEditor(TEMP_VDB_NAME, vdbArchive);
            boolean bl = factory.isValidDefnFile();
            return bl;
        }
        finally {
            factory.cleanup(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getVDBDefFile(String vdbArchiveFileName) throws Exception {
        VDBReader factory = new VDBReader();
        try {
            factory.createVDBContextEditor(new File(vdbArchiveFileName));
            File file = factory.getVDBDefnFile();
            return file;
        }
        finally {
            factory.cleanup(true);
        }
    }

    public static InputStream createVDBDefnInputStream(VDBDefn vdbDefn, Properties headerProps) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        VDBWriter.writeVDBDefn((OutputStream)bos, (VDBDefn)vdbDefn, (Properties)headerProps);
        byte[] contents = bos.toByteArray();
        bos.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(contents);
        return bis;
    }

    public static VDBDefn loadVDBDefn(String fileName, String directory) throws Exception {
        return VDBReader.loadVdbDefn(fileName, directory, true, null);
    }

    private static VDBDefn loadVdbDefn(String fileName, String directory, boolean closeContext, File archiveSoftRef) throws Exception {
        VDBReader factory = new VDBReader();
        File f = null;
        f = directory != null ? new File(directory, fileName) : new File(fileName);
        try {
            boolean isDotVDB = VDBReader.isVDBArchive(f.getAbsolutePath());
            if (isDotVDB) {
                factory.createVDBContextEditor(f.getAbsoluteFile());
                byte[] vdbContent = null;
                if (archiveSoftRef == null) {
                    vdbContent = ByteArrayHelper.toByteArray((File)f);
                }
                VDBDefn vDBDefn = factory.createVDBDefnFromContextEditor(null, vdbContent, archiveSoftRef, true);
                return vDBDefn;
            }
            if (VDBReader.isVDBDef(f.getAbsolutePath())) {
                VDBDefn vDBDefn = factory.createVDBDefn(f, archiveSoftRef);
                return vDBDefn;
            }
            try {
                throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBReader.Invalid_file_type", (Object)f.getAbsolutePath()));
            }
            catch (MetaMatrixCoreException mmc) {
                throw mmc;
            }
            catch (Exception e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }
        finally {
            factory.cleanup(closeContext);
        }
    }

    public static VDBDefn loadVDBDefn(String name, byte[] vdbFile, char[] defFile) throws Exception {
        VDBReader factory = new VDBReader();
        try {
            VDBDefn defn = null;
            if (defFile == null || defFile.length == 0) {
                factory.createVDBContextEditor(name, vdbFile);
                defn = factory.createVDBDefnFromContextEditor(name, vdbFile, null, false);
            } else {
                defn = factory.createVDBDefnFromDEF(name, vdbFile, defFile, null);
            }
            VDBDefn vDBDefn = defn;
            return vDBDefn;
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        finally {
            factory.cleanup(true);
        }
    }

    public static VDBDefn loadVDBDefn(byte[] vdbFile, String vdbName) throws Exception {
        VDBReader factory = new VDBReader();
        try {
            VDBDefn defn = null;
            factory.createVDBContextEditor(vdbName, vdbFile);
            VDBDefn vDBDefn = defn = factory.createVDBDefnFromContextEditor(vdbName, vdbFile, null, false);
            return vDBDefn;
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        finally {
            factory.cleanup(true);
        }
    }

    public static VDBDefn loadVDBDefn(VDBDefn vdbDefn, byte[] vdbArchive) throws MetaMatrixCoreException {
        VDBReader factory = new VDBReader();
        try {
            VDBDefn vDBDefn = factory.createVDBDefnFromContextEditor(vdbDefn, vdbArchive);
            return vDBDefn;
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        finally {
            try {
                factory.cleanup(true);
            }
            catch (Exception e) {}
        }
    }

    public static VDBDefn loadVDBDefn(VdbEditingContextImpl contextEditor) throws Exception {
        VDBDefn defn = null;
        if (!contextEditor.isOpen()) {
            return VDBReader.loadVDBDefn(contextEditor, true);
        }
        File vdbArchiveFile = contextEditor.getPathToVdb().toFile();
        File tempDirFolder = contextEditor.getVdbContentsFolder();
        VirtualDatabase vdb = contextEditor.getVirtualDatabase();
        ConfigurationModelContainer configCntr = null;
        byte[] vdbFileContents = null;
        File archiveSoftRef = null;
        boolean failIfNoDef = false;
        defn = VDBReader.createVDBDefnFromContextEditor(vdbArchiveFile, tempDirFolder, vdb, configCntr, vdbFileContents, archiveSoftRef, failIfNoDef);
        return defn;
    }

    public static VDBDefn loadVDBDefn(VdbEditingContextImpl contextEditor, boolean closeEditor) throws Exception {
        VDBReader factory = new VDBReader();
        try {
            VDBDefn defn;
            VDBDefn vDBDefn = defn = factory.createVDBDefnFromEditor(contextEditor);
            return vDBDefn;
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        finally {
            factory.cleanup(closeEditor);
        }
    }

    public static VDBDefn loadVDBDefn(VdbContext contextEditor, boolean closeEditor) throws Exception {
        VDBDefn defn = null;
        if (!contextEditor.isOpen()) {
            VDBReader factory = new VDBReader();
            try {
                VDBDefn vDBDefn = defn = factory.createVDBDefnFromEditor(contextEditor);
                return vDBDefn;
            }
            catch (MetaMatrixCoreException mmc) {
                throw mmc;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
            finally {
                factory.cleanup(closeEditor);
            }
        }
        File vdbArchiveFile = contextEditor.getVdbFile();
        File tempDirFolder = new File(contextEditor.getTempDirectory().getPath());
        VirtualDatabase vdb = contextEditor.getVirtualDatabase();
        ConfigurationModelContainer configCntr = null;
        byte[] vdbFileContents = null;
        File archiveSoftRef = null;
        boolean failIfNoDef = false;
        defn = VDBReader.createVDBDefnFromContextEditor(vdbArchiveFile, tempDirFolder, vdb, configCntr, vdbFileContents, archiveSoftRef, failIfNoDef);
        return defn;
    }

    public static VDBDefn loadVDBDefn(VdbEditingContextImpl contextEditor, boolean closeEditor, ConfigurationModelContainer configModelContainer) throws Exception {
        VDBReader factory = new VDBReader(configModelContainer);
        try {
            VDBDefn defn;
            VDBDefn vDBDefn = defn = factory.createVDBDefnFromEditor(contextEditor);
            return vDBDefn;
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        finally {
            factory.cleanup(closeEditor);
        }
    }

    public static VDBDefn loadVDBDefn(VdbContextEditor contextEditor, boolean closeEditor, ConfigurationModelContainer configModelContainer) throws Exception {
        VDBReader factory = new VDBReader(configModelContainer);
        try {
            VDBDefn defn;
            VDBDefn vDBDefn = defn = factory.createVDBDefnFromEditor((VdbContext)contextEditor);
            return vDBDefn;
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        finally {
            factory.cleanup(closeEditor);
        }
    }

    public static VDBDefn loadVDBDefn(VdbContext context, boolean closeEditor, ConfigurationModelContainer configModelContainer) throws Exception {
        VDBDefn defn = null;
        File vdbArchiveFile = context.getVdbFile();
        File tempDirFolder = new File(context.getTempDirectory().getPath());
        VirtualDatabase vdb = context.getVirtualDatabase();
        ConfigurationModelContainer configCntr = configModelContainer;
        byte[] vdbFileContents = null;
        File archiveSoftRef = null;
        boolean failIfNoDef = false;
        defn = VDBReader.createVDBDefnFromContextEditor(vdbArchiveFile, tempDirFolder, vdb, configCntr, vdbFileContents, archiveSoftRef, failIfNoDef);
        return defn;
    }

    public static VDBDefn loadVDBDefn(String fileName, String directory, File softRefLocation) throws Exception {
        return VDBReader.loadVdbDefn(fileName, directory, true, softRefLocation);
    }

    private VDBDefn createVDBDefnFromContextEditor(VDBDefn vdbDefn, byte[] vdbArchive) throws Exception {
        String fileName = vdbDefn.getFileName();
        if (fileName == null) {
            fileName = vdbDefn.getName();
        }
        this.createVDBContextEditor(fileName, vdbArchive);
        BasicVDBDefn basedefn = (BasicVDBDefn)this.createVDBDefnFromContextEditor(vdbDefn.getName(), vdbArchive, null, false);
        if (vdbDefn.getVersion() != null) {
            basedefn.setVersion(vdbDefn.getVersion());
        }
        if (vdbDefn.getDateCreated() != null) {
            basedefn.setDateCreated(vdbDefn.getDateCreated());
        }
        if (vdbDefn.getCreatedBy() != null) {
            basedefn.setCreatedBy(vdbDefn.getCreatedBy());
        }
        if (vdbDefn.getDescription() != null) {
            basedefn.setDescription(vdbDefn.getDescription());
        }
        Iterator types = vdbDefn.getConnectorTypes().values().iterator();
        while (types.hasNext()) {
            ConnectorBindingType t = (ConnectorBindingType)types.next();
            basedefn.addConnectorType((ComponentType)t);
        }
        Iterator mit = vdbDefn.getModels().iterator();
        while (mit.hasNext()) {
            ModelInfo mi = (ModelInfo)mit.next();
            BasicModelInfo miu = (BasicModelInfo)basedefn.getModel(mi.getName());
            miu.setIsVisible(mi.isVisible());
            miu.enableMutliSourceBindings(mi.isMultiSourceBindingEnabled());
            List bindingNames = mi.getConnectorBindingNames();
            if (bindingNames == null) continue;
            Iterator bit = bindingNames.iterator();
            while (bit.hasNext()) {
                String bname = (String)bit.next();
                ConnectorBinding cb = vdbDefn.getConnectorBindingByName(bname);
                if (cb == null) continue;
                basedefn.addConnectorBinding(miu.getName(), cb);
            }
        }
        return basedefn;
    }

    private VDBDefn createVDBDefn(File vdbDefFile, File archiveSoftRef) throws Exception {
        VDBDefn defn = null;
        if (vdbDefFile == null) {
            Assertion.isNotNull((Object)vdbDefFile, (String)VdbEditPlugin.Util.getString("VDBReader.VDBDefn_file_arg_null"));
        }
        if (!vdbDefFile.exists()) {
            throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBReader.VDBDefn_file_doesnt_exist", (Object)vdbDefFile));
        }
        if (!vdbDefFile.canRead()) {
            throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBReader.VDBDefn_file_not_readable", (Object)vdbDefFile));
        }
        try {
            VDBDefnXMLHelper helper = VDBReader.createVDBXMLHelper();
            Element root = helper.getRoot(vdbDefFile);
            VDBDefn defntemp = helper.createVDBDefn(root, null);
            File archiveFile = new File(vdbDefFile.getParent(), defntemp.getFileName());
            this.createVDBContextEditor(archiveFile);
            defn = helper.createVDBDefn(this.editor.getVirtualDatabase(), archiveSoftRef);
            helper.addVDBDefnInfo(defn, root);
            if (archiveSoftRef == null) {
                byte[] archivebyteArray = new byte[]{};
                archivebyteArray = ByteArrayHelper.toByteArray((File)archiveFile);
                ((BasicVDBDefn)defn).setVDBJar(archivebyteArray);
            }
            VDBReader.loadFromContextEditor(this.editor.getVdbFile(), this.editor.getVirtualDatabase(), defn);
            defn = VDBReader.loadAddtionalVDBModelInfo(defn, root, this.configContainer);
            VDBReader.determineVDBStatus(defn);
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return defn;
    }

    private static boolean isVDBArchive(String fileName) {
        return fileName.toLowerCase().endsWith(VDB_READER_EXTENSIONS[1]);
    }

    private static boolean isVDBDef(String fileName) {
        return fileName.toLowerCase().endsWith(VDB_READER_EXTENSIONS[0]);
    }

    private VDBDefn createVDBDefnFromDEF(String name, byte[] vdbFile, char[] defFile, File archiveSoftRef) throws Exception {
        VDBDefn defn = null;
        if (defFile == null) {
            Assertion.isNotNull((Object)defFile, (String)"VDB Defn File Name must be specified");
        }
        try {
            VDBDefnXMLHelper helper = VDBReader.createVDBXMLHelper();
            Element root = helper.getRoot(defFile);
            VDBDefn defntemp = helper.createVDBDefn(root, null);
            String fileName = defntemp.getFileName();
            if (fileName == null) {
                fileName = name;
            }
            this.createVDBContextEditor(fileName, vdbFile);
            defn = helper.createVDBDefn(this.editor.getVirtualDatabase(), archiveSoftRef);
            helper.addVDBDefnInfo(defn, root);
            if (archiveSoftRef == null) {
                ((BasicVDBDefn)defn).setVDBJar(vdbFile);
            }
            VDBReader.loadFromContextEditor(this.editor.getVdbFile(), this.editor.getVirtualDatabase(), defn);
            defn = VDBReader.loadAddtionalVDBModelInfo(defn, root, this.configContainer);
            if (name != null) {
                ((BasicVDBDefn)defn).setName(name);
            }
            VDBReader.determineVDBStatus(defn);
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return defn;
    }

    private VDBDefn createVDBDefnFromEditor(VdbEditingContextImpl contextEditor) throws Exception {
        VDBDefn defn = null;
        File vdbFile = contextEditor.getPathToVdb().toFile();
        this.editor = this.createVDBContextEditor(vdbFile);
        if (this.editor instanceof VdbContextImpl && contextEditor.getVirtualDatabase() != null) {
            ((VdbContextImpl)this.editor).setVirtualDatabase(contextEditor.getVirtualDatabase());
        }
        defn = this.createVDBDefnFromContextEditor(this.editor.getVirtualDatabase().getName(), null, null, false);
        return defn;
    }

    private VDBDefn createVDBDefnFromEditor(VdbContext contextEditor) throws Exception {
        VDBDefn defn = null;
        File vdbFile = contextEditor.getVdbFile();
        this.editor = this.createVDBContextEditor(vdbFile);
        defn = this.createVDBDefnFromContextEditor(this.editor.getVirtualDatabase().getName(), null, null, false);
        return defn;
    }

    private static VDBDefn createVDBDefnFromContextEditor(File vdbArchiveFile, File tempDirFolder, VirtualDatabase vdb, ConfigurationModelContainer configCntr, byte[] vdbFileContents, File archiveSoftRef, boolean failIfNoDef) throws Exception {
        VDBDefn defn = null;
        File vdbDefnFile = VDBReader.getVDBDefnFile(tempDirFolder, vdbArchiveFile);
        if (failIfNoDef) {
            if (vdbDefnFile == null || vdbDefnFile.length() == 0L) {
                throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBReader.VDBDefn_file_not_in_vdbarchive", (Object)vdb.getName()));
            }
            if (!vdbDefnFile.exists()) {
                throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBReader.VDBDefn_file_not_found"));
            }
        }
        try {
            VDBDefnXMLHelper helper = VDBReader.createVDBXMLHelper();
            defn = helper.createVDBDefn(vdb, archiveSoftRef);
            Element root = null;
            if (vdbDefnFile != null) {
                byte[] vdbDefn = ByteArrayHelper.toByteArray((File)vdbDefnFile);
                String vdbString = new String(vdbDefn);
                root = helper.getRoot(vdbString.toCharArray());
                helper.addVDBDefnInfo(defn, root);
                helper.addExecutionProperties(defn, root);
            }
            if (archiveSoftRef == null && vdbFileContents != null) {
                ((BasicVDBDefn)defn).setVDBJar(vdbFileContents);
            }
            VDBReader.loadFromContextEditor(vdbArchiveFile, vdb, defn);
            if (vdbDefnFile != null) {
                defn = VDBReader.loadAddtionalVDBModelInfo(defn, root, configCntr);
            }
            if (vdb.getName() != null) {
                ((BasicVDBDefn)defn).setName(vdb.getName());
            }
            VDBReader.determineVDBStatus(defn);
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return defn;
    }

    private VDBDefn createVDBDefnFromContextEditor(String name, byte[] vdbFile, File archiveSoftRef, boolean failIfNoDef) throws Exception {
        VDBDefn defn = null;
        File vdbDefnFile = this.getVDBDefnFile();
        if (failIfNoDef) {
            if (vdbDefnFile == null || vdbDefnFile.length() == 0L) {
                throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBReader.VDBDefn_file_not_in_vdbarchive", (Object)name));
            }
            if (!vdbDefnFile.exists()) {
                throw new MetaMatrixRuntimeException(VdbEditPlugin.Util.getString("VDBReader.VDBDefn_file_not_found"));
            }
        }
        try {
            VDBDefnXMLHelper helper = VDBReader.createVDBXMLHelper();
            defn = helper.createVDBDefn(this.editor.getVirtualDatabase(), archiveSoftRef);
            Element root = null;
            if (vdbDefnFile != null) {
                byte[] vdbDefn = ByteArrayHelper.toByteArray((File)vdbDefnFile);
                String vdbString = new String(vdbDefn);
                root = helper.getRoot(vdbString.toCharArray());
                helper.addVDBDefnInfo(defn, root);
                helper.addExecutionProperties(defn, root);
            }
            if (archiveSoftRef == null && vdbFile != null) {
                ((BasicVDBDefn)defn).setVDBJar(vdbFile);
            }
            VDBReader.loadFromContextEditor(this.editor.getVdbFile(), this.editor.getVirtualDatabase(), defn);
            if (vdbDefnFile != null) {
                defn = VDBReader.loadAddtionalVDBModelInfo(defn, root, this.configContainer);
            }
            if (name != null) {
                ((BasicVDBDefn)defn).setName(name);
            }
            VDBReader.determineVDBStatus(defn);
        }
        catch (MetaMatrixCoreException mmc) {
            throw mmc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return defn;
    }

    private static VDBDefnXMLHelper createVDBXMLHelper() {
        return new VDBDefnXMLHelper();
    }

    private static void loadFromContextEditor(File vdbFile, VirtualDatabase vdb, VDBDefn vdbDefn) throws VdbProcessingException, MetaMatrixComponentException {
        ArrayList<VDBModelDefn> collection = null;
        boolean isIncomplete = false;
        boolean isError = false;
        try {
            ZipFile vdbArchive;
            EList modelRef;
            BasicVDBDefn defn = (BasicVDBDefn)vdbDefn;
            defn.setHasWSDLDefined(VDBReader.hasWsdl(vdbFile));
            Severity severity = vdb.getSeverity();
            if (severity.getValue() == 3) {
                defn.setModelInfos(new ArrayList(1));
                defn.setStatus((short)1);
                String msg = VdbEditPlugin.Util.getString("VDBReader.VDB_is_at_a_nondeployable_severity_state", new Object[]{vdb.getName(), severity.getName()});
                defn.setVDBValidityError(isIncomplete, msg);
                isIncomplete = true;
                isError = true;
            }
            if ((modelRef = vdb.getModels()) == null || modelRef.isEmpty()) {
                defn.setModelInfos(new ArrayList(1));
                defn.setStatus((short)1);
                String msg = VdbEditPlugin.Util.getString("VDBReader.No_models_in_vdb_1", (Object)vdbDefn.getFileName());
                defn.setVDBValidityError(isIncomplete, msg);
                isIncomplete = true;
                return;
            }
            Iterator iter = modelRef.iterator();
            collection = new ArrayList<VDBModelDefn>(modelRef.size());
            Severity modseverity = null;
            while (iter.hasNext()) {
                ModelReference model = (ModelReference)iter.next();
                modseverity = model.getSeverity();
                if (modseverity.getValue() == 3) {
                    defn.setStatus((short)1);
                    String msg = VdbEditPlugin.Util.getString("VDBReader.Model_is_at_a_nondeployable_severity_state", new Object[]{model.getName(), modseverity.getName()});
                    defn.setVDBValidityError(isIncomplete, msg);
                    isIncomplete = true;
                }
                int modelType = model.getModelType().getValue();
                switch (modelType) {
                    case 0: 
                    case 1: 
                    case 10: {
                        ZipFile vdbArchive2;
                        VDBModelDefn modelEntry = (VDBModelDefn)VDBReader.createModelInfo(model);
                        if (modelEntry.getModelURI() == null) break;
                        if (modelType == 10 && (vdbArchive2 = VDBReader.getVdbArchive(vdbFile)) != null) {
                            HashMap<String, byte[]> ddlFileNamesToFiles = new HashMap<String, byte[]>();
                            Enumeration<? extends ZipEntry> e = vdbArchive2.entries();
                            while (e.hasMoreElements()) {
                                String pathInVdb;
                                String fileName;
                                ZipEntry entry = e.nextElement();
                                if (entry == null || !VDBReader.isVdbMaterializationDDLFile(fileName = new Path(pathInVdb = entry.getName()).lastSegment())) continue;
                                InputStream fileStream = vdbArchive2.getInputStream(entry);
                                ddlFileNamesToFiles.put(pathInVdb, ByteArrayHelper.toByteArray((InputStream)fileStream, (int)1024));
                                fileStream.close();
                            }
                            modelEntry.setDDLFiles(ddlFileNamesToFiles);
                        }
                        collection.add(modelEntry);
                    }
                }
            }
            defn.setModelInfos(collection);
            defn.setVDBValidityError(isIncomplete);
            if (!isError) {
                VDBReader.determineVDBStatus((VDBDefn)defn);
            }
            if ((vdbArchive = VDBReader.getVdbArchive(vdbFile)) != null) {
                Enumeration<? extends ZipEntry> e = vdbArchive.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    defn.setVisibility(entry.getName(), VDBReader.isVisible(vdb, entry));
                }
            }
            return;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static ModelInfo createModelInfo(ModelReference modelRef) {
        return new BasicVDBModelDefn(modelRef);
    }

    private static VDBDefn loadAddtionalVDBModelInfo(VDBDefn defn, Element root, ConfigurationModelContainer configCntr) throws Exception {
        VDBDefnXMLHelper helper = VDBReader.createVDBXMLHelper();
        Properties headerProps = new VDBDefnXMLHelper().getHeaderProperties(root);
        boolean is42 = VDBDefnXMLHelper.is42ConfigurationCompatible((Properties)headerProps);
        defn = is42 ? helper.addModelInfo42(root, defn, configCntr) : (VDBDefnXMLHelper.is41Compatible((Properties)headerProps) ? helper.addModelInfo42(root, defn, configCntr) : helper.addModelInfo(root, defn, configCntr));
        return defn;
    }

    VdbContext createVDBContextEditor(String fileName, byte[] vdbFile) throws VdbProcessingException, MetaMatrixComponentException {
        if (fileName == null) {
            fileName = TEMP_VDB_NAME;
        } else if (!VDBReader.isVDBArchive(fileName)) {
            fileName = fileName + ".vdb";
        }
        this.tempVDBFiles = null;
        try {
            this.tempVDBFiles = new TempDirectory(System.currentTimeMillis(), random.nextLong());
            this.tempVDBFiles.create();
            File f = new File(this.tempVDBFiles.getPath(), fileName);
            new FileUtil(f.getAbsolutePath()).writeBytes(vdbFile);
            return this.createVDBContextEditor(f);
        }
        catch (VdbProcessingException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    private VdbContext createVDBContextEditor(File vdbArchive) throws VdbProcessingException, MetaMatrixComponentException {
        try {
            File vdbWorkingFolder = null;
            vdbWorkingFolder = VdbEditPlugin.getInstance() != null ? VdbEditPlugin.getVdbWorkingDirectory() : new File(FileUtils.TEMP_DIRECTORY);
            if (!vdbWorkingFolder.exists()) {
                vdbWorkingFolder.mkdir();
            }
            this.editor = new VdbContextImpl(vdbArchive, vdbWorkingFolder);
            this.editor.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        return this.editor;
    }

    private static void determineVDBStatus(VDBDefn defn) {
        BasicVDBDefn bvdbdefn = (BasicVDBDefn)defn;
        bvdbdefn.determineVdbsStatus();
    }

    private File getVDBDefnFile() {
        File tempDirFolder = new File(this.editor.getTempDirectory().getPath());
        File vdbFile = this.editor.getVdbFile();
        return VDBReader.getVDBDefnFile(tempDirFolder, vdbFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getVDBDefnFile(File tempDirFolder, File vdbFile) {
        File defnFile = new File(tempDirFolder, "ConfigurationInfo.def");
        if (defnFile.exists() && defnFile.length() > 0L) {
            return defnFile;
        }
        defnFile = null;
        if (!vdbFile.exists() || vdbFile.length() <= 0L) return defnFile;
        InputStream is = null;
        ZipFile archive = new ZipFile(vdbFile);
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry == null || !entry.getName().equalsIgnoreCase("ConfigurationInfo.def")) continue;
            is = archive.getInputStream(entry);
            defnFile = new File(tempDirFolder, "ConfigurationInfo.def");
            FileUtils.write((InputStream)is, (File)defnFile);
            break;
        }
        Object var8_8 = null;
        if (is == null) return defnFile;
        try {
            is.close();
            return defnFile;
        }
        catch (IOException ignored) {}
        return defnFile;
        {
            catch (Exception e) {
                defnFile = null;
                VdbEditPlugin.Util.log(4, e.getLocalizedMessage());
                Object var8_9 = null;
                if (is == null) return defnFile;
                try {
                    is.close();
                    return defnFile;
                }
                catch (IOException ignored) {}
                return defnFile;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean isValidDefnFile() {
        File f = this.getVDBDefnFile();
        if (f == null) {
            return false;
        }
        VDBDefnXMLHelper helper = VDBReader.createVDBXMLHelper();
        try {
            Element root = helper.getRoot(f);
            return helper.containsModelInfo(root);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void cleanup(boolean closeEditor) throws Exception {
        VDBReader.cleanup(this.editor, this.tempVDBFiles, closeEditor);
    }

    private static void cleanup(VdbContext context, TempDirectory tempDir, boolean closeEditor) throws Exception {
        Exception error = null;
        try {
            if (closeEditor && context != null) {
                context.close((IProgressMonitor)new NullProgressMonitor());
                context.dispose();
            }
        }
        catch (Exception e) {
            error = e;
        }
        try {
            if (tempDir != null) {
                tempDir.remove();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (error != null) {
            throw error;
        }
    }

    private static ZipFile getVdbArchive(File vdbFile) throws ZipException, IOException {
        ArgCheck.isNotNull((Object)vdbFile);
        if (vdbFile != null && vdbFile.exists() && vdbFile.length() > 0L) {
            return new ZipFile(vdbFile);
        }
        return null;
    }

    private static boolean hasWsdl(File vdbFile) throws ZipException, IOException {
        ZipEntry entry;
        ArgCheck.isNotNull((Object)vdbFile);
        boolean hasWsdl = false;
        ZipFile archive = VDBReader.getVdbArchive(vdbFile);
        if (archive != null && (entry = archive.getEntry("MetaMatrixDataServices.wsdl")) != null) {
            hasWsdl = true;
        }
        return hasWsdl;
    }

    private static boolean isVdbMaterializationDDLFile(String fileName) {
        ArgCheck.isNotNull((Object)fileName);
        return ScriptType.isDDLScript((String)fileName) && (ScriptType.isMaterializationScript((String)fileName) || ScriptType.isCreateScript((String)fileName) || ScriptType.isSwapScript((String)fileName) || ScriptType.isTruncateScript((String)fileName) || ScriptType.isLoadScript((String)fileName));
    }

    private static boolean isVisible(VirtualDatabase vdb, ZipEntry entry) {
        ArgCheck.isNotNull((Object)vdb);
        ArgCheck.isNotNull((Object)entry);
        String pathInArchive = entry.getName();
        ModelReference ref = VDBReader.getModelReference(vdb, pathInArchive);
        if (ref != null) {
            return ref.isVisible();
        }
        String fileName = new Path(pathInArchive).lastSegment();
        if (fileName != null) {
            if (IndexUtil.isIndexFile((String)fileName)) {
                return false;
            }
            if (fileName.equalsIgnoreCase("MetaMatrix-VdbManifestModel.xmi")) {
                return false;
            }
            if (StringUtil.startsWithIgnoreCase((String)fileName, (String)"MaterializationModel") && StringUtil.endsWithIgnoreCase((String)fileName, (String)".xmi")) {
                return false;
            }
            if (VDBReader.isVdbMaterializationDDLFile(fileName)) {
                return false;
            }
            if (fileName.equalsIgnoreCase("MetaMatrixDataServices.wsdl")) {
                return true;
            }
            return true;
        }
        return false;
    }

    private static ModelReference getModelReference(VirtualDatabase vdb, String pathInArchive) {
        ArgCheck.isNotNull((Object)vdb);
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        IPath pathToMatch = VDBReader.createNormalizedPath(pathInArchive);
        Iterator i = vdb.getModels().iterator();
        while (i.hasNext()) {
            ModelReference ref = (ModelReference)i.next();
            IPath refPath = VDBReader.createNormalizedPath(ref.getModelLocation());
            if (!pathToMatch.equals(refPath)) continue;
            return ref;
        }
        IPath upperPathToMatch = VDBReader.createNormalizedPath(pathInArchive.toUpperCase());
        Iterator i2 = vdb.getModels().iterator();
        while (i2.hasNext()) {
            ModelReference ref = (ModelReference)i2.next();
            IPath upperRefPath = VDBReader.createNormalizedPath(ref.getModelLocation().toUpperCase());
            if (!upperPathToMatch.equals(upperRefPath)) continue;
            return ref;
        }
        return null;
    }

    private static IPath createNormalizedPath(String pathInArchive) {
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        Path path = new Path(pathInArchive);
        return path.segmentCount() == 1 ? path.removeTrailingSeparator().makeRelative() : path.makeAbsolute();
    }
}

