/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.tools.genericimport.ui.wizards;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.builder.MetamodelBuilderPlugin;
import com.metamatrix.metamodels.builder.MetamodelEntityBuilder;
import com.metamatrix.metamodels.builder.ModelBuilder;
import com.metamatrix.metamodels.builder.processor.Processor;
import com.metamatrix.metamodels.internal.builder.execution.MetamodelEntityBuilderImpl;
import com.metamatrix.metamodels.internal.builder.execution.ModelBuilderImpl;
import com.metamatrix.metamodels.internal.builder.execution.processor.EntityProcessor;
import com.metamatrix.metamodels.internal.builder.execution.processor.ModelProcessor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommand;
import com.metamatrix.modeler.core.refactor.OrganizeImportHandler;
import com.metamatrix.modeler.tools.genericimport.ui.UiConstants;
import com.metamatrix.modeler.tools.genericimport.ui.util.GenericImportUtil;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class GenericImportProcessor
implements Processor {
    Connection sqlConnection;
    String modelName;
    IContainer targetLocation;
    String targetLocationStr;
    ResourceSet resourceSet;
    private MultiStatus status;
    private List allResources;
    private boolean builderDebugEnabled = false;
    private static final String DELIM = ".";
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$tools$genericimport$ui$wizards$GenericImportProcessor == null ? (class$com$metamatrix$modeler$tools$genericimport$ui$wizards$GenericImportProcessor = GenericImportProcessor.class$("com.metamatrix.modeler.tools.genericimport.ui.wizards.GenericImportProcessor")) : class$com$metamatrix$modeler$tools$genericimport$ui$wizards$GenericImportProcessor));
    private static final String EXTMODELS_SCHEMA = "ExtModels";
    private static final String MODELS_SCHEMA = "Models";
    private static final String RELATIONAL_SCHEMA = "Relational";
    private static final String EXTENSIONS_SCHEMA = "Extensions";
    private static final String RELATIONSHIP_SCHEMA = "Relationship";
    private static final String XSD_SCHEMA = "XSD";
    private static final String UML_SCHEMA = "UML";
    private static final String[] PROCESS_ORDER = new String[]{"ExtModels", "Extensions", "Models", "Relational", "Relationship", "XSD", "UML"};
    static /* synthetic */ Class class$com$metamatrix$modeler$tools$genericimport$ui$wizards$GenericImportProcessor;

    private static String getString(String id) {
        return UiConstants.Util.getString(I18N_PREFIX + id);
    }

    GenericImportProcessor(Connection sqlConnection, String modelName, IContainer targetLocation, MultiStatus status) {
        this.sqlConnection = sqlConnection;
        this.modelName = modelName;
        this.targetLocation = targetLocation;
        this.status = status;
        IPath targetPath = targetLocation.getLocation();
        this.targetLocationStr = targetPath.toOSString();
        try {
            this.resourceSet = ModelerCore.getModelContainer();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ArgCheck.isNotNull((Object)sqlConnection);
        ArgCheck.isNotNull((Object)modelName);
        ArgCheck.isNotNull((Object)targetLocation);
    }

    public int getRecordCount() {
        int rowCount = 0;
        for (int i = 0; i < PROCESS_ORDER.length; ++i) {
            int schemaCount = this.getSchemaRecordCount(PROCESS_ORDER[i]);
            if (schemaCount <= 0) continue;
            rowCount += schemaCount;
        }
        return rowCount;
    }

    public IStatus process(IProgressMonitor monitor) {
        this.builderDebugEnabled = MetamodelBuilderPlugin.Util.isDebugEnabled("metamodelBuilder");
        if (this.builderDebugEnabled) {
            String message = "STARTING PROCESSING >>>>   VDB ModelName: " + this.modelName;
            UiConstants.Util.log(1, message);
        }
        monitor.beginTask(GenericImportProcessor.getString("progressTitle"), 1);
        monitor.subTask("Calculating total number of entities... ");
        int totalRecords = this.getRecordCount();
        monitor.worked(1);
        monitor.beginTask(GenericImportProcessor.getString("progressTitle"), totalRecords * 2);
        this.allResources = new ArrayList();
        for (int i = 0; i < PROCESS_ORDER.length; ++i) {
            this.process(PROCESS_ORDER[i], monitor);
            if (monitor != null && monitor.isCanceled() || this.status.getSeverity() == 4) break;
        }
        Iterator resrcIter = this.allResources.iterator();
        while (resrcIter.hasNext()) {
            Resource resource = (Resource)resrcIter.next();
            try {
                this.rebuildImports(resource);
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
            }
            catch (ModelerCoreException e) {}
        }
        if (this.builderDebugEnabled) {
            String message = "FINISHED PROCESSING >>>>   VDB ModelName: " + this.modelName;
            UiConstants.Util.log(1, message);
        }
        return new Status(0, "com.metamatrix.modeler.tools.genericimport.ui", 1, "Import Complete", null);
    }

    private int getSchemaRecordCount(String schemaType) {
        int modelType = this.getModelTypeConstant(schemaType);
        String modelAndSchema = this.modelName + DELIM + schemaType;
        int schemaRecordCount = 0;
        if (MODELS_SCHEMA.equals(schemaType) || EXTMODELS_SCHEMA.equals(schemaType)) {
            ModelBuilderImpl modelBuilder = new ModelBuilderImpl(this.status, this.resourceSet);
            ModelProcessor modelProcessor = new ModelProcessor(this.sqlConnection, (ModelBuilder)modelBuilder, modelAndSchema, this.resourceSet, this.targetLocationStr, this.status);
            schemaRecordCount = modelProcessor.getRecordCount();
        } else if (modelType != -1) {
            MetamodelEntityBuilderImpl entityBuilder = new MetamodelEntityBuilderImpl(this.status, this.resourceSet);
            EntityProcessor entityProcessor = new EntityProcessor(this.sqlConnection, (MetamodelEntityBuilder)entityBuilder, modelType, modelAndSchema, this.status);
            schemaRecordCount = entityProcessor.getRecordCount();
        }
        return schemaRecordCount;
    }

    private void process(String schemaType, IProgressMonitor monitor) {
        int modelType = this.getModelTypeConstant(schemaType);
        String modelAndSchema = this.modelName + DELIM + schemaType;
        if (MODELS_SCHEMA.equals(schemaType) || EXTMODELS_SCHEMA.equals(schemaType)) {
            ModelBuilderImpl modelBuilder = new ModelBuilderImpl(this.status, this.resourceSet);
            ModelProcessor modelProcessor = new ModelProcessor(this.sqlConnection, (ModelBuilder)modelBuilder, modelAndSchema, this.resourceSet, this.targetLocationStr, this.status);
            modelProcessor.process(monitor);
            if (this.status.getSeverity() < 4) {
                List createdResources = modelProcessor.getCreatedResources();
                if (createdResources != null) {
                    Iterator iter = createdResources.iterator();
                    while (iter.hasNext()) {
                        Resource resource = (Resource)iter.next();
                        this.allResources.add(resource);
                        try {
                            resource.save(Collections.EMPTY_MAP);
                        }
                        catch (IOException e) {
                            String message = "Attempt to save the models failed ";
                            GenericImportUtil.addStatus((MultiStatus)this.status, (int)4, (String)message, (Throwable)e);
                        }
                    }
                }
                try {
                    this.targetLocation.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    String message = "Attempt to refresh the workspace failed ";
                    GenericImportUtil.addStatus((MultiStatus)this.status, (int)4, (String)message, (Throwable)e);
                }
            }
        } else if (modelType != -1) {
            MetamodelEntityBuilderImpl entityBuilder = new MetamodelEntityBuilderImpl(this.status, this.resourceSet);
            EntityProcessor entityProcessor = new EntityProcessor(this.sqlConnection, (MetamodelEntityBuilder)entityBuilder, modelType, modelAndSchema, this.status);
            entityProcessor.process(monitor);
        }
    }

    public void rebuildImports(Resource resource) throws ModelerCoreException {
        OrganizeImportHandler handler = new OrganizeImportHandler(){

            public Object choose(List options) {
                return null;
            }
        };
        OrganizeImportCommand command = new OrganizeImportCommand();
        command.setResource(resource);
        command.setHandler(handler);
        command.execute(null);
    }

    private int getModelTypeConstant(String schemaType) {
        int modelType = -1;
        if (RELATIONAL_SCHEMA.equalsIgnoreCase(schemaType)) {
            modelType = 1;
        } else if (EXTENSIONS_SCHEMA.equalsIgnoreCase(schemaType)) {
            modelType = 2;
        } else if (RELATIONSHIP_SCHEMA.equalsIgnoreCase(schemaType)) {
            modelType = 3;
        } else if (XSD_SCHEMA.equalsIgnoreCase(schemaType)) {
            modelType = 4;
        } else if (UML_SCHEMA.equalsIgnoreCase(schemaType)) {
            modelType = 5;
        }
        return modelType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

