/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.slutil;

import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTempBuffer;
import java.io.IOException;
import java.io.InputStream;

public class UtilTempBufferInputStream
extends InputStream {
    private UtilTempBuffer tempBuffer;
    private int currentPos;
    private long length;

    public UtilTempBufferInputStream(UtilTempBuffer utilTempBuffer) {
        this.tempBuffer = utilTempBuffer;
        this.currentPos = 0;
        this.length = utilTempBuffer.getSize();
    }

    public int read() throws IOException {
        if ((long)this.currentPos == this.length) {
            return -1;
        }
        try {
            byte by = this.tempBuffer.read(this.currentPos);
            ++this.currentPos;
            return by & 0xFF;
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((long)this.currentPos == this.length) {
            return -1;
        }
        try {
            int n3 = this.tempBuffer.read(this.currentPos, byArray, n, n2);
            this.currentPos += n3;
            return n3;
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }

    public void close() throws IOException {
        this.tempBuffer = null;
        this.currentPos = -1;
        this.length = 0L;
    }

    public void reset() {
        this.currentPos = 0;
        this.length = this.tempBuffer.getSize();
    }

    public long getLength() {
        long l;
        try {
            l = this.tempBuffer.getSize();
        }
        catch (NullPointerException nullPointerException) {
            l = -1L;
        }
        return l;
    }

    private String getExceptionMessage(int n) {
        UtilException utilException = new UtilException(n);
        return utilException.getMessage();
    }
}

