/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseColumns;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplConnection;
import com.metamatrix.jdbc.slbase.BasePreparedStatement;
import com.metamatrix.jdbc.slbase.BaseResultSet;
import com.metamatrix.jdbc.slbase.BaseSQL;
import com.metamatrix.jdbc.slbase.BaseSQLColumnSpecification;
import com.metamatrix.jdbc.slbase.BaseSQLTableReference;
import com.metamatrix.jdbc.slbase.BaseStatement;
import com.metamatrix.slutil.UtilVectorUnsynced;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public final class BaseResultSetMetaData
implements ResultSetMetaData {
    protected Object associate;
    protected BaseColumns columns;
    BaseExceptions exceptions;
    boolean metaDataDiscovered;

    protected BaseResultSetMetaData(Object object, BaseExceptions baseExceptions) {
        this.associate = object;
        this.exceptions = baseExceptions;
        this.setupColumns();
    }

    private void setupColumns() {
        this.columns = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).columns : ((BasePreparedStatement)this.associate).currentColumns;
    }

    public int getColumnCount() throws SQLException {
        this.validateClosedState();
        return this.columns.count(1);
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        BaseColumn baseColumn = this.columns.get(n);
        if (baseColumn.isAutoIncrementDeterminedPostDescribe) {
            BaseImplConnection baseImplConnection = null;
            baseImplConnection = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).connection.implConnection : ((BasePreparedStatement)this.associate).connection.implConnection;
            baseImplConnection.fixupAutoIncrement(baseColumn);
            baseColumn.isAutoIncrementDeterminedPostDescribe = false;
        }
        return baseColumn.isAutoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isCaseSensitive;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isSearchable != 1;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isCurrency;
    }

    public int isNullable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isNullable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isSigned;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).displaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).label;
    }

    public String getColumnName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).name;
    }

    public String getSchemaName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        String string = this.columns.get((int)n).schemaName;
        if (!(string != null && string.length() != 0 || this.metaDataDiscovered)) {
            this.discoverMetaData();
            string = this.columns.get((int)n).schemaName;
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).precision;
    }

    public int getScale(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).scale;
    }

    public String getTableName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        String string = this.columns.get((int)n).tableName;
        if (!(string != null && string.length() != 0 || this.metaDataDiscovered)) {
            this.discoverMetaData();
            string = this.columns.get((int)n).tableName;
        }
        return string;
    }

    public String getCatalogName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        String string = this.columns.get((int)n).catalogName;
        if (!(string != null && string.length() != 0 || this.metaDataDiscovered)) {
            this.discoverMetaData();
            string = this.columns.get((int)n).catalogName;
        }
        return string;
    }

    public int getColumnType(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).type;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).typeName;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isReadOnly;
    }

    public boolean isWritable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isWritable;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isDefinitelyWritable;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return BaseData.mapJDBCTypeToJavaObjectTypeName(this.columns.get((int)n).type);
    }

    private void validateClosedState() throws SQLException {
        if (this.associate instanceof BaseResultSet) {
            BaseResultSet baseResultSet = (BaseResultSet)this.associate;
            if (baseResultSet.implResultSet == null || baseResultSet.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
        } else {
            BasePreparedStatement basePreparedStatement = (BasePreparedStatement)this.associate;
            if (basePreparedStatement.implStatement == null || basePreparedStatement.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
        }
    }

    private void validateColumnIndex(int n) throws SQLException {
        if (!this.columns.isValidColumnOrdinal(n)) {
            Integer n2 = new Integer(n);
            String[] stringArray = new String[]{n2.toString()};
            throw this.exceptions.getException(6006, stringArray);
        }
    }

    private void discoverMetaData() {
        this.metaDataDiscovered = true;
        BaseStatement baseStatement = null;
        baseStatement = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).statement : (BaseStatement)this.associate;
        String string = baseStatement.connection.connectProps.get("resultsetMetaDataOptions");
        if ((Integer.parseInt(string) & 1) != 0) {
            this.discoverMetaData(baseStatement);
        }
    }

    private void discoverMetaData(BaseStatement baseStatement) {
        BaseSQL baseSQL = baseStatement.implStatement.sql;
        UtilVectorUnsynced utilVectorUnsynced = baseSQL.getSelectTables();
        BaseSQLColumnSpecification[] baseSQLColumnSpecificationArray = baseSQL.getSelectColumns();
        if (utilVectorUnsynced == null || baseSQLColumnSpecificationArray == null) {
            return;
        }
        int n = utilVectorUnsynced.size();
        int n2 = 1;
        for (int i = 0; i < baseSQLColumnSpecificationArray.length; ++i) {
            BaseSQLColumnSpecification baseSQLColumnSpecification = baseSQLColumnSpecificationArray[i];
            if (baseSQLColumnSpecification.isTableColumn()) {
                if (n == 1) {
                    this.setMetaData((BaseSQLTableReference)utilVectorUnsynced.elementAt(0), n2++);
                } else {
                    n2 = this.getMetaDataFromTables(baseStatement.connection, utilVectorUnsynced, baseSQLColumnSpecification, true, n2);
                }
            } else {
                n2 = baseSQLColumnSpecification.isQualifiedStar() ? this.getMetaDataFromTables(baseStatement.connection, utilVectorUnsynced, baseSQLColumnSpecification, true, n2) : (baseSQLColumnSpecification.isUnqualifiedStar() ? this.getMetaDataFromTables(baseStatement.connection, utilVectorUnsynced, baseSQLColumnSpecification, false, n2) : ++n2);
            }
            if (n2 != -1) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMetaDataFromTables(BaseConnection baseConnection, UtilVectorUnsynced utilVectorUnsynced, BaseSQLColumnSpecification baseSQLColumnSpecification, boolean bl, int n) {
        int n2 = utilVectorUnsynced.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            BaseSQLTableReference baseSQLTableReference = (BaseSQLTableReference)utilVectorUnsynced.elementAt(i);
            StringBuffer stringBuffer = new StringBuffer(5);
            stringBuffer.append("SELECT ");
            stringBuffer.append(baseSQLColumnSpecification.getFullSpecification());
            stringBuffer.append(" FROM ");
            stringBuffer.append(baseSQLTableReference.getFullReference() + " " + baseSQLTableReference.getCorrelation());
            stringBuffer.append(" WHERE 0 = 1");
            Statement statement = null;
            try {
                statement = baseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                n3 = resultSet.getMetaData().getColumnCount();
                resultSet.close();
                for (int j = 0; j < n3; ++j) {
                    this.setMetaData(baseSQLTableReference, n++);
                }
                if (!bl) continue;
                break;
            }
            catch (SQLException sQLException) {
                if (i != n2 - 1 && bl) continue;
                n3 = -1;
                return n3;
            }
            finally {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException sQLException) {}
            }
        }
        return n;
    }

    private void setMetaData(BaseSQLTableReference baseSQLTableReference, int n) {
        BaseColumn baseColumn = this.columns.get(n);
        String string = baseSQLTableReference.getTable();
        String string2 = baseSQLTableReference.getSchema();
        String string3 = baseSQLTableReference.getCatalog();
        if (string != null && string.length() > 0) {
            baseColumn.tableName = baseSQLTableReference.getTable();
        }
        if (string2 != null && string2.length() > 0) {
            baseColumn.schemaName = baseSQLTableReference.getSchema();
        }
        if (string3 != null && string3.length() > 0) {
            baseColumn.catalogName = baseSQLTableReference.getCatalog();
        }
    }
}

