/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BasePreparedStatement;
import com.metamatrix.jdbc.slbase.BaseStatementPool;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BasePreparedStatementPoolable
implements Statement,
PreparedStatement {
    BasePreparedStatement realPreparedStatement;
    BaseStatementPool pool;
    BaseExceptions exceptions;

    BasePreparedStatementPoolable(BasePreparedStatement basePreparedStatement, BaseStatementPool baseStatementPool) {
        this.realPreparedStatement = basePreparedStatement;
        this.realPreparedStatement.cleanUpDuringFinalization = false;
        this.pool = baseStatementPool;
        this.exceptions = basePreparedStatement.exceptions;
    }

    protected SQLException closedException() {
        return this.exceptions.getException(6009);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            BaseConnection baseConnection = this.realPreparedStatement.connection;
            synchronized (baseConnection) {
                if (this.realPreparedStatement != null) {
                    this.pool.putPreparedStatement(this.realPreparedStatement);
                    this.realPreparedStatement = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            return this.realPreparedStatement.executeQuery(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.realPreparedStatement.getMaxFieldSize();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.realPreparedStatement.setMaxFieldSize(n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.realPreparedStatement.getMaxRows();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            this.realPreparedStatement.setMaxRows(n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            this.realPreparedStatement.setEscapeProcessing(bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.realPreparedStatement.getQueryTimeout();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.realPreparedStatement.setQueryTimeout(n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void cancel() throws SQLException {
        try {
            this.realPreparedStatement.cancel();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.realPreparedStatement.getWarnings();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.realPreparedStatement.clearWarnings();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            this.realPreparedStatement.setCursorName(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSet();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.realPreparedStatement.getUpdateCount();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.realPreparedStatement.getMoreResults();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            this.realPreparedStatement.setFetchDirection(n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.realPreparedStatement.getFetchDirection();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this.realPreparedStatement.setFetchSize(n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.realPreparedStatement.getFetchSize();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSetConcurrency();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSetType();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.realPreparedStatement.addBatch(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.realPreparedStatement.clearBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.realPreparedStatement.executeBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.realPreparedStatement.getConnection();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        try {
            return this.realPreparedStatement.getMoreResults(n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.realPreparedStatement.getGeneratedKeys();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string, n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string, nArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string, stringArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string, n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string, nArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string, stringArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSetHoldability();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            return this.realPreparedStatement.executeQuery();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute() throws SQLException {
        try {
            return this.realPreparedStatement.execute();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n, n2, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            this.realPreparedStatement.setBoolean(n, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        try {
            this.realPreparedStatement.setByte(n, by);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setShort(int n, short s) throws SQLException {
        try {
            this.realPreparedStatement.setShort(n, s);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setInt(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setLong(int n, long l) throws SQLException {
        try {
            this.realPreparedStatement.setLong(n, l);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        try {
            this.realPreparedStatement.setFloat(n, f);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        try {
            this.realPreparedStatement.setDouble(n, d);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realPreparedStatement.setBigDecimal(n, bigDecimal);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setString(int n, String string) throws SQLException {
        try {
            this.realPreparedStatement.setString(n, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.realPreparedStatement.setBytes(n, byArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n, date);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n, time);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n, timestamp);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setAsciiStream(n, inputStream, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setUnicodeStream(n, inputStream, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setBinaryStream(n, inputStream, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.realPreparedStatement.clearParameters();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n, object, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n, object, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n, object);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.realPreparedStatement.addBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.realPreparedStatement.setCharacterStream(n, reader, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        try {
            this.realPreparedStatement.setRef(n, ref);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        try {
            this.realPreparedStatement.setBlob(n, blob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        try {
            this.realPreparedStatement.setClob(n, clob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        try {
            this.realPreparedStatement.setArray(n, array);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n, date, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n, time, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n, timestamp, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        try {
            this.realPreparedStatement.setURL(n, uRL);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getParameterMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }
}

