/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import java.sql.SQLException;

final class BaseConnectionStartup
extends Thread {
    private BaseConnection connection;
    private volatile boolean hasTimedOut;
    private boolean connectedBeforeTimeout;
    private SQLException sqle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BaseConnectionStartup(BaseConnection baseConnection, int n, BaseExceptions baseExceptions) throws SQLException {
        this.connection = baseConnection;
        this.hasTimedOut = false;
        this.connectedBeforeTimeout = false;
        this.sqle = null;
        baseExceptions.setUnsyncLogExceptions(true);
        this.start();
        try {
            this.join((long)n * 1000L);
            this.hasTimedOut = true;
        }
        catch (Exception exception) {
        }
        finally {
            baseExceptions.setUnsyncLogExceptions(false);
        }
        if (this.sqle != null) {
            throw this.sqle;
        }
        if (!this.connectedBeforeTimeout) {
            baseConnection.setTimedOut();
            throw baseExceptions.getException(6049, "HYT00");
        }
    }

    public void run() {
        try {
            this.connection.connect();
            if (this.hasTimedOut) {
                this.connection.implConnection.close();
            } else {
                this.connectedBeforeTimeout = true;
            }
        }
        catch (Throwable throwable) {
            this.sqle = throwable instanceof SQLException ? (SQLException)throwable : new SQLException(throwable.toString());
        }
    }
}

