/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.relationship.ui.part;

import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.actions.ScaledFontManager;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.part.AbstractDiagramEditPart;
import com.metamatrix.modeler.diagram.ui.part.AbstractFreeEditPart;
import com.metamatrix.modeler.diagram.ui.part.DiagramEditPart;
import com.metamatrix.modeler.diagram.ui.util.DiagramXYLayoutEditPolicy;
import com.metamatrix.modeler.diagram.ui.util.LassoDragTracker;
import com.metamatrix.modeler.relationship.ui.layout.RelationshipLayoutHelper;
import com.metamatrix.modeler.relationship.ui.part.RelationshipNodeEditPart;
import com.metamatrix.modeler.relationship.ui.part.RelationshipTypeNodeEditPart;
import com.metamatrix.modeler.ui.IDiagramTypeEditPart;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class RelationshipDiagramEditPart
extends AbstractDiagramEditPart
implements IDiagramTypeEditPart {
    static DragTracker m_dragTracker = null;
    private String sCurrentRouterStyle = "DiagramRouterStyles.fan.textid";

    protected IFigure createFigure() {
        Figure newFigure = this.getFigureFactory().createFigure(this.getModel());
        this.setCurrentDiagramFont(ScaledFontManager.getFont());
        return newFigure;
    }

    protected void createEditPolicies() {
        this.setSelectablePart(false);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramXYLayoutEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        if (m_dragTracker == null) {
            m_dragTracker = new LassoDragTracker();
        }
        return m_dragTracker;
    }

    private boolean hasChildren() {
        return this.getViewer().getContents().getChildren().size() > 0;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    public void layout(boolean layoutChildren) {
        if (!this.hasChildren()) {
            return;
        }
        if (layoutChildren) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(layoutChildren);
            }
        }
        if (!((DiagramModelNode)this.getModel()).wasLayedOut()) {
            this.layout();
        } else {
            ((DiagramModelNode)this.getModel()).recoverObjectProperties();
        }
    }

    public void layout() {
        if (!this.hasChildren()) {
            return;
        }
        DiagramModelNode selectedModelNode = null;
        if (this.getViewer().getSelectedEditParts().size() == 1) {
            Object selectedPart = this.getViewer().getSelectedEditParts().get(0);
            if (selectedPart instanceof RelationshipNodeEditPart) {
                selectedModelNode = (DiagramModelNode)((DiagramEditPart)selectedPart).getModel();
            } else if (selectedPart instanceof RelationshipTypeNodeEditPart) {
                selectedModelNode = (DiagramModelNode)((DiagramEditPart)selectedPart).getModel();
            }
        }
        RelationshipLayoutHelper layoutHelper = new RelationshipLayoutHelper((DiagramModelNode)this.getModel(), selectedModelNode);
        layoutHelper.layoutAll();
        this.updateAnchorsAndLinks();
    }

    private void updateAnchorsAndLinks() {
        EditPart canvasEditPart = this.getViewer().getContents();
        List canvasChildren = canvasEditPart.getChildren();
        Iterator iter = canvasChildren.iterator();
        EditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (EditPart)iter.next();
            if (!(nextEditPart instanceof DiagramEditPart) || nextEditPart instanceof AbstractFreeEditPart) continue;
            ((DiagramEditPart)nextEditPart).createOrUpdateAnchorsLocations(false);
        }
    }

    public boolean hasConnections() {
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (nextEditPart.getSourceConnections().isEmpty() && nextEditPart.getTargetConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void refreshFont(boolean refreshChildren) {
        super.refreshFont(refreshChildren);
        if (this.hasChildren()) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(true);
            }
        }
    }

    protected void refreshVisuals() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if (this.sCurrentRouterStyle.equals("DiagramRouterStyles.fan.textid")) {
            cLayer.setConnectionRouter((ConnectionRouter)new FanRouter());
        }
    }

    public void updateForPreferences() {
        RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.relationship.backgroundcolor");
        this.getFigure().setBackgroundColor(new Color(null, currentBkgdColor));
        this.refreshFont(true);
        this.layout(false);
    }
}

