/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import com.metamatrix.sequelink.security.Message;
import iaik.security.provider.IAIK;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;

public final class DESKeyFactory
extends SecretKeyFactorySpi {
    private static final String PROVIDER_NAME = "IAIK";
    private static final String KEY_FACTORY_NAME = "DES";
    private SecretKeyFactory realKeyFactory;

    public DESKeyFactory() {
        IAIK iAIK = new IAIK();
        int n2 = Security.addProvider((Provider)iAIK);
        try {
            this.realKeyFactory = SecretKeyFactory.getInstance(KEY_FACTORY_NAME, PROVIDER_NAME);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(Message.Gen.getException(7630, noSuchProviderException.getMessage()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(Message.Gen.getException(7631, noSuchAlgorithmException.getMessage()));
        }
        if (n2 != -1) {
            Security.removeProvider(PROVIDER_NAME);
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.realKeyFactory.generateSecret(keySpec);
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        return this.realKeyFactory.getKeySpec(secretKey, clazz);
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        return this.realKeyFactory.translateKey(secretKey);
    }
}

