/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseEscapeTranslator;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseSQLParser;
import com.metamatrix.jdbc.slbase.BaseSQLStringGenerator;
import com.metamatrix.jdbc.slbase.BaseSQLTreeNode;
import com.metamatrix.jdbc.slbase.BaseSQLTreePostOrderTraverser;
import com.metamatrix.jdbc.slbase.BaseSQLTreeTraversalVisitor;
import java.sql.SQLException;

final class BaseSQLEscapeProcessor
implements BaseSQLTreeTraversalVisitor {
    private BaseExceptions exceptions;
    private BaseEscapeTranslator translator;
    private BaseSQLTreeNode escapeNode = null;
    private BaseSQLTreeNode whereNode;

    BaseSQLEscapeProcessor() {
    }

    public void processEscapes(BaseSQLTreeNode baseSQLTreeNode, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        BaseSQLTreePostOrderTraverser baseSQLTreePostOrderTraverser = new BaseSQLTreePostOrderTraverser();
        this.translator = baseEscapeTranslator;
        this.exceptions = baseExceptions;
        baseSQLTreePostOrderTraverser.setExceptions(baseExceptions);
        baseSQLTreePostOrderTraverser.setVisitor(this);
        baseSQLTreePostOrderTraverser.traverse(baseSQLTreeNode);
    }

    public boolean visit(BaseSQLTreeNode baseSQLTreeNode, int n2) throws SQLException {
        if (baseSQLTreeNode != null && (baseSQLTreeNode.type & 0x2000) != 0) {
            this.escapeNode = baseSQLTreeNode;
            this.translator.translateEscape(this.escapeNode, this.getWhereClause(this.escapeNode));
            this.replaceEscape(this.translator.getTranslation(), this.translator.getNewWhere());
        }
        return true;
    }

    private String getWhereClause(BaseSQLTreeNode baseSQLTreeNode) throws SQLException {
        if (baseSQLTreeNode.type != 8208) {
            return "";
        }
        boolean bl = true;
        String string = null;
        this.whereNode = null;
        while (baseSQLTreeNode != null && bl) {
            if ((baseSQLTreeNode = baseSQLTreeNode.getParent()) == null || baseSQLTreeNode.type != 1008) continue;
            bl = false;
        }
        if (baseSQLTreeNode != null) {
            baseSQLTreeNode = baseSQLTreeNode.getRightSibling();
            if (baseSQLTreeNode.type == 1009) {
                bl = false;
            }
        }
        if (baseSQLTreeNode != null) {
            this.whereNode = baseSQLTreeNode;
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            string = baseSQLStringGenerator.generateSQL(baseSQLTreeNode, false, this.exceptions);
            if (string.length() == 0) {
                string = null;
            }
        }
        return string;
    }

    private void replaceEscape(String string, String string2) throws SQLException {
        if (string != null) {
            BaseSQLTreeNode baseSQLTreeNode = null;
            BaseSQLParser baseSQLParser = null;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            if (string.indexOf(63) == -1) {
                bl = false;
            }
            if (string.indexOf(40) == -1) {
                bl3 = false;
            }
            if (string2 == null || string2.indexOf(63) == -1) {
                bl2 = false;
            }
            if (bl || bl3 || bl2) {
                baseSQLParser = new BaseSQLParser(this.translator, 1);
                baseSQLParser.setUp(null, this.exceptions);
            }
            string = " " + string + " ";
            baseSQLTreeNode = bl || bl3 ? baseSQLParser.parse(string, '\"') : new BaseSQLTreeNode(1016, string);
            this.escapeNode.removeChildren();
            this.escapeNode.setNextChild(baseSQLTreeNode);
            if (this.whereNode != null && string2 != null) {
                string2 = " " + string2 + " ";
                baseSQLTreeNode = bl2 ? baseSQLParser.parse(string2, '\"') : new BaseSQLTreeNode(1016, string2);
                this.whereNode.removeChildren();
                this.whereNode.setNextChild(baseSQLTreeNode);
            }
        }
    }
}

