/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseData;

public class BaseColumns {
    static final int INITIAL_SIZE = 16;
    private BaseColumn[] columns = new BaseColumn[16];
    private int nextEmptyPosition = 0;
    public static final int COUNT_ALL = 0;
    public static final int COUNT_EXPOSED = 1;
    public static final int COUNT_HIDDEN = 2;
    public static final int COUNT_KEY = 3;
    public static final int COUNT_AUTOINCREMENT = 4;
    private boolean countsValid = false;
    private int hiddenCount;
    private int exposedCount;
    private int allCount;
    private int keyCount;
    private int autoincrementCount;

    public void add(BaseColumn baseColumn) {
        if (this.nextEmptyPosition == this.columns.length - 1) {
            BaseColumn[] baseColumnArray = this.columns;
            this.columns = new BaseColumn[this.columns.length * 2];
            System.arraycopy(baseColumnArray, 0, this.columns, 0, baseColumnArray.length);
        }
        this.columns[this.nextEmptyPosition++] = baseColumn;
        this.countsValid = false;
    }

    public int count(int n2) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        switch (n2) {
            case 0: {
                return this.allCount;
            }
            case 1: {
                return this.exposedCount;
            }
            case 2: {
                return this.hiddenCount;
            }
            case 3: {
                return this.keyCount;
            }
            case 4: {
                return this.autoincrementCount;
            }
        }
        return 0;
    }

    private void calculateCounts() {
        this.allCount = this.nextEmptyPosition;
        this.hiddenCount = 0;
        this.exposedCount = 0;
        this.keyCount = 0;
        this.autoincrementCount = 0;
        for (int i2 = 0; i2 < this.allCount; ++i2) {
            BaseColumn baseColumn = this.columns[i2];
            if (baseColumn.isHidden) {
                ++this.hiddenCount;
            } else {
                ++this.exposedCount;
            }
            if (baseColumn.isKey) {
                ++this.keyCount;
            }
            if (!baseColumn.isAutoIncrement || baseColumn.isHidden) continue;
            ++this.autoincrementCount;
        }
        this.countsValid = true;
    }

    public BaseColumn get(int n2) {
        BaseColumn baseColumn = this.columns[n2 - 1];
        return baseColumn;
    }

    public boolean isValidColumnOrdinal(int n2) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        return n2 > 0 && n2 <= this.exposedCount;
    }

    public int getOrdinal(String string) {
        BaseColumn baseColumn;
        int n2;
        int n3 = this.count(0);
        for (n2 = 1; n2 <= n3; ++n2) {
            baseColumn = this.get(n2);
            if (baseColumn.label == null || !baseColumn.label.equalsIgnoreCase(string)) continue;
            return n2;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            baseColumn = this.get(n2);
            if (baseColumn.name == null || !baseColumn.name.equalsIgnoreCase(string)) continue;
            return n2;
        }
        return 0;
    }

    public void reset() {
        if (this.columns != null) {
            this.nextEmptyPosition = 0;
        }
        this.countsValid = false;
    }

    public void resetCount() {
        this.countsValid = false;
    }

    public void markColumnsAsKeyStartingAt(int n2, boolean bl) {
        this.allCount = this.nextEmptyPosition;
        for (int i2 = n2 - 1; i2 < this.allCount; ++i2) {
            BaseColumn baseColumn = this.columns[i2];
            if (!(baseColumn.isSearchable != 4 && baseColumn.isSearchable != 3 || baseColumn.isHidden || BaseData.isStreamed(baseColumn.baseDataType))) {
                baseColumn.isKey = true;
            }
            if (!bl) continue;
            baseColumn.isHidden = true;
        }
        this.countsValid = false;
    }
}

